<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Transfert extends Model
{
    protected $table='transfert';
    protected $primaryKey='id';
    //protected $fillable=['sscc','emplacement', 'date', 'evenement', 'operateur' ,'last_update'];
    public $timestamps = false;

    public function getPrimaryKey(){
        return $this->primaryKey;
    }

    public function emplacementSource(){
        return $this->belongsTo('App\Emplacement','idEmplacementSrc');
    }

    public function emplacementDestination(){
        return $this->belongsTo('App\Emplacement','idEmplacementDes');
    }

    public function produitStock(){
        return $this->belongsTo('App\StockProduit','idStock');
    }

    public function operateur(){
        return $this->belongsTo('App\User','id_operateur');
    }

}
