<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Tracabilite extends Model
{
    protected $table='tracabilite';
    protected $primaryKey='id';
    protected $fillable=['sscc','emplacement', 'date', 'evenement', 'operateur' ,'last_update'];
    public $timestamps = false;

    public function getPrimaryKey(){
        return $this->primaryKey;
    }

    public function operateurs(){
        return $this->belongsTo('App\User','operateur');
    }

    public function emplacements(){
        return $this->belongsTo('App\Emplacement','emplacement');
    }
}
