<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 04/06/2017
 * Time: 13:24
 */

namespace App;


use Illuminate\Database\Eloquent\Model;

class StockProduit extends Model
{

    protected $table = 'stock_produit';
    protected $primaryKey = 'id_stock_produit';
    protected $fillable = ['quantite', 'date_fabrication', 'date_peremption', 'numero_lot', 'date_entree', 'validation', 'id_produit', 'id_emplacement','idInventaire'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }


    public function emplacement()
    {
        return $this->belongsTo('App\Emplacement', 'id_emplacement', 'id_emplacement');
    }

    public function entite(){
        return $this->belongsTo('App\Entite', 'num_entite','num_entite');
    }

    public function ue(){
        return $this->belongsTo('App\Ue', 'num_ue','num_ue');
    }




    public function produit()
    {
        return $this->belongsTo('App\Produit', 'id_produit', 'id_produit');
    }



    public function ligneBonReception()
    {
        return $this->belongsTo('App\LigneBonReception', 'id_ligne_bon_reception');
    }
    public function ligneBonReceptionn()
    {
        return $this->hasMany('App\LigneBonReception', 'id_stock_produit');
    }

    public function LigneProduit(){
        return $this->hasMany('App\LigneProduit','id_stock_produit','idStock');
    }
    
    public function LigneInventaire()
    {
        return $this->hasMany('App\LigneInventaire','id_stock_produit','idStock');
    }

    public function Inventaire()
    {
        return $this->belongsTo('App\Inventaire', 'idInventaire', 'idInventaire');
    }

    public function ligneBonReceptionUe(){
        return $this->hasMany('App\LigneBonReceptionUe','id_stock_produit');
    }

    public function ligne_produit(){
        return $this->hasMany('App\LigneProduit','idStock');
    }






}