<?php

namespace App;


use Illuminate\Database\Eloquent\Model;

class ProduitCompose extends Model
{
    protected $table='produit_compose';
    protected $primaryKey='id';
    protected $fillable=['type', 'id_produit_parent','id_produit_enfant','quantite'];
    public $timestamps = false;

    public function getPrimaryKey(){
        return $this->primaryKey;
    }

    public function produitParent(){
        return $this->belongsTo('App\Produit','id_produit_parent');
    }

    public function produitEnfant(){
        return $this->belongsTo('App\Produit','id_produit_enfant');
    }
}