<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 28/05/2017
 * Time: 12:22
 */

namespace App;

use Illuminate\Database\Eloquent\Model;


class Produit extends Model
{
    protected $table='produit';
    protected $primaryKey='id_produit';
    protected $fillable=['designation', 'reference', 'code_identificattion', 'tva', 'code_mesure', 'actif', 'id_categorie'];
    public $timestamps = false;
    public function  getPrimaryKey()
    {
        return $this->primaryKey;
    }

    public function catigorie(){
        return $this->belongsTo('App\Categorie','id_categorie');
    }

    public function ligneCommandeFournisseur(){
        return $this->hasMany('App\LigneCommandeFournisseur');
    }

    public function stockProduit()
    {
        return $this->hasMany('App\StockProduit','id_produit');
    }

    public function uniteMesure()
    {
        return $this->belongsTo('App\UniteMesure','code_mesure');
    }

    public function bonReception()
    {
        return $this->hasOne('App\BonReception');
    }
    public function ligneCommandeProduit(){
        return $this->hasMany('App\LigneCommandeProduit','id_produit');
    }

    public function LigneProduit()
    {
        return $this->hasMany('App\LigneProduit','id_produit','idProduit');
    }

    public function ligneBonReception(){
        return $this->hasMany('App\LigneBonReception','id_produit');
    }

    public function productions(){
        return $this->hasMany('App\Production','id_produit');
    }

    public function produitCompose(){
        return $this->hasMany('App\ProduitCompose','id_produit');
    }
}