<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Production extends Model
{
    protected $table='production';
    protected $primaryKey='id';
    protected $fillable=['numero_production','emplacement_mp', 'designation_mp', 'quantite_mp', 'emplacement_pf' ,'	designation_pf' ,'quantite_pf','date2','status','id_produit','id_ue','last_update','operateur1','operateur2','date1'];
    public $timestamps = false;

    public function getPrimaryKey(){
        return $this->primaryKey;
    }

    public function produits(){
        return $this->belongsTo('App\Produit','id');
    }

    /*public function ligneBonReceptionUes(){
        return $this->belongsTo('App\LigneBonReceptionUe','id');
    }*/

    public function operateurMP(){
        return $this->belongsTo('App\User','operateur1');
    }

    public function operateurPF(){
        return $this->belongsTo('App\User','operateur2');
    }

    public function emplacementsMP(){
        return $this->belongsTo('App\Emplacement','emplacement_mp');
    }

    public function emplacementsPF(){
        return $this->belongsTo('App\Emplacement','emplacement_pf');
    }

}
