<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class Preparation extends Model
{

    protected $table = 'preparation';
    protected $primaryKey = 'idPreparation';
    protected $fillable = ['idCommande', 'idTransporteur', 'numPreparation', 'datePrevue','dateExpedition','statutPreparation','nombreUE','nombreProduits','totalPoids'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }

    public function CommandeClient()
    {
        return $this->belongsTo('App\CommandeClient','idCommande');
    }

    public function Client()
    {
        return $this->belongsTo('App\Client','adresse_livraison');
    }

    public function LigneProduit()
    {
        return $this->hasMany('App\LigneProduit', 'idPreparation', 'idPreparation');
    }

    public function  Transporteur()
    {
        return $this->belongsTo('App\Transporteur','idTransporteur');
    }

    public function LignePreparationChargement()
    {
        return $this->hasMany('App\LignePreparationChargement','idPreparation','idPreparation');
    }

    public function entite(){
        return $this->belongsTo('App\Entite', 'num_entite','num_entite');
    }

    public function livraison(){
        return $this->belongsTo('App\BonLivraison', 'idPreparation','id_preparation');
    }


}










