<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class LigneProduit extends Model
{

    protected $table = 'ligne_produit';
    protected $primaryKey = 'idLigneProduit';
    protected $fillable = ['idPreparation', 'idUE','idProduit','idStock','idUser','quantite_a_preparer','quantite_preparer','quantite_restante'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }

     public function Preparation()
    {
        return $this->belongsTo('App\Preparation','idPreparation');
    }

    public function Produit()
    {
       return $this->belongsTo('App\Produit','idProduit');
    }

    public function stockProduit()
    {
        return $this->belongsTo('App\StockProduit','idStock');
    }

    public function UniteExpedition()
    {
        return $this->belongsTo('App\UniteExpedition','idUE');
    }

    public function User()
    {
        return $this->belongsTo('App\User','idUser');
    }

    public function NumeroSerie(){
        return $this->hasMany('App\NumeroSerie', 'id_ligne_produit','idLigneProduit');
    }

}