<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class LigneInventaire extends Model
{

    protected $table = 'ligne_inventaire';
    protected $primaryKey = 'idLigneInventaire';
    protected $fillable = ['idInventaire', 'idStock','idOperateur','idEmplacement','quantiteEstimee','quantiteComptee','ecart','codeEmplacement'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }

    public function Inventaire()
    {
        return $this->belongsTo('App\LigneInventaire','idInventaire','idInventaire');
    }

    public function User()
    {
        return $this->belongsTo('App\User','idOperateur');
    }
    public function Stock()
    {
        return $this->belongsTo('App\StockProduit','idStock');
    }
    public function Emplacement()
    {
        return $this->belongsTo('App\Emplacement','codeEmplacement','code_identification');
    }
    public function produit()
    {
        return $this->belongsTo('App\Produit','id_produit');
    }






}