<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class LigneCommandeProduit  extends Model
{

    protected $table = 'ligne_commande_produit';
    protected $primaryKey = 'idLigneCommandeProduit';
    protected $fillable = ['idCommande', 'idProduit', 'quantiteCommande', 'prixHT','prixTTC','totalPrixHT','totalPrixTTC'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }

    public function produit()
    {
        return $this->belongsTo('App\Produit', 'idProduit', 'id_produit');
    }

    public function commandeClient()
    {
        return $this->belongsTo('App\CommandeClient', 'idCommande', 'idCommande');
    }
}