<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 13/06/2017
 * Time: 11:43
 */

namespace App;


use Illuminate\Database\Eloquent\Model;

class LigneCommandeFournisseur extends Model
{

    protected $table='ligne_commande_fournisseur';
    protected $primaryKey='id_ligne_commande_fournisseur';
    protected $fillable=['id_commande', 'id_produit', 'statut', 'quantite_commander', 'quantite_receptionne', 'tva', 'prix_ht', 'prix_ttc', 'total_prix_ht', 'total_prix_ttc'];
    public $timestamps = false;
    public function  getPrimaryKey(){
        return $this->primaryKey;
    }


    public function commandeFournisseur(){
        return $this->belongsTo('App\CommandeFournisseur','id_commande_fournisseur');
    }


    public function produit(){
        return $this->belongsTo('App\Produit','id_produit', 'id_produit');
    }


    public function ligneBonReception()
    {
        return $this->hasMany('App\LigneBonReception', 'id_commande_fournisseur', 'id_commande_fournisseur');
    }



}