<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class LigneBonReceptionUe extends Model
{
    protected $table='ligne_bon_reception_ue';
    protected $primaryKey='id';
    protected $fillable=['sscc','id_ligne_bon_reception','id_stock_produit','last_update'];
    public $timestamps = false;

    public function getPrimaryKey(){
        return $this->primaryKey;
    }

    public function ligneBonReception(){
        return $this->belongsTo('App\LigneBonReception','id_ligne_bon_reception');
    }

    public function stock(){
        return $this->hasMany('App\StockProduit','id_stock_produit');
    }


}
