<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 19/06/2017
 * Time: 14:08
 */

namespace App;


use Illuminate\Database\Eloquent\Model;

class LigneBonReception extends Model
{

    protected $table='ligne_bon_reception';
    protected $primaryKey='id_ligne_bon_reception';
    protected $fillable=['id_bon_reception', 'id_ligne_commande_fournisseur','quantite_commander','quantite_receptionner', 'quantite_reste_receptionnee', 'id_stock_produit', 'id_produit','operateur'];
    public $timestamps = false;
    public function  getPrimaryKey(){
        return $this->primaryKey;
    }

    public function bonReception()
    {
        return $this->belongsTo('App\BonReception', 'id_bon_reception');
    }


    public function ligneCommandeFournisseur()
    {
        return $this->belongsTo('App\LigneCommandeFournisseur', 'id_ligne_commande_fournisseur');
    }

    public function stockProduit()
    {
        return $this->hasOne('App\StockProduit', 'id_stock_produit', 'id_stock_produit');
    }

    public function produit()
    {
        return $this->hasOne('App\Produit', 'id_produit', 'id_produit');
    }

    public function Operateur()
    {
        return $this->belongsTo('App\User','operateur');
    }
    public function Emplacement()
    {
        return $this->belongsTo('App\Emplacement','idEmplacement');
    }

    public function produits(){
        return $this->belongsTo('App\Produit');
    }

    public function ligneBonReceptionUe(){
        return $this->hasMany('App\LigneBonReceptionUe');
    }

    public function numeroSerie(){
        return $this->hasMany('App\NumSerie','id_ligne_reception');
    }




}