<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class Inventaire extends Model
{

    protected $table = 'inventaire';
    protected $primaryKey = 'idInventaire';
    protected $fillable = ['numInventaire', 'designationInventaire', 'dateDebut', 'dateFin','typeInventaire','statutInventaire','commentaire'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }

    public function LigneInventaire()
    {
        return $this->hasMany('App\LigneInventaire', 'idInventaire', 'idInventaire');
    }
    public function Stock()
    {
        return $this->hasMany('App\StockProduit', 'idInventaire', 'idInventaire');
    }

}










