<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/


Route::controllers([
    'auth' => 'Auth\AuthController',
    'password' => 'Auth\PasswordController',
]);


//authentification
Route::get('login','AuthentificationController@index')->name('login');
Route::post('login','AuthentificationController@login');
Route::post('licence','AuthentificationController@licence');
Route::get('test','AuthentificationController@test');
Route::get('logout','AuthentificationController@logout');
Route::get('administration', function ()
{
    return view('accueil.administration');
});
Route::get('historique', function ()
{
    return view('accueil.historique');
});
Route::get('configuration', function ()
{
    return view('accueil.configuration');
});
Route::get('fournisseurs', function ()
{
    return view('accueil.fournisseurs');
});Route::get('clients', function ()
{
    return view('accueil.clients');
});
Route::get('profil_acces', function ()
{
    return view('accueil.profil_acces');
});Route::get('stock', function ()
{
    return view('accueil.stock');
});

Route::group(['middleware' => ['login']], function () {

    Route::get('/', 'AccueilController@index');


    //configuration
    Route::get('configuration/index','ConfigurationController@index');



    //Route::group(['prefix' => 'configuration'], function () {

       //utilisateur
    Route::get('utilisateur/index', 'UtilisateurController@index');
    Route::get('utilisateur/ajouter', 'UtilisateurController@getForm');
    Route::get('utilisateur/profil','UtilisateurController@getDroits');
    Route::get('utilisateur/type','UtilisateurController@getDroits');

    Route::post('utilisateur/ajouter','UtilisateurController@postForm');
    Route::post('utilisateur/supprimer/{id}','UtilisateurController@delete');
    Route::get('utilisateur/modifier/{id}', 'UtilisateurController@getFormEdit');
    Route::put('utilisateur/modifier/{id}', 'UtilisateurController@postFormEdit');


       //categorie
    Route::get('categorie/index', 'CategorieController@index');
    Route::get('categorie/ajouter', 'CategorieController@getForm');
    Route::post('categorie/ajouter','CategorieController@postForm');
    Route::post('categorie/supprimer/{id}','CategorieController@delete');
    Route::get('categorie/modifier/{id}', 'CategorieController@getFormEdit');
    Route::put('categorie/modifier/{id}', 'CategorieController@postFormEdit');


       //unité de mesure
    Route::get('unite_mesure/index', 'UniteMesureController@index');
    Route::get('unite_mesure/ajouter', 'UniteMesureController@getForm');
    Route::post('unite_mesure/ajouter','UniteMesureController@postForm');
    Route::post('unite_mesure/supprimer/{id}','UniteMesureController@delete');
    Route::get('unite_mesure/modifier/{id}', 'UniteMesureController@getFormEdit');
    Route::put('unite_mesure/modifier/{id}', 'UniteMesureController@postFormEdit');

       //zone
    Route::get('zone/index', 'ZoneController@index');
    Route::get('zone/ajouter', 'ZoneController@getForm');
    Route::post('zone/ajouter','ZoneController@postForm');
    Route::post('zone/supprimer/{id}','ZoneController@delete');
    Route::get('zone/modifier/{id}', 'ZoneController@getFormEdit');
    Route::put('zone/modifier/{id}', 'ZoneController@postFormEdit');

       //emplacement
    Route::get('emplacement/index', 'EmplacementController@index');
    Route::get('emplacement/ajouter', 'EmplacementController@getForm');
    Route::post('emplacement/ajouter','EmplacementController@postForm');
    Route::post('emplacement/supprimer/{id}','EmplacementController@delete');
    Route::get('emplacement/modifier/{id}', 'EmplacementController@getFormEdit');
    Route::put('emplacement/modifier/{id}', 'EmplacementController@postFormEdit');

    Route::get('emplacement/getProduitStock/{id}', 'EmplacementController@getProduitStock');

    Route::post('emplacement/detail_ue/{id}','EmplacementController@detail_ue');

    Route::post('emplacement/downloadModele','EmplacementController@downloadModele');

    Route::post('emplacement/upload', 'EmplacementController@import');

    Route::get('emplacement/exportEmp', 'EmplacementController@exportEmp')->name('exportEmp');




    //});



    //produit
    Route::get('produit/index', 'ProduitController@index');
    Route::get('produit/ajouter', 'ProduitController@getForm');
    Route::post('produit/ajouter','ProduitController@postForm');
    Route::post('produit/supprimer/{id}','ProduitController@delete');
    Route::get('produit/modifier/{id}', 'ProduitController@getFormEdit');
    Route::put('produit/modifier/{id}', 'ProduitController@postFormEdit');
    Route::post('produit/upload', 'ProduitController@import');
    Route::post('produit/downloadModele','ProduitController@downloadModele');

    Route::post('produit/getproduit/{id_produit}','ProduitController@getProduitFromId');

    Route::get('produit/exportProduit','ProduitController@exportProduit')->name('exportProduit');
    Route::get('produit/recherche', 'ProduitController@recherche')->name('recherche');
    //Route::get('produit/recherche', 'ProduitController@index');
    
	//client
    Route::get('client/recherche', 'ClientController@recherche')->name('recherche_client');

    //stock_produit
    Route::get('stock_produit/index', 'StockProduitController@index');

    Route::get('stock_produit/indexWithIdProduit/{id}', 'StockProduitController@indexWithIdProduit');
    Route::get('stock_produit/indexWithIdEmplacement/{id}', 'StockProduitController@indexWithIdEmplacement');
    Route::get('stock_produit/indexWithIdZone/{id}', 'StockProduitController@indexWithIdZone');
    Route::get('stock_produit/indexWithIdEntite/{id}', 'StockProduitController@indexWithIdEntite');

    Route::get('stock_produit/recherche', 'StockProduitController@recherche')->name('rechercheee');
    Route::post('stock_produit/recherche_lot', 'StockProduitController@recherche_lot');
    //Route::get('stock_produit/recherche', 'StockProduitController@index')->name('rechercheee');


    Route::get('stock_produit/ajouter', 'StockProduitController@getForm');
    Route::post('stock_produit/ajouter','StockProduitController@postForm');
    Route::post('stock_produit/supprimer/{id}','StockProduitController@delete');
    Route::get('stock_produit/modifier/{id}', 'StockProduitController@getFormEdit');
    Route::put('stock_produit/modifier/{id}', 'StockProduitController@postFormEdit');
    Route::get('stock_produit/emplacements', 'StockProduitController@getEmplacement');

    Route::post('stock_produit/infos/{id_produit}', 'StockProduitController@getInfoStockProduit');

    Route::post('stock_produit/exportStock','StockProduitController@exportStock')->name('exportStock');

    Route::post('stock_produit/exportUeStock','StockProduitController@exportUeStock')->name('exportUeStock');


    //stock par N de lot
    Route::get('stock_produit_lot/index', 'StockProduitController@index_lot');

    Route::get('stock_produit_lot/produit/{id}', 'StockProduitController@indexWithIdProduit_lot');
    Route::get('stock_produit_lot/emplacement/{id}', 'StockProduitController@indexWithIdEmplacement_lot');
    Route::get('stock_produit_lot/zone/{id}', 'StockProduitController@indexWithIdZone_lot');
    Route::get('stock_produit_lot/entite/{id}', 'StockProduitController@indexWithIdEntite_lot');

    Route::get('stock_produit_lot/ajouter', 'StockProduitController@getForm_lot');
    Route::post('stock_produit_lot/ajouter','StockProduitController@postForm_lot');
    Route::post('stock_produit_lot/supprimer/{id}','StockProduitController@delete_lot');
    Route::get('stock_produit_lot/modifier/{id}', 'StockProduitController@getFormEdit_lot');
    Route::put('stock_produit_lot/modifier/{id}', 'StockProduitController@postFormEdit_lot');

    Route::post('/getProduit','StockProduitController@getProduit')->name('getProduit');

    Route::post('/getUE','StockProduitController@getUE')->name('getUE');

    Route::post('/getEmp','StockProduitController@getEmp')->name('getEmp');

    Route::post('/getEntite','StockProduitController@getEntite')->name('getEntite');

    Route::post('/getZone','StockProduitController@getZone')->name('getZone');






    //fournisseur
    Route::get('fournisseur/index', 'FournisseurController@index');
    Route::get('fournisseur/ajouter', 'FournisseurController@getForm');
    Route::get('fournisseur/communes', 'FournisseurController@getCommune');
    Route::post('fournisseur/ajouter','FournisseurController@postForm');
    Route::post('fournisseur/supprimer/{id}','FournisseurController@delete');
    Route::get('fournisseur/modifier/{id}', 'FournisseurController@getFormEdit');
    Route::put('fournisseur/modifier/{id}', 'FournisseurController@postFormEdit');



    //commande_fournisseur
    Route::get('commande_fournisseur/index', 'CommandeFournisseurController@index');
    Route::get('commande_fournisseur/ajouter', 'CommandeFournisseurController@getForm');
    Route::get('commande_fournisseur/fournisseur', 'CommandeFournisseurController@getFournisseur');
    Route::get('commande_fournisseur/prix', 'CommandeFournisseurController@getFournisseur');
    Route::post('commande_fournisseur/ajouter','CommandeFournisseurController@postForm');
    Route::post('commande_fournisseur/supprimer/{id}','CommandeFournisseurController@delete');
    Route::post('commande_fournisseur/ajouter_ligne_commande','CommandeFournisseurController@postAddLigneCommande');
    Route::post('commande_fournisseur/supprimer_ligne_commande/{id}','CommandeFournisseurController@deleteLigneCommandeFournisseur');
    Route::post('commande_fournisseur/modifier/supprimer_ligne_commande/{id}/{idCommande}','CommandeFournisseurController@deleteLigneCommandeFournisseurEdit');
    Route::post('commande_fournisseur/modifier/ajouter/{id}','CommandeFournisseurController@postAddLigneCommandeEdit');
    Route::put('commande_fournisseur/ajouter_ligne_commande/{id}','CommandeFournisseurController@postEditeLigneCommande');
    Route::put('commande_fournisseur/modifier_ligne_commande/{id}/{idCommande}','CommandeFournisseurController@postEditeLigneCommandeEdit');
    Route::get('commande_fournisseur/modifier/{id}', 'CommandeFournisseurController@getFormEdit');
    Route::get('commande_fournisseur/modifier/annuler/{id}', 'CommandeFournisseurController@cancelModification');
    Route::put('commande_fournisseur/modifier/{id}', 'CommandeFournisseurController@postFormEdit');
    Route::get('commande_fournisseur/detail/{id}', 'CommandeFournisseurController@showDetailCommandeFournisseur');
    Route::post('commande_fournisseur/supprimer/{id}','CommandeFournisseurController@delete');



    //receptions
	Route::get('reception/recherche', 'BonReceptionFournisseurControlleur@recherche_list')->name('recherche_reception');
    //Route::get('configuration/index','ConfigurationController@index');
    Route::get('reception/index','ReceptionController@index');

    Route::post('reception/upload', 'BonReceptionFournisseurControlleur@import_ue');
    Route::post('reception/upload_entite', 'BonReceptionFournisseurControlleur@import_entite');
    Route::post('reception/upload_normal', 'BonReceptionFournisseurControlleur@import');

    Route::post('reception/export', 'BonReceptionFournisseurControlleur@export');

    Route::group(['prefix' => 'receptions'], function () {
        Route::get('reception_fournisseur_ue/index', 'BonReceptionFournisseurControlleur@index_ue');

        Route::post('reception_fournisseur_ue_downloadModele', 'BonReceptionFournisseurControlleur@downloadModele');

        //bon de reception fournisseur
        Route::get('reception_fournisseur/index', 'BonReceptionFournisseurControlleur@index');
        Route::get('reception_fournisseur/ajouter', 'BonReceptionFournisseurControlleur@getForm');

        Route::get('reception_fournisseur_ue/ajouter', 'BonReceptionFournisseurControlleur@getForm_ue');


        Route::get('reception_fournisseur/ajouter/{id}', 'BonReceptionFournisseurControlleur@getFormWithIdCommande');
        Route::get('reception_fournisseur/communes', 'BonReceptionFournisseurControlleur@getCommune');
        Route::post('reception_fournisseur/ajouter','BonReceptionFournisseurControlleur@postForm');
        Route::post('reception_fournisseur/supprimer/{id}','BonReceptionFournisseurControlleur@delete');

        Route::post('reception_fournisseur_ue/supprimer/{id}','BonReceptionFournisseurControlleur@delete_ue');


        Route::post('reception_fournisseur/supprimer_ligne_bon_reception/{id}','BonReceptionFournisseurControlleur@deleteLigneBonReception');
        Route::get('reception_fournisseur/modifier/{id}', 'BonReceptionFournisseurControlleur@getFormEdit');
        Route::put('reception_fournisseur/modifier/{id}', 'BonReceptionFournisseurControlleur@postFormEdit');
        Route::get('reception_fournisseur/detail/{id}', 'BonReceptionFournisseurControlleur@showDetailBonReception')->name('detailReception');

        Route::get('reception_fournisseur_ue/detail/{id}', 'BonReceptionFournisseurControlleur@showDetailBonReceptionUE')->name('detailReceptionUE');


        Route::get('reception_fournisseur_ue/modifier/{id}', 'BonReceptionFournisseurControlleur@getFormEditUE');
        Route::post('reception_fournisseur_ue/modifier/{id}', 'BonReceptionFournisseurControlleur@postFormEditUE');

        Route::put('reception_fournisseur/ajouter_quantite_receptionnee/{id}','BonReceptionFournisseurControlleur@postAddQuantiteReceptionnee');
        Route::put('reception_fournisseur/modifier_ligne_bon_reception/{id}/{idBonRception}','BonReceptionFournisseurControlleur@postEditeLigneBonReceptionEdit');
        Route::get('reception_fournisseur/modifier/annuler/{id}', 'BonReceptionFournisseurControlleur@cancelModification');
        Route::post('reception_fournisseur/modifier/supprimer_ligne_bon_reception/{id}/{idBonReception}','BonReceptionFournisseurControlleur@deleteLigneBonReceptionEdit');

        Route::get('reception_fournisseur/valider/{id}','BonReceptionFournisseurControlleur@valider');

        Route::get('reception_fournisseur_ue/valider/{id}','BonReceptionFournisseurControlleur@valider_ue');

        Route::post('reception_fournisseur/detail/ue/{id}','BonReceptionFournisseurControlleur@get_ue_from_poduit');
        Route::post('reception_fournisseur/detail/ue/checked/{id}','BonReceptionFournisseurControlleur@get_ue_checked');

        Route::get('reception_fournisseur/detail/ue/downloadPDF/{id}','BonReceptionFournisseurControlleur@downloadPDF');

        Route::post('reception_fournisseur/detail/simule_saisie_fo','BonReceptionFournisseurControlleur@simule_saisie_fo')->name('simule_saisie_fo');

        Route::post('reception_fournisseur/detail/simule_saisie_fo_ue','BonReceptionFournisseurControlleur@simule_saisie_fo_ue')->name('simule_saisie_fo_ue');

        Route::post('reception_fournisseur/ajouter/produitNonCommande','BonReceptionFournisseurControlleur@produitNonCommande')->name('ajouterProduitNonCommande');

        Route::post('reception_fournisseur/modifier/produitNonCommande','BonReceptionFournisseurControlleur@produitNonCommandeModifier')->name('produitNonCommandeModifier');

        Route::post('reception_fournisseur_ue/num_serie/{id}','BonReceptionFournisseurControlleur@get_num_serie');

        Route::post('reception_fournisseur/index','BonReceptionFournisseurControlleur@recherche');

        Route::post('reception_fournisseur_ue/num_serie/modifier/{id}','BonReceptionFournisseurControlleur@postFormEditSN');



        //bon de reception production
        Route::get('reception_production/index', 'BonReceptionProductionControlleur@index');
        Route::get('reception_production/ajouter', 'BonReceptionProductionControlleur@getForm');
        Route::post('reception_production/ajouter','BonReceptionProductionControlleur@postForm');
        //receptions/reception_production/ajouter
        //postAddLigneBonReceptionProduction
        Route::post('reception_production/ajouter_ligne_bon_reception_production','BonReceptionProductionControlleur@postAddLigneBonReceptionProduction');
        Route::put('reception_production/ajouter_ligne_bon_reception_production/{id}','BonReceptionProductionControlleur@postEditeLigneBonReceptionProduction');
        //BonReceptionProductionControlleur@deleteLigneBonReceptionProduction
        Route::post('reception_production/supprimer_ligne_bon_reception_production/{id}','BonReceptionProductionControlleur@deleteLigneBonReceptionProduction');
        Route::get('reception_production/detail/{id}', 'BonReceptionProductionControlleur@showDetailBonReceptionProduction');
        Route::get('reception_production/modifier/{id}', 'BonReceptionProductionControlleur@getFormEdit');
        Route::post('reception_production/modifier/{id}', 'BonReceptionProductionControlleur@postFormEdit');
        Route::post('reception_production/modifier/ajouter/{id}', 'BonReceptionProductionControlleur@postAddLigneBonReceptionProductionEdit');
        //Route::post('commande_fournisseur/modifier/ajouter/{id}','CommandeFournisseurController@postAddLigneCommandeEdit');
        Route::post('reception_production/modifier/supprimer_ligne_bon_reception/{id}/{idBonReception}','BonReceptionProductionControlleur@deleteLigneBonReceptionEdit');
        Route::put('reception_production/modifier_ligne_bon_reception/{id}/{idBonReception}','BonReceptionProductionControlleur@postEditeLigneBonReceptionProductionEdit');
        Route::get('reception_production/modifier/annuler/{id}', 'BonReceptionProductionControlleur@cancelModificationBonReceptionProduction');
        Route::post('reception_production/modifier/supprimer_ligne_bon_reception/{id}/{idBonReception}','BonReceptionProductionControlleur@deleteLigneBonReceptionEdit');
        Route::post('reception_production/supprimer/{id}','BonReceptionProductionControlleur@delete');


    });
        //commande client
Route::get('commande_client/index', 'CommandeClientController@index');
Route::post('commande_client/annuler/{id}','CommandeClientController@delete');
Route::get('commande_client/detail/{id}','CommandeClientController@show');
Route::get('commande_client/preparation/{id}','CommandeClientController@redirectPreparation');
Route::post('commande_client/downloadModele','CommandeClientController@downloadModele');
        // Importer
Route::post('upload', 'CommandeClientController@upload');

Route::get('commande_client/ajouter', 'CommandeClientController@getForm');
Route::post('commande_client/ajouter','CommandeClientController@postForm');
Route::get('commande_client/client', 'CommandeClientController@getClient');
Route::post('commande_client/ajouterLigneCommande', 'CommandeClientController@postAddLigneCommande');
Route::post('commande_client/modifierLigneCommande/{id}', 'CommandeClientController@postEditeLigneCommande');
Route::post('commande_client/supprimerLigneCommande/{id}', 'CommandeClientController@deleteLigneCommande');
Route::put('commande_client/modifier_ligne_commande/{id}/{idCommande}','CommandeClientController@postEditeLigneCommandeEdit');
Route::get('commande_client/modifier/{id}', 'CommandeClientController@getFormEdit');
Route::get('commande_client/modifier/annuler/{id}', 'CommandeClientController@cancelModification');
Route::put('commande_client/modifier/{id}', 'CommandeClientController@postFormEdit');
Route::post('commande_client/modifier/ajouter/{id}','CommandeClientController@postAddLigneCommandeEdit');
Route::put('commande_client/modifier_ligne_commande/{id}/{idCommande}','CommandeClientController@postEditeLigneCommandeEdit');
Route::post('commande_client/modifier/supprimer_ligne_commande/{id}/{idCommande}','CommandeClientController@deleteLigneCommandeClientEdit');

        //Transporteur
Route::get('transporteur/index', 'TransporteurController@index');
Route::post('transporteur/supprimer/{id}', 'TransporteurController@delete');
Route::get('transporteur/ajouter', 'TransporteurController@getForm');
Route::post('transporteur/ajouter', 'TransporteurController@postForm');
Route::get('transporteur/modifier/{id}', 'TransporteurController@getFormEdit');
Route::put('transporteur/modifier/{id}', 'TransporteurController@postFormEdit');

        //Preparation
		        
Route::get('/preparation/recherche', 'PreparationController@recherche')->name('recherche_preparation');
Route::get('preparation/filtre', 'PreparationController@filtre')->name('filtre_preparation');
//Route::get('preparation/filtre', 'PreparationController@filtre2');

Route::get('preparation/index', 'PreparationController@index')->name('index_preparation');
Route::get('preparation/detail/{id}', 'PreparationController@show')->name('detail_preparation');
Route::get('preparation/modifier/{id}', 'PreparationController@getEdit');
Route::post('preparation/modifier/{id}', 'PreparationController@postEdit');
Route::post('preparation/annuler/{id}', 'PreparationController@delete');

Route::post('preparation/annuler2/{id}', 'PreparationController@annuler');

Route::get('preparation/ajouter', 'PreparationController@getForm');
Route::post('preparation/ajouter', 'PreparationController@postForm');
Route::get('preparation/commande_client', 'PreparationController@getCommandeClient');
Route::get('preparation/sessionPreparation', 'PreparationController@sessionPreparation');
Route::get('preparation/sessionDate', 'PreparationController@sessionDate');

Route::post('preparation/sessionEntite/{id}', 'PreparationController@sessionEntite');
Route::get('preparation/sessionOperateur', 'PreparationController@sessionOperateur');

Route::get('preparation/sessionSociale', 'PreparationController@sessionSociale');
Route::get('preparation/sessionTransporteur', 'PreparationController@sessionTransporteur');
Route::get('preparation/sessionCommande', 'PreparationController@sessionCommande');
Route::get('preparation/produit/ajouter', 'PreparationController@getFormProduit');
Route::post('preparation/produit/ajouter', 'PreparationController@postFormProduit');
Route::get('preparation/produit/genererUE', 'PreparationController@getFormUE');
Route::post('preparation/produit/genererUE', 'PreparationController@postFormUE');
Route::post('preparation/produit/deleteProduit/{id}', 'PreparationController@deleteProduit');
Route::put('preparation/produit/modifier/{id}', 'PreparationController@postEditeLigneProduit');
Route::post('preparation/modifier/produit/ajouter', 'PreparationController@postEditProduit');
Route::get('preparation/modifier/produit/ajouter', 'PreparationController@getEditProduit');
Route::get('preparation/modifier/produit/genererUE', 'PreparationController@getEditUE');
Route::post('preparation/modifier/produit/genererUE', 'PreparationController@postEditUE');
Route::get('preparation/modifier/annuler/{id}', 'PreparationController@cancelEdit');

Route::get('preparation/get_ue_from_stock/{entite}/{id_produit}', 'PreparationController@getAllUeFromStock');
Route::post('preparation/modifier_ligne_produit_preparation', 'PreparationController@EditLigneProduit')->name('modifier_ligne_produit_preparation');

Route::post('preparation/upload', 'PreparationController@import');
Route::post('preparation/upload_ue', 'PreparationController@import_ue');

Route::post('preparation/downloadModele','PreparationController@downloadModele');

Route::post('preparation/detail/simule_saisie_fo', 'PreparationController@simule_saisie_fo_preparation')->name('simule_saisie_fo_preparation');
Route::get('preparation/sessionCommandee', 'PreparationController@sessionCommandee');

        //Chargement
Route::get('/chargement/recherche', 'ChargementController@recherche')->name('recherche_chargement');
Route::get('chargement/filtre', 'ChargementController@filtre')->name('filtre_chargement');
Route::get('chargement/index', 'ChargementController@index')->name('index_chargement');


Route::get('chargement/ajouter', 'ChargementController@getForm');
Route::get('chargement/ajouter/{id}', 'ChargementController@getFormid');
Route::post('chargement/ajouter/{id}', 'ChargementController@postForm');
Route::post('chargement/annuler/{id}', 'ChargementController@delete');
Route::get('chargement/modifier/{id}', 'ChargementController@getEdit');
Route::post('chargement/modifier/{id}', 'ChargementController@postEdit');
Route::get('chargement/sessionChargement', 'ChargementController@sessionChargement');
Route::get('chargement/sessionDate', 'ChargementController@sessionDate');
Route::get('chargement/detail/{id}', 'ChargementController@show');
Route::post('chargement/detail/{id}', 'ChargementController@show');

Route::get('chargement/charge/{id}', 'ChargementController@charge');

Route::post('chargement/numero_serie/{id}', 'ChargementController@get_numero_serie');

Route::post('chargement/export', 'ChargementController@export');





    //Configuration PDF
Route::get('configurationPDF/index', 'ConfigurationPDFController@getForm');
Route::post('configurationPDF/index', 'ConfigurationPDFController@postForm');
Route::get('preferences', 'PreferencesController@index');
Route::get('preferences/index', 'PreferencesController@index');
Route::post('preferences/configurer', 'PreferencesController@configurer');


    //Inventaire
Route::get('inventaire/index', 'InventaireController@index');
Route::get('inventaire/ajouter', 'InventaireController@getForm');
Route::post('inventaire/ajouter', 'InventaireController@postForm');
Route::post('inventaire/supprimer/{id}', 'InventaireController@delete');
Route::get('inventaire/detail/{id}', 'InventaireController@show');
Route::post('inventaire/detail/{id}', 'InventaireController@show');
Route::get('inventaire/modifier/{id}', 'InventaireController@getEdit');
Route::post('inventaire/modifier/{id}', 'InventaireController@postEdit');

Route::post('inventaire/getEmplacement/{id}', 'InventaireController@getEmplacement');
Route::post('inventaire/inserer', 'InventaireController@insererUneLigneProduit')->name('insererInventaire');
Route::get('inventaire/cloture/{id}', 'InventaireController@cloture')->name('cloture');
Route::post('inventaire/modifierLigneProdui/', 'InventaireController@modifier_ligne_produit')->name('ligne_produit_modifier');
Route::post('inventaire/deleteLigne', 'InventaireController@destroyLigneInventaire')->name('deleteLigne');


    //Route droit d'accés mobile
Route::get('profil/mobile','GestionProfilMobileController@index');
Route::get('profil/mobile/ajouter','GestionProfilMobileController@ajouter');
Route::post('profil/mobile/ajouter','GestionProfilMobileController@addNewProfil');
Route::post('profil/mobile/supprimer/{id}','GestionProfilMobileController@supprimer');
Route::get('profil/mobile/modifier/{id}','GestionProfilMobileController@modifier');
Route::post('profil/mobile/modifier/{id}','GestionProfilMobileController@editProfil');


    //Route droit d'accés mobile

Route::get('profil/backoffice', 'GestionProfilBackofficeController@index');
Route::get('profil/backoffice/ajouter','GestionProfilBackofficeController@ajouter');
Route::post('profil/backoffice/ajouter','GestionProfilBackofficeController@addNewProfil');
Route::post('profil/backoffice/supprimer/{id}','GestionProfilBackofficeController@supprimer');
Route::get('profil/backoffice/modifier/{id}','GestionProfilBackofficeController@modifier');
Route::post('profil/backoffice/modifier/{id}','GestionProfilBackofficeController@editProfil');

    //Bon livraison
Route::get('livraison/index', 'BonLivraisonController@index');
Route::get('livraison/detail/{id}', 'BonLivraisonController@show');
Route::post('livraison/detail/{id}', 'BonLivraisonController@show');
Route::get('livraison/ajouter/{id}', 'BonLivraisonController@add');
Route::post('livraison/detail/get_list_produit_composer/{id}', 'BonLivraisonController@get_produits_compose');

    //Bon livraison
Route::get('livraison/index', 'BonLivraisonController@index');
Route::get('livraison/detail/{id}', 'BonLivraisonController@show');
Route::post('livraison/detail/{id}', 'BonLivraisonController@show');
Route::get('livraison/ajouter/{id}', 'BonLivraisonController@add');

Route::get('livraison/annuler/{id}', 'BonLivraisonController@annuler');
Route::post('livraison/import', 'BonLivraisonController@export');

   // Route::get('produit/test', 'ProduitController@test');

 //Historiques des  actions
Route::get('historique/index','HistoriqueController@index');
Route::get('historique/rechercheHisto', 'HistoriqueController@rechercheHisto')->name('rechercheHisto');
Route::get('preparation/recherchePrep', 'PreparationController@recherchePrep')->name('recherchePrep');


    //client
Route::get('client/index', 'ClientController@index');
Route::get('client/ajouter', 'ClientController@getForm');
Route::post('client/ajouter','ClientController@postForm');
Route::post('client/supprimer/{id}','ClientController@delete');
Route::get('client/modifier/{id}', 'ClientController@getFormEdit');
Route::put('client/modifier/{id}', 'ClientController@postFormEdit');

    //production
Route::resource('production/index', 'ProductionController');

    //tracabilité
Route::resource('tracabilite/index', 'TracabiliteController');
Route::get('tracabilite/recherche', 'TracabiliteController@rechercheTraca')->name('rechercheTraca');

    //
Route::resource('transfert/index', 'TransfertController');
Route::get('produit/rechercheTrans', 'TransfertController@rechercheTrans')->name('rechercheTrans');

//super admin
Route::get('super_admin/index', 'SuperAdminController@index');
Route::post('super_admin/moduleBdd', 'SuperAdminController@moduleBdd')->name('moduleBdd');
Route::post('super_admin/tableBdd', 'SuperAdminController@tableBdd')->name('tableBdd');
Route::get('super_admin/deconnecter_devices', 'SuperAdminController@deconnecter_devices')->name("deconnecter_devices");
Route::get('super_admin/supp_devices', 'SuperAdminController@supp_devices')->name("supp_devices");
Route::get('super_admin/export_preference', 'SuperAdminController@export_preference')->name("export_preference");

});