<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 30/05/2017
 * Time: 11:37
 */

namespace App\Http\Controllers;

use App\Emplacement;
use App\Historique;
use App\Zone;
use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use App\BonReception;
use App\LigneBonReception;
use App\StockProduit;

use Carbon\Carbon;
use Illuminate\Support\Facades\Session;

use Illuminate\Http\Request;

class ZoneController extends Controller
{




    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                $stockProduit->update();*/

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }




    public function index()
    {
        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        $zones = Zone::all();
        return view('zone.index',compact('zones'));
    }


    public function getForm()
    {
        return view('zone.ajouter');
    }


    public function postForm(Request $request)
    {

        $zone = Zone::where('libelle','=',$request->input('libelle'))->first();
        if($zone == null)
        {
            $zone = new Zone();
            $zone->libelle = $request->input('libelle');
            $zone->description = $request->input('description');

            $zone->save();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Administration->Les zones de l\'entrepôt';
            $HistoriqueActions->description = 'Ajout du zone : '.$zone->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('zone/index')->with('msgAdd',"La nouvelle zone de stockage a été ajouté avec succès");

        }
        else
        {
            return redirect()->back()->withInput()->with('msgLib','Le libellé existe déjà');
        }

    }


    public function delete($id)
    {

        $exist = Emplacement::where('id_zone', '=', $id)->count();
        if($exist == 0)
        {
            $zone=Zone::find($id);

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Administration->Les zones de l\'entrepôt';
            $HistoriqueActions->description = 'Suppression du zone : '.$zone->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $zone->delete();

            return redirect('zone/index')->with('msgDelete',"La zone de stockage a été supprimé avec succès");

        }
        else
        {
            return redirect('zone/index')->with('msgDeleteImpossible',"Impossible de supprimer cette zone de stockage car il y a des emplacements qui sont affectés");

        }


    }


    public function getFormEdit($id)
    {
        $zone = Zone::find($id);
        return view('zone/modifier', compact('zone'));
    }


    public function postFormEdit(Request $request, $id)
    {
        $zone = Zone::find($id);
        $exist = Zone::where('libelle','=',$request->input('libelle'))->where('id_zone','!=',$id)->count();

        if($exist == 0 )
        {
            $zone->libelle = $request->input('libelle');
            $zone->description = $request->input('description');

            $zone->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Administration->Les zones de l\'entrepôt';
            $HistoriqueActions->description = 'Modification du zone : '.$zone->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('zone/index')->with('msgAdd',"La zone de stockage a été modifié avec succès");
        }
        else
        {
            return redirect('zone/modifier/'.$id)->with('msgLib','Le libellé existe déjà');

        }

    }

}