<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 24/05/2017
 * Time: 12:03
 */

namespace App\Http\Controllers;


use App\Historique;
use App\ProfileMobile;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\User;
use App\ProfilBackoffice;
use Illuminate\Support\Facades\Input;

use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use App\BonReception;
use App\LigneBonReception;
use App\StockProduit;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;


class UtilisateurController extends Controller
{

    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();
            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                $stockProduit->update();*/

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }



    public function getDroits(){
        $id = Input::get('ID');
       // dd($id);
        if($id==0){
            $droits=ProfilBackoffice::get();
        }else{
            $droits=ProfileMobile::get();

        }
        //  dd("jhdkjlksq");
       // $code=uniqid(false);





        return response()->json($droits);
       // dd($droits);

    }

    public function index()
    {

        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        $users = User::with('profil_acces_backoffice')
        ->with('profil_acces_mobile')->get();
    //    dd($users);
        return view('utilisateur.index',compact('users'));
    }

    public function getForm()
    {
        $profils=ProfilBackoffice::get();
        $profils_mobile=ProfileMobile::get();
        return view('utilisateur.ajouter',compact('profils','profils_mobile'));
    }


    public function postForm(Request $request)
    {
        if($request->input('password') == $request->input('password_confirmation'))
        {
            $user = User::where('login', '=',$request->input('login'))->first();
            //dd($user);
            if($user == null)
            {
                $user = new User();
                $user->nom = $request->input('name');
                $user->prenom = $request->input('firstname');
                $user->email = $request->input('email');
                $user->profil = $request->input('profil');
                $user->telephone = $request->input('phone');
                $user->login = $request->input('login');
                $user->password = md5($request->input('password'));
                $user->idProfilDroit = $request->input('profil_droit');
               /// dd($request->input('profil'));
                if( ($request->input('profil')) == '1' )
                {
                   $apiKey = md5(uniqid(rand(), true));
                   $user->api_key = $apiKey;

                  /*  $uniqid=uniqid();
                   // dd($uniqid);

                    $hashed= hash('md5',$uniqid);
                     $user->hashCode=$hashed;*/
                }
                   $user->save();
                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Ajout';
                $HistoriqueActions->nom_table = 'Administration->Utilisateurs';
                $HistoriqueActions->description = 'Ajout d\'utilisateur : '.$user->nom.' '.$user->prenom;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date = Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                return redirect('utilisateur/index')->with('msgAdd',"l'utilisateur a été ajouté avec succès");

            }
            else
            {
                return redirect()->back()->withInput()->with('msgIdf','Identifiant existe déjà');
            }
        }
        else
        {
            return redirect()->back()->withInput()->with('msgPsw','Veuillez confirmer le même mot de passe');
        }
    }


    public function delete($id)
    {
        $user=User::find($id);
        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Suppression';
        $HistoriqueActions->nom_table = 'Administration->Utilisateurs';
        $HistoriqueActions->description = 'Suppression d\'utilisateur : '.$user->nom.' '.$user->prenom;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date = Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();
        $user->delete();

        return redirect('utilisateur/index')->with('msgDelete',"l'utilisateur a été supprimé avec succès");

    }

    public function getFormEdit($id)
    {
        $user = User::find($id);

        $profils=ProfilBackoffice::get();
        $profils_mobile=ProfileMobile::get();
        return view('utilisateur/modifier', compact('user','profils','profils_mobile'));
    }

    public function postFormEdit(Request $request, $id)
    {
        if($request->input('password') == $request->input('password_confirmation')) {


            $user = User::find($id);
            $exist = User::where('login', '=', $request->input('login'))->where('id_user', '!=', $id)->count();
            $passwordChange = User::where('id_user', '=', $id)->value('password');
            // dd($passwordChange);
            if ($exist == 0) {
                $user->nom = $request->input('name');
                $user->prenom = $request->input('firstname');
                $user->email = $request->input('email');
                $user->telephone = $request->input('phone');
                $user->profil = $request->input('profil');
                $user->idProfilDroit = $request->input('profil_droit');
                $user->login = $request->input('login');
                if ($passwordChange != ($request->input('password'))) {
                    $user->password = md5($request->input('password'));
                }

                $user->update();

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Modification';
                $HistoriqueActions->nom_table = 'Administration->Utilisateurs';
                $HistoriqueActions->description = 'Modification d\'utilisateur : '.$user->nom.' '.$user->prenom;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date = Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                return redirect('utilisateur/index')->with('msgAdd', "l'utilisateur a été modifié avec succès");
            } else {
                return redirect('utilisateur/modifier/' . $id)->with('msgIdf', 'Identifiant existe déjà');

            }
        }
        else
            {
                return redirect()->back()->withInput()->with('msgPsw', 'Veuillez confirmer le même mot de passe');
            }
        }

}