<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 25/05/2017
 * Time: 11:55
 */

namespace App\Http\Controllers;

use App\Historique;
use App\Produit;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\UniteMesure;

use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use App\BonReception;
use App\LigneBonReception;
use App\StockProduit;
use Illuminate\Support\Facades\Session;

class UniteMesureController extends Controller
{




    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                $stockProduit->update();*/

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }




    public function index()
    {
        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        $unites_mesure = UniteMesure::all();
        return view('unite_mesure.index',compact('unites_mesure'));
    }


    public function getForm()
    {
        return view('unite_mesure.ajouter');
    }



    public function postForm(Request $request)
    {

        $unite_mesure = UniteMesure::where('libelle','=',$request->input('libelle'))->first();
        if($unite_mesure == null)
        {
            $unite_mesure = new UniteMesure();
            $unite_mesure->libelle = $request->input('libelle');
            $unite_mesure->description = $request->input('description');

            $unite_mesure->save();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Administration->Les unités de mesure';
            $HistoriqueActions->description = 'Ajout d\'unité de mesure : '.$unite_mesure->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('unite_mesure/index')->with('msgAdd',"L'unité de mesure a été ajouté avec succès");

        }
        else
        {
            return redirect()->back()->withInput()->with('msgLib','Le libellé existe déjà');
        }

    }


    public function delete($id)
    {

        $existe = Produit::where('code_mesure', '=', $id)->count();
        if($existe == 0)
        {
            $unite_mesure=UniteMesure::find($id);
            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Administration->Les unités de mesure';
            $HistoriqueActions->description = 'Suppression  d\'unité de mesure : '.$unite_mesure->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();
            $unite_mesure->delete();
            return redirect('unite_mesure/index')->with('msgDeleteOk',"L'unité de mesure a été supprimé avec succès");
        }
        else
        {
            return redirect('unite_mesure/index')->with('msgDeleteNotOk',"Suppression impossible car cette unité de mesure est affecté a un produit ");
        }





    }

    public function getFormEdit($id)
    {
        $unite_mesure = UniteMesure::find($id);
        return view('unite_mesure/modifier', compact('unite_mesure'));
    }

    public function postFormEdit(Request $request, $id)
    {
        $unite_mesure = UniteMesure::find($id);
        $exist = UniteMesure::where('libelle','=',$request->input('libelle'))->where('id_unite_mesure','!=',$id)->count();
        if($exist == 0)
        {
            $unite_mesure->libelle = $request->input('libelle');
            $unite_mesure->description = $request->input('description');

            $unite_mesure->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Administration->Les unités de mesure';
            $HistoriqueActions->description = 'Modification  d\'unité de mesure : '.$unite_mesure->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('unite_mesure/index')->with('msgAdd',"L'unité de mesure a été modifié avec succès");
        }
        else
        {
            return redirect('unite_mesure/modifier/'.$id)->with('msgLib',"L'unité de mesure existe déjà");

        }

    }


}