<?php

namespace App\Http\Controllers;


use App\Preparation;
use App\Transporteur;
use App\Zone;
use App\Emplacement;
use App\Historique;
use Carbon\Carbon;
use Illuminate\Database\SeedServiceProvider;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;





class TransporteurController extends Controller
{

    public function index()
    {
        $transporteurs= Transporteur::all();
       // dd($transporteurs);
        return view('transporteur.index',compact('transporteurs'));
    }

    public function delete($id)
    {
        $exist = Preparation::where('idTransporteur', '=', $id)->count();
        if($exist == 0)
        {

            $transporteurs= Transporteur::find($id);

            $historique = new Historique();
            $historique->type_action = 'Supprission';
            $historique->nom_table = 'Transporteur';
            $historique->date = date("Y-m-d");
            $historique->description = "Supprission du transporteur N°: ".$transporteurs->numTransporteur."  de la liste de transporteurs de la base de données ";
            $historique->nom_user = Session::get('nom') ." ". Session::get('prenom');
            $historique->save();

            Transporteur::find($id)->delete();

            return redirect('transporteur/index')->with('msgDeleteOk',"Le transporteur a été supprimé avec succès");
        }
        else
       {
            return redirect('transporteur/index')->with('msgDeleteNotOk',"Impossible de supprimer le transporteur, car des préparations lui sont attribuées.");
        }




      //  return redirect('commande_client/index')->with('msgSupprimer','La commande client a été annuler avec succès');
    }

    public function getForm()
    {

        $emplacements=Emplacement::where('emplacement_mobile','=','OUI')->get();
        return view('transporteur.ajouter',compact('emplacements'));
    }

    public function postForm(Request $request)
    {
        $exist = Transporteur::where('numTransporteur', '=', $request->input('numTransporteur'))->count();
        if($exist == 0)
        {

            $transporteur = new Transporteur();
            $transporteur->numTransporteur = $request->input('numTransporteur');

            $transporteur->raisonSocial = $request->input('raison_social');

            $transporteur->nomTransporteur = $request->input('nomTransporteur');
            $transporteur->prenomTransporteur = $request->input('prenomTransporteur');
            $transporteur->telephoneTransporteur = $request->input('telephoneTransporteur');
            $transporteur->idEmplacement = $request->input('idSelectVehicule');
            $transporteur->save();


            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Clients->Les transporteurs';
            $HistoriqueActions->description = 'Ajout du transporteur  : '.$transporteur->nomTransporteur.' '.$transporteur->prenomTransporteur;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('transporteur/index')->with('msgAddSuccess',"Le transporteur a été ajouté avec succès");



        }
        else
        {
            return redirect('transporteur/ajouter')->with('msgAddExist',"Ce transporteur existe déjà");

        }
    }


    public function getFormEdit($id)
    {

        $transporteur = Transporteur::find($id);
        $emplacements=Emplacement::where('emplacement_mobile','=','OUI')->get();

        return view('transporteur/modifier', compact('transporteur','emplacements'));


    }


    public function postFormEdit(Request $request, $id)
    {

        //dd($request->input());

        $transporteur = Transporteur::find($id);
       // dd($transporteur);
        $exist = Transporteur::where('numTransporteur', '=', $request->input('numTransporteur'))
            ->where('numTransporteur', '!=', $transporteur->numTransporteur)
            ->count();
        //dd($exist);
        if($exist == 0)
        {


            $transporteur->numTransporteur = $request->input('numTransporteur');

            $transporteur->raisonSocial = $request->input('raison_social');
            
            $transporteur->nomTransporteur = $request->input('nomTransporteur');
            $transporteur->prenomTransporteur = $request->input('prenomTransporteur');
            $transporteur->telephoneTransporteur = $request->input('telephoneTransporteur');
            $transporteur->idEmplacement = $request->input('idSelectVehicule');
            $transporteur->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Clients->Les transporteurs';
            $HistoriqueActions->description = 'Modification du transporteur  : '.$transporteur->nomTransporteur.' '.$transporteur->prenomTransporteur;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('transporteur/index')->with('msgAddSuccess',"Le transporteur a été modifié avec succès");

        }
        else
        {
            return redirect('transporteur/modifier/'.$id)->with('msgUpdateExist','Ce transporteur existe déjà');

        }


    }



}
