<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Transfert;

class TransfertController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        /*for ($i=0; $i < 5000 ; $i++) { 
            $tran = new Transfert();
            $tran->num_transfert = "210";
            $tran->idStock = 28;
            $tran->idEmplacementSrc = 31;
            $tran->idEmplacementDes = 33;
            $tran->qntTrans = 6;
            $tran->id_operateur = 43;
            $tran->date_trans = "02/08/2020";
            $tran->last_update = date("Y-m-d H:i:s");
            $tran->save();
        }*/
        $transferts = Transfert::with('emplacementSource')->with('emplacementDestination')->with('produitStock.produit')->with('operateur')->orderBy('date_trans', 'DESC')->paginate(10);
        //dd($transferts);
        return view('transfert/index',compact('transferts'));
    }


    public function rechercheTrans(Request $request){

    $mot_a_rechercher = $request->get('recherche');

    $transferts = Transfert::
    join('user','user.id_user','=','transfert.id_operateur')->
    join('emplacement AS source','source.id_emplacement','=','transfert.idEmplacementSrc')->
    join('emplacement AS des','des.id_emplacement','=','transfert.idEmplacementDes')->
    join('stock_produit','stock_produit.id_stock_produit','=','transfert.idStock')->
    join('produit','produit.id_produit','=','stock_produit.id_produit')->

    Where('source.libelle','like','%'.$mot_a_rechercher.'%')->
    orWhere('des.libelle','like','%'.$mot_a_rechercher.'%')->
    orWhere('qntTrans','like','%'.$mot_a_rechercher.'%')->
    orWhere('ssccTrans','like','%'.$mot_a_rechercher.'%')->
    orWhere('user.nom','like','%'.$mot_a_rechercher.'%')->
    orWhere('user.prenom','like','%'.$mot_a_rechercher.'%')->
    orWhere('reference','like','%'.$mot_a_rechercher.'%')->
    orWhere('designation','like','%'.$mot_a_rechercher.'%')->

    with('emplacementSource')->with('emplacementDestination')->with('produitStock.produit')->with('operateur')->orderBy('date_trans', 'DESC')->select('source.libelle as libelle_source','des.libelle as libelle_des','transfert.*')->paginate(10)->appends('recherche' , $mot_a_rechercher);
            //dd($transferts);

    return view('transfert.index',compact('transferts','mot_a_rechercher'));
}
}