<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Tracabilite;

use DB;

class TracabiliteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$tracabilite = Tracabilite::count();
        $tracabilite = Tracabilite::paginate(10);
        //dd($tracabilite);
        return view('tracabilite.index',compact('tracabilite'));
    }

    public function rechercheTraca(Request $request){

    $mot_a_rechercher = $request->get('recherche');
    if ($mot_a_rechercher == "" || $mot_a_rechercher == null) {
        return $this->index();
    }

    $tracabilite = Tracabilite::
    join('user','user.id_user','=','tracabilite.operateur')->
    join('emplacement','emplacement.id_emplacement','=','tracabilite.emplacement')->

    Where('date','like','%'.$mot_a_rechercher.'%')->
    orWhere('sscc','like','%'.$mot_a_rechercher.'%')->
    orWhere('evenement','like','%'.$mot_a_rechercher.'%')->
    orWhere('user.nom','like','%'.$mot_a_rechercher.'%')->
    orWhere('user.prenom','like','%'.$mot_a_rechercher.'%')->
    orWhere('emplacement.libelle','like','%'.$mot_a_rechercher.'%')->
    paginate(10)->appends('recherche' , $mot_a_rechercher);
    //dd($tracabilite);
    return view('tracabilite.index',compact('tracabilite','mot_a_rechercher'));
}

   
}
