<?php
namespace App\Http\Controllers;

use App\BonReception;
use App\LigneBonReception;
use App\StockProduit;
use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use Illuminate\Support\Facades\Session;
use App\Device;
use App\Version;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Preferences;
use Excel;

class SuperAdminController extends Controller{
    public function index(){

        $version = Version::all();
        $device = Device::all();

        return view('super_admin/index',compact('version','device'));
    }
    public function deconnecter_devices(Request $request){

        $devices = Device::get();
        foreach ($devices as $key => $d) {
            $d->flag_synchro = 0;
            $d->save();
        }
        

        $request->session()->flash('ok', 'La base de données a été mise à jour avec succès');
        return redirect('super_admin/index');
    }

    public function export_preference(){


        $preferences = Preferences::get();

        //dd($preferences);


        Excel::create('Preference_'.date('y-m-d'),function($excel) use ($preferences){
        $excel->sheet('Feuil1', function($sheet) use ($preferences){
            
            /*$sheet->setStyle(array(
                'font' => array(
                    'name' =>  'Calibri',
                    'size' =>  10,
                )
            ));*/
            /*$sheet->setWidth(array(
                'A' =>  30,
                'B' =>  50,
                'C' =>  30,
                'D' =>  30,
                'E' =>  15,
                'F' =>  20,
                'G' =>  70,
                'H' =>  15,
                'I' =>  15,
                'J' =>  15,
                'K' =>  25,
            ));*/
            //$sheet->getStyle('T')->getAlignment()->setWrapText(true);
            $sheet->loadView('configuration.preferences.export.exportExcel')->with(['preferences'=>$preferences]);
        });
    })->download('xlsx');
        
    }

    public function moduleBdd(Request $request){
        $all_module = $request->input('allmodule');
        $modules = $request->input('module');
        if ($all_module != null) {
            DB::unprepared('truncate table bon_reception');
            DB::unprepared('truncate table ligne_bon_reception');
            DB::unprepared('truncate table ligne_bon_reception_ue');
            DB::unprepared('truncate table num_serie');

            DB::unprepared('truncate table preparation');
            DB::unprepared('truncate table ligne_produit');
            DB::unprepared('truncate table unite_expedition');
            DB::unprepared('truncate table entite');
            DB::unprepared('truncate table numero_serie');

            DB::unprepared('truncate table inventaire');
            DB::unprepared('truncate table ligne_inventaire');

            DB::unprepared('truncate table inventaire');
            DB::unprepared('truncate table ligne_inventaire');

            DB::unprepared('truncate table commande_client');
            DB::unprepared('truncate table ligne_commande_produit');

            DB::unprepared('truncate table commande_fournisseur');
            DB::unprepared('truncate table ligne_commande_fournisseur');

            DB::unprepared('truncate table chargement');
            DB::unprepared('truncate table ligne_preparation_chargement');

            DB::unprepared('truncate table bon_livraison');
            DB::unprepared('truncate table ligne_bl_produit');

            DB::unprepared('truncate table stock_produit');
            DB::unprepared('truncate table ue');

            DB::unprepared('truncate table transfert');

            DB::unprepared('truncate table historique');

            DB::unprepared('truncate table tracabilite');

            //DB::unprepared('truncate table preferences');

            DB::unprepared('truncate table production');

            DB::unprepared('truncate table compteur_module');

         }else{
            foreach ($modules as $key => $value) {
                switch ($value) {
                    case 'RECEPTION':
                        DB::unprepared('truncate table bon_reception');
                        DB::unprepared('truncate table ligne_bon_reception');
                        DB::unprepared('truncate table ligne_bon_reception_ue');
                        DB::unprepared('truncate table num_serie');
                        break;

                    case 'PREPARATION':
                        DB::unprepared('truncate table preparation');
                        DB::unprepared('truncate table ligne_produit');
                        DB::unprepared('truncate table unite_expedition');
                        DB::unprepared('truncate table entite');
                        DB::unprepared('truncate table numero_serie');
                        break;

                    case 'INVENTAIRE':
                        DB::unprepared('truncate table inventaire');
                        DB::unprepared('truncate table ligne_inventaire');
                        break;

                    case 'INVENTAIRE':
                        DB::unprepared('truncate table inventaire');
                        DB::unprepared('truncate table ligne_inventaire');
                        break;

                    case 'COMMANDE CLIENT':
                        DB::unprepared('truncate table commande_client');
                        DB::unprepared('truncate table ligne_commande_produit');
                        break;

                    case 'COMMANDE FOURNISSEUR':
                        DB::unprepared('truncate table commande_fournisseur');
                        DB::unprepared('truncate table ligne_commande_fournisseur');
                        break;

                    case 'CHARGEMENT':
                        DB::unprepared('truncate table chargement');
                        DB::unprepared('truncate table ligne_preparation_chargement');
                        break;

                    case 'LIVRAISON':
                        DB::unprepared('truncate table bon_livraison');
                        DB::unprepared('truncate table ligne_bl_produit');
                        break;

                    case 'STOCK':
                        DB::unprepared('truncate table stock_produit');
                        DB::unprepared('truncate table ue');
                        break;

                    case 'TRANSFERT':
                        DB::unprepared('truncate table transfert');
                        break;

                    case 'HISTORIQUE':
                        DB::unprepared('truncate table historique');
                        break;

                    case 'TRACABILITE':
                        DB::unprepared('truncate table tracabilite');
                        break;

                    /*case 'PREFERENCE':
                        DB::unprepared('truncate table preferences');
                        break;*/

                    case 'PRODUCTION':
                        DB::unprepared('truncate table production');
                        break;

                    case 'COMPTEUR MODULE':
                        DB::unprepared('truncate table compteur_module');
                        break;
                }

            }
         }
        $request->session()->flash('ok', 'La base de données a été mise à jour avec succès');
        return redirect('super_admin/index');
    }

    public function tableBdd(Request $request){
        $all_bdd = $request->input('allbdd');
        $bdd = $request->input('bdd');
        if ($all_bdd != null) {
            DB::unprepared('truncate table bon_livraison');
            DB::unprepared('truncate table bon_reception');
            DB::unprepared('truncate table categorie');
            DB::unprepared('truncate table chargement');
            DB::unprepared('truncate table client');
            DB::unprepared('truncate table commande_client');
            DB::unprepared('truncate table commande_fournisseur');
            DB::unprepared('truncate table commune');
            DB::unprepared('truncate table compteur_module');
            DB::unprepared('truncate table configuration_pdf');

            DB::unprepared('truncate table device');
            DB::unprepared('truncate table droit_acces');
            DB::unprepared('truncate table droit_acces_backoffice');
            DB::unprepared('truncate table droit_acces_mobile');
            DB::unprepared('truncate table emplacement');
            DB::unprepared('truncate table entite');
            DB::unprepared('truncate table fournisseur');
            DB::unprepared('truncate table historique');
            DB::unprepared('truncate table inventaire');
            DB::unprepared('truncate table ligne_bl_produit');

            DB::unprepared('truncate table ligne_bon_reception');
            DB::unprepared('truncate table ligne_bon_reception_ue');
            DB::unprepared('truncate table ligne_commande_fournisseur');
            DB::unprepared('truncate table ligne_commande_produit');
            DB::unprepared('truncate table ligne_inventaire');
            DB::unprepared('truncate table ligne_preparation_chargement');
            DB::unprepared('truncate table ligne_produit');
            DB::unprepared('truncate table liste_valeur');
            DB::unprepared('truncate table log_table');
            DB::unprepared('truncate table num_serie');
            DB::unprepared('truncate table numero_serie');

            DB::unprepared('truncate table preferences');
            DB::unprepared('truncate table preparation');
            DB::unprepared('truncate table production');
            DB::unprepared('truncate table produit');
            DB::unprepared('truncate table produit_compose');
            DB::unprepared('truncate table profil_backoffice');
            DB::unprepared('truncate table profil_mobile');
            DB::unprepared('truncate table stock_produit');
            DB::unprepared('truncate table tracabilite');
            DB::unprepared('truncate table transfert');

            DB::unprepared('truncate table transporteur');
            DB::unprepared('truncate table ue');
            DB::unprepared('truncate table unite_expedition');
            DB::unprepared('truncate table unite_mesure');
            DB::unprepared('truncate table user');
            DB::unprepared('truncate table utilisateur');
            DB::unprepared('truncate table utilisation');
            DB::unprepared('truncate table version');
            DB::unprepared('truncate table wilaya');
            DB::unprepared('truncate table zone');

        }else{
            foreach ($bdd as $key => $value) {
                switch ($value) {
                    case 'bon_livraison':
                        DB::unprepared('truncate table bon_livraison');
                        break;
                    case 'bon_reception':
                        DB::unprepared('truncate table bon_reception');
                        break;
                    case 'categorie':
                        DB::unprepared('truncate table categorie');
                        break;
                    case 'chargement':
                        DB::unprepared('truncate table chargement');
                        break;
                    case 'client':
                        DB::unprepared('truncate table client');
                        break;
                    case 'commande_client':
                        DB::unprepared('truncate table commande_client');
                        break;
                    case 'commande_fournisseur':
                        DB::unprepared('truncate table commande_fournisseur');
                        break;
                    case 'commune':
                        DB::unprepared('truncate table commune');
                        break;
                    case 'compteur_module':
                        DB::unprepared('truncate table compteur_module');
                        break;
                    case 'configuration_pdf':
                        DB::unprepared('truncate table configuration_pdf');
                        break;
                    case 'device':
                        DB::unprepared('truncate table device');
                        break;

                    case 'droit_acces':
                        DB::unprepared('truncate table droit_acces');
                        break;
                    case 'droit_acces_backoffice':
                        DB::unprepared('truncate table droit_acces_backoffice');
                        break;
                    case 'droit_acces_mobile':
                        DB::unprepared('truncate table droit_acces_mobile');
                        break;
                    case 'emplacement':
                        DB::unprepared('truncate table emplacement');
                        break;
                    case 'entite':
                        DB::unprepared('truncate table entite');
                        break;
                    case 'fournisseur':
                        DB::unprepared('truncate table fournisseur');
                        break;
                    case 'historique':
                        DB::unprepared('truncate table historique');
                        break;
                    case 'inventaire':
                        DB::unprepared('truncate table inventaire');
                        break;
                    case 'ligne_bl_produit':
                        DB::unprepared('truncate table ligne_bl_produit');
                        break;
                    case 'ligne_bon_reception':
                        DB::unprepared('truncate table ligne_bon_reception');
                        break;

                    case 'ligne_bon_reception_ue':
                        DB::unprepared('truncate table ligne_bon_reception_ue');
                        break;
                    case 'ligne_commande_fournisseur':
                        DB::unprepared('truncate table ligne_commande_fournisseur');
                        break;
                    case 'ligne_commande_produit':
                        DB::unprepared('truncate table ligne_commande_produit');
                        break;
                    case 'ligne_inventaire':
                        DB::unprepared('truncate table ligne_inventaire');
                        break;
                    case 'ligne_preparation_chargement':
                        DB::unprepared('truncate table ligne_preparation_chargement');
                        break;
                    case 'ligne_produit':
                        DB::unprepared('truncate table ligne_produit');
                        break;
                    case 'liste_valeur':
                        DB::unprepared('truncate table liste_valeur');
                        break;
                    case 'log_table':
                        DB::unprepared('truncate table log_table');
                        break;
                    case 'num_serie':
                        DB::unprepared('truncate table num_serie');
                        break;
                    case 'numero_serie':
                        DB::unprepared('truncate table numero_serie');
                        break;
                    case 'preferences':
                        DB::unprepared('truncate table preferences');
                        break;

                    case 'preparation':
                        DB::unprepared('truncate table preparation');
                        break;
                    case 'production':
                        DB::unprepared('truncate table production');
                        break;
                    case 'produit':
                        DB::unprepared('truncate table produit');
                        break;
                    case 'produit_compose':
                        DB::unprepared('truncate table produit_compose');
                        break;
                    case 'profil_backoffice':
                        DB::unprepared('truncate table profil_backoffice');
                        break;
                    case 'profil_mobile':
                        DB::unprepared('truncate table profil_mobile');
                        break;
                    case 'stock_produit':
                        DB::unprepared('truncate table stock_produit');
                        break;
                    case 'tracabilite':
                        DB::unprepared('truncate table tracabilite');
                        break;
                    case 'transfert':
                        DB::unprepared('truncate table transfert');
                        break;
                    case 'transporteur':
                        DB::unprepared('truncate table transporteur');
                        break;

                    case 'ue':
                        DB::unprepared('truncate table ue');
                        break;
                    case 'unite_expedition':
                        DB::unprepared('truncate table unite_expedition');
                        break;
                    case 'unite_mesure':
                        DB::unprepared('truncate table unite_mesure');
                        break;
                    case 'user':
                        if (Config::get('database')['default'] == "sqlsrv") {
                            DB::unprepared('truncate table [user]');
                        }else{
                            DB::unprepared('truncate table user');
                        }
                        break;
                   // case 'utilisateur':
                        //DB::unprepared('truncate table utilisateur');
                        //break;
                    case 'utilisation':
                        DB::unprepared('truncate table utilisation');
                        break;
                    case 'version':
                        DB::unprepared('truncate table version');
                        break;
                    case 'wilaya':
                        DB::unprepared('truncate table wilaya');
                        break;
                    case 'bon_livraison':
                        DB::unprepared('truncate table bon_livraison');
                        break;
                    case 'zone':
                        DB::unprepared('truncate table zone');
                        break;    
                }
            }
        }
        $request->session()->flash('ok', 'La base de données a été mise à jour avec succès');
        return redirect('super_admin/index');
    }

}