<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 04/06/2017
 * Time: 14:03
 */

namespace App\Http\Controllers;

use App\Ue;
use App\Entite;
use App\Emplacement;
use App\Historique;
use App\Produit;
use App\StockProduit;
use App\Zone;
use App\Inventaire;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\DB;

use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use App\BonReception;
use App\ListValeur;
use App\LigneBonReception;
use Illuminate\Support\Facades\Session;
use Config;

use Excel;
use PHPExcel;
use DNS1D;
use PHPExcel_Worksheet_Drawing;


class StockProduitController extends Controller
{




    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);
            
            if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur ON');
                }
            foreach($lignescommande as $ligne){

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }
            if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur OFF');
                }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception ON');
                }

            foreach($lignesBonReception as $ligne)
            {
                
                $ligneBonReception = new LigneBonReception();
                    $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                    $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                    $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                    $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                    $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                    $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                    $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;
                    $ligneBonReception->date_fabrication = $ligne->date_fabrication;
                    $ligneBonReception->date_peremption = $ligne->date_peremption;
                    $ligneBonReception->numLot = $ligne->numLot;
                    $ligneBonReception->idEmplacement = $ligne->idEmplacement;
                    $ligneBonReception->id_produit = $ligne->id_produit; 
                    $ligneBonReception->qteReceptionnerFO = $ligne->qteReceptionnerFO;
                    $ligneBonReception->operateur = $ligne->operateur;
                    $ligneBonReception->save();



              /*  $stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->last_update= date("Y-m-d H:i:s");
                $stockProduit->update();*/


            }
            if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception OFF');
                }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');

            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }

    public function index()
    {
        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);


        $stocks = StockProduit::where('quantite' ,"!=", 0)->with('emplacement')->with('produit')->with('Inventaire')->paginate(10);
        

        if (Session::get('N_LOT') == '1') {

        $quantiteCollect = collect();
        $quantiteUtilisableCollect = collect();
        $quantiteReelleCollect = collect();
        $dateEntreeStockCollect = collect();
        $dateInventaireCollect = collect();
        $designationInventaireCollect = collect();  
        
        foreach ($stocks as $key => $stock) {
                
                $quantite_physique = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite');

                $quantite_utilisable = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_utilisable');


                $quantite_reelle = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_reelle');

                $dateEntreeStock = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('date_entree', 'desc')->first();

                $inventaire = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('idInventaire', 'desc')->first();

                $quantiteCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_physique);
                $quantiteUtilisableCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_utilisable);
                $quantiteReelleCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_reelle);

                $dateEntreeStockCollect->put($stock->id_produit."-".$stock->id_emplacement,$dateEntreeStock->date_entree);
                if ($inventaire->idInventaire != null) {
                    $inventairee = Inventaire::find($inventaire->idInventaire);
                    $designation = $inventairee->designationInventaire ;
                    $date = $inventairee->dateFin ;

                    $designationInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $designation);
                    $dateInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $date);
                }
            }

            $stocks = $stocks->groupBy(function($item, $key){   
                return $item["id_produit"]."-".$item["id_emplacement"];
            });
            $produits = Produit::all();
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            $ues = Ue::all();
            return view('stock_produit.index',compact('stocks', 'produits','ues','quantiteCollect','dateEntreeStockCollect','designationInventaireCollect','dateInventaireCollect','emplacements','entites','zones','quantiteReelleCollect','quantiteUtilisableCollect'));
             }else{
                //dd($stocks);
                $produits = null;
                $emplacements = null;
                $entites = Entite::all();
                $zones = Zone::all();
                $ues = null;
                return view('stock_produit.index',compact('stocks', 'produits','emplacements','entites','zones','ues'));
             }
    }

    public function recherche(Request $request){
        $rechercher = 1;
        $produit = $request->get('produit');
        $entite = $request->get('entite');
        $zone = $request->get('zone');
        $emplacement = $request->get('emplacement');
        $ue = $request->get('ue');
        $designation_produit = $request->get('designation_produit');
        $stocks = null;
        //dd($produit, $zone, $entite, $emplacement);
        
        if ($zone) {
            $emplacements = Emplacement::where('id_zone',$zone)->get(['id_emplacement']); 
            $emplacements = $emplacements->toArray();


            $stocks = StockProduit::select('stock_produit.*')->
            join('produit','produit.id_produit','=','stock_produit.id_produit')->
            where('quantite', "!=", 0)->where(function($query) use ($produit, $entite, $emplacement,$emplacements,$ue,$designation_produit){
                            if ( $produit != null) $query->where('stock_produit.id_produit', $produit);
                            if ( $entite != null) $query->where('num_entite', $entite);
                            if ( $ue != null) $query->where('num_ue', $ue);
                            if ( $designation_produit != null) $query->where('designation', 'like','%'.$designation_produit.'%');
                            if ( $emplacement != null) $query->where('id_emplacement', $emplacement); 
                            $query->whereIn('id_emplacement', $emplacements);
                        })->with('emplacement')->with('produit')->with('Inventaire')->paginate(10)->appends(['produit' => $produit, 'entite'=> $entite, 'zone' => $zone, 'emplacement' => $emplacement, 'ue' => $ue, 'designation_produit' => $designation_produit]);

        }else{
            $stocks = StockProduit::select('stock_produit.*')->
            join('produit','produit.id_produit','=','stock_produit.id_produit')->
            where('quantite', "!=", 0)->where(function($query) use ($produit, $entite, $emplacement,$ue,$designation_produit){
                            if ( $produit != null) $query->where('stock_produit.id_produit', $produit);
                            if ( $entite != null) $query->where('num_entite', $entite);
                            if ( $ue != null) $query->where('num_ue', $ue);
                            if ( $designation_produit != null) $query->where('designation', 'like','%'.$designation_produit.'%');
                            if ( $emplacement != null) $query->where('id_emplacement', $emplacement);  
                    })->with('emplacement')->with('produit')->with('Inventaire')->paginate(10)->appends(['produit' => $produit, 'entite'=> $entite, 'zone' => $zone, 'emplacement' => $emplacement, 'ue' => $ue, 'designation_produit' => $designation_produit]);
        }
        //dd($stocks);
        $produitSelected = null;
        $emplacementSelected = null;
        $entiteSelected = null;
        $zoneSelected = null;
        $ueSelected = null;
        $descriptionSelected =null;

        if ($produit != null) $produitSelected = Produit::find($produit);
        if ($emplacement != null) $emplacementSelected = Emplacement::find($emplacement);
        if ($entite != null) $entiteSelected = Entite::find($entite);
        if ($zone != null) $zoneSelected = Zone::find($zone);
        if ($ue != null) $ueSelected = Ue::find($ue);
        if ($designation_produit != null || $designation_produit != "") $descriptionSelected = $designation_produit;

        if (Session::get('N_LOT') == '1') {
            $quantiteCollect = collect();
            $quantiteUtilisableCollect = collect();
            $quantiteReelleCollect = collect();
            $dateInventaireCollect = collect();
            $designationInventaireCollect = collect();  
            $dateEntreeStockCollect = collect();

            foreach ($stocks as $key => $stock) {
    
                $quantite_physique = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite');

                $quantite_utilisable = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_utilisable');

                $quantite_reelle = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_reelle');

               

                $dateEntreeStock = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('date_entree', 'desc')->first();

               

                $inventaire = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('idInventaire', 'desc')->first();

                $quantiteCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_physique);
                $quantiteUtilisableCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_utilisable);
                $quantiteReelleCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_reelle);

                $dateEntreeStockCollect->put($stock->id_produit."-".$stock->id_emplacement,$dateEntreeStock->date_entree);

                if ($inventaire->idInventaire != null) {
                    $inventairee = Inventaire::find($inventaire->idInventaire);
                    $designation = $inventairee->designationInventaire ;
                    $date = $inventairee->dateFin ;

                    $designationInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $designation);
                    $dateInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $date);
                }

            }

            $stocks = $stocks->groupBy(function($item, $key){   
                return $item["id_produit"]."-".$item["id_emplacement"];
            });
            $produits = Produit::all();
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            $ues = Ue::all();

            return view('stock_produit.index',compact('rechercher','ues','stocks', 'produits', 'produitSelected','quantiteCollect','dateInventaireCollect','designationInventaireCollect','dateEntreeStockCollect','zones','entites','emplacements','quantiteUtilisableCollect','quantiteReelleCollect' ,'emplacementSelected','entiteSelected','zoneSelected','ueSelected','designation_produit'));
        }else{
            $produits = Produit::all();
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            $ues = Ue::all();

            return view('stock_produit.index',compact('rechercher','ues','stocks', 'produits', 'produitSelected','zones','entites','emplacements','emplacementSelected','entiteSelected','zoneSelected','ueSelected','designation_produit'));

        }
        
        

    }

    public function recherche_lot(Request $request){
        $produit = $request->input('produit');
        $entite = $request->input('entite');
        $zone = $request->input('zone');
        $emplacement = $request->input('emplacement');
        $stocks = null;
        //dd($produit, $zone, $entite, $emplacement);
        
        if ($zone) {
            $emplacements = Emplacement::where('id_zone',$zone)->get(['id_emplacement']); 
            $emplacements = $emplacements->toArray();
            $stocks= collect();
            $collet = StockProduit::where(function($query) use ($produit, $entite, $emplacement,$emplacements){
                            if ( $produit != null) $query->where('id_produit', $produit);
                            if ( $entite != null) $query->where('num_entite', $entite);
                            if ( $emplacement != null) $query->where('id_emplacement', $emplacement); 
                            $query->whereIn('id_emplacement', $emplacements);
                    })->with('emplacement')->with('produit')->with('Inventaire')->chunk(500, function ($rows) use ($stocks) {
                    foreach ($rows as $row) {
                        $stocks->push($row);
                    }
                });
        }else{
            $stocks= collect();
            $collet = StockProduit::where(function($query) use ($produit, $entite, $emplacement){
                            if ( $produit != null) $query->where('id_produit', $produit);
                            if ( $entite != null) $query->where('num_entite', $entite);
                            if ( $emplacement != null) $query->where('id_emplacement', $emplacement);  
                    })->with('emplacement')->with('produit')->with('Inventaire')->chunk(500, function ($rows) use ($stocks) {
                    foreach ($rows as $row) {
                        $stocks->push($row);
                    }
                });
        }
        //dd($stocks);
        $produitSelected = null;
        $emplacementSelected = null;
        $entiteSelected = null;
        $zoneSelected = null;

        if ($produit != null) $produitSelected = Produit::find($produit);
        if ($emplacement != null) $emplacementSelected = Emplacement::find($emplacement);
        if ($entite != null) $entiteSelected = Entite::find($entite);
        if ($zone != null) $zoneSelected = Zone::find($zone);

        $produits = Produit::all();
        $emplacements = Emplacement::all();
        $entites = Entite::all();
        $zones = Zone::all();

        return view('stock_produit_lot.index',compact('stocks', 'produits', 'produitSelected','zones','entites','emplacements','emplacementSelected','entiteSelected','zoneSelected'));

    }

        public function indexWithIdProduit($idPropduit){
            $stocks = StockProduit::where('id_produit', '=', $idPropduit)->with('emplacement')->with('produit')->get();
            if (Session::get('N_LOT') == '1') {
            $quantiteCollect = collect();
            $quantiteUtilisableCollect = collect();
            $quantiteReelleCollect = collect();
            $dateInventaireCollect = collect();
            $designationInventaireCollect = collect();  
            $dateEntreeStockCollect = collect();
            //$dateCollect = collect();
            //$quantite = 0;
            //$stocks2 = StockProduit::where('id_produit', '=', $idPropduit)->with('emplacement')->with('produit')->with('inventaire')->get();

            foreach ($stocks as $key => $stock) {
    
                $quantite_physique = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite');

                $quantite_utilisable = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_utilisable');

                $quantite_reelle = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_reelle');

               

                $dateEntreeStock = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('date_entree', 'desc')->first();

               

                $inventaire = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('idInventaire', 'desc')->first();

                $quantiteCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_physique);
                $quantiteUtilisableCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_utilisable);
                $quantiteReelleCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_reelle);

                $dateEntreeStockCollect->put($stock->id_produit."-".$stock->id_emplacement,$dateEntreeStock->date_entree);

                if ($inventaire->idInventaire != null) {
                    $inventairee = Inventaire::find($inventaire->idInventaire);
                    $designation = $inventairee->designationInventaire ;
                    $date = $inventairee->dateFin ;

                    $designationInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $designation);
                    $dateInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $date);
                }

            }

            $stocks = $stocks->groupBy(function($item, $key){   
                return $item["id_produit"]."-".$item["id_emplacement"];
            });
            $produits = Produit::all();
            $produitSelected = Produit::find($idPropduit);
            $emplacements = Emplacement::all();
            $entites = Entite::all();

            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'produitSelected','quantiteCollect','dateInventaireCollect','designationInventaireCollect','dateEntreeStockCollect','zones','entites','emplacements','quantiteUtilisableCollect','quantiteReelleCollect'));
        }else{
            $produits = Produit::all();
            $produitSelected = Produit::find($idPropduit);
            $emplacements = Emplacement::all();
            $entites = Entite::all();

            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'produitSelected','zones','entites','emplacements'));

        }
        }

        public function indexWithIdEmplacement($idEmplacement){
            $stocks = StockProduit::where('id_emplacement', '=', $idEmplacement)->with('emplacement')->with('produit')->get();
             if (Session::get('N_LOT') == '1') {
            $quantiteCollect = collect();
            $quantiteUtilisableCollect = collect();
            $quantiteReelleCollect = collect();
            $dateInventaireCollect = collect();
            $designationInventaireCollect = collect();  
            $dateEntreeStockCollect = collect();


            foreach ($stocks as $key => $stock) {


                $quantite_physique = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite');

                $quantite_utilisable = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_utilisable');

                $quantite_reelle = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_reelle');

                

                $dateEntreeStock = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('date_entree', 'desc')->first();

                

                $inventaire = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('idInventaire', 'desc')->first();

                $quantiteCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_physique);
                $quantiteUtilisableCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_utilisable);
                $quantiteReelleCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_reelle);

                $dateEntreeStockCollect->put($stock->id_produit."-".$stock->id_emplacement,$dateEntreeStock->date_entree);

                if ($inventaire->idInventaire != null) {
                    $inventairee = Inventaire::find($inventaire->idInventaire);
                    $designation = $inventairee->designationInventaire ;
                    $date = $inventairee->dateFin ;

                    $designationInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $designation);
                    $dateInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $date);
                }

            }

            $stocks = $stocks->groupBy(function($item, $key){   
                return $item["id_produit"]."-".$item["id_emplacement"];
            });
            $produits = Produit::all();
            $emplacementSelected = Emplacement::find($idEmplacement);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'emplacementSelected','quantiteCollect','dateInventaireCollect','designationInventaireCollect','dateEntreeStockCollect','zones','entites','emplacements','quantiteUtilisableCollect','quantiteReelleCollect'));
        }else{
            $produits = Produit::all();
            $emplacementSelected = Emplacement::find($idEmplacement);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'emplacementSelected','zones','entites','emplacements'));

        }
        }

        public function indexWithIdZone($idZone){

            $emplacements = Emplacement::where('id_zone',$idZone)->get(['id_emplacement']); 
            $emplacements = $emplacements->toArray();


            $stocks = StockProduit::whereIn('id_emplacement', $emplacements)->with('emplacement')->with('produit')->get();
            if (Session::get('N_LOT') == '1') {

            $quantiteCollect = collect();
            $quantiteUtilisableCollect = collect();
            $quantiteReelleCollect = collect();
            $dateInventaireCollect = collect();
            $designationInventaireCollect = collect();  
            $dateEntreeStockCollect = collect();


            foreach ($stocks as $key => $stock) {


                $quantite_physique = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite');

                $quantite_utilisable = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_utilisable');

                $quantite_reelle = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_reelle');

                $dateEntreeStock = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('date_entree', 'desc')->first();

                
                $inventaire = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('idInventaire', 'desc')->first();

                $quantiteCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_physique);
                $quantiteUtilisableCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_utilisable);
                $quantiteReelleCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_reelle);

                $dateEntreeStockCollect->put($stock->id_produit."-".$stock->id_emplacement,$dateEntreeStock->date_entree);

                if ($inventaire->idInventaire != null) {
                    $inventairee = Inventaire::find($inventaire->idInventaire);
                    $designation = $inventairee->designationInventaire ;
                    $date = $inventairee->dateFin ;

                    $designationInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $designation);
                    $dateInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $date);
                }

            }

            $stocks = $stocks->groupBy(function($item, $key){   
                return $item["id_produit"]."-".$item["id_emplacement"];
            });
            $produits = Produit::all();
            $zoneSelected = Zone::find($idZone);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'zoneSelected','quantiteCollect','dateInventaireCollect','designationInventaireCollect','dateEntreeStockCollect','zones','entites','emplacements','quantiteUtilisableCollect','quantiteReelleCollect'));
        }else{
            $produits = Produit::all();
            $zoneSelected = Zone::find($idZone);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'zoneSelected','zones','entites','emplacements'));

        }
        }

        public function indexWithIdEntite($idEntite){
        //dd($idEntite);


            $stocks = StockProduit::where('num_entite', $idEntite)->with('emplacement')->with('produit')->get();
            if (Session::get('N_LOT') == '1') {
            $quantiteCollect = collect();
            $quantiteUtilisableCollect = collect();
            $quantiteReelleCollect = collect();
            $dateInventaireCollect = collect();
            $designationInventaireCollect = collect();  
            $dateEntreeStockCollect = collect();


            foreach ($stocks as $key => $stock) {


                $quantite_physique = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite');

                $quantite_utilisable = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_utilisable');

                $quantite_reelle = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->sum('quantite_reelle');

                $dateEntreeStock = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('date_entree', 'desc')->first();

                
                $inventaire = StockProduit::where('id_produit',$stock->id_produit)->where('id_emplacement',$stock->id_emplacement)->orderBy('idInventaire', 'desc')->first();

                $quantiteCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_physique);
                $quantiteUtilisableCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_utilisable);
                $quantiteReelleCollect->put($stock->id_produit."-".$stock->id_emplacement, $quantite_reelle);

                $dateEntreeStockCollect->put($stock->id_produit."-".$stock->id_emplacement,$dateEntreeStock->date_entree);

                if ($inventaire->idInventaire != null) {
                    $inventairee = Inventaire::find($inventaire->idInventaire);
                    $designation = $inventairee->designationInventaire ;
                    $date = $inventairee->dateFin ;

                    $designationInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $designation);
                    $dateInventaireCollect->put($stock->id_produit."-".$stock->id_emplacement, $date);
                }

            }

            $stocks = $stocks->groupBy(function($item, $key){   
                return $item["id_produit"]."-".$item["id_emplacement"];
            });
            $produits = Produit::all();
            $entiteSelected = Entite::where('num_entite',$idEntite)->first();
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'entiteSelected','quantiteCollect','dateInventaireCollect','designationInventaireCollect','dateEntreeStockCollect','zones','entites','emplacements','quantiteUtilisableCollect','quantiteReelleCollect'));
        }else{
            $produits = Produit::all();
            $entiteSelected = Entite::where('num_entite',$idEntite)->first();
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();

            return view('stock_produit.index',compact('stocks', 'produits', 'entiteSelected','zones','entites','emplacements'));
        }
        }

        public function index_lot(){
            CommandeFournisseur::where('date_creation', '=', null)->delete();
            BonReception::where('date_creation', '=', null)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $this->restorData();
            Session::put('commandes_fournisseurs', null);
            Session::put('bonReception', null);
        //$stocks = StockProduit::all()->with('emplacement.produit')->get();
            /*$stocks = StockProduit::where('quantite' ,"!=", 0)->with('emplacement')->with('produit')->with('Inventaire')->get();*/
            $stocks= collect();
        $collet = StockProduit::where('quantite' ,"!=", 0)->with('emplacement')->with('produit')->with('Inventaire')->chunk(500, function ($rows) use ($stocks) {
            foreach ($rows as $row) {
                $stocks->push($row);
            }
        });
        //dd($stocks);
            $produits = Produit::all();
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            return view('stock_produit_lot.index',compact('stocks', 'produits', 'emplacements','entites','zones'));
        }

        public function indexWithIdProduit_lot($idPropduit){
            $stocks = StockProduit::where('id_produit', '=', $idPropduit)->with('emplacement')->with('produit')->get();
            $produits = Produit::all();
            $produitSelected = Produit::find($idPropduit);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            return view('stock_produit_lot.index',compact('stocks', 'produits', 'produitSelected','emplacements','entites','zones'));
        }
        public function indexWithIdEmplacement_lot($idEmplacement){
            $stocks = StockProduit::where('id_emplacement', $idEmplacement)->with('emplacement')->with('produit')->get();
            $produits = Produit::all();
            $emplacementSelected = Emplacement::find($idEmplacement);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            return view('stock_produit_lot.index',compact('stocks', 'produits', 'emplacementSelected','emplacements','zones','entites'));
        }
        public function indexWithIdZone_lot($idZone){
            $emplacements = Emplacement::where('id_zone',$idZone)->get(['id_emplacement']); 
            $emplacements = $emplacements->toArray();


            $stocks = StockProduit::whereIn('id_emplacement', $emplacements)->with('emplacement')->with('produit')->get();
            $produits = Produit::all();
            $zoneSelected = Zone::find($idZone);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            return view('stock_produit_lot.index',compact('stocks', 'produits', 'zoneSelected','entites','zones','emplacements'));
        }
        public function indexWithIdEntite_lot($idEntite){
            $stocks = StockProduit::where('num_entite', $idEntite)->with('emplacement')->with('produit')->get();
            $produits = Produit::all();
            $entiteSelected = Entite::find($idEntite);
            $emplacements = Emplacement::all();
            $entites = Entite::all();
            $zones = Zone::all();
            return view('stock_produit_lot.index',compact('stocks', 'produits', 'entiteSelected','zones','entites','emplacements'));
        }

        public function getForm()
        {
            $produits = Produit::all();
            $zones = Zone::all();
            $emplacements = Emplacement::all();

            return view('stock_produit.ajouter', compact('produits', 'zones', 'emplacements'));
        }

        public function getForm_lot()
        {
            $produits = Produit::all();
            $zones = Zone::all();
            $emplacements = Emplacement::all();

            return view('stock_produit_lot.ajouter', compact('produits', 'zones', 'emplacements'));
        }

        public function postForm(Request $request)
        {
            
        //$reference_produit = $request->input('reference_produit');
        //$emplacement = Emplacement::where('libelle', '=', $request->input('emplacement'))->first(); //$request->input('emplacement');
            if($request->input('produit')!=null && $request->input('zone') !=null && $request->input('emplacement')!=null) {
                $emplacement = Emplacement::find($request->input('emplacement'));
            //dd($emplacement);
                if ($emplacement->etat == 'NON DISPONIBLE') {

                    return redirect('stock_produit/ajouter')->withInput()->with('msgAddEmplacement', "L'emplacement que vous avez choisi est occupé");
                //  redirect('stock_produit/ajouter')->withInput()->with('msgAddExist',"L'emplacement que vous avez choisi est occupé par un autre stock d'un autre produit");
                } else {

                //  $stock_produit = StockProduit::where('id_produit', '=', $request->input('produit'))->where('id_emplacement', '=', $request->input('emplacement'))->first();
                //  dd($stock_produit);
                //  if($stock_produit == null)
                //   {

                    if ($request->input('quantite') > 0) {
                        $emplacement = Emplacement::find($request->input('emplacement'));
                        $produit = Produit::find($request->input('produit'));
                        $volumeProduit = ($produit->volume) * ($request->input('quantite'));
                        $volumeMax = $emplacement->volumeMax;
                    //dd($volumeMax);
                    $tauxOccupation = 0;
                    if ($volumeMax != 0) {
                        $tauxOccupation = ($emplacement->tauxOccupation) + ($volumeProduit / $volumeMax) * 100;
                        $tauxOccupation = number_format($tauxOccupation, 2);
                    }
                        
                    //  dd($tauxOccupation);

                        if ($tauxOccupation > 100) {

                            return redirect('stock_produit/ajouter')->withInput()->with('msgAddEmplacement', "L'emplacement sélectionné ne peut pas contenir toute cette quantité");
                        } else {
                            $edit = false;
                            $idStock = 0;
                            if (Session::get('N_LOT') == '1') {
                                $s = StockProduit::where('numero_lot', '=', $request->input('numeroLot'))
                                ->where('id_produit', '=', $request->input('produit'))
                                ->where('id_emplacement', '=', $request->input('emplacement'))
                                ->where('num_ue', $request->input('ue'))
                                ->where('num_entite', $request->input('entite'))
                                ->get();
                                if ($s->first() != null) {
                                    $edit = true;
                                    $idStock = $s->first()->id_stock_produit;
                                }
                            }  
                            if (Session::get('N_LOT') == '0'){
                                $s = StockProduit::where('id_emplacement', '=', $request->input('emplacement'))
                                ->where('id_produit', '=', $request->input('produit'))
                                ->where('num_ue', $request->input('ue'))
                                ->where('num_entite', $request->input('entite'))
                                ->get();
                                if ($s->first() != null) {
                                    $edit = true;
                                    $idStock = $s->first()->id_stock_produit;
                                }
                            }
                            if ($edit) {
                                $stock_produit = StockProduit::find($idStock);
                                $stock_produit->quantite = $stock_produit->quantite + $request->input('quantite');
                                $stock_produit->quantite_utilisable = $stock_produit->quantite_utilisable + $request->input('quantite');
                                $stock_produit->quantite_reelle = $stock_produit->quantite_reelle + $request->input('quantite');
                                $stock_produit->date_entree = $request->input('date');
                                if (Session::get('DATE_PEREMPTION') == '1') {
                                    $stock_produit->date_fabrication = $request->input('dateFabrication');
                                    $stock_produit->date_peremption = $request->input('datePeremption');
                                }
                                $stock_produit->validation = 1;
                                $stock_produit->update();

                                $produit=Produit::find($stock_produit->id_produit);
                                $HistoriqueActions = new Historique();
                                $HistoriqueActions->type_action = 'Ajout';
                                $HistoriqueActions->nom_table = 'Administration->Stock';
                                $HistoriqueActions->description = 'Ajout du stock : '.$produit->reference;
                                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                                $HistoriqueActions->save();

                            } else {
                                $stock_produit = new StockProduit();
                                $stock_produit->quantite = $request->input('quantite');
                                $stock_produit->quantite_utilisable = $request->input('quantite');
                                $stock_produit->quantite_reelle = $request->input('quantite');
                                $stock_produit->date_entree = $request->input('date');
                                $stock_produit->id_produit = $request->input('produit');
                                $stock_produit->id_emplacement = $request->input('emplacement');
                                if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                                    $stock_produit->num_ue = $request->input('ue');
                                }
                                if (Session::get('STOCK_ENTITE') == '1') {
                                    $stock_produit->num_entite = $request->input('entite');
                                }
                                if (Session::get('N_LOT') == '1') {
                                    $stock_produit->numero_lot = $request->input('numeroLot');
                                } else {
                                    $stock_produit->numero_lot = "";
                                }
                                if (Session::get('DATE_PEREMPTION') == '1') {
                                    $stock_produit->date_fabrication = $request->input('dateFabrication');
                                    $stock_produit->date_peremption = $request->input('datePeremption');
                                }
                                $stock_produit->validation = 1;
                                $stock_produit->save();

                            //ajouter entité
                            if (Session::get('STOCK_ENTITE') == '1') {
                                $entite = Entite::where('num_entite',$request->input('entite'))->first();
                                $liste_valeur = ListValeur::join('preferences','preferences.valeur_preference',"=","liste_valeur.code")
                                                    ->where('nom_liste', "TYPE_ENTITE")->first();
                                if ($entite == null) {
                                    $new_entite = new Entite();
                                    $new_entite->num_entite = $request->input('entite');
                                    $new_entite->type_entite = $liste_valeur->valeur;
                                    $new_entite->libelle_entite = "";
                                    $new_entite->save();
                                }
                            }
                            //ajouter UE
                            //0 : FERMER
                            //1 : OUVERT
                            //2 : VIDE
                            if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                                $ue = UE::where('num_ue',$request->input('ue'))->first();
                                
                                if ($ue == null) {
                                    $new_ue = new UE();
                                    $new_ue->num_ue = $request->input('ue');
                                    $new_ue->nbr_produit = 1;
                                    $new_ue->etat_ue = 0;
                                    $new_ue->id_emplacement = $request->input('emplacement');
                                    $new_ue->last_update = date("Y-m-d H:i:s");
                                    $new_ue->save();
                                }else{
                                    $ue->nbr_produit += 1;
                                    $ue->etat_ue = 1;
                                    $ue->last_update = date("Y-m-d H:i:s");
                                    $ue->update();
                                }
                            }

                                $produit=Produit::find($stock_produit->id_produit);
                                $HistoriqueActions = new Historique();
                                $HistoriqueActions->type_action = 'Ajout';
                                $HistoriqueActions->nom_table = 'Administration->Stock';
                                $HistoriqueActions->description = 'Ajout du stock : '.$produit->reference;
                                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                                $HistoriqueActions->save();

                            //$emplacement = Emplacement::find($request->input('emplacement'));
                            }
                            $emplacement->tauxOccupation = $tauxOccupation;
                            if ($tauxOccupation == 100) {
                                $emplacement->etat = 'NON DISPONIBLE';
                            }
                            $emplacement->last_update = date("Y-m-d H:i:s");
                            $emplacement->update();


                            return redirect('stock_produit/index')->with('msgAjouter', "Le stock de ce produit a été ajouté avec succès");

                        }


                    } else {
                    // return redirect('stock_produit/ajouter')->with('msgAddQuantite',"Veuillez introduire une quantité supérieure à 0");
                        return redirect()->back()->withInput()->with('msgAddQuantite', "Veuillez introduire une quantité supérieure à 0");
                    }

                // }
                /*  else
                  {
                      return redirect()->back()->withInput()->with('msgAddExist',"Un stock de ce produit existe déjà dans cet emplacement");
                      //   return redirect('stock_produit/ajouter')->with('msgAddExist',"Un stock de ce produit existe déjà dans cet emplacement");
                  }*/
              }
          }else{
            return redirect('stock_produit/ajouter')->withInput()->with('msgAddEmplacement',"tous les champs sont obligatoires");

        }
    }

    public function postForm_lot(Request $request)
    {
        if($request->input('produit')!=null && $request->input('zone') !=null && $request->input('emplacement')!=null) {
            $emplacement = Emplacement::find($request->input('emplacement'));
            if ($emplacement->etat == 'NON DISPONIBLE') {

                return redirect('stock_produit_lot/ajouter')->withInput()->with('msgAddEmplacement', "L'emplacement que vous avez choisi est occupé");
            } else {

                if ($request->input('quantite') > 0) {
                    $emplacement = Emplacement::find($request->input('emplacement'));
                    $produit = Produit::find($request->input('produit'));
                    $volumeProduit = ($produit->volume) * ($request->input('quantite'));
                    $volumeMax = $emplacement->volumeMax;
                    $tauxOccupation = ($emplacement->tauxOccupation) + ($volumeProduit / $volumeMax) * 100;
                    $tauxOccupation = number_format($tauxOccupation, 2);

                    if ($tauxOccupation > 100) {

                        return redirect('stock_produit_lot/ajouter')->withInput()->with('msgAddEmplacement', "L'emplacement sélectionné ne peut pas contenir toute cette quantité");
                    } else {
                        $edit = false;
                        $idStock = 0;
                        if (Session::get('N_LOT') == '1') {
                            $s = StockProduit::where('numero_lot', '=', $request->input('numeroLot'))
                            ->where('id_produit', '=', $request->input('produit'))
                            ->where('id_emplacement', '=', $request->input('emplacement'))
                            ->where('num_ue', $request->input('ue'))
                            ->where('num_entite', $request->input('entite'))
                            ->get();
                            if ($s->first() != null) {
                                $edit = true;
                                $idStock = $s->first()->id_stock_produit;
                            }
                        } else {
                            $s = StockProduit::where('id_emplacement', '=', $request->input('emplacement'))
                            ->where('id_produit', '=', $request->input('produit'))
                            ->get();
                            if ($s->first() != null) {
                                $edit = true;
                                $idStock = $s->first()->id_stock_produit;
                            }
                        }
                        if ($edit) {
                            $stock_produit = StockProduit::find($idStock);
                            $stock_produit->quantite = $stock_produit->quantite + $request->input('quantite');
                            $stock_produit->quantite_utilisable = $stock_produit->quantite_utilisable + $request->input('quantite');
                            $stock_produit->quantite_reelle = $stock_produit->quantite_reelle + $request->input('quantite');
                            $stock_produit->date_entree = $request->input('date');
                            if (Session::get('DATE_PEREMPTION') == '1') {
                                $stock_produit->date_fabrication = $request->input('dateFabrication');
                                $stock_produit->date_peremption = $request->input('datePeremption');
                            }
                            $stock_produit->validation = 1;
                            $stock_produit->update();

                            $produit=Produit::find($stock_produit->id_produit);
                            $HistoriqueActions = new Historique();
                            $HistoriqueActions->type_action = 'Ajout';
                            $HistoriqueActions->nom_table = 'Administration->Stock';
                            $HistoriqueActions->description = 'Ajout du stock : '.$produit->reference;
                            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                            $HistoriqueActions->save();

                        } else {
                            $stock_produit = new StockProduit();
                            $stock_produit->num_entite = $request->input('entite');
                            $stock_produit->num_ue = $request->input('ue');
                            $stock_produit->quantite = $request->input('quantite');
                            $stock_produit->quantite_utilisable = $request->input('quantite');
                            $stock_produit->quantite_reelle = $request->input('quantite');
                            $stock_produit->date_entree = $request->input('date');
                            $stock_produit->id_produit = $request->input('produit');
                            $stock_produit->id_emplacement = $request->input('emplacement');
                            if (Session::get('N_LOT') == '1') {
                                $stock_produit->numero_lot = $request->input('numeroLot');
                            } else {
                                $stock_produit->numero_lot = "";
                            }
                            if (Session::get('DATE_PEREMPTION') == '1') {
                                $stock_produit->date_fabrication = $request->input('dateFabrication');
                                $stock_produit->date_peremption = $request->input('datePeremption');
                            }
                            $stock_produit->validation = 1;
                            $stock_produit->save();

                        //ajouter entité
                        if (Session::get('STOCK_ENTITE') == '1') {
                            $entite = Entite::where('num_entite',$request->input('entite'))->first();
                            $liste_valeur = ListValeur::join('preferences','preferences.valeur_preference',"=","liste_valeur.code")
                                                    ->where('nom_liste', "TYPE_ENTITE")->first();
                            if ($entite == null) {
                                $new_entite = new Entite();
                                $new_entite->num_entite = $request->input('entite');
                                $new_entite->type_entite = $liste_valeur->valeur;
                                $new_entite->libelle_entite = "";
                                $new_entite->save();
                            }
                        }
                        //ajouter UE
                        if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                            $ue = UE::where('num_ue',$request->input('ue'))->first();
                            if ($ue == null) {
                                $new_ue = new UE();
                                $new_ue->num_ue = $request->input('ue');
                                $new_ue->nbr_produit = 1;
                                $new_ue->etat_ue = 0;
                                $new_ue->id_emplacement = $request->input('emplacement');
                                $new_ue->last_update = date("Y-m-d H:i:s");
                                $new_ue->save();
                            }else{
                                $ue->nbr_produit += 1;
                                $ue->etat_ue = 1;
                                $ue->last_update = date("Y-m-d H:i:s");
                                $ue->update();
                            }
                        }

                            $produit=Produit::find($stock_produit->id_produit);
                            $HistoriqueActions = new Historique();
                            $HistoriqueActions->type_action = 'Ajout';
                            $HistoriqueActions->nom_table = 'Administration->Stock';
                            $HistoriqueActions->description = 'Ajout du stock : '.$produit->reference;
                            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                            $HistoriqueActions->save();
                        }
                        $emplacement->tauxOccupation = $tauxOccupation;
                        if ($tauxOccupation == 100) {
                            $emplacement->etat = 'NON DISPONIBLE';
                        }
                        $emplacement->last_update = date("Y-m-d H:i:s");
                        $emplacement->update();


                        return redirect('stock_produit_lot/index')->with('msgAjouter', "Le stock de ce produit a été ajouté avec succès");
                    }
                } else {
                    return redirect()->back()->withInput()->with('msgAddQuantite', "Veuillez introduire une quantité supérieure à 0");
                }
            }
        }else{
            return redirect('stock_produit_lot/ajouter')->withInput()->with('msgAddEmplacement',"tous les champs sont obligatoires");

        }

    }



    public function delete($id)
    {
        $stock = StockProduit::find($id);
        if($stock->quantite > 0)
        {
            return redirect('stock_produit/index')->with('msgDeleteNotOk',"Impossible de supprimer cette ligne du stock, car il y a des produits qui sont stockés");
        }
        else
        {
            $produit=Produit::find($stock->id_produit);
            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Administration->Stock';
            $HistoriqueActions->description = 'Suppression du stock : '.$produit->reference;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            StockProduit::find($id)->delete();

            return redirect('stock_produit/index')->with('msgDeleteOk',"le stock du produit a été supprimé avec succès");
        }
    }

    public function delete_lot($id)
    {
        $stock = StockProduit::find($id);
        if($stock->quantite > 0)
        {
            return redirect('stock_produit_lot/index')->with('msgDeleteNotOk',"Impossible de supprimer cette ligne du stock, car il y a des produits qui sont stockés");
        }
        else
        {
            $produit=Produit::find($stock->id_produit);
            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Administration->Stock';
            $HistoriqueActions->description = 'Suppression du stock : '.$produit->reference;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            StockProduit::find($id)->delete();

            return redirect('stock_produit_lot/index')->with('msgDeleteOk',"le stock du produit a été supprimé avec succès");
        }
    }


    public function getFormEdit($id)
    {
        $stock_produit = StockProduit::where('id_stock_produit','=',$id)->with('emplacement')->with('produit')->first();
        $zones = Zone::all();
        $zoneSelected = Zone::find($stock_produit->emplacement->id_zone);
        $emplacements = Emplacement::all();
        $produits = Produit::all();

        return view('stock_produit/modifier', compact('stock_produit', 'produits', 'zones', 'emplacements', 'zoneSelected'));
    }

    public function getFormEdit_lot($id)
    {
        $stock_produit = StockProduit::where('id_stock_produit','=',$id)->with('emplacement')->with('produit')->first();
        $zones = Zone::all();
        $zoneSelected = Zone::find($stock_produit->emplacement->id_zone);
        $emplacements = Emplacement::all();
        $produits = Produit::all();

        return view('stock_produit_lot/modifier', compact('stock_produit', 'produits', 'zones', 'emplacements', 'zoneSelected'));
    }


    public function getEmplacement()
    {
        $ref = Input::get('ID');
        $rest=DB::table('emplacement')
        ->where('id_zone','=',$ref)
        ->orderBy('libelle')
        ->get();
        return response()->json($rest);
    }


    public function postFormEdit(Request $request, $id)
    {
        if($request->input('produit')!=null && $request->input('zone') !=null && $request->input('emplacement')!=null) {

            $stock_produit = StockProduit::find($id);
            $exist = StockProduit::where('id_stock_produit','!=',$id)
            ->where('id_produit', '=', $request->input('produit'))
            ->where('id_emplacement', '=', $request->input('emplacement'))
            ->where('quantite', '=', $request->input('quantite'))
            ->where('date_entree', '=', $request->input('date'))
            ->where('num_entite', $request->input('entite'))
            ->where('num_ue', $request->input('ue'))
            ->count();
            if($exist == 0)
            {
                //tester si il ya des préparation deriere
                $resultat = $this->getInfoStockProduit($id);
                if ($resultat != null) {
                    foreach ($resultat->ligne_produit as $key => $value) {
                        if ($value->preparation->livraison == null && $value->preparation->statutPreparation != 4) {
                            return redirect('stock_produit/modifier/'.$id)->withInput()->with('msgAddEmplacement',"Modification impossible : il existe des préparations qui ne sont pas encore livrer.");
                        }
                    }
                }
                //dd($resultat);
                $emplacement = Emplacement::find($request->input('emplacement'));
                $produit = Produit::find($request->input('produit'));
                $volumeProduit = ($produit->volume) * ($request->input('quantite'));
                $volumeMax = $emplacement->volumeMax;
                $stockQnt=$stock_produit->quantite;
                $volumeProduitStock= ($produit->volume) * $stockQnt;
                $encienTaux = 0;
                $tauxOccupation = 0;
                if ($volumeMax == 0 || $volumeMax == null || $volumeMax == '') {
                   $encienTaux = 0;
                   $tauxOccupation = 0;
                }else{
                    $encienTaux=number_format((($volumeProduitStock/$volumeMax)*100),2) ;
                    $tauxOccupation = ($emplacement->tauxOccupation) + (($volumeProduit / $volumeMax) * 100)-$encienTaux;
                }
                
                $tauxOccupation = number_format($tauxOccupation, 2);
                if ($tauxOccupation > 100) {

                    return redirect('stock_produit/modifier/'.$id)->withInput()->with('msgAddEmplacement',"L'emplacement sélectionné ne peut pas contenir toute cette quantité");
                }

                $stock_produit->id_produit = $request->input('produit');
                $stock_produit->num_ue = $request->input('ue');
                $stock_produit->num_entite = $request->input('entite');
                $stock_produit->id_emplacement = $request->input('emplacement');
                $stock_produit->quantite = $request->input('quantite');
                $stock_produit->quantite_utilisable = $request->input('quantite');
                $stock_produit->quantite_reelle = $request->input('quantite');
                $stock_produit->date_entree = $request->input('date');
                if(Session::get('N_LOT')=='1') {
                    $stock_produit->numero_lot = $request->input('numeroLot');
                }else{
                    $stock_produit->numero_lot ="";
                }
                if(Session::get('DATE_PEREMPTION')=='1') {
                    $stock_produit->date_fabrication = $request->input('dateFabrication');
                    $stock_produit->date_peremption = $request->input('datePeremption');
                }

                $stock_produit->validation = 1;
                $stock_produit->last_update= date("Y-m-d H:i:s");
                $stock_produit->update();

            //ajouter entité
            if (Session::get('STOCK_ENTITE') == '1') {            
                $entite = Entite::where('num_entite',$request->input('entite'))->first();
                $liste_valeur = ListValeur::join('preferences','preferences.valeur_preference',"=","liste_valeur.code")
                                            ->where('nom_liste', "TYPE_ENTITE")->first();
                if ($entite == null) {
                    $new_entite = new Entite();
                    $new_entite->num_entite = $request->input('entite');
                    $new_entite->type_entite = $liste_valeur->valeur;
                    $new_entite->libelle_entite = "";
                    $new_entite->save();
                }
            }
            //ajouter UE
            if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                $ue = UE::where('num_ue',$request->input('ue'))->first();
                if ($ue == null) {
                    $new_ue = new UE();
                    $new_ue->num_ue = $request->input('ue');
                    $new_ue->nbr_produit = 1;
                    $new_ue->etat_ue = 0;
                    $new_ue->id_emplacement = $request->input('emplacement');
                    $new_ue->last_update = date("Y-m-d H:i:s");
                    $new_ue->save();
                }else{
                    //$ue->nbr_produit += 1;
                    $ue->etat_ue = 1;
                    $ue->last_update = date("Y-m-d H:i:s");
                    $ue->update();
                }
            }

                $produit=Produit::find($stock_produit->id_produit);
                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Modification';
                $HistoriqueActions->nom_table = 'Administration->Stock';
                $HistoriqueActions->description = 'Modification du stock : '.$produit->reference;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                $emplacement->tauxOccupation = $tauxOccupation;
                if($tauxOccupation == 100)
                {
                    $emplacement->etat = 'NON DISPONIBLE';
                }
                $emplacement->last_update= date("Y-m-d H:i:s");
                $emplacement->update();

                return redirect('stock_produit/index')->with('msgUpdate',"Le stock de ce produit a été modifié avec succès");
            }
            else
            {
                return redirect('stock_produit/modifier/'.$id)->with('msgStockProduit','Ce stock de produit existe déjà ');
            }

        }else{
            return redirect('stock_produit/modifier/'.$id)->withInput()->with('msgAddEmplacement',"tous les champs sont obligatoires");
        }
    }

    public function postFormEdit_lot(Request $request, $id)
    {
        if($request->input('produit')!=null && $request->input('zone') !=null && $request->input('emplacement')!=null) {

            $stock_produit = StockProduit::find($id);
            $exist = StockProduit::where('id_stock_produit','!=',$id)
            ->where('id_produit', '=', $request->input('produit'))
            ->where('id_emplacement', '=', $request->input('emplacement'))
            ->where('quantite', '=', $request->input('quantite'))
            ->where('date_entree', '=', $request->input('date'))
            ->where('num_entite', '=', $request->input('entite'))
            ->where('num_ue', '=', $request->input('ue'))
            ->count();
            if($exist == 0)
            {
                $emplacement = Emplacement::find($request->input('emplacement'));
                $produit = Produit::find($request->input('produit'));
                $volumeProduit = ($produit->volume) * ($request->input('quantite'));
                $volumeMax = $emplacement->volumeMax;
                $stockQnt=$stock_produit->quantite;
                $volumeProduitStock= ($produit->volume) * $stockQnt;
                $encienTaux=number_format((($volumeProduitStock/$volumeMax)*100),2) ;

                $tauxOccupation = ($emplacement->tauxOccupation) + (($volumeProduit / $volumeMax) * 100)-$encienTaux;
                $tauxOccupation = number_format($tauxOccupation, 2);
                if ($tauxOccupation > 100) {

                    return redirect('stock_produit_lot/modifier/'.$id)->withInput()->with('msgAddEmplacement',"L'emplacement sélectionné ne peut pas contenir toute cette quantité");
                }

                $stock_produit->id_produit = $request->input('produit');
                $stock_produit->num_ue = $request->input('ue');
                $stock_produit->num_entite = $request->input('entite');
                $stock_produit->id_emplacement = $request->input('emplacement');
                $stock_produit->quantite = $request->input('quantite');
                $stock_produit->quantite_utilisable = $request->input('quantite');
                $stock_produit->quantite_reelle = $request->input('quantite');
                $stock_produit->date_entree = $request->input('date');
                if(Session::get('N_LOT')=='1') {
                    $stock_produit->numero_lot = $request->input('numeroLot');
                }else{
                    $stock_produit->numero_lot ="";
                }
                if(Session::get('DATE_PEREMPTION')=='1') {
                    $stock_produit->date_fabrication = $request->input('dateFabrication');
                    $stock_produit->date_peremption = $request->input('datePeremption');
                }

                $stock_produit->validation = 1;
                $stock_produit->last_update= date("Y-m-d H:i:s");
                $stock_produit->update();

                //ajouter entité
                if (Session::get('STOCK_ENTITE') == '1') {
                $entite = Entite::where('num_entite',$request->input('entite'))->first();
                $liste_valeur = ListValeur::join('preferences','preferences.valeur_preference',"=","liste_valeur.code")
                                            ->where('nom_liste', "TYPE_ENTITE")->first();
                if ($entite == null) {
                    $new_entite = new Entite();
                    $new_entite->num_entite = $request->input('entite');
                    $new_entite->type_entite = $liste_valeur->valeur;
                    $new_entite->libelle_entite = "";
                    $new_entite->save();
                }
            }
            //ajouter UE
            if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                $ue = UE::where('num_ue',$request->input('ue'))->first();
                if ($ue == null) {
                    $new_ue = new UE();
                    $new_ue->num_ue = $request->input('ue');
                    $new_ue->nbr_produit = 1;
                    $new_ue->etat_ue = 0;
                    $new_ue->id_emplacement = $request->input('emplacement');
                    $new_ue->last_update = date("Y-m-d H:i:s");
                    $new_ue->save();
                }else{
                    $ue->nbr_produit += 1;
                    $ue->etat_ue = 1;
                    $ue->last_update = date("Y-m-d H:i:s");
                    $ue->update();
                }
            }

                $produit=Produit::find($stock_produit->id_produit);
                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Modification';
                $HistoriqueActions->nom_table = 'Administration->Stock';
                $HistoriqueActions->description = 'Modification du stock : '.$produit->reference;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                $emplacement->tauxOccupation = $tauxOccupation;
                if($tauxOccupation == 100)
                {
                    $emplacement->etat = 'NON DISPONIBLE';
                }
                $emplacement->last_update= date("Y-m-d H:i:s");
                $emplacement->update();

                return redirect('stock_produit_lot/index')->with('msgUpdate',"Le stock de ce produit a été modifié avec succès");
            }
            else
            {
                return redirect('stock_produit_lot/modifier/'.$id)->with('msgStockProduit','Ce stock de produit existe déjà ');
            }

        }else{
            return redirect('stock_produit_lot/modifier/'.$id)->withInput()->with('msgAddEmplacement',"tous les champs sont obligatoires");
        }
    }

    public function getInfoStockProduit($id_stock){
        $produitEnStock = StockProduit::where('id_stock_produit', $id_stock)->with('emplacement')
        ->with('produit')
        ->with('inventaire')
        ->with('entite')
        ->with('ue')
        ->with('ligne_produit.preparation.livraison')
        ->first();
        return $produitEnStock;
    }
    public function exportStock(Request $request){

        $emplacement = $request->input('emplacementExport');
        $entite = $request->input('entiteExport');
        $produit = $request->input('produitExport');
        $zone = $request->input('zoneExport');
        $ue = $request->input('ueExport');
        //dd($emplacement, $entite,$produit,$zone,$ue);

        $stocks = null;
        /*$stocks= collect();
        $collet = StockProduit::where('quantite' ,"!=", 0)->with('emplacement')->with('produit')->with('Inventaire')->chunk(500, function ($rows) use ($stocks) {
            foreach ($rows as $row) {
                $stocks->push($row);
            }
        });*/
        
        if ($zone) {
            $emplacements = Emplacement::where('id_zone',$zone)->get(['id_emplacement']); 
            $emplacements = $emplacements->toArray();
            $stocks= collect();
            $collet = StockProduit::where('quantite', "!=", 0)->where(function($query) use ($produit, $entite, $emplacement,$emplacements,$ue){
                            if ( $produit != null) $query->where('id_produit', $produit);
                            if ( $entite != null) $query->where('num_entite', $entite);
                            if ( $ue != null) $query->where('num_ue', $ue);
                            if ( $emplacement != null) $query->where('id_emplacement', $emplacement); 
                            $query->whereIn('id_emplacement', $emplacements);
                    })->with('emplacement')
            ->with('produit.uniteMesure')
            ->with('entite')
            ->with('ligneBonReceptionUe.ligneBonReception.bonReception.commandeFounisseur.Fournisseur')
            ->with('ligneBonReceptionn.numeroSerie')
            ->chunk(500, function ($rows) use ($stocks) {
            foreach ($rows as $row) {
                $stocks->push($row);
            }
        });
        }else{
            $stocks= collect();
            $collet = StockProduit::where('quantite', "!=", 0)->where(function($query) use ($produit, $entite, $emplacement,$ue){
                            if ( $produit != null) $query->where('id_produit', $produit);
                            if ( $entite != null) $query->where('num_entite', $entite);
                            if ( $ue != null) $query->where('num_ue', $ue);
                            if ( $emplacement != null) $query->where('id_emplacement', $emplacement);  
                    })->with('emplacement')->with('produit.uniteMesure')->with('entite')
                        ->with('ligneBonReceptionUe.ligneBonReception.bonReception.commandeFounisseur.Fournisseur')->with('ligneBonReceptionn.numeroSerie')->chunk(500, function ($rows) use ($stocks) {
            foreach ($rows as $row) {
                $stocks->push($row);
            }
        });
                        //dd($stocks[0]->ligneBonReceptionn[0]->numeroSerie);
        }
        //dd($entite,$stocks);
        if ($emplacement != "") {
            $emplacement = Emplacement::find($emplacement);
        }
        if ($entite != "") {
            $entite = Entite::find($entite);
        }
        if ($produit != "") {
            $produit = Produit::find($produit);
        }
        if ($zone != "") {
            $zone = Zone::find($zone);
        }
        if ($ue != "") {
            $ue = Ue::find($ue);
        }
        //dd(isset($stocks[7]->ligneBonReceptionUe[0]));

    Excel::create('Stock_'.date('y-m-d'),function($excel) use ($stocks,$ue,$zone,$emplacement,$produit,$entite){
        $excel->sheet('Feuil1', function($sheet) use ($stocks,$ue,$zone,$emplacement,$produit,$entite){
            $sheet->setColumnFormat(array(
               'A' =>  '@',
                'B' =>  '@',
                'C' =>  '@',
                'D' =>  '@',
                'E' =>  '@',
                'F' =>  '@',
                'G' =>  '@',
                'H' =>  '@',
                'I' =>  '@',
                'J' =>  '@',
                'K' =>  '@',
                'L' =>  '@',
                'M' =>  '@',
                'N' =>  '@',
                'O' =>  '@',
                'P' =>  '@',
                'Q' =>  '@', 
                'R' =>  '@', 
            ));
            $sheet->setWidth(array(
                'A' =>  30,
                'B' =>  50,
                'C' =>  30,
                'D' =>  30,
                'E' =>  30,
                'F' =>  20,
                'G' =>  30,
                'H' =>  25,
                'I' =>  15,
                'J' =>  20,
                'K' =>  70,
                'L' =>  20,
                'M' =>  35,
                'N' =>  20,
                'O' =>  20,
                'P' =>  20,
                'Q' =>  35,
                'R' =>  35,
            ));
            $sheet->getStyle('G')->getAlignment()->setWrapText(true);
            $sheet->loadView('stock_produit.export.exportStock')->with(['stocks'=>$stocks, 'date'=>date('Y-m-d'),'ue'=> $ue, 'zone'=>$zone, 'produit'=>$produit ,'entite'=>$entite, 'emplacement'=>$emplacement]);
        });
    })->download('xlsx');
        
    }

    public function getProduit(){
        $result = array();
        $sp1 = DB::table('produit')
              ->where('produit.reference','LIKE' , '%' . $_POST['q'] . '%')
              ->limit(15)     
              ->get();
          $result =  $sp1; 
          return response()->json($result);
    }

    public function getUE(){
        $result = array();
        $sp1 = DB::table('ue')
              ->where('ue.num_ue','LIKE' , '%' . $_POST['q'] . '%')
              ->limit(15)     
              ->get();
          $result =  $sp1; 
          return response()->json($result);
    }

    public function getEmp(){
        $result = array();
        $sp1 = DB::table('emplacement')
              ->where('emplacement.libelle','LIKE' , '%' . $_POST['q'] . '%')
              ->limit(15)     
              ->get();
          $result =  $sp1; 
          return response()->json($result);
    }

    public function getEntite(){
        $result = array();
        $sp1 = DB::table('entite')
              ->where('entite.num_entite','LIKE' , '%' . $_POST['q'] . '%')
              ->limit(15)     
              ->get();
          $result =  $sp1; 
          return response()->json($result);
    }

     public function getZone(){
        $result = array();
        $sp1 = DB::table('zone')
              ->where('zone.libelle','LIKE' , '%' . $_POST['q'] . '%')
              ->limit(15)     
              ->get();
          $result =  $sp1; 
          return response()->json($result);
    }

    public function exportUeStock(Request $request){
        $ue = $request->input('ueExport');
        $stocks = null;
      
            $stocks= collect();
            $collet = StockProduit::where('quantite', "!=", 0)->where(function($query) use ($ue){
                            
                            if ( $ue != null) $query->where('num_ue', $ue);
                            
                    })->with('emplacement')->with('produit')->with('entite')
                        ->with('ligneBonReceptionUe.ligneBonReception.bonReception.commandeFounisseur.Fournisseur')->chunk(500, function ($rows) use ($stocks) {
            foreach ($rows as $row) {
                $stocks->push($row);
            }
        });


        if ($ue != "") {
            $ue = Ue::where('num_ue',$ue)->with('emplacement')->first();
        }
        //dd($stocks[0]);






    Excel::create('Fiche_de_stock_'.date('y-m-d'),function($excel) use ($stocks,$ue){
        $excel->sheet('Feuil1', function($sheet) use ($stocks,$ue){
            $nombreLigne = $stocks->count();
            $i= 7;
            foreach ($stocks as $key => $value) {
                
                $position = 'A'.$i.'';
                $path=DNS1D::getBarcodePNGPath($value->produit->reference, 'C128',6,200,array(1,1,1), true);
                $objDrawing3 = new PHPExcel_Worksheet_Drawing;
                $objDrawing3->setPath(public_path($path)); //your image path
                $objDrawing3->setCoordinates($position);
                $objDrawing3->setResizeProportional(false);
                $objDrawing3->setWidth(270);
                $objDrawing3->setHeight(60);           
                $objDrawing3->setWorksheet($sheet);
                $i= $i+3;
            }

            $sheet->setHeight(1, 50);
            $sheet->setHeight(2, 50);
            $sheet->cell('A1', function($cell) {
                $cell->setFontSize(20);
            });
            $path=DNS1D::getBarcodePNGPath("$ue->num_ue", 'C128',6,200,array(1,1,1), true);
            $objDrawing3 = new PHPExcel_Worksheet_Drawing;
            $objDrawing3->setPath(public_path($path)); //your image path
            $objDrawing3->setCoordinates('C2');
            $objDrawing3->setResizeProportional(false);
            // set width later
            $objDrawing3->setWidth(280);
            $objDrawing3->setHeight(48);
            //$objDrawing3->setWidthAndHeight(1000,48);
            //$objDrawing3->setResizeProportional(true);
            $objDrawing3->setWorksheet($sheet);

            //$sheet->getStyle('C')->getAlignment()->setWrapText(true);

            $sheet->setColumnFormat(array(
                'A' =>  '@',
                'B' =>  '@',
                'C' =>  '@',
                'D' =>  '@',
                'E' =>  '@',
                'F' =>  '@',
                'G' =>  '@',
                'H' =>  '@',
                'I' =>  '@',
                'J' =>  '@',
            ));
            $sheet->setStyle(array(
                'font' => array(
                    'name' =>  'Calibri',
                    'size' =>  20,
                )
            ));
            $sheet->setWidth(array(
                'A' =>  20,
                'B' =>  10,
                'C' =>  10,
                'D' =>  10,
                'E' =>  10,
                'F' =>  10,
                'G' =>  10,
                'H' =>  10,
                'I' =>  10,
                'J' =>  10,
            ));
            //$sheet->mergeCells('A7:B9');
            //$sheet->mergeCells('C7:C9');
            $sheet->loadView('stock_produit.export.exportUeStock')->with(['stocks'=>$stocks, 'date'=>date('Y-m-d'),'ue'=> $ue]);
        });
    })->download('xlsx');
    }
}