<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 28/05/2017
 * Time: 14:35
 */

namespace App\Http\Controllers;

use App\ProduitCompose;
use App\Historique;
use App\Produit;
use App\Categorie;
use App\StockProduit;
use App\UniteMesure;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Redirect;
use PHPExcel_IOFactory;
use PHPExcel_Style_NumberFormat;
use \Response;
use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use App\BonReception;
use Excel;
use App\LigneBonReception;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;


use PHPExcel;




class ProduitController extends Controller
{




    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->last_update= date("Y-m-d H:i:s");
                $stockProduit->update();*/

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }




    public function index()
    {

        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        $produits = Produit::with("catigorie")->with("uniteMesure")->paginate(10);
        //dd($produits[0]->catigorie->libelle);

        //dd($produits);
        //pour optmiser la resultat de la requette utiliser "paginate()"
        //chunk()

       // DB::unprepared('Delete from produit where id_produit>=46');
        //test
      /*  $designation=Produit::select('designation')
        ->value('designation');*/
        return view('produit.index',compact('produits'));
    }

  /*  public function test(){
       // $num = Input::get('ID');

       // Session::put('numChargement',$num);

        $categorie=Produit::select('reference')
            ->value('reference');

        return response()->json($categorie);

    }*/

    public function downloadModele(Request $request){

        if (Session::get('COMPOSE_PACK')) {
            $file=public_path()."/Modele_Produits.xlsx";
        }else{
           $file=public_path()."/Modele_Produits1.xlsx"; 
        }
        
        $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
        return Response::download($file, 'Modele_Produits.xlsx',$headers);
        //return \Illuminate\Support\Facades\Response::download($file);

    }
    public function getForm()
    {
        $categories = Categorie::all();
        $unites_mesure = UniteMesure::all();
        //$produits = Produit::where('id_produit_compose','=',null)->get();
        $produitsPack = Produit::where('compose_pack','!=','OUI')->get();
        $produitsMP = Produit::where('compose_mp','!=','OUI')->get();
        return view('produit.ajouter',compact('categories', 'unites_mesure','produitsPack','produitsMP'));
    }

    public function import(Request $request)
    {
        ini_set('max_execution_time', 1000);
        // Version avec  titre
        //$list = Session::get('listIdMagasin');

        $bytes = $request->file('file')->getClientSize();

        $ext = Input::file('file')->getClientOriginalExtension();
        if ( $ext == "xlsx" || $ext == 'xls')
        {
        if ($bytes < 25165824) {
            $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));
            $sheet = $objPHPExcel->getSheet(0);
            $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();

                //  $file = $request->file('file');

                //  if ($file != null) {
            if ($highestRow > 1) {
                //dd($sheet->getRowIndex());
                $y=1;
                DB::beginTransaction();
                foreach ($sheet->getRowIterator() as $key=> $row) {
                    //Version 2
                    $designation=null;
                    $reference=null;
                    $categorie=null;
                    $code_barre=null;
                    $code_mesure=null;
                    $tva=null;
                    $poids=null;
                    $volume=null;
                    $parent=null;
                    $qnt=null;
                    $serie=null;

                    if ($row->getRowIndex() >= 2) {
                        // On boucle sur les cellule de la ligne
                       /* $objPHPExcel->getActiveSheet()
                            ->getStyle('C'.$y)
                            ->getNumberFormat()
                            ->setFormatCode( PHPExcel_Style_NumberFormat::FORMAT_TEXT );*/
                        $designation= $sheet->getCell('A'.$y)->getValue();
                        $categorie= $sheet->getCell('B'.$y)->getValue();
                        $code_barre= $sheet->getCell('C'.$y)->getValue();
                        $reference= $sheet->getCell('D'.$y)->getValue();
                        $tva = $sheet->getCell('E'.$y)->getValue();
                        if($tva==null || $tva==''){
                            $tva=0;
                        }
                        $code_mesure =$sheet->getCell('F'.$y)->getValue();
                        $poids =$sheet->getCell('G'.$y)->getValue();
                        if($poids==null || $poids==''){
                            $poids=0;
                        }
                        $volume =$sheet->getCell('H'.$y)->getValue();
                        if($volume==null || $volume==''){
                            $volume=0;
                        }
                        if (Session::get('COMPOSE_PACK')) {
                            $parent =$sheet->getCell('I'.$y)->getValue();
                            $qnt =$sheet->getCell('J'.$y)->getValue();
                            $serie =$sheet->getCell('K'.$y)->getValue();
                        }else{
                            $serie =$sheet->getCell('I'.$y)->getValue();
                        }
                       
                        if($categorie!=null && $categorie!='' ){
                            if ($reference!=null && $reference!='') {

                        if($code_mesure==null || $code_mesure==''){
                            $code_mesure='Unité';
                        }
                            $mesure=UniteMesure::where('libelle','=',$code_mesure)->get();
                            if($mesure->first()==null){
                                $cat=new UniteMesure();
                                $cat->libelle=$code_mesure;
                                $cat->description = '';
                                $cat->save();
                                $mesure=$cat->id_unite_mesure;
                            }else{
                                $mesure=$mesure->first()->id_unite_mesure;
                            }
                            $categorieExist=Categorie::where('libelle','=',$categorie)->get();
                            if($categorieExist->first()==null){
                                $cat=new Categorie();
                                $cat->libelle=$categorie;
                                $cat->save();
                                $categorieExist=$cat->id_categorie;
                            }else{
                                $categorieExist=$categorieExist->first()->id_categorie;
                            }
                           /* $produit = Produit::where('designation', '=', $designation)
                                ->where('id_categorie', '=', $categorieExist)
                                ->where('reference', '=', $reference)
                                ->where('code_identification', '=', $code_barre)
                                ->first();*/
                                $produit = Produit::where('id_categorie', '=', $categorieExist)
                                ->where('reference', '=', $reference)
                                ->where('code_identification', '=', $code_barre)
                                ->first();

                            $existDesignation= Produit::where('designation', '=', $designation)
                                ->count();

                            $existReference= Produit::where('reference', '=', $reference)
                                ->count();
                            $existCode= Produit::where('code_identification', '=', $code_barre)
                                ->count();
                            if($existReference ==0 )
                            {
                                //dd($reference);
                                $produit = new Produit();
                                if ($designation == null) $designation = "";
                                $produit->designation = $designation;
                                $produit->reference = $reference;
                                $produit->code_identification = $code_barre;
                                $produit->tva = $tva;
                                $produit->code_mesure = $mesure;
                                $produit->poids = $poids;
                                $produit->volume = $volume;
                                $produit->statut = 'actif';
                                $produit->id_categorie = $categorieExist;
                                if (strtoupper($serie) == "OUI") $produit->num_serie = 1;
                                else $produit->num_serie = 0;
                                
                                $produit->save();
                                if (Session::get('COMPOSE_PACK')) {
                                if ($parent != null){
                                    $idParent=Produit::where('reference',$parent)->first();
                                    if($idParent != null){
                                        //$p=Produit::find($idParent->first()->id_produit);
                                        /*$p->id_produit_compose = $produit->id_produit;
                                        $p->qnt_produit_compose =$qnt;*/
                                        $idParent->compose_pack = 'OUI';
                                        $idParent->update();

                                        $produitCompose = new ProduitCompose();
                                        $produitCompose->type = "COMPOSE_PACK";
                                        $produitCompose->id_produit_parent = $idParent->id_produit;
                                        $produitCompose->id_produit_enfant = $produit->id_produit;
                                        $produitCompose->quantite = $qnt;
                                        $produitCompose->last_update = date("Y-m-d H:i:s");
                                        $produitCompose->save();
                                    }
                                }
                            }
                            }else{
                                $existReference= Produit::where('reference', '=', $reference)->first();
                                if ($designation == null) $designation = "";
                                $existReference->designation = $designation;
                                $existReference->reference = $reference;
                                $existReference->code_identification = $code_barre;
                                $existReference->tva = $tva;
                                $existReference->code_mesure = $mesure;
                                $existReference->poids = $poids;
                                $existReference->volume = $volume;
                                $existReference->statut = 'actif';
                                $existReference->id_categorie = $categorieExist;
                                if (strtoupper($serie) == "OUI") $existReference->num_serie = 1;
                                else $existReference->num_serie = 0;
                                
                                $existReference->update();
                                if (Session::get('COMPOSE_PACK')) {
                                if ($parent != null){
                                    $idParent=Produit::where('reference',$parent)->first();
                                    if($idParent != null){
                                        //$p=Produit::find($idParent->first()->id_produit);
                                        /*$p->id_produit_compose = $produit->id_produit;
                                        $p->qnt_produit_compose =$qnt;*/
                                        $idParent->compose_pack = 'OUI';
                                        $idParent->update();

                                        $produitCompose = new ProduitCompose();
                                        $produitCompose->type = "COMPOSE_PACK";
                                        $produitCompose->id_produit_parent = $idParent->id_produit;
                                        $produitCompose->id_produit_enfant = $existReference->id_produit;
                                        $produitCompose->quantite = $qnt;
                                        $produitCompose->last_update = date("Y-m-d H:i:s");
                                        $produitCompose->save();
                                    }
                                }
                            }


                            }
                            }else {
                            DB::rollback();
                            return Redirect::back()->withErrors(["Échec de l'importationle</br> Ligne :".$key." le champ Référence produit est obligatoire."]);
                        }

                        }else {
                            DB::rollback();
                            return Redirect::back()->withErrors(["Échec de l'importationle</br> Ligne :".$key." le champ catégorie est obligatoire."]);
                        }
                    }
                    $y++;
                    }
                    // dd($value);
                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Importation';
                $HistoriqueActions->nom_table = 'Administration->Les produits';
                $HistoriqueActions->description = 'Importation des produits depuis un fichier';
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();
                    DB::commit();
                    return redirect('produit/index')->with('msg', 'Fichier importé avec succès');

                }
                else{
                    DB::rollback();
                    return Redirect::back()->withErrors(['Fichier vide ']);
                }
            } else {
                DB::rollback();
                return Redirect::back()->withErrors(['Fichier volumineux ']);
            }

        } else {
            DB::rollback();
            return Redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);
        }
    }
   /* public function import(Request $request)
    {
        ini_set('max_execution_time', 1000);
        // Version avec  titre
        //$list = Session::get('listIdMagasin');

        $bytes = $request->file('file')->getClientSize();

        $ext = Input::file('file')->getClientOriginalExtension();
        if ($ext == "csv" || $ext == "xlsx" || $ext == 'xls') {
            if ($bytes < 25165824) {

                //  $file = $request->file('file');

                //  if ($file != null) {
                $path = Input::file('file')->getRealPath();




                $data = Excel::load($path, function ($reader) {

                })->get();


                if (!empty($data) && $data->count()) {


                    foreach ($data as $key => $value) {
                        dd($value);
                    //Version 2
                    $designation=null;
                    $reference=null;
                    $categorie=null;
                    $code_barre=null;
                    $code_mesure=null;
                    $tva=null;
                    $poids=null;
                    $volume=null;
                    $parent=null;
                    $qnt=null;

                        $reference = utf8_encode($value->reference);
                        $designation =utf8_encode( $value->designation);
                        $categorie = utf8_encode($value->categorie);
                        $code_mesure = utf8_encode($value->code_mesure);
                        $code_barre = utf8_encode($value->code_a_barres);
                        $tva = $value->tva;
                        $poids=$value->poids;
                        $volume=$value->volume;
                        $parent=utf8_encode($value->parent);
                        $qnt=$value->quantite;
                       /* foreach ($row->getCellIterator() as $cell) {
                            if ($designation == null) {
                                $designation = $cell->getValue();
                                //    dd($designation);
                            } elseif ($categorie == null) {
                                $categorie = $cell->getValue();

                            } elseif ($code_barre == null) {
                                $code_barre = $cell->getValue();

                            } elseif ($reference == null) {
                                $reference = $cell->getValue();

                            } elseif ($tva == null) {
                               // $tva = $cell->getValue();
                              //  $tva = $sheet->getCell('E'.$y)->getValue();
                            } elseif ($code_mesure == null) {
                                $code_mesure =$sheet->getCell('F'.$y)->getValue();
                               // dd($code_mesure);

                            } elseif ($poids == null) {
                                $poids = $cell->getValue();

                            } elseif ($volume == null) {
                                $volume = $cell->getValue();

                            } elseif ($parent == null) {
                                $parent = $cell->getValue();

                            } elseif ($qnt == null) {
                                $qnt = $cell->getValue();

                            }
                        }
                      //  dd($code_barre);
                        if($code_mesure==null || $code_mesure==''){
                            $code_mesure='Unité';
                        }
                            $mesure=UniteMesure::where('libelle','=',$code_mesure)->get();
                            if($mesure->first()==null){
                                $cat=new UniteMesure();
                                $cat->libelle=$code_mesure;
                                $cat->save();
                                $mesure=$cat->id_unite_mesure;
                            }else{
                                $mesure=$mesure->first()->id_unite_mesure;
                            }
                            $categorieExist=Categorie::where('libelle','=',$categorie)->get();
                            if($categorieExist->first()==null){
                                $cat=new Categorie();
                                $cat->libelle=$categorie;
                                $cat->save();
                                $categorieExist=$cat->id_categorie;
                            }else{
                                $categorieExist=$categorieExist->first()->id_categorie;
                            }
                            $produit = Produit::where('designation', '=', $designation)
                                ->where('id_categorie', '=', $categorieExist)
                                ->where('reference', '=', $reference)
                                ->where('code_identification', '=', $code_barre)
                                ->first();

                            $existDesignation= Produit::where('designation', '=', $designation)
                                ->count();

                            $existReference= Produit::where('reference', '=', $reference)
                                ->count();
                            $existCode= Produit::where('code_identification', '=', $code_barre)
                                ->count();
                            if($existDesignation == 0 && $existReference ==0 && $existCode==0 && $produit==null)
                            {

                                $produit = new Produit();
                                $produit->designation = $designation;
                                $produit->reference = $reference;
                                $produit->code_identification = $code_barre;
                                $produit->tva = $tva;
                                $produit->code_mesure = $mesure;
                                $produit->poids = $poids;
                                $produit->volume = $volume;
                                $produit->statut = 'actif';
                                $produit->id_categorie = $categorieExist;
                                $produit->save();

                                if ($parent != null)
                                {
                                    $idParent=Produit::where('reference','=',$parent)->get();
                                    if($idParent->first()!=null){
                                        $p=Produit::find($idParent->first()->id_produit);
                                        $p->id_produit_compose = $produit->id_produit;
                                        $p->qnt_produit_compose =$qnt;
                                        $p->update();
                                    }
                                }






                            }

                    }
                    // dd($value);
                    return redirect('produit/index')->with('msg', 'Fichier importé avec succès');

                }
                else
                    return redirect::back()->withErrors(['Fichier vide ']);
            } else return redirect::back()->withErrors(['Fichier volumineux ']);

        } else return redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);
    }
*/
    public function postForm(Request $request)
    {
        //dd($request->input('savoirPak'),$request->input('savoirMP'),$request->input('produit_Pack'), $request->input('quantite_Pack'), $request->input('produit_mp'), $request->input('quantite_mp'));

        $produit = Produit::where('designation', '=', $request->input('designation'))
            ->where('id_categorie', '=', $request->input('id_categorie'))
            ->where('reference', '=', $request->input('reference'))
            ->where('code_identification', '=', $request->input('code_a_barre'))
            ->first();

        $existDesignation= Produit::where('designation', '=', $request->input('designation'))
            ->count();

        $existReference= Produit::where('reference', '=', $request->input('reference'))
            ->count();
        $existCode= Produit::where('code_identification', '=', $request->input('code_a_barre'))
            ->count();

        /*if($existDesignation > 0 ){
            return redirect()->back()->withInput()->with('msgIdf','Cette désignation existe déjà');
        }*/

        if($existReference > 0 ){
            return redirect()->back()->withInput()->with('msgIdf','Cette référence existe déjà');
        }
        if($existCode > 0 ){
            return redirect()->back()->withInput()->with('msgIdf','Ce code à barres existe déjà');
        }

        if($produit == null)
        {
            //...
            $savoirMP  = $request->input('savoirMP');
            $savoirPak  = $request->input('savoirPak');

            $produit_pack = $request->input('produit_Pack');
            $quantite_pack = $request->input('quantite_Pack');
            $produit_mp = $request->input('produit_mp');
            $quantite_mp = $request->input('quantite_mp');
            //vérifier si le champ produit est renseigné 
            if ($savoirPak) {
                foreach ($produit_pack as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé pack"');
                        return redirect()->back()->withInput(); 
                    }
                }
                foreach ($quantite_pack as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé pack"');
                        return redirect()->back()->withInput(); 
                    }
                }
            }

            if ($savoirMP) {
                foreach ($produit_mp as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé MP"');
                        return redirect()->back()->withInput(); 
                    }
                }
                foreach ($quantite_mp as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé MP"');
                        return redirect()->back()->withInput(); 
                    }
                }
            }
            /*if (sizeof($quantite_Pack) != 0) {
               foreach ($produit_Pack as $key => $value) {
                   if ($value == '') {
                      $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé pack"');
                        return redirect()->back()->withInput(); 
                   }
               }
            }
            if (sizeof($quantite_mp) != 0) {
               foreach ($produit_mp as $key => $value) {
                   if ($value == '') {
                      $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé pack"');
                        return redirect()->back()->withInput(); 
                   }
               }
            }*/

            //Vérifier les doublons...
            $count = 0;
            if ($savoirPak) {
                foreach ($produit_pack as $key => $pack) {
                    foreach ($produit_pack as $key => $pack2) {
                        if ($pack == $pack2) {
                            $count++;
                        }
                    }
                    if ($count == 2) {
                        $request->session()->flash('msgIdf', 'Erreur : champ produit dupliqué dans la section "Produit composé pack"');
                        return redirect()->back()->withInput();
                    }else
                        $count =0;
                }
            }
            if ($savoirMP) {
                $count = 0;
                foreach ($produit_mp as $key => $mp) {
                    foreach ($produit_mp as $key => $mp2) {
                        if ($mp == $mp2) {
                            $count++;
                        }
                    }
                    if ($count == 2) {
                        $request->session()->flash('msgIdf', 'Erreur : champ produit dupliqué dans la section "Produit composé mp"');
                        return redirect()->back()->withInput();
                    }else
                        $count =0;
                }
            }

            $produit = new Produit();
            $produit->designation = $request->input('designation');
            $produit->reference = $request->input('reference');
            $produit->code_identification = $request->input('code_a_barre');
            $produit->tva = $request->input('tva');
            $produit->code_mesure = $request->input('unite_mesure');
            $produit->poids = $request->input('poids');
            $produit->volume = $request->input('volume');
            $produit->statut = $request->input('statut');
            $produit->id_categorie = $request->input('categorie');
            $produit->num_serie = $request->input('serie');
            $produit->last_update= date("Y-m-d H:i:s");

            if ($savoirPak) {
                $produit->compose_pack ="OUI";
            }else
                 $produit->compose_pack ="NON";

            if ($savoirMP) {
                $produit->compose_mp ="OUI";
            }else
                $produit->compose_mp ="NON";
            /*if ($request->input("produit_compose") != null)
            {
                $produit->id_produit_compose = $request->input('produit');
                $produit->qnt_produit_compose = $request->input('qnt');
            }*/
            $produit->save();

            if ($savoirPak) {
                for ($pack=0; $pack < count($produit_pack); $pack++) {
                    $produitCompose = new ProduitCompose();
                    $produitCompose->type = "COMPOSE_PACK";
                    $produitCompose->id_produit_parent = $produit->id_produit;
                    $produitCompose->id_produit_enfant = $produit_pack[$pack];
                    $produitCompose->quantite = $quantite_pack[$pack];
                    $produitCompose->last_update = date("Y-m-d H:i:s");
                    $produitCompose->save();
                }
            }

            if ($savoirMP) {
                for ($mp=0; $mp < count($produit_mp); $mp++) {
                    $produitCompose = new ProduitCompose();
                    $produitCompose->type = "COMPOSE_MP";
                    $produitCompose->id_produit_parent = $produit->id_produit;
                    $produitCompose->id_produit_enfant = $produit_mp[$mp];
                    $produitCompose->quantite = $quantite_mp[$mp];
                    $produitCompose->last_update = date("Y-m-d H:i:s");
                    $produitCompose->save();
                }
            }

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Administration->Les produits';
            $HistoriqueActions->description = 'Ajout du produit : '.$produit->reference;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('produit/index')->with('msg',"Le produit a été ajouté avec succès");

        }
        else{
            return redirect()->back()->withInput()->with('msgIdf','Ce produit existe déjà');
        }
    }


    public function delete($id)
    {

        $stockProduit = StockProduit::where('id_produit', '=', $id)->first();

        if($stockProduit != null && $stockProduit->quantite > 0)
        {
            return redirect('produit/index')->with('msgDeleteNotOk',"Impossible de supprimer ce produit car il existe une quantité de ce produit dans le stock ");
        }
        else
        {
            //vérifier si le produit a des produits composé pack ou mp
            $test = ProduitCompose::where('id_produit_parent',$id)
                                  ->orWhere('id_produit_enfant',$id)->delete();
            //dd($test);

            $produit=Produit::find($id);

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Administration->Les produits';
            $HistoriqueActions->description = 'Suppression du produit : '.$produit->reference;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $produit->delete();
            return redirect('produit/index')->with('msgDeleteOk',"Le produit a été supprimé avec succès");
        }

    }

    public function getFormEdit($id)
    {
        $produit = Produit::where('id_produit', '=', $id)->with("catigorie")->with("uniteMesure")->first();
        $categories = Categorie::all();
        $unites_mesure = UniteMesure::all();
        $produitsPack = Produit::where('compose_pack','!=','OUI')->where('id_produit','!=',$id)->get();
        $produitsMP = Produit::where('compose_mp','!=','OUI')->where('id_produit','!=',$id)->get();

        $produitComposePack = produitCompose::where('id_produit_parent', $id)
                                            ->where('type','COMPOSE_PACK')
                                            ->get();
        $produitComposeMP = produitCompose::where('id_produit_parent', $id)
                                            ->where('type','COMPOSE_MP')
                                            ->get();                                                                    
        return view('produit/modifier', compact('produit', 'categories', 'unites_mesure','produitsPack','produitComposePack','produitComposeMP','produitsMP'));
    }


    public function postFormEdit(Request $request, $id)
    {
        //dd($request->input('savoirPak'),$request->input('savoirMP'),$request->input('produit_Pack'), $request->input('quantite_Pack'), $request->input('produit_mp'), $request->input('quantite_mp'));
        $produit = Produit::where('designation', '=', $request->input('designation'))->where('id_categorie', '=', $request->input('id_categorie'))->where('reference', '=', $request->input('reference'))->where('code_identification', '=', $request->input('code_a_barre'))->where('statut', '=', $request->input('statut'))->first();

        $existDesignation= Produit::where('designation', '=', $request->input('designation'))
            ->where('id_produit','!=',$id)
            ->count();

        $existReference= Produit::where('reference', '=', $request->input('reference'))
            ->where('id_produit','!=',$id)
            ->count();
        $existCode= Produit::where('code_identification', '=', $request->input('code_a_barre'))
            ->where('id_produit','!=',$id)
            ->count();

        /*if($existDesignation > 0 )
        {
            return redirect()->back()->withInput()->with('msgIdf','Cette désignation existe déjà');
        }*/

        if($existReference > 0 )
        {
            return redirect()->back()->withInput()->with('msgIdf','Cette référence existe déjà');
        }
        if($existCode > 0 )
        {
            return redirect()->back()->withInput()->with('msgIdf','Ce code à barres existe déjà');
        }


        if($produit == null)
        {
            //...
            //
            $savoirMP  = $request->input('savoirMP');
            $savoirPak  = $request->input('savoirPak');

            $produit_pack = $request->input('produit_Pack');
            $quantite_pack = $request->input('quantite_Pack');
            $produit_mp = $request->input('produit_mp');
            $quantite_mp = $request->input('quantite_mp');
             //vérifier si le champ produit est renseigné 
            if ($savoirPak) {
                foreach ($produit_pack as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé pack"');
                        return redirect()->back()->withInput(); 
                    }
                }
                foreach ($quantite_pack as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé pack"');
                        return redirect()->back()->withInput(); 
                    }
                }
            }

            if ($savoirMP) {
                foreach ($produit_mp as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé MP"');
                        return redirect()->back()->withInput(); 
                    }
                }
                foreach ($quantite_mp as $key => $value) {
                    if ($value == '') {
                        $request->session()->flash('msgIdf', 'Erreur : Veuillez remplir tous les champs "Produit composé MP"');
                        return redirect()->back()->withInput(); 
                    }
                }
            }
            //Vérifier les doublons...
            $count = 0;
            if ($savoirPak) {
                foreach ($produit_pack as $key => $pack) {
                    foreach ($produit_pack as $key => $pack2) {
                        if ($pack == $pack2) {
                            $count++;
                        }
                    }
                    if ($count == 2) {
                        $request->session()->flash('msgIdf', 'Erreur : champ produit dupliqué dans la section "Produit composé pack"');
                        return redirect()->back()->withInput();
                    }else
                        $count =0;
                }
            }
            if ($savoirMP) {
                $count = 0;
                foreach ($produit_mp as $key => $mp) {
                    foreach ($produit_mp as $key => $mp2) {
                        if ($mp == $mp2) {
                            $count++;
                        }
                    }
                    if ($count == 2) {
                        $request->session()->flash('msgIdf', 'Erreur : champ produit dupliqué dans la section "Produit composé MP"');
                        return redirect()->back()->withInput();
                    }else
                        $count =0;
                }
            }

            $produit = Produit::find($id);
            $produit->designation = $request->input('designation');
            $produit->reference = $request->input('reference');
            $produit->code_identification = $request->input('code_a_barre');
            $produit->tva = $request->input('tva');
            $produit->code_mesure = $request->input('unite_mesure');
            $produit->poids = $request->input('poids');
            $produit->volume = $request->input('volume');
            $produit->statut = $request->input('statut');
            $produit->id_categorie = $request->input('categorie');
            $produit->num_serie = $request->input('serie');
            $produit->last_update= date("Y-m-d H:i:s");

            if ($savoirPak) {
                $produit->compose_pack ="OUI";
            }else
                 $produit->compose_pack ="NON";

            if ($savoirMP) {
                $produit->compose_mp ="OUI";
            }else
                $produit->compose_mp ="NON";

            $produit->update();

            /*if ($request->input("produit_compose") != null){
                $produit->id_produit_compose = $request->input('produit');
                $produit->qnt_produit_compose = $request->input('qnt');
            }else{
                $produit->id_produit_compose = null;
                $produit->qnt_produit_compose = null;
            }*/

            //delete
            $produitCompose = ProduitCompose::where('id_produit_parent',$id)->delete();

            if ($savoirPak) {
                for ($pack=0; $pack < count($produit_pack); $pack++) {
                    
                    $produitCompose = new ProduitCompose();
                    $produitCompose->type = "COMPOSE_PACK";
                    $produitCompose->id_produit_parent = $produit->id_produit;
                    $produitCompose->id_produit_enfant = $produit_pack[$pack];
                    $produitCompose->quantite = $quantite_pack[$pack];
                    $produitCompose->last_update = date("Y-m-d H:i:s");
                    $produitCompose->save();   
                }
            }

            if ($savoirMP) {
                for ($mp=0; $mp < count($produit_mp); $mp++) {
                    //pensé apres a vérifier les doublons.
                    $produitCompose = new ProduitCompose();
                    $produitCompose->type = "COMPOSE_MP";
                    $produitCompose->id_produit_parent = $produit->id_produit;
                    $produitCompose->id_produit_enfant = $produit_mp[$mp];
                    $produitCompose->quantite = $quantite_mp[$mp];
                    $produitCompose->last_update = date("Y-m-d H:i:s");
                    $produitCompose->save();   
                }
            }

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Administration->Les produits';
            $HistoriqueActions->description = 'Modification du produit : '.$produit->reference;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('produit/index')->with('msg',"Le produit a été modifié avec succès");
        }
        else
        {
            return redirect()->back()->withInput()->with('msgIdf','Ce produit existe déjà');
        }

    }

public function getProduitFromId($id){
        return Produit::find($id);
    }


    public function exportProduit(){
    $produits = Produit::with("catigorie")->with("uniteMesure")->get();
    Excel::create('Les produits_'.date('y-m-d'),function($excel) use ($produits){
        $excel->sheet('Feuil1', function($sheet) use ($produits){
            $sheet->setColumnFormat(array(
               'C' => '@',
               'D' => '@',
            ));
            $sheet->setWidth(array(
                'A' =>  50,
                'B' =>  20,
                'C' =>  20,
                'D' =>  20,
                'E' =>  10,
                'F' =>  10,
                'G' =>  10,
                'H' =>  15,
                'I' =>  15,
            ));
            
            $sheet->loadView('produit.export.exportProduit')->with('produits',$produits);
        });
    })->download('xlsx');
}
   public function recherche(Request $request){

    $mot_a_rechercher = $request->get('recherche');

    $produits = Produit::select('produit.*')->
    join('categorie','produit.id_categorie','=','categorie.id_categorie')->
    Where('designation','like','%'.$mot_a_rechercher.'%')->
    orWhere('reference','like','%'.$mot_a_rechercher.'%')->
    orWhere('code_identification','like','%'.$mot_a_rechercher.'%')->
    orWhere('tva','like','%'.$mot_a_rechercher.'%')->
    orWhere('statut','like','%'.$mot_a_rechercher.'%')->
    orWhere('libelle','like','%'.$mot_a_rechercher.'%')->
    with("catigorie")->with("uniteMesure")->paginate(10)->appends('recherche' , $mot_a_rechercher);
            //dd($produits);
    return view('produit.index',compact('produits','mot_a_rechercher'));
}

}