<?php

namespace App\Http\Controllers;

use App\LigneBonReceptionUe;
use App\BonLivraison;
use App\Emplacement;
use App\Chargement;
use App\CommandeClient;
use App\Historique;
use App\Client;
use App\LignePreparationChargement;
use App\LigneProduit;
use App\ListValeur;
use App\Produit;
use App\LigneCommandeProduit;
use App\Preparation;
use App\StockProduit;
use App\Transporteur;
use App\UniteExpedition;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\SeedServiceProvider;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use PHPExcel_IOFactory;
use Excel;
use App\Preferences;
use Config;
use PHPExcel_Style_NumberFormat;
use PHPExcel_Shared_Date;
use \Response;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Redirect;
use App\Ue;
use App\Entite;
use App\ConfigurationPdf;
use App\CompteurModule;
use App\NumSerie;
use App\LigneBonReception;
use App\NumeroSerie;
use App\Wilaya;



class PreparationController extends Controller
{
    public function restorData()
    {
        Session::put('numCommande',null);
        Session::put('numP',null);
        Session::put('dateP',null);
        Session::put('Transporteur',null);
        Session::put('commande',null);
        Session::put('raisonSociale', null);
        Session::put('adresseClient', null);
        Session::put('idPreparation',null);
        Session::put('preparation', null);
        Session::put('ligneProduits',null);
        Session::put('pageSource', null);
        Session::put('idPr', null);
        Session::put('entite', null);
        Session::put('Oper', null);
        Session::put('sociale', null);
        Session::put('n_commande', null);

        Session::put('mode_affichage',null);
        Session::put('region_client',null);
        

        $deleteLigneProduit=LigneProduit::where('idPreparation','=',0)->get();
        $deleteUE=UniteExpedition::where('nombreProduits','=',0)->get();
        foreach($deleteLigneProduit as $delete)
        {
            $ligne=$delete;
            $ligne->delete();
        }
        foreach($deleteUE as $delete)
        {
            $ligne=$delete;
            $ligne->delete();
        }
        //-1 from compteur module
        if (Session::get('NumPreparation') != null) {
            //$pre = CompteurModule::where('MODULE','PREPARATION')->first();
            /*if ($pre != null) {
                $pre->COMPTEUR_PAR_JOUR -= 1;
                $pre->COMPTEUR_PAR_MOIS -= 1;
                $pre->COMPTEUR_PAR_AN -= 1;
                $pre->last_update = date("Y-m-d");
                $pre->update();
            }*/
            Session::put('NumPreparation',null);
        }
        
    }

    public function index(){
            //récupéré le choix du filtre si il existe
            //$mode_affichage = Session::get('mode_affichage');
            //$region_client = Session::get('region_client');
            
            $this->restorData();
            //liste des préparations qui ne sont pas encore été livrée
            $preparations=Preparation::with('CommandeClient.Client')
            ->with('Client')
            ->with('Transporteur')
            ->with('livraison')
            ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
            ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
            ->whereDoesntHave('livraison') // Exclut les préparations qui ont une relation livraison
            ->orderBy('datePrevue','DESC')
            ->paginate(100);
            //enregistrer le choix du filtre dans la session
            //Session::put('mode_affichage',1);

            $regions = Wilaya::all();

        //dd($preparations);
        return view('preparation.index',compact('preparations','regions'));
    }

    public function recherche(Request $request){
        $mot_a_rechercher = Input::get('recherche');

        //récupéré le choix du filtre si il existe
        $mode_affichage = Input::get('mode_affichage');
        $region_client =  Input::get('region_client');
        //dd($mot_a_rechercher, $mode_affichage , $region_client);
        $regions = Wilaya::all();

        $preparations = Preparation::with('CommandeClient.Client')
        ->with('Client')
        ->with('Transporteur')->with('livraison')
        ->join('liste_valeur', 'liste_valeur.code', '=', 'preparation.statutPreparation')
        ->where('liste_valeur.nom_liste', '=', 'STATUT_PREPARATION')
        ->where(function($query0) use ($mode_affichage, $region_client){
                if ( $mode_affichage == 1) $query0->whereDoesntHave('livraison'); // Exclut les préparations qui ont une relation livraison
                if ( $region_client != 0) $query0->WhereHas('Client', function ($query2) use ($region_client) {
                    $query2->where('region', $region_client);
                });
        })
        ->where(function ($query) use ($mot_a_rechercher) {
            $query->where('numPreparation', 'like', '%' . $mot_a_rechercher . '%')
                ->orWhere('datePrevue', 'like', '%' . $mot_a_rechercher . '%')
                ->orWhere('liste_valeur.valeur', 'like', '%' . $mot_a_rechercher . '%')
                ->orWhereHas('Client', function ($query6) use ($mot_a_rechercher) {
                    $query6->where('raisonSociale', 'like', '%' . $mot_a_rechercher . '%');
                })
                ->orWhereHas('CommandeClient', function ($query3) use ($mot_a_rechercher) {
                    $query3->where('numCommande', 'like', '%' . $mot_a_rechercher . '%');
                })
                ->orWhereHas('livraison', function ($query4) use ($mot_a_rechercher) {
                    $query4->where('num_bl', 'like', '%' . $mot_a_rechercher . '%');
                })
                ->orWhereHas('Transporteur', function ($query5) use ($mot_a_rechercher) {
                    $query5->where('numTransporteur', 'like', '%' . $mot_a_rechercher . '%');
                });
        })
        ->orderBy('datePrevue', 'DESC')
        ->paginate(100)
        ->appends(['recherche'=> $mot_a_rechercher, 'mode_affichage' => $mode_affichage, 'region_client' => $region_client]);

        return view('preparation.index',compact('preparations','mot_a_rechercher','regions','mode_affichage','region_client'));
    }

    public function filtre(Request $request){
        $mode_affichage = Input::get('mode_affichage');
        $region_client = Input::get('region_client');

        $regions = Wilaya::all();

        //dd($mode_affichage, $region_client);
        $preparations = Preparation::with('CommandeClient.Client')
        ->with('Client')
        ->with('Transporteur')->with('livraison')
        ->join('liste_valeur', 'liste_valeur.code', '=', 'preparation.statutPreparation')
        ->where('liste_valeur.nom_liste', '=', 'STATUT_PREPARATION')
        ->where(function($query) use ($mode_affichage, $region_client){
                if ( $mode_affichage == 1) $query->whereDoesntHave('livraison'); // Exclut les préparations qui ont une relation livraison
                if ( $region_client != 0) $query->WhereHas('Client', function ($query2) use ($region_client) {
                    $query2->where('region', $region_client);
                });
        })
        ->orderBy('datePrevue', 'DESC')
        ->paginate(100)
        ->appends(['mode_affichage' => $mode_affichage, 'region_client' => $region_client]);

        return view('preparation.index',compact('preparations','mode_affichage','region_client','regions'));
    }


      public function annuler($id){
        $lignePreparation= LignePreparationChargement::select('idPreparation')
        ->get();

        $exist = LignePreparationChargement::where('idPreparation','=',$id)
        ->whereIn('idPreparation',$lignePreparation)
        ->count();

       // dd($exist);
        if($exist == 0 )
        {
            $ligneProduit = LigneProduit::where('idPreparation','=',$id)->get();

            foreach($ligneProduit as $ligne){
                $stock = StockProduit::where('id_stock_produit',$ligne->idStock)->first();
                $stock->quantite_utilisable += $ligne->quantite_a_preparer;
                $stock->last_update = date("Y-m-d H:i:s");
                $stock->update();

                //supprimer les numéros série
                $num_serie = NumeroSerie::where('id_ligne_produit',$ligne->idLigneProduit)->delete();
                /*if ($num_serie != null) {
                    $num_serie->delete();
                }*/

                $box = Ue::where('num_ue',$stock->num_ue)->first();
                //si le box est ouvert
                if ($box->etat_ue == 1) {
                    $idStocks= StockProduit::where('num_ue',$box->num_ue)->get(['id_stock_produit']);
                    $idStocks= $idStocks->toArray();
                    //dd($idStocks);

                    $existePreparation = LigneProduit::join('preparation','preparation.idPreparation',"=","ligne_produit.idPreparation")->
                    where('statutPreparation',"!=",4)->
                    where('ligne_produit.idPreparation','!=',$id)->
                    whereIn('idStock',$idStocks)->get();
                    //dd($existePreparation);

                    if ($existePreparation->isEmpty()) {
                        $box->etat_ue = 0;
                        $box->last_update = date("Y-m-d H:i:s");
                        $box->update();
                    }
                }
                //$ligne->delete();
            }
            $preparations = Preparation::find($id);

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Annulation';
            $HistoriqueActions->nom_table = 'Clients->Les préparations';
            $HistoriqueActions->description = 'Annulation de la préparation : '.$preparations->numPreparation;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $preparations->statutPreparation = 4;
            $preparations->last_update = date("Y-m-d H:i:s");
            $preparations->update();



            return redirect('preparation/index')->with('msgSupprimer','La préparation a été annulée avec succès');
        }
        else
        {
            return redirect('preparation/index')->with('msgExist',"Annulation impossible car un chargement est affecté à cette préparation");
        }

    }

    public function delete($id){
        $lignePreparation= LignePreparationChargement::select('idPreparation')
        ->get();

        $exist = LignePreparationChargement::where('idPreparation','=',$id)
        ->whereIn('idPreparation',$lignePreparation)
        ->count();

       // dd($exist);
        if($exist == 0 )
        {
            $preparations = Preparation::find($id);
            if ($preparations->statutPreparation == 4) {
                $ligneProduit = LigneProduit::where('idPreparation','=',$id)->delete();
            }else{
                $ligneProduit = LigneProduit::where('idPreparation','=',$id)->get();
                foreach($ligneProduit as $ligne){
                    $stock = StockProduit::where('id_stock_produit',$ligne->idStock)->first();
                    $stock->quantite_utilisable += $ligne->quantite_a_preparer;
                    $stock->last_update = date("Y-m-d H:i:s");
                    $stock->update();

                    //supprimer les numéros série
                    $num_serie = NumeroSerie::where('id_ligne_produit',$ligne->idLigneProduit)->delete();
                    /*if ($num_serie != null) {
                        $num_serie->delete();
                    }*/
                    
                    
                    $box = Ue::where('num_ue',$stock->num_ue)->first();
                    //si le box est ouvert
                    if ($box->etat_ue == 1) {
                        $idStocks= StockProduit::where('num_ue',$box->num_ue)->get(['id_stock_produit']);
                        $idStocks= $idStocks->toArray();
                        //dd($idStocks);

                        $existePreparation = LigneProduit::join('preparation','preparation.idPreparation',"=","ligne_produit.idPreparation")->
                        where('statutPreparation',"!=",4)->
                        where('ligne_produit.idPreparation','!=',$id)->
                        whereIn('idStock',$idStocks)->get();
                        //dd($existePreparation);

                        if ($existePreparation->isEmpty()) {
                            $box->etat_ue = 0;
                            $box->last_update = date("Y-m-d H:i:s");
                            $box->update();
                        }
                    }

                    $ligne->delete();
                }
            }
            
            //$preparations = Preparation::find($id);

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Clients->Les préparations';
            $HistoriqueActions->description = 'Suppression de la préparation: '.$preparations->numPreparation;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $preparations->delete();



            return redirect('preparation/index')->with('msgSupprimer','La préparation a été supprimée  avec succès');
        }
        else
        {
            return redirect('preparation/index')->with('msgExist',"Suppression impossible car un chargement est affecté à cette préparation");
        }

    }

    public function getForm(){


        $deleteUE=UniteExpedition::where('SSCC','=',0)->get();
        foreach($deleteUE as $delete)
        {
            $ligne=$delete;
            $ligne->delete();
        }

        //$commandes=CommandeClient::with('Client')->get();
        $p='commande_client  where idCommande not in (select idCommande from preparation) ';
        $commandes =DB::table(DB::raw($p))->get();
       // dd($commandes);

        $transporteurs = Transporteur::get();
        //dd($transporteurs);
        $LigneProduits=LigneProduit::where('idPreparation','=',0)
        ->with('StockProduit.Emplacement')
        ->with('UniteExpedition')
        ->with('Produit')
        ->with('User')
        ->get();
    //   dd($LigneProduits);
        $operateurs=User::where('profil','=','1')
            ->get();

        $totalPoids=$LigneProduits->sum('total_poids');
        $totalProduits=$LigneProduits->count();
        $totalUE = null;
        if (Session::get('STOCK_EMPLACEMENT_MOBILE')=='1') {
            $totalUE = LigneProduit::join('stock_produit','stock_produit.id_stock_produit','=','ligne_produit.idStock')->where('idPreparation','=',0)->get();
            $totalUE = $totalUE->unique('num_ue')->count();
        }else{
            $totalUE = DB::table('ligne_produit')->where('idPreparation','=',0)->where('idUE','!=',0)->count(DB::raw('DISTINCT idUE'));
        }
        

        $UEs= LigneProduit::where('idPreparation','=',0)
        ->where('idUE','!=',0)
        ->with('UniteExpedition')
                //->groupBy('idUE')
        ->get();

        /*$lastNum =Preparation::orderBy('idPreparation','desc')->first();
        if ($lastNum != null) {
            $NumPreparation = substr_replace($lastNum->numPreparation, "", 0, 5);
            if ($NumPreparation == 99999){
                $NumPreparation='PREPA00001';
            }
            else {
                $NumPreparation = $NumPreparation + 1;
                $NumPreparation=str_pad($NumPreparation, 5, '0', STR_PAD_LEFT);


                $NumPreparation ='PREPA'.$NumPreparation;
            }

        }
        else
            $NumPreparation='PREPA00001';*/
        if ( Session::get('NumPreparation') == null) {
        $monfichier = fopen('NumeroPreparation.txt', 'r');

        $ligne1 = fgets($monfichier);
        $prefixe = explode("=", $ligne1);
        $prefixe = str_replace("\r\n","",$prefixe[1]);

        $ligne2 = fgets($monfichier);
        $date = explode("=", $ligne2);
        $date = str_replace("\r\n","",$date[1]);
        $date = date("Y-m-d");
        if ($date == "AAMMJJ") {
            $date = date("y-m-d");
        }
        if($date == "JJMMAA"){
            $date = date("d-m-y");
        }
        if ($date == "AAAA") {
            $date = date("Y");
        }
        if ($date == "AA") {
            $date = date("y");
        }

        $date = str_replace("-","",$date);

        //récupéré nombre de bon livraison par jour , par mois par an
        $prep = CompteurModule::where('MODULE',"PREPARATION")->first();
        $day = 0;
        $mounth = 0;
        $year = 0;

        if ($prep != null) {
            $timestamp = strtotime($prep->last_update);
            
            if (date("Y", $timestamp) == date('Y')) $year = $prep->COMPTEUR_PAR_AN + 1;
            else $year = 1;

            if (date("m", $timestamp) == date('m')) $mounth = $prep->COMPTEUR_PAR_MOIS + 1;
            else $mounth = 1;

            if (date("d", $timestamp) == date('d')) $day= $prep->COMPTEUR_PAR_JOUR + 1;
            else $day = 1;

            //$prep->last_update = date("Y-m-d");
            //$prep->update();
        }else{
            /*$prep = new CompteurModule();
            $prep->MODULE = "PREPARATION";
            $prep->COMPTEUR_PAR_JOUR = 1;
            $prep->COMPTEUR_PAR_MOIS = 1;
            $prep->COMPTEUR_PAR_AN = 1;
            $prep->last_update = date("Y-m-d");
            $prep->save();*/
            $day = 1;
            $mounth = 1;
            $year = 1;
        }
        $ligne3 = fgets($monfichier);
        $taille_compteur = explode("=", $ligne3);
        $taille_compteur = (int)str_replace("\r\n","",$taille_compteur[1]);

        $ligne4 = fgets($monfichier);
        $format_sequence = explode("=", $ligne4);
        $format_sequence = str_replace("\r\n","",$format_sequence[1]);
        $format_sequence = str_replace("+","",$format_sequence);

        $jour = str_pad($day, $taille_compteur, '0', STR_PAD_LEFT);
        $mois = str_pad($mounth, $taille_compteur, '0', STR_PAD_LEFT);
        $an = str_pad($year, $taille_compteur, '0', STR_PAD_LEFT);

        $format_sequence = str_replace("DATE",$date,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_JOUR",$jour,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_MOIS",$mois,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_AN",$an,$format_sequence);
        $NumPreparation = $prefixe.$format_sequence;

        Session::put('NumPreparation',$NumPreparation);
        }else
        $NumPreparation = Session::get('NumPreparation');

        if (Session::get('dateP') == null)
        {
            Session::put('dateP',date("Y-m-d"));
        }
        //$num_entite = Preparation::get(['num_entite']);
        //dd($num_entite);
        $entites = Entite::all();
        //dd($num_entite,$entites);
        $sociales = Client::all();
        //dd($sociales);
        $commandes = CommandeClient::all();


        return view('preparation.ajouter',compact('operateurs','transporteurs','commandes','LigneProduits','totalPoids','totalProduits','totalUE','UEs','NumPreparation','entites','sociales','commandes'));
    }

    public function postForm(Request $request){
        //dd($request->input('n_commande'));
            $nombre_de_ue = collect();
            $preparation_a_modifier = 0;



     $numExist=Preparation::where('numPreparation','=',$request->input('numPreparation'))->count();




     if($numExist > 0)
     {
        return redirect('preparation/ajouter')->with('msgExist','Numéro de préparation existe déjà');
    }
    else
    {
        $preparationExist=false;
        if(Session::get('numCommande')!= null && $request->input('raisonSociale')!= null) {
            $idCommande=CommandeClient::where('numCommande','=',Session::get('numCommande'))->get()->first()->idCommande;
            $C=Preparation::where('idCommande','=',$idCommande)->get();
            if($C->first()){
                $preparationExist=true;
            }

        }
        if($preparationExist)
        {
            return redirect('preparation/ajouter')->with('msgExist','Cette commande a une prépartion déjà');
        }
        else {
            $LigneProduits = LigneProduit::where('idPreparation', '=', 0)
            ->get();

            $condition = 0;
            $idUser = null;
            $idUE = null;
            $n = 0;
            foreach ($LigneProduits as $LigneProduit) {
                $idUser = $LigneProduit->idUser;
                $idUE = $LigneProduit->idUE;

                foreach ($LigneProduits as $LigneProduit) {
                    if (($idUser != $LigneProduit->idUser) && ($idUE == $LigneProduit->idUE) && $idUE != 0) {
                        $condition += 1;
                    }
                }
            }
            if ($condition == 0) {

                $preparation = new Preparation();
                $monfichier = fopen('NumeroPreparation.txt', 'r');

        $ligne1 = fgets($monfichier);
        $prefixe = explode("=", $ligne1);
        $prefixe = str_replace("\r\n","",$prefixe[1]);

        $ligne2 = fgets($monfichier);
        $date = explode("=", $ligne2);
        $date = str_replace("\r\n","",$date[1]);
        $date = date("Y-m-d");
        if ($date == "AAMMJJ") {
            $date = date("y-m-d");
        }
        if($date == "JJMMAA"){
            $date = date("d-m-y");
        }
        if ($date == "AAAA") {
            $date = date("Y");
        }
        if ($date == "AA") {
            $date = date("y");
        }

        $date = str_replace("-","",$date);

        //récupéré nombre de bon livraison par jour , par mois par an
        $prep = CompteurModule::where('MODULE',"PREPARATION")->first();
        
        if ($prep != null) {
            $timestamp = strtotime($prep->last_update);
            
            if (date("Y", $timestamp) == date('Y')) $prep->COMPTEUR_PAR_AN += 1;
            else $prep->COMPTEUR_PAR_AN = 1;

            if (date("m", $timestamp) == date('m')) $prep->COMPTEUR_PAR_MOIS += 1;
            else $prep->COMPTEUR_PAR_MOIS = 1;

            if (date("d", $timestamp) == date('d')) $prep->COMPTEUR_PAR_JOUR += 1;
            else $prep->COMPTEUR_PAR_JOUR = 1;

            $prep->last_update = date("Y-m-d");
            $prep->update();
        }else{
            $prep = new CompteurModule();
            $prep->MODULE = "PREPARATION";
            $prep->COMPTEUR_PAR_JOUR = 1;
            $prep->COMPTEUR_PAR_MOIS = 1;
            $prep->COMPTEUR_PAR_AN = 1;
            $prep->last_update = date("Y-m-d");
            $prep->save();
        }

        $ligne3 = fgets($monfichier);
        $taille_compteur = explode("=", $ligne3);
        $taille_compteur = (int)str_replace("\r\n","",$taille_compteur[1]);

        $ligne4 = fgets($monfichier);
        $format_sequence = explode("=", $ligne4);
        $format_sequence = str_replace("\r\n","",$format_sequence[1]);
        $format_sequence = str_replace("+","",$format_sequence);

        $jour = str_pad($prep->COMPTEUR_PAR_JOUR, $taille_compteur, '0', STR_PAD_LEFT);
        $mois = str_pad($prep->COMPTEUR_PAR_MOIS, $taille_compteur, '0', STR_PAD_LEFT);
        $an = str_pad($prep->COMPTEUR_PAR_AN, $taille_compteur, '0', STR_PAD_LEFT);

        $format_sequence = str_replace("DATE",$date,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_JOUR",$jour,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_MOIS",$mois,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_AN",$an,$format_sequence);
        $NumPreparation = $prefixe.$format_sequence;

                $preparation->numPreparation = $NumPreparation;
                
                if ($request->input('transporteur') != null) {
                    $preparation->idTransporteur = $request->input('transporteur');
                }

                $preparation->datePrevue = $request->input('datePrevue');
                if (Session::get('STOCK_ENTITE')) {
                    $preparation->num_entite = $request->input('entite');
                }
                if (Session::get('STOCK_ENTITE')!= "1" && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')!= "1") {
                    $preparation->nombreUE = $request->input('nombreUE');
                }else
                 $preparation->nombreUE = -1;
                
                $preparation->statutPreparation = 0;
                $preparation->totalPoids = $request->input('totalPoids');
                $preparation->nombreProduits = $request->input('nombreProduit');

                if (Session::get('numCommande') != null && $request->input('raisonSociale') != null) {
                    $numCommande = Session::get('numCommande');
                    $idCommande = CommandeClient::where('numCommande', '=', $numCommande)->value('idCommande');
                    $cmd = CommandeClient::find($idCommande);
                    $cmd->statutCommande = "En cours de préparation";
                    $cmd->update();
                    $preparation->idCommande = $idCommande;
                }
                $preparation->last_update = date("Y-m-d H:i:s");
                $preparation->adresse_livraison = $request->input('sociale');
                if ($request->input('n_commande') != null && $request->input('n_commande')!= "") {
                     $commandeee = CommandeClient::where('numCommande',$request->input('n_commande'))->first();
                    if (!$commandeee) {
                        $commande = new CommandeClient();
                        $commande->numCommande = $request->input('n_commande');
                        $commande->dateCommande = date("Y-m-d");
                        $commande->idClient = $request->input('sociale');
                        $commande->save();
                        $id_commande = $commande->idCommande;
                        $preparation->idCommande = $id_commande;
                    }else{
                        $id_commande = $commandeee->idCommande;
                        $preparation->idCommande = $id_commande;
                    }
                }
               
                $preparation->save();
                $preparation_a_modifier = $preparation->idPreparation;


                Session::put('NumPreparation',null);

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Ajout';
                $HistoriqueActions->nom_table = 'Clients->Les préparations';
                $HistoriqueActions->description = 'Ajout de la préparation: '.$preparation->numPreparation;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                $idPreparation = Preparation::max('idPreparation');

                foreach ($LigneProduits as $ligne) {
                   
                    //$ligne = $ligneProduit;
                    $ligne->idPreparation = $idPreparation;
                    $ligne->last_update = date("Y-m-d H:i:s");
                    $ligne->update();
                    //mettre a jour la quantité utilisable stock
                    $stock = StockProduit::find($ligne->idStock);
                    $stock->quantite_utilisable -= $ligne->quantite_a_preparer;
                    $stock->last_update = date("Y-m-d H:i:s");
                    $stock->update();

                    if (! $nombre_de_ue->contains($stock->num_ue)) {
                        //inserer dans la collection le ue;
                        $nombre_de_ue->put($stock->num_ue, 1); 
                    }
                }
                 //changer etat de ue
                 $count_ue_fermer = 0;
    foreach ($nombre_de_ue as $key => $ue) {
        $box = Ue::where('num_ue',$key)->first();
        if ($box->etat_ue == 0){
            $stock = StockProduit::where('num_ue',$key)->where('quantite_utilisable','!=',0)->first();
            if ($stock != null) {
                $box->etat_ue = 1;
                $box->last_update = date("Y-m-d H:i:s");
                $box->update();
            }else {
                $count_ue_fermer++;      
            }
        }
}

if (Session::get('STOCK_ENTITE')== "1" && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')== "1") {
    //modifier le champ nombreUE de l'objet preparation
        $pre = Preparation::find($idPreparation);
        if ($pre != null) {
            $pre->nombreUE = $count_ue_fermer;
                    $pre->update();
        }
                    
                }
    $this->charger_numero_serie($LigneProduits);



                    // dd($idPreparation->idPreparation);


                return redirect('preparation/index')->with('msgAjouter', 'Préparation ajoutée avec succès');


            } else {

                return redirect('preparation/ajouter')->with('msgExist', 'l\'UE doit être préparée par un seul opérateur');

            }
        }

    }
}


public function charger_numero_serie($lignes){
    //dd($lignes);
    foreach($lignes as $ligne){
        //dd($ligne);
        //tester si ue est fermer
        $stock = StockProduit::find($ligne->idStock);
        $ue_fermer = Ue::where('num_ue',$stock->num_ue)->first();

        if ($ue_fermer->etat_ue == 0) {
            //get id_ligne_reception
            $ligne_reception = LigneBonReception::where('id_stock_produit',$ligne->idStock)->first();
            if ($ligne_reception != null ) {
               $ligne_num_serie = NumSerie::where('id_ligne_reception',$ligne_reception->id_ligne_bon_reception)->get();
                if ($ligne_num_serie != null) {
                    foreach($ligne_num_serie as $value){
                        //testé si N/S existe deja 
                        $existe = NumeroSerie::where('num_serie',$value->num_serie)->first();
                        if ($existe == null) {
                            $serie = new NumeroSerie();
                            $serie->id_ligne_produit = $ligne->idLigneProduit;
                            $serie->num_serie = $value->num_serie;
                            $serie->last_update = date("Y-m-d H:i:s");
                            $serie->save();
                        } 
                    }
                }
            }
        }
    }
    return true;
}

/*public function decharger_numero_serie($ligne){
     $ligne_reception = LigneBonReception::where('id_stock_produit',$ligne->idStock)->first();
     if ($ligne_reception != null) {
        $ligne_num_serie = NumSerie::where('id_ligne_reception',$ligne_reception->id_ligne_bon_reception)->get();
        if ($ligne_num_serie != null) {
            NumeroSerie::where('id_ligne_produit',$ligne->idLigneProduit)->delete();
        }
     }
}*/
public function decharger_numero_serie($lignes){
    foreach($lignes as $ligne){
        //dd($ligne);
        //tester si ue est fermer
        $stock = StockProduit::find($ligne->idStock);
        $ue_fermer = Ue::where('num_ue',$stock->num_ue)->first();

        if ($ue_fermer->etat_ue == 1) {
            //get id_ligne_reception
            $ligne_reception = LigneBonReception::where('id_stock_produit',$ligne->idStock)->first();
            if ($ligne_reception != null ) {
               $ligne_num_serie = NumSerie::where('id_ligne_reception',$ligne_reception->id_ligne_bon_reception)->get();
                if ($ligne_num_serie != null) {
                    NumeroSerie::where('id_ligne_produit',$ligne->idLigneProduit)->delete();
                }
            }
        }
    }
    return true;
}
public function charger_ligne_numero_serie($ligne){
    //dd($lignes);

        //dd($ligne);
        //tester si ue est fermer
        $stock = StockProduit::find($ligne->idStock);
        $ue_fermer = Ue::where('num_ue',$stock->num_ue)->first();

        if ($ue_fermer->etat_ue == 0) {
            //get id_ligne_reception
            $ligne_reception = LigneBonReception::where('id_stock_produit',$ligne->idStock)->first();
            if ($ligne_reception != null ) {
               $ligne_num_serie = NumSerie::where('id_ligne_reception',$ligne_reception->id_ligne_bon_reception)->get();
                if ($ligne_num_serie != null) {
                    foreach($ligne_num_serie as $value){
                        //testé si N/S existe deja 
                        $existe = NumeroSerie::where('num_serie',$value->num_serie)->first();
                        if ($existe == null) {
                            $serie = new NumeroSerie();
                            $serie->id_ligne_produit = $ligne->idLigneProduit;
                            $serie->num_serie = $value->num_serie;
                            $serie->last_update = date("Y-m-d H:i:s");
                            $serie->save();
                        } 
                    }
                }
            }
        }
    return true;
}

public function sessionPreparation(){
    $num = Input::get('ID');
    $numP= Session::put('numP',$num);
    return response()->json();

}
public function sessionOperateur(){
    Session::put('Oper', null);
    $num = Input::get('ID');
    $numP= Session::put('Oper',$num);
    return response()->json();

}
public function sessionDate(){
    $date = Input::get('ID');
    $dateP= Session::put('dateP',$date);
    return response()->json();

}
public function sessionCommandee(){
    $commande = Input::get('ID');
    $commande= Session::put('n_commande',$commande);
    return response()->json();
}

public function sessionEntite(Request $request,$entite){
    //$date = $request->input('entite');
    $dateP= Session::put('entite',$entite);
    return response()->json();

}
public function sessionSociale(){
    $date = Input::get('ID');
    $dateP= Session::put('sociale',$date);
    return response()->json();

}
public function sessionTransporteur(){
    $transporteur = Input::get('ID');

    Session::put('Transporteur',$transporteur);
    return response()->json();

}
public function sessionCommande(){
    $commande = Input::get('ID');

    if($commande== 1)
    {

        Session::put('commande',$commande);
    }
    else
    {
        Session::put('commande',null);
        Session::put('numCommande', null);
        Session::put('raisonSociale', null);
        Session::put('adresseClient', null);
    }

    return response()->json();

}



public function getCommandeClient(){

    $ref = Input::get('ID');

       /*     $rest2=CommandeClient::join('client','client.idClient','=','commande_client.idClient')
                ->where('idCommande','=',$ref)
                ->first();*/
       // dd($rest2);
      /*  $rest=CommandeClient::join('client','client.idClient','=','commande_client.idClient')
            ->where('numCommande','=',$ref)
            ->get();*/
            $rest=CommandeClient::with('Client')
            ->where('idCommande','=',$ref)
            ->first();

        //dd($rest->raisonSociale);

            $restcount=CommandeClient::join('client','client.idClient','=','commande_client.idClient')
            ->where('idCommande','=',$ref)
            ->count();

            if ($restcount != 0){
                Session::put('numCommande', $rest->numCommande);
                Session::put('commande', 'checked');
                Session::put('raisonSociale', $rest->client->raisonSociale);
                Session::put('adresseClient', $rest->client->adresseClient);


            }
            else{
                Session::put('commande', null);
                Session::put('numCommande', null);
                Session::put('raisonSociale', null);
                Session::put('adresseClient', null);
            }


            return response()->json($rest);

        }



        public function getFormProduit(){

            $operateurs=User::where('profil','=','1')
            ->get();
            $idCommande='';
            $alerte='';
            if ( Session::get('numCommande')!= null )
            {
                $numCommande=Session::get('numCommande');

                $idCommande = CommandeClient::where('numCommande','=',$numCommande)->first();
            //dd($idCommande->idCommande);

                $ligneCommandeProduits= LigneCommandeProduit::select('idProduit')
                ->where('idCommande','=',$idCommande->idCommande)
                ->get();

            //dd($ligneCommandeProduits->count());

                $lignePreparationProduits=LigneProduit::select('idProduit')
                ->where('idPreparation','=',0)
                ->get();
            //dd($lignePreparationProduits);

                $stockproduits = StockProduit::with('Produit')
                ->with('emplacement')
                ->whereIn('id_produit',$ligneCommandeProduits)
                ->whereNotIn('id_produit',$lignePreparationProduits)
                ->get();
            //dd($stockproduits);
           // dd($stockproduits);
                if ($ligneCommandeProduits->count() == 1 && $stockproduits->count() == 0) {
                 $alerte = "Attention ! Ce produit n'est pas dans le stock.";
             }
             elseif ($ligneCommandeProduits->count() > $stockproduits->count()) {
                 $alerte = "Attention ! Certains produits ne sont pas dans le stock.";
             }
             elseif ($stockproduits->count() == 0) {
                 $alerte = "Attention ! Ces produits ne sont pas dans le stock";
             }
           //dd($stockproduits->count());
         }
         else {
            $lignePreparationProduits=LigneProduit::select('idProduit')
            ->where('idPreparation','=',0)
            ->get();

            $stockproduits =null;
            $stockproduits= collect();
            $collet = StockProduit::where('quantite_utilisable','>',0)
            ->where('num_entite',Session::get('entite'))
            ->with('Produit')
            ->with('emplacement')
            ->whereNotIn('id_produit',$lignePreparationProduits)
            //->distinct('id_produit')
            ->chunk(500, function ($rows) use ($stockproduits) {
                    foreach ($rows as $row) {
                        $stockproduits->push($row);
                    }
                });
            //dd(Session::get('entite'),$stockproduits);
            //$stockproduits = $stockproduits->unique('id_produit');
            $stockproduits = $stockproduits->groupBy(function($item, $key){   
                    return $item["id_produit"];
                });
            //dd($stockproduits);
            //dd(Session::get('entite'));
        }

        //dd($stockproduits);


        return view('preparation.ajouter_produit',compact('operateurs','stockproduits','idCommande','alerte'));
    }

    public function postFormProduit(Request $request){
        if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1"){
        //dd($request->input('select'));
        $produits = $request->input('select');
        $quantites = $request->input('quantite');
        //dd($produits,$quantites );
        
       
        for ($i=0; $i < count($produits) ; $i++) {
            $produit = Produit::find($produits[$i]);
            $resultat_algo_picking = $this->AlgoPicking3(Session::get('entite') ,$produit ,$quantites[$i], 0 );
            //dd($resultat_algo_picking);
            if ($resultat_algo_picking == null) {
                //DB::rollback();
                //dd('Échec');
                return Redirect::back()->withErrors(["Échec de ajouter le produit :".$produit->reference]);
            }

            foreach ($resultat_algo_picking as $key => $value) {

                                        /*//ajouer une ue
                                                    $existeUE = UniteExpedition::where('SSCC',$value[0]->num_ue)->first();
                                                    $ue = null;
                                                    if ($existeUE != null) {

                                                        $existeUE->nombreProduits = $existeUE->nombreProduits + 1;
                                                        $existeUE->poidsProduits = $existeUE->poidsProduits + ( $produit->poids * $value[1]);
                                                        $existeUE->update();
                                                        $ue = $existeUE;
                                                    }else{
                                            //si oui créer une unite expedition
                                                        $existeUE = new UniteExpedition();
                                                        $existeUE->SSCC = $value[0]->num_ue;
                                                        $existeUE->nombreProduits = 1;
                                                        $existeUE->poidsProduits = $produit->poids * $value[1];
                                                        $existeUE->save();
                                                        $ue = $existeUE;   
                                                    }*/

                                        $LigneProduit = new LigneProduit();
                                        $LigneProduit->idPreparation = 0;
                                        $LigneProduit->idUE = 0;
                                        $LigneProduit->idProduit = $produit->id_produit;
                                        $LigneProduit->idStock = $key;
                                        $LigneProduit->idUser = $request->input('operateur');
                                        $LigneProduit->quantite_a_preparer = $value[1];
                                        $LigneProduit->quantite_preparer = 0;
                                        $LigneProduit->quantite_restante = $value[1];
                                        $LigneProduit->total_poids = $produit->poids * $value[1];
                                        $LigneProduit->simule_fo = 0;
                                        $LigneProduit->last_update = date("Y-m-d H:i:s");
                                        $LigneProduit->save();                                
                                   }
        }
            
        }else{
        $stockproduits = StockProduit::with('Produit')->with('emplacement')->get();

        foreach ($stockproduits as $stockproduit) {
            if($request->input('select'.$stockproduit->id_stock_produit.'')=='selected'){
                $ligne_produit = new LigneProduit ();
                $ligne_produit->idPreparation = 0;
                $ligne_produit->idUE = 0;
                $ligne_produit->idProduit = $stockproduit->Produit->id_produit;
                $ligne_produit->idStock = $stockproduit->id_stock_produit;
                $ligne_produit->idUser = $request->input('operateur');
                $qnt= $ligne_produit->quantite_a_preparer = $request->input('quantite' . $stockproduit->id_stock_produit . '');
                $ligne_produit->total_poids =$qnt*($stockproduit->Produit->poids) ;
                $ligne_produit->quantite_preparer =0 ;
                $ligne_produit->quantite_restante =$qnt;
                $ligne_produit->save();
            }
        }
    }

        return redirect('preparation/ajouter');
    }

    public function deleteProduit($id){

        $ligneProduit = LigneProduit::find($id);
        //dd($ligneProduit);
        if ($ligneProduit->idPreparation != 0) {
           //mettre a jour la quantité utilisable stock
            $stock = StockProduit::where('id_stock_produit',$ligneProduit->idStock)->first();
            $stock->quantite_utilisable += $ligneProduit->quantite_a_preparer;
            $stock->last_update = date("Y-m-d H:i:s");
            $stock->update();

            $ligneProduit->supprimer = 1;
            $ligneProduit->update();
            //changer état du box a 1 (ouvert) + décharger les n/s
            //ici
            $stockk = StockProduit::where('num_ue',$stock->num_ue)->where('quantite_utilisable','!=',0)->first();
            if ($stockk != null) {
                $box = Ue::where('num_ue',$stock->num_ue)->first();
                //tester si le box été fermer
                if ($box->etat_ue == 0) {
                    //incrémentée nombre UE de la table préparation
                    $preparation = Preparation::find($ligneProduit->idPreparation);
                    $preparation->nombreUE -= 1;
                    $preparation->update();

                }
                $box->etat_ue = 1;
                $box->last_update = date("Y-m-d H:i:s");
                $box->update();
            /*$ue = Ue::where('num_ue',$stock->num_ue)->first();
            $ue->etat_ue = 1;
            $ue->update();*/
            //get all ligne_produit meme ue
            $numero_serie_reception = NumSerie::where('numUE',$stockk->num_ue)->get();

                if ($numero_serie_reception != null) {
                    $liste_ligne = collect();
                    foreach($numero_serie_reception as $key => $num_serie_reception){
                        $ligne_reception = LigneBonReception::find($num_serie_reception->id_ligne_reception);
                            $ligne_produit_preparation = null;
                            if ($ligne_reception != null) {
                                $ligne_produit_preparation = LigneProduit::where('idStock',$ligne_reception->id_stock_produit)
                                ->where(function ($query) use ($ligneProduit) {
                                    $query->where('idPreparation', $ligneProduit->idPreparation)
                                          ->orWhere('idPreparation', 0);
                                })->first();
                            }
                                                
                            if ($ligne_produit_preparation != null) {
                                $liste_ligne->put($key, $ligne_produit_preparation);
                            }  
                    }
                }
                                        
            $this->decharger_numero_serie($liste_ligne);            
        
            return redirect()->back()->withInput()->with('msgSupprimer','Le produit a été supprimé avec succès');
        }else{
            $ligneProduit->delete();
            return redirect()->back()->withInput()->with('msgSupprimer','Le produit a été supprimé avec succès');
        } 
    }else{
        return redirect()->back()->withInput()->with('msgSupprimer','Le produit a été supprimé avec succès');
    }
}

    public function postEditeLigneProduit(Request $request,$id){
        $LigneProduit=LigneProduit::find($id);
        $qantite=$request->input('quantite');
        $SSCC =$request->input('sscc');
        $stockProduit=StockProduit::where('id_stock_produit','=',$LigneProduit->idStock)->with('ue')->first();

        if($qantite <= ($stockProduit->quantite_utilisable + $LigneProduit->quantite_a_preparer)){
            //mettre a jour la quantité utilisable dans le stock
            $stockProduit->quantite_utilisable += $LigneProduit->quantite_a_preparer;
            $stockProduit->quantite_utilisable -= $qantite;
            $stockProduit->update();

            $poids=($LigneProduit->total_poids)/($LigneProduit->quantite_a_preparer);
            $poids=number_format($poids,2,'.','');
            $LigneProduit->quantite_a_preparer=$qantite;
            $LigneProduit->quantite_restante=($qantite)-($LigneProduit->quantite_preparer);
            $LigneProduit->idUE=$SSCC;
            $LigneProduit->total_poids=$qantite*$poids;
            $LigneProduit->last_update= date("Y-m-d H:i:s");
            $LigneProduit->modifier = 1;
            $LigneProduit->update();

            
            return redirect()->back()->withInput()->with('msgAjouter','Produit modifiée avec succès');

        }
        else
        {
            $LigneProduit->idUE=$SSCC;
            $LigneProduit->last_update= date("Y-m-d H:i:s");
            $LigneProduit->update();
            return redirect()->back()->withInput()->with('msgExist','Quantité n\'est pas valide');
        }


    }



    public function getFormUE()
    {

        $UE = new UniteExpedition();
        $UE->SSCC = 0;
        $UE->nombreProduits = 0;
        $UE->poidsProduits = 0;
        $UE->save();
        $idUE =UniteExpedition::select('idUE')->get()->last();
      //  dd($idUE->idUE);
        $SSCC=6130000000000000+($idUE->idUE);
        $SSCC=number_format($SSCC,0,'.','');


        $LigneProduits=LigneProduit::where('idPreparation','=',0)
        ->with('StockProduit.Emplacement')
        ->with('UniteExpedition')
        ->with('Produit')
        ->with('User')
        ->get();
        return view('preparation.ajouter_ue',compact('LigneProduits','SSCC'));
    }

    public function postFormUE(Request $request)
    {

        $LigneProduits=LigneProduit::where('idPreparation','=',0)
        ->with('StockProduit.Emplacement')
        ->with('UniteExpedition')
        ->with('Produit')
        ->with('User')
        ->get();

        $idUE =UniteExpedition::where('SSCC','=',0)->value('idUE');
        $UE=UniteExpedition::find($idUE);
        $UE->SSCC = $request->input('sscc');
        $UE->nombreProduits = $request->input('nombreProduit');
        $UE->poidsProduits = $request->input('poidsProduit');
        $UE->update();

        $idUE =UniteExpedition::max('idUE');
        $conditionOperateur=0;
        $idUser=null;
        foreach ($LigneProduits as $LigneProduit)
        {
            if($request->input('select'.$LigneProduit->idLigneProduit.'')=='selected') {

                if ($idUser != $LigneProduit->idUser) {
                    $conditionOperateur += 1;
                }
                $idUser = $LigneProduit->idUser;
            }

        }


        if($conditionOperateur == 1)
        {
            foreach ($LigneProduits as $LigneProduit) {
                //   dd($request->input('select'.$LigneProduit->idLigneProduit.''));
                if($request->input('select'.$LigneProduit->idLigneProduit.'')=='selected')
                {
                    $ligne =LigneProduit::find($LigneProduit->idLigneProduit);
                    $ligne->idUE = $idUE ;
                    $ligne->last_update= date("Y-m-d H:i:s");
                    $ligne->update();

                }
            }
            return redirect('preparation/ajouter');
        }
        else
        {

            return redirect()->back()->withInput()->with('msgExist','l\'UE doit être préparée par un seul opérateur' );
        }





    }


    public function show($id)
    {
        $configuration = ConfigurationPdf::first();
        //dd($configuration);
        $preparation = Preparation::with('Transporteur')
        ->with('CommandeClient.Client')
        ->with('entite')
        ->with('Client')
        ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
        ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
        ->find($id);
        //dd($preparation);
        $LigneProduits = LigneProduit::where('idPreparation','=',$id)->with('stockProduit')->get();
        //dd($LigneProduits);

        $existBl=BonLivraison::where('id_preparation','=',$id)->count();
        //dd($preparation);

        return view('preparation.detail',compact('preparation','LigneProduits','existBl','configuration'));
    }

    public function getEdit($id)
    {
        Session::put('idPreparation',$id);

        $preparation = Preparation::with('Transporteur')
        ->with('CommandeClient.Client')
        ->with('CommandeClient.Client')
        ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
        ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
        ->find($id);
       // dd($preparation);
        $lignesProduits=LigneProduit::where('idPreparation','=',$id)
        ->get();

        $LigneProduits = LigneProduit::where('supprimer',0)->where('idPreparation','=',$id)
        ->orwhere('idPreparation','=',0)->get();
        //dd($LigneProduits);
        $transporteurs = Transporteur::get();

        $totalPoids=$LigneProduits->sum('total_poids');

        $totalProduits=$LigneProduits->count();

        /*$totalUE = DB::table('ligne_produit')
        ->where('idPreparation','=',$id)
        ->where('idUE','!=',0)
        ->orwhere('idPreparation','=',0)
        ->where('idUE','!=',0)
        ->count(DB::raw('DISTINCT idUE'));*/
        //$totalUE = DB::table('ligne_produit')
        //->where('idPreparation','=',$id)->get();
        //->with('stockProduit')->get();
        //
        $totalUE = null ;
        if (Session::get('STOCK_EMPLACEMENT_MOBILE')=='1') {
            $totalUE = LigneProduit::join('stock_produit','stock_produit.id_stock_produit','=','ligne_produit.idStock')->where('idPreparation',$id )->orwhere('idPreparation','=',0)->get();
            $totalUE = $totalUE->unique('num_ue')->count();
        }else{
            $totalUE = DB::table('ligne_produit')
            ->where('idPreparation','=',$id)
            ->where('idUE','!=',0)
            ->orwhere('idPreparation','=',0)
            ->where('idUE','!=',0)
            ->count(DB::raw('DISTINCT idUE'));
        }

        $UEs= LigneProduit::where('idPreparation','=',$id)
        ->where('idUE','!=',0)
        ->orwhere('idPreparation','=',0)
        ->where('idUE','!=',0)
        ->with('UniteExpedition')
            //->groupBy('idUE')
        ->get();
       //dd($UEs);
        if(!Session::has('ligneProduits'))
        {
            Session::put('ligneProduits',$lignesProduits);

        }

        $listeStatut= ListValeur::
        where('nom_liste','=','STATUT_PREPARATION')
        ->get();
        //dd($listeStatut);

        $commandes = CommandeClient::all();




        return view('preparation.modifier',compact('preparation','LigneProduits','transporteurs','totalUE','totalProduits','totalPoids','UEs','listeStatut','commandes'));


    }
    public function postEdit(Request $request,$id){
        $nombre_de_ue = collect();
        $lignePreparationChargement;

        //dd($request->input('n_commande'),$request->input('sociale'));

        $numExist=Preparation::where('numPreparation','=',$request->input('numPreparation'))
        ->where('idPreparation','!=',$id)
        ->count();
        //dd($numExist);


        if($numExist > 0)
        {
            return redirect('preparation/modifier/'.$id.'')->with('msgExist','Numéro de préparation existe déjà');
        }
        else
        {
            $condition=0;
            $idUser=null;
            $idUE=null;

            $ligneProduits=LigneProduit::where('idPreparation','=',0)
            ->orwhere('idPreparation','=',$id)
            ->get();
            foreach ($ligneProduits as $LigneProduit)
            {
                $idUser = $LigneProduit->idUser;
                $idUE = $LigneProduit->idUE;
                foreach ($ligneProduits as $LigneProduit)
                {
                    if(($idUser != $LigneProduit->idUser) && ($idUE == $LigneProduit->idUE)&& $idUE != 0)
                    {
                        $condition += 1;
                    }

                }
            }

            if($condition == 0 ){

                $preparation=Preparation::find($id);

                $lignePreparationChargement=LignePreparationChargement::where('idPreparation','=',$id)->first();

                if($lignePreparationChargement != null)
                {
                    $chargement = Chargement::find($lignePreparationChargement->idChargement);
                    if (Session::get('STOCK_ENTITE') != "1" && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1") {
                    $chargement->totalUE_chargement =($chargement->totalUE_chargement)+(($request->input('nombreUE')-($preparation->nombreUE)));
                }
                    $chargement->totalProduits_chargement =($chargement->totalProduits_chargement)+(($request->input('nombreProduit')-($preparation->nombreProduits)));
                    $chargement->totalPoids_chargement =($chargement->totalPoids_chargement)+(($request->input('totalPoids')-($preparation->totalPoids)));
                    $chargement->last_update= date("Y-m-d H:i:s");
                    $chargement->update();
                }

                //dd($chargement);


                $preparation->numPreparation=$request->input('numPreparation');
                $preparation->idTransporteur=$request->input('transporteur');
                $preparation->datePrevue=$request->input('datePrevue');
                if (Session::get('STOCK_ENTITE') != "1" && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1") {
                    $preparation->nombreUE=$request->input('nombreUE');
                }
            
                //$preparation->statutPreparation=$request->input('statutPreparation');
                $preparation->totalPoids=$request->input('totalPoids');
                $preparation->nombreProduits=$request->input('nombreProduit');
                $preparation->last_update= date("Y-m-d H:i:s");
                if ($request->input('n_commande') != null && $request->input('n_commande')!= "") {
                    $commandeee = CommandeClient::where('numCommande',$request->input('n_commande'))->first();
                    if (!$commandeee) {
                        $commande = new CommandeClient();
                        $commande->numCommande = $request->input('n_commande');
                        $commande->dateCommande = date("Y-m-d");
                        $commande->idClient = $request->input('sociale');
                        $commande->save();
                        $id_commande = $commande->idCommande;
                        $preparation->idCommande = $id_commande;
                    }else{
                        $id_commande = $commandeee->idCommande;
                        $preparation->idCommande = $id_commande;
                    }
                }
                
                $preparation->update();

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Modification';
                $HistoriqueActions->nom_table = 'Clients->Les préparations';
                $HistoriqueActions->description = 'Modification de la préparation: '.$preparation->numPreparation;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                LigneProduit::where('idPreparation','=',$id)->where('supprimer',1)->delete();

                $LigneProduits=LigneProduit::where('idPreparation','=',0)
                ->get();



                foreach ($LigneProduits as $ligneProduit)
                {
                    $ligne = $ligneProduit;
                    $ligne->idPreparation = $id;
                    $ligne->last_update= date("Y-m-d H:i:s");
                    $ligne->update();
                    //mettre a jour la quantite_utilisable
                    $stock = StockProduit::where('id_stock_produit',$ligne->idStock)->first();
                    /*$stock->quantite_utilisable -= $ligne->quantite_a_preparer ;
                    $stock->last_update = date("Y-m-d H:i:s");
                    $stock->update();*/

                    if (! $nombre_de_ue->contains($stock->num_ue)) {
                        //inserer dans la collection le ue;
                        $nombre_de_ue->put($stock->num_ue, $ligne->idLigneProduit); 
                    }
                }
                $count_nbr_ue_fermer = 0;
                              //changer etat de ue
    foreach ($nombre_de_ue as $key => $value) {
        $box = Ue::where('num_ue',$key)->first();
        if ($box->etat_ue == 0){

            $stock = StockProduit::where('num_ue',$key)->where('quantite_utilisable','!=',0)->first();
            if ($stock != null) {
                $box->etat_ue = 1;
                $box->last_update = date("Y-m-d H:i:s");
                $box->update();
            }else{
                $count_nbr_ue_fermer++;
                //ajouter le ue dans la table unite_expedition si 
                /*if (Session::get('AJOUT_CHARGEMENT_PREPARATION')=="1") {
                    
                }*/
                $unite_expedition = new UniteExpedition();
                $unite_expedition->SSCC = $box->num_ue;
                $unite_expedition->nombreProduits = $box->nbr_produit;
                $unite_expedition->poidsProduits = 0;
                $unite_expedition->statut = 0;
                $unite_expedition->save();
                //inserer id dans idUE de la table ligne_produit
                $lignee = LigneProduit::find($value);
                $lignee->last_update= date("Y-m-d H:i:s");
                $lignee->idUE = $unite_expedition->idUE;
                $lignee->update();

                
            }
            
    }
        
}

//$this->charger_numero_serie($LigneProduits);

if($lignePreparationChargement != null)
                {
 $chargement = Chargement::find($lignePreparationChargement->idChargement);

 $chargement->totalUE_chargement += $count_nbr_ue_fermer++;
 $chargement->update();
}
 //dd($count_nbr_ue_fermer);


                $LigneProduitsPreparation=LigneProduit::where('idPreparation','=',$id)
                ->get();

                foreach ($LigneProduitsPreparation as $ligneProduitPre)
                {
                    $ligne = $ligneProduitPre;
                    $ligne->last_update= date("Y-m-d H:i:s");
                    $ligne->update();
                }


                return redirect('preparation/index')->with('msgAjouter','Préparation modifiée avec succès');
            }
            else{

                return redirect()->back()->with('msgExist','l\'UE doit être préparée par un seul opérateur');

            }
        }

    }



    public function cancelEdit($id){

        //dd( Session::get('ligne_modifier'));
        $ligneProduits=Session::get('ligneProduits');
        //dd($ligneProduits);
        
        $memory_ligne = collect();
        $stock1 = null;
        $stock2 = null;
        $old = LigneProduit::where('idPreparation', '=', $id)->where('modifier',1)->orwhere('supprimer',1)->get();
        //dd($old);
        //comparer 2 collection ...
        //$diff = $ligneProduits->diff($old);
        //dd($diff);

        foreach($old as $key=>$ligne){
            $stockk = StockProduit::find($ligne->idStock);
            //dd($stockk);
            if ($ligne->modifier == 1) {
                $stockk->quantite_utilisable += $ligne->quantite_a_preparer;
                $stockk->last_update = date("Y-m-d H:i:s");
                $stockk->update();
                $stock1= $stockk;
            }
            /*if ($ligne->supprimer == 1) {
                $stockk->quantite_utilisable -= $ligne->quantite_a_preparer;
                $stockk->last_update = date("Y-m-d H:i:s");
                $stockk->update();
                $stock1= $stockk;
            }*/
            
            
            //dd($stock);
            $memory_ligne->put($key,$ligne->idLigneProduit);
        }
        //delete old ligne
        LigneProduit::where('idPreparation', '=', $id)->delete();

        foreach($ligneProduits as $ligne)
        {
            if ($memory_ligne->contains($ligne->idLigneProduit)) {
                //mettre a jour le stock
                $stock = StockProduit::where('id_stock_produit',$ligne->idStock)->with('ue')->first();
                $stock->quantite_utilisable -= $ligne->quantite_a_preparer;
                $stock->last_update = date("Y-m-d H:i:s");
                $stock->update();
                //tester si qte_utilisable == 0
                //etat_ue =0
                $s = StockProduit::where('num_ue',$stock->ue->num_ue)->where('quantite_utilisable','!=',0)->first();
                $box = Ue::where('num_ue',$stock->ue->num_ue)->first();
                if ($s != null) {
                    $box->etat_ue = 1;
                    $box->last_update = date("Y-m-d H:i:s");
                    $box->update();
                }else{
                    $box->etat_ue = 0;
                    $box->last_update = date("Y-m-d H:i:s");
                    $box->update();
                }

                
                
                $stock2 = $stock;
            }
            $ligneP = new LigneProduit();
            $ligneP->idPreparation = $ligne->idPreparation;
            $ligneP->idUE = $ligne->idUE;
            $ligneP->idProduit =$ligne->idProduit;
            $ligneP->idStock = $ligne->idStock;
            $ligneP->idUser = $ligne->idUser;
            $ligneP->quantite_a_preparer = $ligne->quantite_a_preparer;
            $ligneP->quantite_preparer = $ligne->quantite_preparer;
            $ligneP->quantite_restante = $ligne->quantite_restante;
            $ligneP->total_poids =$ligne->total_poids;
            $ligneP->save();
        }




        $this->restorData();
        //dd($stock1, $stock2);

        return redirect('preparation/index');
    }

    public function getEditProduit(){
        $id=Session::get('idPreparation');

        $preparation = Preparation::with('Transporteur')
        ->with('CommandeClient.Client')
        ->find($id);

        $operateurs=User::where('profil','=','1')
        ->get();

        if ( $preparation->idCommande != '' && $preparation->idCommande != 0 && $preparation->idCommande != null)
        {
            $numCommande=$preparation->idCommande ;

            $ligneCommandeProduits= LigneCommandeProduit::select('idProduit')
            ->where('idCommande','=',$numCommande)
            ->get();

            //dd($ligneCommandeProduits);

            $lignePreparationProduits=LigneProduit::select('idProduit')
            ->where('idPreparation','=',0)
            ->Orwhere('idPreparation','=',$id)
            ->get();

          //  dd($lignePreparationProduits);



            $stockproduits = StockProduit::with('Produit')
            ->with('emplacement')
            ->whereIn('id_produit',$ligneCommandeProduits)
            ->whereNotIn('id_produit',$lignePreparationProduits)
            ->get();

         /*   foreach($ligneCommandeProduits as $ligneCommandeProduit) {


                $stockproduits = StockProduit::with('Produit')
                    ->with('emplacement')
                    ->where('id_produit', '=', $ligneCommandeProduit->idProduit)
                    ->get();
                }*/

            }
            else {
                

                $lignePreparationProduits=LigneProduit::select('idProduit')
                ->where('idPreparation','=',0)
                ->Orwhere('idPreparation','=',$id)
                ->get();

                $stockproduits = StockProduit::where('quantite_utilisable','>',0)->with('Produit')
                ->where('num_entite',$preparation->num_entite)
                ->with('emplacement')
                ->whereNotIn('id_produit',$lignePreparationProduits)
                ->get();
                 $stockproduits = $stockproduits->groupBy(function($item, $key){   
                    return $item["id_produit"];
                });

            }


            return view('preparation.modifier_produit',compact('operateurs','stockproduits','id','preparation'));
        }



        public function postEditProduit(Request $request){
            if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1"){
            $id=Session::get('idPreparation');

            //dd($request->input('select'));
        $produits = $request->input('select');
        $quantites = $request->input('quantite');
        //dd($produits,$quantites );
        
       
        for ($i=0; $i < count($produits) ; $i++) {
            $produit = Produit::find($produits[$i]);
            $resultat_algo_picking = $this->AlgoPicking3($request->input('entite') ,$produit ,$quantites[$i], 0 );
            //dd('fin');
            if ($resultat_algo_picking == null) {
                //DB::rollback();
                //dd('Échec');
                return Redirect::back()->withErrors(["Échec de ajouter le produit :".$produit]);
            }
            $liste_new_ligne_produit = collect();

            foreach ($resultat_algo_picking as $key => $value) {

                                        /*//ajouer une ue
                                                    $existeUE = UniteExpedition::where('SSCC',$value[0]->num_ue)->first();
                                                    $ue = null;
                                                    if ($existeUE != null) {

                                                        $existeUE->nombreProduits = $existeUE->nombreProduits + 1;
                                                        $existeUE->poidsProduits = $existeUE->poidsProduits + ( $produit->poids * $value[1]);
                                                        $existeUE->update();
                                                        $ue = $existeUE;
                                                    }else{
                                            //si oui créer une unite expedition
                                                        $existeUE = new UniteExpedition();
                                                        $existeUE->SSCC = $value[0]->num_ue;
                                                        $existeUE->nombreProduits = 1;
                                                        $existeUE->poidsProduits = $produit->poids * $value[1];
                                                        $existeUE->save();
                                                        $ue = $existeUE;   
                                                    }*/

                                        $LigneProduit = new LigneProduit();
                                        $LigneProduit->idPreparation = $id; 
                                        $LigneProduit->idUE = 0;
                                        $LigneProduit->idProduit = $produit->id_produit;
                                        $LigneProduit->idStock = $key;
                                        $LigneProduit->idUser = $request->input('operateur');
                                        $LigneProduit->quantite_a_preparer = $value[1];
                                        $LigneProduit->quantite_preparer = 0;
                                        $LigneProduit->quantite_restante = $value[1];
                                        $LigneProduit->total_poids = $produit->poids * $value[1];
                                        $LigneProduit->simule_fo = 0;
                                        $LigneProduit->last_update = date("Y-m-d H:i:s");
                                        $LigneProduit->save();
                                        //mettre a jour la qnt utilisable
                                        $stock = StockProduit::where('id_stock_produit',$key)->first();
                                        //$stock->quantite_utilisable -= $ligne->quantite_a_preparer ;
                                        $stock->quantite_utilisable -= $value[1] ;
                                        $stock->last_update = date("Y-m-d H:i:s");
                                        $stock->update();
                                        //changer etat ue
                                        //get ue
                                        $getUe = StockProduit::find($key);
                                        if ($getUe != null) {
                                            $box = Ue::where('num_ue',$getUe->num_ue)->first();
                                            if ($box->etat_ue == 0) {
                                               $stockk = StockProduit::where('num_ue',$getUe->num_ue)->where('quantite_utilisable','!=',0)->first();
                                               if ($stockk != null) {
                                                    $box = Ue::where('num_ue',$stock->num_ue)->first();
                                                    //décrémenter nombre UE de la table préparation
                                            $preparation = Preparation::find($id);
                                            $preparation->nombreUE -= 1;
                                            $preparation->update();
                                                    $box->etat_ue = 1;
                                                    $box->last_update = date("Y-m-d H:i:s");
                                                    $box->update();
                                                }

                                            }
                                            if ($box->etat_ue == 1) {
                                               $stockk = StockProduit::where('num_ue',$getUe->num_ue)->where('quantite_utilisable','!=',0)->first();
                                               if ($stockk == null) {
                                                    $box = Ue::where('num_ue',$stock->num_ue)->first();
                                                           //décrémenter nombre UE de la table préparation
                                            $preparation = Preparation::find($id);
                                            //dd($request->input('id_preparation'), $preparation);
                                            $preparation->nombreUE += 1;
                                            $preparation->update();
                                                    $box->etat_ue = 0;
                                                    $box->last_update = date("Y-m-d H:i:s");
                                                    $box->update();
                                                    $liste_new_ligne_produit->put($key, $LigneProduit);
                                                    //get old ligne_produit with same num_ue
                                                    //get id stock from old ligne produit with same num_ue
                                                    /*$id_stocks = StockProduit::where('num_ue', $getUe->num_ue)->pluck('id_stock_produit');

                                                    //enlever le id ajouter ici
                                                    $id_stocks
                                                    
                                                    $old_ligne_produit = LigneProduit::where('idPreparation',$request->input('id_preparation'))
                                                    ->whereIn('idStock',$id_stocks->toArray())->get();
                                                    //dd($old_ligne_produit, $id_stocks, $id_stocks->toArray());
                                                    //if ($old_ligne_produit != null) {
                                                        $this->charger_numero_serie($old_ligne_produit);
                                                    //}*/
                                                }
                                            }

                                        }
                                                                     
                                   }
                                   //$this->charger_numero_serie($liste_new_ligne_produit);
                                   //get old ligne_produit with same num_ue
                                   foreach($liste_new_ligne_produit as $value){
                                        $stock = StockProduit::find($value->idStock);
                                        //$id_stocks = StockProduit::where('num_ue', $stock->num_ue)->get(['id_stock_produit']);
                                        //$id_stocks= $id_stocks->toArray();

                                        $old_ligne_produit = LigneProduit::join("stock_produit","stock_produit.id_stock_produit","=","ligne_produit.idStock")->where('idPreparation','!=',0)
                                                    ->where('stock_produit.num_ue', $stock->num_ue)->get();

                                                    //dd($request->input('id_preparation'),$old_ligne_produit);
                                        $this->charger_numero_serie($old_ligne_produit);
                                   }
                                   $this->charger_numero_serie($liste_new_ligne_produit);
                                   
                                  
                                        
                                   }


            $id=Session::get('idPreparation');
            //ici mettre un chunk
            $stockproduits= collect();
            $collet = StockProduit::with('Produit')->with('emplacement')->chunk(500, function ($rows) use ($stockproduits) {
                    foreach ($rows as $row) {
                        $stockproduits->push($row);
                    }
                });

            foreach ($stockproduits as $stockproduit) {
                if($request->input('select'.$stockproduit->id_stock_produit.'')=='selected')
                {
                    $ligne_produit = new LigneProduit ();
                    $ligne_produit->idPreparation = 0;
                    $ligne_produit->idUE = 0;
                    $ligne_produit->idProduit = $stockproduit->Produit->id_produit;
                    $ligne_produit->idStock = $stockproduit->id_stock_produit;
                    $ligne_produit->idUser = $request->input('operateur');
                    $qnt= $ligne_produit->quantite_a_preparer = $request->input('quantite' . $stockproduit->id_stock_produit . '');
                    $ligne_produit->total_poids =$qnt*($stockproduit->Produit->poids) ;
                    $ligne_produit->quantite_preparer =0 ;
                    $ligne_produit->quantite_restante =$qnt;
                    $ligne_produit->last_update= date("Y-m-d H:i:s");
                    $ligne_produit->save();
                }
            }
        }

            return redirect('preparation/modifier/'.$id.'');

        }

        public function getEditUE()
        {

            $id=Session::get('idPreparation');
        //dd($id);
            $UE = new UniteExpedition();
            $UE->SSCC = 0;
            $UE->nombreProduits = 0;
            $UE->poidsProduits = 0;
            $UE->save();
            $idUE =UniteExpedition::select('idUE')->get()->last();
        //  dd($idUE->idUE);
            $SSCC=6130000000000000+($idUE->idUE);
            $SSCC=number_format($SSCC,0,'.','');


            $LigneProduits=LigneProduit::with('StockProduit.Emplacement')
            ->with('UniteExpedition')
            ->with('Produit')
            ->with('User')
            ->where('idPreparation','=',0)
            ->orwhere('idPreparation','=',$id)
            ->get();
            return view('preparation.modifier_ue',compact('LigneProduits','SSCC','id'));
        }

        public function postEditUE(Request $request)
        {
            $id=Session::get('idPreparation');

            $LigneProduits=LigneProduit::with('StockProduit.Emplacement')
            ->with('UniteExpedition')
            ->with('Produit')
            ->with('User')
            ->where('idPreparation','=',0)
            ->orwhere('idPreparation','=',$id)
            ->get();

            $idUE =UniteExpedition::where('SSCC','=',0)->value('idUE');
            $UE=UniteExpedition::find($idUE);
            $UE->SSCC = $request->input('sscc');
            $UE->nombreProduits = $request->input('nombreProduit');
            $UE->poidsProduits = $request->input('poidsProduit');
            $UE->update();

            $idUE =UniteExpedition::max('idUE');
            $conditionOperateur=0;
            $idUser=null;

            foreach ($LigneProduits as $LigneProduit)
            {
                if($request->input('select'.$LigneProduit->idLigneProduit.'')=='selected') {

                    if ($idUser != $LigneProduit->idUser) {
                        $conditionOperateur += 1;
                    }
                    $idUser = $LigneProduit->idUser;
                }

            }
            if($conditionOperateur == 1) {

                foreach ($LigneProduits as $LigneProduit) {
                    if ($request->input('select' . $LigneProduit->idLigneProduit . '') == 'selected') {
                        $ligne = LigneProduit::find($LigneProduit->idLigneProduit);
                        $ligne->idUE = $idUE;
                        $ligne->last_update= date("Y-m-d H:i:s");
                        $ligne->update();

                    }
                }
                return redirect('preparation/modifier/' . $id . '');
            }

            else
            {

                return redirect()->back()->withInput()->with('msgExist','l\'UE doit être préparée par un seul opérateur' );
            }
        }

        public function simule_saisie_fo_preparation(Request $request){
            $id_preparation = $request->input('id_preparation');
            $id_ligne_produit = $request->input('id_ligne_produit');
            $quantite_preparer = $request->input('quantite_preparerr');

            $ligne = LigneProduit::find($id_ligne_produit);
            if ($ligne->quantite_restante <  $quantite_preparer) {
            //erreur
                return redirect('preparation/detail/'.$id_preparation)->with('msgExist','Erreur ! la quantité saisie est supérieure à la quantité à préparer');
            }
            else{
                $ligne->idUser = Session::get('id');
                $ligne->quantite_preparer = $quantite_preparer ; 
                $ligne->quantite_restante = $ligne->quantite_restante - $quantite_preparer;
                $ligne->simule_fo = 1;
                $ligne->last_update= date("Y-m-d H:i:s");
                $ligne->update();
            }

        //tester si tt les produit sont préparée
            $en_cours = 1 ;
            $prepare = 1 ;
            $preparee_partiellement = 0;

            $ligne_produits = LigneProduit::where('idPreparation',$id_preparation )->get();
            foreach ($ligne_produits as $ligne) {
                if ($ligne->quantite_restante == 0) {
                    $en_cours = 0;
                    $preparee_partiellement = 1;
                }
                if ($ligne->quantite_restante != 0) {
                    $en_cours = 1 ;
                    $prepare = 0;
                }
            }

            $preparation = Preparation::find($id_preparation);
            $preparation->last_update= date("Y-m-d H:i:s");
            if ($preparation->date_debut == null) {
                $preparation->date_debut = date("Y-m-d H:i:s");
            }
            $preparation->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Simuler saisie FO';
            $HistoriqueActions->nom_table = 'Clients->Les préparations';
            $HistoriqueActions->description = 'Simulation de la préparation: '.$preparation->numPreparation;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();
            

            if ($prepare) {
                $preparation->statutPreparation = 3;

                $preparation->date_fin = date("Y-m-d H:i:s");

                $preparation->update();

                return redirect('preparation/detail/'.$id_preparation)->with('msgAdd','La quantité préparée a été modifiée avec succès');
            }

            elseif ($preparee_partiellement ) {
                $preparation->statutPreparation = 2;
                $preparation->update();

                return redirect('preparation/detail/'.$id_preparation)->with('msgAdd','La quantité préparée a été modifiée avec succès');
            }
            else{
                $preparation->statutPreparation = 1;
                $preparation->update();

                return redirect('preparation/detail/'.$id_preparation)->with('msgAdd','La quantité préparée a été modifiée avec succès');
            }

            $preparation = Preparation::find($id_preparation);
            $preparation->last_update= date("Y-m-d H:i:s");
            if ($preparation->date_debut == null) {
                $preparation->date_debut = date("Y-m-d H:i:s");
            }
            $preparation->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Simuler saisie FO';
            $HistoriqueActions->nom_table = 'Clients->Les préparations';
            $HistoriqueActions->description = 'Simulation de la préparation: '.$preparation->numPreparation;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();
        }

        public function import_ue(Request $request){


            $prepation_client= null;
            ini_set('max_execution_time', 1000);

            $bytes = $request->file('file')->getClientSize();

            $ext = Input::file('file')->getClientOriginalExtension();
            if ( $ext == "xlsx" || $ext == 'xls'){
                if ($bytes < 25165824) {
                    $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));
                    $sheet = $objPHPExcel->getSheet(0);
                    $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                    //dd($highestRow);
                    $erreur = collect();
                    $warning = collect();
                    $adresseLivraison= null;
                    $date_prevue = null;
                    $transpo = null;
                    
                    if ($highestRow > 1) {
                        $y=1;
                        //$nombre_de_ue = collect();
                        DB::beginTransaction();
                        foreach ($sheet->getRowIterator() as $key=> $row) {
                        //Version 2
                            
                            $transporteur = null;
                            $adresse_livraison = null;
                            $date = null;
                            //$numero_ue = null;
                            $code_barre_produit = null;
                            $reference_produit = null;
                            $designation_produit = null;
                            $quantite = null;
                            $operateur = null;

                            if ($row->getRowIndex() >= 2){

                            // On boucle sur les cellule de la ligne
                                
                                $transporteur = $sheet->getCell('A'.$y)->getValue();
                                $date= $sheet->getCell('B'.$y)->getValue();
                                $adresse_livraison = $sheet->getCell('C'.$y)->getValue();

                                //$date = PHPExcel_Style_NumberFormat::toFormattedString($date,PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2);
                                $date = strtotime(str_replace('/', '-',$date));
                                $date = date('Y-m-d',$date);

                                $code_barre_produit= $sheet->getCell('D'.$y)->getValue();
                                $reference_produit= $sheet->getCell('E'.$y)->getValue();
                                $designation_produit= $sheet->getCell('F'.$y)->getValue();
                                $quantite = $sheet->getCell('G'.$y)->getValue();
                                $operateur = $sheet->getCell('H'.$y)->getValue();

                            //Ajouter une préparation avec id commande = 0.
                                if ($row->getRowIndex() == 2) {
                             //vérifier si les champs nécessaire pour créer une préparation client son rempli
                                   if ($date != null || $transporteur != null || $adresse_livraison != null ) {
                                    
                                    $date_prevue = $date;
                                    $transpo = $transporteur;
                                    $adresseLivraison = $adresse_livraison ;
                                    

                                    $preparation = new Preparation();
                                    $NumPreparation = null;
                                    /*$lastNum =Preparation::orderBy('idPreparation','desc')->first();
                                    if ($lastNum != null) {
                                        $NumPreparation = substr_replace($lastNum->numPreparation, "", 0, 5);
                                        if ($NumPreparation == 99999){
                                            $NumPreparation='PREPA00001';
                                        }
                                        else {
                                            $NumPreparation = $NumPreparation + 1;
                                            $NumPreparation=str_pad($NumPreparation, 5, '0', STR_PAD_LEFT);
                                            $NumPreparation ='PREPA'.$NumPreparation;
                                        }
                                    }
                                    else{
                                        $NumPreparation='PREPA00001';
                                    }*/
                                    $monfichier = fopen('NumeroPreparation.txt', 'r');

        $ligne1 = fgets($monfichier);
        $prefixe = explode("=", $ligne1);
        $prefixe = str_replace("\r\n","",$prefixe[1]);

        $ligne2 = fgets($monfichier);
        $datee = explode("=", $ligne2);
        $datee = str_replace("\r\n","",$datee[1]);
        $datee = date("Y-m-d");
        if ($datee == "AAMMJJ") {
            $datee = date("y-m-d");
        }
        if($datee == "JJMMAA"){
            $datee = date("d-m-y");
        }
        if ($datee == "AAAA") {
            $datee = date("Y");
        }
        if ($datee == "AA") {
            $datee = date("y");
        }

        $datee = str_replace("-","",$datee);

        //récupéré nombre de bon livraison par jour , par mois par an
        $prep = CompteurModule::where('MODULE',"PREPARATION")->first();
        if ($prep != null) {
            $timestamp = strtotime($prep->last_update);
            
            if (date("Y", $timestamp) == date('Y')) $prep->COMPTEUR_PAR_AN += 1;
            else $prep->COMPTEUR_PAR_AN = 1;

            if (date("m", $timestamp) == date('m')) $prep->COMPTEUR_PAR_MOIS += 1;
            else $prep->COMPTEUR_PAR_MOIS = 1;

            if (date("d", $timestamp) == date('d')) $prep->COMPTEUR_PAR_JOUR += 1;
            else $prep->COMPTEUR_PAR_JOUR = 1;

            $prep->last_update = date("Y-m-d");
            $prep->update();
        }else{
            $prep = new CompteurModule();
            $prep->MODULE = "PREPARATION";
            $prep->COMPTEUR_PAR_JOUR = 1;
            $prep->COMPTEUR_PAR_MOIS = 1;
            $prep->COMPTEUR_PAR_AN = 1;
            $prep->last_update = date("Y-m-d");
            $prep->save();
        }

        $ligne3 = fgets($monfichier);
        $taille_compteur = explode("=", $ligne3);
        $taille_compteur = (int)str_replace("\r\n","",$taille_compteur[1]);

        $ligne4 = fgets($monfichier);
        $format_sequence = explode("=", $ligne4);
        $format_sequence = str_replace("\r\n","",$format_sequence[1]);
        $format_sequence = str_replace("+","",$format_sequence);

        $jour = str_pad($prep->COMPTEUR_PAR_JOUR, $taille_compteur, '0', STR_PAD_LEFT);
        $mois = str_pad($prep->COMPTEUR_PAR_MOIS, $taille_compteur, '0', STR_PAD_LEFT);
        $an = str_pad($prep->COMPTEUR_PAR_AN, $taille_compteur, '0', STR_PAD_LEFT);

        $format_sequence = str_replace("DATE",$datee,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_JOUR",$jour,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_MOIS",$mois,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_AN",$an,$format_sequence);
        $NumPreparation = $prefixe.$format_sequence;

                                    $preparation->numPreparation = $NumPreparation;

                                    $existTransporteur = Transporteur::where('numTransporteur',$transporteur)->first();
                                    if ($existTransporteur != NULL) {
                                        $preparation->idTransporteur = $existTransporteur->idTransporteur;
                                    }else{
                                        return Redirect::back()->withErrors(["Le N°Transporteur n'existe pas."]);
                                    }
                                
                                $preparation->datePrevue = $date;
                                $preparation->idCommande = 0; //import sans commande
                                $preparation->nombreProduits = $sheet->getHighestRow() - 1;
                                $preparation->last_update = date("Y-m-d H:i:s");
                                $preparation->nombreUE = 0;
                                $preparation->statutPreparation = 0;
                                
                                $existeClient = Client::where('raisonSociale',$adresse_livraison)->first();
                                if ($existeClient != NULL) {
                                    $preparation->adresse_livraison = $existeClient->idClient;
                                }else{
                                    DB::rollback();
                                    return Redirect::back()->withErrors(["Raison sociale n'existe pas."]);
                                }
                                
                                $preparation->totalPoids = 0;
                            
                                $preparation->save();
                                $prepation_client = $preparation;
                            }else {
                                DB::rollback();
                               
                                if ($transporteur == null) {
                                    return Redirect::back()->withErrors(["Le champ 'N°Transporteur' est obligatoire."]);
                                }
                                if ($date) {
                                    return Redirect::back()->withErrors(["Le champ 'Date prévue' est obligatoire."]);
                                }
                                if ($adresse_livraison == null) {
                                    return Redirect::back()->withErrors(["Le champ 'Raison sociale' est obligatoire."]);
                                }
                                
                            }
                        }
                        //vérifier si la date ou numéro livraison on été changé
                        if ($adresse_livraison != $adresseLivraison) {
                            $warning->put($key, " L'adresse de la livraison a été modifiée");
                            break;
                        }
                        if ($transpo != $transporteur) {
                            $warning->put($key, "Le N°Transpour a été modifié");
                            break;
                        }
                        if ($date_prevue != $date) {
                            $warning->put($key, 'La date prevue a été modifiée');
                            break;
                        }
                       
                        //ajouter les lignes produit
                        //tester si le produit existe bien
                        $produit = Produit::where('reference',$reference_produit)->first();
                        if ($produit != null) {
                                $user = User::where('login',$operateur)->first();
                                if ($user != null) {
                                    $resultat_algo_picking = $this->AlgoPicking3(null ,$produit ,$quantite, 1 );
                                    if ($resultat_algo_picking == null) {
                                        DB::rollback();
                                        return Redirect::back()->withErrors(["Échec de l'importation ...."]);
                                    }
                                    

                                    foreach ($resultat_algo_picking as $key => $value) {
                                        /*if (! $nombre_de_ue->contains($value[0]->num_ue)) {
                                        //inserer dans la collection le ue;
                                        $nombre_de_ue->put($value[0]->num_ue, 1);
                                    }*/

                                        /*//ajouer une ue
                                                    $existeUE = UniteExpedition::where('SSCC',$value[0]->num_ue)->first();
                                                    $ue = null;
                                                    if ($existeUE != null) {

                                                        $existeUE->nombreProduits = $existeUE->nombreProduits + 1;
                                                        $existeUE->poidsProduits = $existeUE->poidsProduits + ( $produit->poids * $value[1]);
                                                        $existeUE->update();
                                                        $ue = $existeUE;
                                                    }else{
                                            //si oui créer une unite expedition
                                                        $existeUE = new UniteExpedition();
                                                        $existeUE->SSCC = $value[0]->num_ue;
                                                        $existeUE->nombreProduits = 1;
                                                        $existeUE->poidsProduits = $produit->poids * $value[1];
                                                        $existeUE->save();
                                                        $ue = $existeUE;   
                                                    }*/

                                        $LigneProduit = new LigneProduit();
                                        $LigneProduit->idPreparation = $prepation_client->idPreparation;
                                        //$LigneProduit->idUE = $ue->idUE;
                                        $LigneProduit->idUE = 0;
                                        $LigneProduit->idProduit = $produit->id_produit;
                                        $LigneProduit->idStock = $key;
                                        $LigneProduit->idUser = $user->id_user;
                                        $LigneProduit->quantite_a_preparer = $value[1];
                                        $LigneProduit->quantite_preparer = 0;
                                        $LigneProduit->quantite_restante = $value[1];
                                        $LigneProduit->total_poids = $produit->poids * $value[1];
                                        $LigneProduit->simule_fo = 0;
                                        $LigneProduit->last_update = date("Y-m-d H:i:s");
                                        $LigneProduit->save();

                                        
                                        //mettre a jour le poid dans la préparation
                                        $preparation_a_modifier =  Preparation::where('idPreparation',$prepation_client->idPreparation)->first();
                                                //dd($preparation_a_modifier);
                                        if ($preparation_a_modifier != null) {
                                            $preparation_a_modifier->totalPoids += $produit->poids * $value[1];
                                            $preparation_a_modifier->update();
                                        }                                 
                                   }
                        }else{
                         $erreur->put($key, "Opérateur '".$operateur."' n'existe pas.");
                         break;
                     }
            
                }else{
                    $erreur->put($key, "Le produit ".$reference_produit." n'existe pas.");
                    break;
                }
    }
    $y++;
}
        
/*$preparation_a_modifier =  Preparation::where('idPreparation',$prepation_client->idPreparation)->first();
if ($preparation_a_modifier != null) {
    $preparation_a_modifier->nombreUE = $nombre_de_ue->count();
    $preparation_a_modifier->update();
}*/

$HistoriqueActions = new Historique();
$HistoriqueActions->type_action = 'Importation';
$HistoriqueActions->nom_table = 'Clients->Les préparations';
$HistoriqueActions->description = 'Importation des préparations depuis un fichier';
$HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
$HistoriqueActions->date =Carbon::now('Africa/Algiers');
$HistoriqueActions->save();

                //dd($sheet->getHighestRow() - 1, $erreur->count());
if ($sheet->getHighestRow() - 1 == $erreur->count()) {
    DB::rollback();
                    //delete preparation
                    //Preparation::where('idPreparation', $prepation_client->idPreparation)->delete();
    return redirect('preparation/index')->with('msgAjouterAnnuler',
        [$erreur]);
}
if ($erreur->count() == 0 && $warning->count() == 0) {
    DB::commit();
    return redirect('preparation/index')->with('msgAjouter', 'Fichier importé avec succès');
}else{
    DB::rollback();
                    //return redirect('receptions/reception_fournisseur/index')->with('msgAjouterErreur',
                        //$warning->count().'Nombre de ligne non importé :'. $erreur->count().'.');
    return redirect('preparation/index')->with('msgAjouterErreur',[$warning , $erreur]);
}
}
else
    return Redirect::back()->withErrors(['Fichier vide ']);
} else return Redirect::back()->withErrors(['Fichier volumineux ']);

} else return Redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);
}

        public function import(Request $request){
            $prepation_client= null;
            ini_set('max_execution_time', 1000);

            $bytes = $request->file('file')->getClientSize();

            $ext = Input::file('file')->getClientOriginalExtension();
            if ( $ext == "xlsx" || $ext == 'xls'){
                if ($bytes < 25165824) {
                    $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));
                    $sheet = $objPHPExcel->getSheet(0);
                    $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                    //dd($highestRow);
                    $erreur = collect();
                    $warning = collect();
                    $adresseLivraison= null;
                    $date_prevue = null;
                    $transpo = null;
                    
                    if ($highestRow > 1) {
                        $y=1;
                        $nombre_de_ue = collect();
                        DB::beginTransaction();
                        foreach ($sheet->getRowIterator() as $key=> $row) {
                        //Version 2
                            $entite = null;
                            $transporteur = null;
                            $adresse_livraison = null;
                            $date = null;
                            $numero_commande = null;
                            //$numero_ue = null;
                            $code_barre_produit = null;
                            $reference_produit = null;
                            $designation_produit = null;
                            $quantite = null;
                            $operateur = null;

                            if ($row->getRowIndex() >= 2){

                            // On boucle sur les cellule de la ligne
                                $entite = trim($sheet->getCell('A'.$y)->getValue());
                                $numero_commande = $sheet->getCell('B'.$y)->getValue();
                                $transporteur = $sheet->getCell('C'.$y)->getValue();
                                $date= $sheet->getCell('D'.$y)->getValue();
                                $adresse_livraison = $sheet->getCell('E'.$y)->getValue();

                                $date = strtotime(str_replace('/', '-',$date));
                                $date = date('Y-m-d',$date);

                                $code_barre_produit= $sheet->getCell('F'.$y)->getValue();
                                $reference_produit= $sheet->getCell('G'.$y)->getValue();
                                $designation_produit= $sheet->getCell('H'.$y)->getValue();
                                $quantite = $sheet->getCell('I'.$y)->getValue();
                                $operateur = $sheet->getCell('J'.$y)->getValue();

                            //Ajouter une préparation avec id commande = 0.
                                if ($row->getRowIndex() == 2) {
                             //vérifier si les champs nécessaire pour créer une préparation client son rempli
                                   if ($date != null || $entite != null || $transporteur != null || $adresse_livraison != null ) {
                                    /*$existe_entite = Preparation::where('num_entite',$entite)->first();
                                    if ($existe_entite != null) {
                                        DB::rollback();
                                        return Redirect::back()->withErrors(["Le N° Entité existe déjà avec une autre préparation."]);
                                    }*/
                                    $date_prevue = $date;
                                    $transpo = $transporteur;
                                    $adresseLivraison = $adresse_livraison ;
                                    $entite_ = $entite ;
                                    $commande2 = $numero_commande;
                                    //dd($numero_commande);

                                    $preparation = new Preparation();
                                    $NumPreparation = null;
                                    /*$lastNum =Preparation::orderBy('idPreparation','desc')->first();
                                    if ($lastNum != null) {
                                        $NumPreparation = substr_replace($lastNum->numPreparation, "", 0, 5);
                                        if ($NumPreparation == 99999){
                                            $NumPreparation='PREPA00001';
                                        }
                                        else {
                                            $NumPreparation = $NumPreparation + 1;
                                            $NumPreparation=str_pad($NumPreparation, 5, '0', STR_PAD_LEFT);
                                            $NumPreparation ='PREPA'.$NumPreparation;
                                        }
                                    }
                                    else{
                                        $NumPreparation='PREPA00001';
                                    }*/
                                    $monfichier = fopen('NumeroPreparation.txt', 'r');

        $ligne1 = fgets($monfichier);
        $prefixe = explode("=", $ligne1);
        $prefixe = str_replace("\r\n","",$prefixe[1]);

        $ligne2 = fgets($monfichier);
        $datee = explode("=", $ligne2);
        $datee = str_replace("\r\n","",$datee[1]);
        $datee = date("Y-m-d");
        if ($datee == "AAMMJJ") {
            $datee = date("y-m-d");
        }
        if($datee == "JJMMAA"){
            $datee = date("d-m-y");
        }
        if ($datee == "AAAA") {
            $datee = date("Y");
        }
        if ($datee == "AA") {
            $datee = date("y");
        }

        $datee = str_replace("-","",$datee);

        //récupéré nombre de bon livraison par jour , par mois par an
        $prep = CompteurModule::where('MODULE',"PREPARATION")->first();
        if ($prep != null) {
            $timestamp = strtotime($prep->last_update);
            
            if (date("Y", $timestamp) == date('Y')) $prep->COMPTEUR_PAR_AN += 1;
            else $prep->COMPTEUR_PAR_AN = 1;

            if (date("m", $timestamp) == date('m')) $prep->COMPTEUR_PAR_MOIS += 1;
            else $prep->COMPTEUR_PAR_MOIS = 1;

            if (date("d", $timestamp) == date('d')) $prep->COMPTEUR_PAR_JOUR += 1;
            else $prep->COMPTEUR_PAR_JOUR = 1;

            $prep->last_update = date("Y-m-d");
            $prep->update();
        }else{
            $prep = new CompteurModule();
            $prep->MODULE = "PREPARATION";
            $prep->COMPTEUR_PAR_JOUR = 1;
            $prep->COMPTEUR_PAR_MOIS = 1;
            $prep->COMPTEUR_PAR_AN = 1;
            $prep->last_update = date("Y-m-d");
            $prep->save();
        }

        $ligne3 = fgets($monfichier);
        $taille_compteur = explode("=", $ligne3);
        $taille_compteur = (int)str_replace("\r\n","",$taille_compteur[1]);

        $ligne4 = fgets($monfichier);
        $format_sequence = explode("=", $ligne4);
        $format_sequence = str_replace("\r\n","",$format_sequence[1]);
        $format_sequence = str_replace("+","",$format_sequence);

        $jour = str_pad($prep->COMPTEUR_PAR_JOUR, $taille_compteur, '0', STR_PAD_LEFT);
        $mois = str_pad($prep->COMPTEUR_PAR_MOIS, $taille_compteur, '0', STR_PAD_LEFT);
        $an = str_pad($prep->COMPTEUR_PAR_AN, $taille_compteur, '0', STR_PAD_LEFT);

        $format_sequence = str_replace("DATE",$datee,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_JOUR",$jour,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_MOIS",$mois,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_AN",$an,$format_sequence);
        $NumPreparation = $prefixe.$format_sequence;

                                    $preparation->numPreparation = $NumPreparation;

                                    $existTransporteur = Transporteur::where('numTransporteur',$transporteur)->first();
                                    if ($existTransporteur != NULL) {
                                        $preparation->idTransporteur = $existTransporteur->idTransporteur;
                                    }else{
                                        return Redirect::back()->withErrors(["Le N°Transporteur n'existe pas."]);
                                    }
                                
                                $preparation->datePrevue = $date;
                                //$preparation->idCommande = 0; //import sans commande
                                
                                
                                $preparation->nombreProduits = $sheet->getHighestRow() - 1;
                                $preparation->last_update = date("Y-m-d H:i:s");
                                $preparation->nombreUE = -1;
                                $preparation->statutPreparation = 0;
                                
                                $existeClient = Client::where('raisonSociale',$adresse_livraison)->first();
                                if ($existeClient != NULL) {
                                    $preparation->adresse_livraison = $existeClient->idClient;
                                }else{
                                    DB::rollback();
                                    return Redirect::back()->withErrors(["Adresse de livraison n'existe pas."]);
                                }
                                if ($numero_commande != null) {
                                       $commandeee = CommandeClient::where('numCommande',$numero_commande)->first();
                                    if ($commandeee == null) {
                                        $commande = new CommandeClient();
                                        $commande->numCommande = $numero_commande;
                                        $commande->dateCommande = date("Y-m-d");
                                        $commande->idClient = $existeClient->idClient;
                                        $commande->save();
                                        $id_commande = $commande->idCommande;
                                    }else{
                                        $id_commande = $commandeee->idCommande;
                                    }
                                    $preparation->idCommande = $id_commande;
                                }
                                
                                
                                $preparation->totalPoids = 0;
                                $preparation->num_entite = $entite;
                                $preparation->save();
                                $prepation_client = $preparation;
                                //update le champ nombreUE de l'objet preparation pour déclencher le déclencheur chargement_préparation.
                                /*$prf = Preparation::find($prepation_client->idPreparation);
                                if ($prf != null) {
                                    $prf->nombreUE = 0;
                                    $prf->update();
                                }*/
                            }else {
                                DB::rollback();
                                if ($entite == null) {
                                    return Redirect::back()->withErrors(["Le champ 'N°Entité' est obligatoire."]);
                                }
                                if ($transporteur == null) {
                                    return Redirect::back()->withErrors(["Le champ 'N°Transporteur' est obligatoire."]);
                                }
                                if ($date) {
                                    return Redirect::back()->withErrors(["Le champ 'Date prévue' est obligatoire."]);
                                }
                                if ($adresse_livraison == null) {
                                    return Redirect::back()->withErrors(["Le champ 'Raison sociale' est obligatoire."]);
                                }
                                /*if ($numero_commande == null) {
                                    return Redirect::back()->withErrors(["Le champ 'N°Commande' est obligatoire."]);
                                }*/
                                
                            }
                        }
                        //vérifier si la date ou numéro livraison on été changé
                        if ($adresse_livraison != $adresseLivraison) {
                            $warning->put($key, " L'adresse de la livraison a été modifiée");
                            break;
                        }
                        if ($transpo != $transporteur) {
                            $warning->put($key, "Le N°Transpour a été modifié");
                            break;
                        }
                        if ($date_prevue != $date) {
                            $warning->put($key, 'La date prevue a été modifiée');
                            break;
                        }
                        if ($entite_ != $entite) {
                            $warning->put($key, 'Le N°Entité a été modifié');
                            break;
                        }
                         if ($commande2 != $numero_commande) {
                            $warning->put($key, 'Le N°Commande a été modifié');
                            break;
                        }
                        //ajouter les lignes produit
                        //tester si le produit existe bien
                        $produit = Produit::where('reference',$reference_produit)->first();
                        if ($produit != null) {
                                $user = User::where('login',$operateur)->first();
                                if ($user != null) {
                                    $resultat_algo_picking = $this->AlgoPicking3($entite ,$produit ,$quantite, 1 );
                                    //dd($resultat_algo_picking);
                                    if ($resultat_algo_picking == null) {
                                        DB::rollback();
                                        return Redirect::back()->withErrors(["Échec de l'importation ....".$reference_produit]);
                                    }
                                    

                                    foreach ($resultat_algo_picking as $key => $value) {
                                        //resultat de algo une collection (ligne_stock => quantité retirer de la ligne)
                                        if (! $nombre_de_ue->contains($value[0]->num_ue)) {
                                        //inserer dans la collection le ue;
                                        $nombre_de_ue->put($value[0]->num_ue, 1);
                                         
                                        }

                                        /*//ajouer une ue
                                                    $existeUE = UniteExpedition::where('SSCC',$value[0]->num_ue)->first();
                                                    $ue = null;
                                                    if ($existeUE != null) {

                                                        $existeUE->nombreProduits = $existeUE->nombreProduits + 1;
                                                        $existeUE->poidsProduits = $existeUE->poidsProduits + ( $produit->poids * $value[1]);
                                                        $existeUE->update();
                                                        $ue = $existeUE;
                                                    }else{
                                            //si oui créer une unite expedition
                                                        $existeUE = new UniteExpedition();
                                                        $existeUE->SSCC = $value[0]->num_ue;
                                                        $existeUE->nombreProduits = 1;
                                                        $existeUE->poidsProduits = $produit->poids * $value[1];
                                                        $existeUE->save();
                                                        $ue = $existeUE;   
                                                    }*/

                                        $LigneProduit = new LigneProduit();
                                        $LigneProduit->idPreparation = $prepation_client->idPreparation;
                                        //$LigneProduit->idUE = $ue->idUE;
                                        $LigneProduit->idUE = 0;
                                        $LigneProduit->idProduit = $produit->id_produit;
                                        $LigneProduit->idStock = $key;
                                        $LigneProduit->idUser = $user->id_user;
                                        $LigneProduit->quantite_a_preparer = $value[1];
                                        $LigneProduit->quantite_preparer = 0;
                                        $LigneProduit->quantite_restante = $value[1];
                                        $LigneProduit->total_poids = $produit->poids * $value[1];
                                        $LigneProduit->simule_fo = 0;
                                        $LigneProduit->last_update = date("Y-m-d H:i:s");
                                        $LigneProduit->save();

                                        
                                        //mettre a jour le poid dans la préparation
                                        $preparation_a_modifier =  Preparation::where('idPreparation',$prepation_client->idPreparation)->first();
                                                //dd($preparation_a_modifier);
                                        if ($preparation_a_modifier != null) {
                                            $preparation_a_modifier->totalPoids += $produit->poids * $value[1];
                                            $preparation_a_modifier->update();
                                        }                                 
                                   }
                        }else{
                         $erreur->put($key, "Opérateur '".$operateur."' n'existe pas.");
                         break;
                     }
            
                }else{
                    $erreur->put($key, "Le produit ".$reference_produit." n'existe pas.");
                    break;
                }
    }
    $y++;
}
        
/*$preparation_a_modifier =  Preparation::where('idPreparation',$prepation_client->idPreparation)->first();
if ($preparation_a_modifier != null) {
    $preparation_a_modifier->nombreUE = $nombre_de_ue->count();
    $preparation_a_modifier->update();
}*/

    //dd($nombre_de_ue);
    //modifier le champ nombreUE de l'objet préparation
    $count_ue_fermer = 0;
    //changer etat de ue
   
    foreach ($nombre_de_ue as $key => $ue) {
        $box = Ue::where('num_ue',$key)->first();
        if ($box->etat_ue == 0){
            $stock = StockProduit::where('num_ue',$key)->where('quantite_utilisable','!=',0)->first();
            if ($stock != null) {
                $box->etat_ue = 1;
                $box->last_update = date("Y-m-d H:i:s");
                $box->update();
            }else
                $count_ue_fermer++;
    }
} 
$preparation_a_modifier =  Preparation::where('idPreparation',$prepation_client->idPreparation)->first();
$preparation_a_modifier->nombreUE = $count_ue_fermer;
$preparation_a_modifier->update();


//DB::rollback();

$HistoriqueActions = new Historique();
$HistoriqueActions->type_action = 'Importation';
$HistoriqueActions->nom_table = 'Clients->Les préparations';
$HistoriqueActions->description = 'Importation des préparations depuis un fichier';
$HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
$HistoriqueActions->date =Carbon::now('Africa/Algiers');
$HistoriqueActions->save();

                //dd($sheet->getHighestRow() - 1, $erreur->count());
if ($sheet->getHighestRow() - 1 == $erreur->count()) {
    DB::rollback();
                    //delete preparation
                    //Preparation::where('idPreparation', $prepation_client->idPreparation)->delete();
    return redirect('preparation/index')->with('msgAjouterAnnuler',
        [$erreur]);
}
if ($erreur->count() == 0 && $warning->count() == 0) {
    DB::commit();
    return redirect('preparation/index')->with('msgAjouter', 'Fichier importé avec succès');
}else{
    DB::rollback();
                    //return redirect('receptions/reception_fournisseur/index')->with('msgAjouterErreur',
                        //$warning->count().'Nombre de ligne non importé :'. $erreur->count().'.');
    return redirect('preparation/index')->with('msgAjouterErreur',[$warning , $erreur]);
}
}
else
    return Redirect::back()->withErrors(['Fichier vide ']);
} else return Redirect::back()->withErrors(['Fichier volumineux ']);

} else return Redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);
}

public function AlgoPicking3($entite ,$produit ,$quantite, $importer ){
    //resultat de algo une collection (ligne_stock, quantité retirer de la ligne)
    $ligne_stock_trouve = collect();
    $lignes_stock_ouvert = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
    ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable',$quantite)
    ->where('etat_ue',1)->first();
    //dd($lignes_stock_ouvert);
    if (! $lignes_stock_ouvert) {
        $lignes_stock_ouvert_all = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
        ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable','>',0)
        ->where('etat_ue',1)->get()->sortByDesc('quantite_utilisable');
        if (! $lignes_stock_ouvert_all->isEmpty()) {
            foreach ($lignes_stock_ouvert_all as $key => $ligne) {
                if ($ligne->quantite_utilisable >= $quantite) {
                    $ligne_stock_trouve->put($ligne->id_stock_produit, [$ligne, $quantite]);
                    if ($importer) {
                        $ligne->quantite_utilisable -= $quantite;
                        $ligne->update();
                    }
                    return $ligne_stock_trouve;
                }else{
                    $ligne_stock_trouve->put($ligne->id_stock_produit, [$ligne, $ligne->quantite_utilisable]);
                    $quantite -= $ligne->quantite_utilisable;
                    if ($importer) {
                        $ligne->quantite_utilisable = 0;
                        $ligne->update();
                    }
                    
                }
            }
        }

        $lignes_stock_ferme = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
        ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable',$quantite)
        ->where('etat_ue',0)->first();
        if (! $lignes_stock_ferme) {
            $lignes_stock_ferme_all = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
            ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable','>',0)
            ->where('etat_ue',0)->get()->sortByDesc('quantite_utilisable');
            if (! $lignes_stock_ferme_all->isEmpty()) {
               foreach ($lignes_stock_ferme_all as $key => $ligne) {
                   if ($ligne->quantite_utilisable >= $quantite) {
                        $ligne_stock_trouve->put($ligne->id_stock_produit, [$ligne, $quantite]);
                        if ($importer) {
                            $ligne->quantite_utilisable -= $quantite;
                            $ligne->update();
                        }
                        return $ligne_stock_trouve;
                    }else{
                        $ligne_stock_trouve->put($ligne->id_stock_produit, [$ligne, $ligne->quantite_utilisable]);
                        $quantite -= $ligne->quantite_utilisable;
                        if ($importer) {
                            $ligne->quantite_utilisable = 0;
                            $ligne->update();
                        }
                        
                    }
               }
            }
            return null;
        }else{
            $ligne_stock_trouve->put($lignes_stock_ferme->id_stock_produit, [$lignes_stock_ferme, $quantite]);
            if ($importer) {
                $lignes_stock_ferme->quantite_utilisable = 0;
                $lignes_stock_ferme->update();
            }
            return $ligne_stock_trouve;
        }
    }else{
        $ligne_stock_trouve->put($lignes_stock_ouvert->id_stock_produit, [$lignes_stock_ouvert, $quantite]);
        if ($importer) {
            $lignes_stock_ouvert->quantite_utilisable = 0;
            $lignes_stock_ouvert->update();
        }
        return $ligne_stock_trouve;
    }
}

public function AlgoPicking2($entite ,$produit ,$quantite ){

    //resultat de algo une collection (ligne_stock, quantité retirer de la ligne)
    $ligne_stock_trouve = collect();
    $lignes_stock_ue_ouvert_min = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
    ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable','>',0)->where('etat_ue',1)->where('quantite_utilisable',"<=",$quantite)->get()->sortBy('quantite_utilisable');
    //dd($lignes_stock_ue_ouvert_min);

    if (! $lignes_stock_ue_ouvert_min->isEmpty()) {
        foreach ($lignes_stock_ue_ouvert_min as $key => $ligne) {
            if ($ligne->quantite_utilisable >= $quantite) {
                $ligne_stock_trouve->put($ligne->id_stock_produit, $quantite);
                return $ligne_stock_trouve;
            }else{
                $ligne_stock_trouve->put($ligne->id_stock_produit, $ligne->quantite_utilisable);
                $quantite -= $ligne->quantite_utilisable;
            }
            
        }
    }
    $lignes_stock_ue_ouvert_max = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
    ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable','>',0)->where('etat_ue',1)->where('quantite_utilisable',">",$quantite)->get()->sortBy('quantite_utilisable');

    if (! $lignes_stock_ue_ouvert_max->isEmpty()) {
        foreach ($lignes_stock_ue_ouvert_max as $key => $ligne) {
            if ($ligne->quantite_utilisable >= $quantite) {
                $ligne_stock_trouve->put($ligne->id_stock_produit, $quantite);
                return $ligne_stock_trouve;
            }else{
                $ligne_stock_trouve->put($ligne->id_stock_produit, $ligne->quantite_utilisable);
                $quantite -= $ligne->quantite_utilisable;
            }
            
        }
    }

    $lignes_stock_ue_fermer_min = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
    ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable','>',0)->where('etat_ue',0)->where('quantite_utilisable',"<=",$quantite)->get()->sortBy('quantite_utilisable');

    if (! $lignes_stock_ue_fermer_min->isEmpty()) {
        foreach ($lignes_stock_ue_fermer_min as $key => $ligne) {
            if ($ligne->quantite_utilisable >= $quantite) {
                $ligne_stock_trouve->put($ligne->id_stock_produit, $quantite);
                return $ligne_stock_trouve;
            }else{
                $ligne_stock_trouve->put($ligne->id_stock_produit, $ligne->quantite_utilisable);
                $quantite -= $ligne->quantite_utilisable;
            }
            
        }
    }

    $lignes_stock_ue_fermer_max = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
    ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable','>',0)->where('etat_ue',1)->where('quantite_utilisable',">",$quantite)->get()->sortBy('quantite_utilisable');

    if (! $lignes_stock_ue_fermer_max->isEmpty()) {
        foreach ($lignes_stock_ue_fermer_max as $key => $ligne) {
            if ($ligne->quantite_utilisable >= $quantite) {
                $ligne_stock_trouve->put($ligne->id_stock_produit, $quantite);
                return $ligne_stock_trouve;
            }else{
                $ligne_stock_trouve->put($ligne->id_stock_produit, $ligne->quantite_utilisable);
                $quantite -= $ligne->quantite_utilisable;
            }
            
        }
    }

    return 0;
}
public function AlgoPicking($entite ,$produit ,$quantite ){
    //récupérer les lignes stock par num_entite et id_produit et qnt.utilisable > 0
    $lignes_stock = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")
    ->where('num_entite',$entite)->where('id_produit',$produit->id_produit)->where('quantite_utilisable','>',0)
    ->get();
    //dd($lignes_stock);
    if ($lignes_stock != null) {
        //resultat de algo une collection (ligne_stock, quantité retirer de la ligne)
        $ligne_stock_trouve = collect();
        //diviser la collection en 2: 
        //1: avec etat de ue ouvert.
        //2: avec etat de ue fermer.
        $ligne_stock_ue_ouvert = $lignes_stock->filter(function ($value, $key) {
                                                    return $value->etat_ue == 1 ;
                                                });
        $ligne_stock_ue_fermer = $lignes_stock->filter(function ($value, $key) {
                                                    return $value->etat_ue == 0 ;
                                                });
        //dd($ligne_stock_ue_fermer);
        //dd($ligne_stock_ue_ouvert);
        //on cherche d'abord dans les box ouvert
        if ($ligne_stock_ue_ouvert != null) {
            foreach ($ligne_stock_ue_ouvert as $key => $ligne) {
                if ($ligne->quantite_utilisable >= $quantite) {
                    $ligne_stock_trouve->put($ligne->id_stock_produit, $quantite);
                    $quantite = 0;
                    break;
                }else{
                    $ligne_stock_trouve->put($ligne->id_stock_produit, $ligne->quantite_utilisable);
                    $quantite -= $ligne->quantite_utilisable;
                }
            } 
        }
        if ($quantite == 0) {
            //dd($ligne_stock_trouve);
            return $ligne_stock_trouve;
        }
        //on cherche dans les box fermer
        if ($ligne_stock_ue_fermer != null) {
            foreach ($ligne_stock_ue_fermer as $key => $ligne) {
                if ($ligne->quantite_utilisable >= $quantite) {
                    $ligne_stock_trouve->put($ligne->id_stock_produit, $quantite);
                    $quantite = 0;
                    break;
                }else{
                    $ligne_stock_trouve->put($ligne->id_stock_produit, $ligne->quantite_utilisable);
                    $quantite -= $ligne->quantite_utilisable;
                }
            }
        }
        if ($quantite == 0) {
            //dd($ligne_stock_trouve);
            return $ligne_stock_trouve;
        }else{
            //dd('le stock ne contien pas la quantiter souété préparer');
            return -1;

        }
    }else{
        //dd('pas de ligne de stock trouvé');
        return 0;
    }
}

public function downloadModele(Request $request){
    if (Session::get('STOCK_ENTITE') == '1') {
        $file=public_path()."/Modele_preparation_UE_Entite.xlsx";
    $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
    return Response::download($file, 'Modele_preparation_UE_Entite.xlsx',$headers);
    }else{
        $file=public_path()."/Modele_preparation_UE.xlsx";
    $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
    return Response::download($file, 'Modele_preparation_UE.xlsx',$headers);
    }
    
}

public function getAllUeFromStock($entite, $id_produit){
    //$stock = get_object_vars($stock);
    //$stock = json_decode($stock);
    $resultat = null;
    if (Session::get('STOCK_ENTITE')) {
        $resultat = StockProduit::where('num_entite',$entite)->where('id_produit',$id_produit)->get();
    }else{
        $resultat = StockProduit::where('id_produit',$id_produit)->get();
    }
    
    return $resultat;
}

public function EditLigneProduit(Request $request){
    

        $num_ue = $request->input('numero_ue');
        $reference =$request->input('referencee');
        //dd($reference);
        $quantite = $request->input('quantite_a_preparer_modal');
        $importer = $request->input('importer');
        //dd($importer);
        $ligne = LigneProduit::where('idLigneProduit',$request->input('id_ligne_produit'))->with('stockProduit')->with('Preparation')->first();



        if ($ligne != null) {
            //récupérer une liste des num_ue de la préparation
            $liste = LigneProduit::where('idPreparation', $ligne->idPreparation)->join('stock_produit','stock_produit.id_stock_produit','=','ligne_produit.idStock')->with('produit')->get();
            //dd($liste);
            foreach ($liste as $key => $value) {
                if ($num_ue == $value->num_ue && $reference == $value->produit->reference && $ligne->stockProduit->num_ue != $num_ue){
                    return redirect()->back()->withInput()->with('msgExist','N°UE existe déjà dans la liste');
                }
            }
            //dd($liste);
            //dd($ligne);
                $stock = StockProduit::where('num_ue',$num_ue)->where('id_produit',$ligne->idProduit)->first();
                //dd($stock);
                if ($stock != null) {
                    //dd($stock->quantite_utilisable, $quantite);
                    if ($stock->quantite_utilisable < $quantite) {
                        if ($importer == "1") {


                        if ($stock->num_ue == $ligne->stockProduit->num_ue) {
                            //dd($stock->num_ue,$num_ue);
                            //get quantité utilisable + quantité a préparé
                            if ($stock->quantite_utilisable + $ligne->quantite_a_preparer  < $quantite) {
                                return redirect()->back()->withInput()->with('msgExist','Quantité n\'est pas valide');
                            }else{
                                if ($importer == "1") {
                        
                                    $stock->quantite_utilisable -= $quantite;
                                    $stock->last_update = date("Y-m-d H:i:s");
                                    $stock->update();

                                    $stock2 = StockProduit::where('id_stock_produit',$ligne->idStock)->with('ue')->first();
                                    $stock2->quantite_utilisable += $ligne->quantite_a_preparer;
                                    $stock2->update();

                                     //etat_ue
                                     $stock3 = StockProduit::where('num_ue',$stock2->ue->num_ue)->where('quantite_utilisable','!=',0)->first();
                                     //dd($stock3);
                                     $box = Ue::where('num_ue',$stock2->ue->num_ue)->first();
                                    if ($stock3 != null) {
                                        if ($box->etat_ue == 0) {
                                            //décrémenter nombre UE de la table préparation
                                            $preparation = Preparation::find($ligne->idPreparation);
                                            $preparation->nombreUE -= 1;
                                            $preparation->update();

                                        }
                                        $box->etat_ue = 1;
                                        $box->last_update = date("Y-m-d H:i:s");
                                        $box->update();
                                        //get all ligne_produit meme ue
                                        $numero_serie_reception = NumSerie::where('numUE',$stock2->ue->num_ue)->get();
                                        if ($numero_serie_reception != null) {
                                            $liste_ligne = collect();
                                            foreach($numero_serie_reception as $key => $num_serie_reception){
                                                $ligne_reception = LigneBonReception::find($num_serie_reception->id_ligne_reception);
                                                $ligne_produit_preparation = null;
                                                if ($ligne_reception != null) {
                                                    $ligne_produit_preparation = LigneProduit::where('idStock',$ligne_reception->id_stock_produit )->where(function ($query) use ($ligne){
                                                    $query->where('idPreparation', $ligne->idPreparation)
                                                          ->orWhere('idPreparation', 0);
                                                })->first();
                                                }
                                                
                                                if ($ligne_produit_preparation != null) {
                                                    $liste_ligne->put($key, $ligne_produit_preparation);
                                                }  
                                            }
                                        }
                                        
                                        $this->decharger_numero_serie($liste_ligne);
                                    }else{
                                        //incrémenter nombre UE de la table préparation
                                            $preparation = Preparation::find($ligne->idPreparation);
                                            $preparation->nombreUE += 1;
                                            $preparation->update();
                                        $box->etat_ue = 0;
                                        $box->last_update = date("Y-m-d H:i:s");
                                        $box->update(); 
                                        //get all ligne_produit meme ue
                                        $numero_serie_reception = NumSerie::where('numUE',$stock2->ue->num_ue)->get();
                                        if ($numero_serie_reception != null) {
                                            $liste_ligne = collect();
                                            foreach($numero_serie_reception as $key => $num_serie_reception){
                                                $ligne_reception = LigneBonReception::find($num_serie_reception->id_ligne_reception);
                                                $ligne_produit_preparation = null;
                                                if ($ligne_reception != null) {
                                                    $ligne_produit_preparation = LigneProduit::where('idStock',$ligne_reception->id_stock_produit )->where('idPreparation',$ligne->idPreparation)->first();
                                                }
                                                
                                                if ($ligne_produit_preparation != null) {
                                                    $liste_ligne->put($key, $ligne_produit_preparation);
                                                }  
                                            }
                                        }
                                         $this->charger_numero_serie($liste_ligne);
                                    }
                                   
                                }
                        
                        $ligne->idStock = $stock->id_stock_produit;
                        $ligne->quantite_a_preparer = $quantite;
                        $ligne->idUE = 0;
                        $ligne->quantite_restante = $quantite;
                        $ligne->last_update =date("Y-m-d H:i:s");
                        $ligne->modifier = 1;
                        $ligne->update();

                        $HistoriqueActions = new Historique();
                        $HistoriqueActions->type_action = 'Modification';
                        $HistoriqueActions->nom_table = 'Clients->Les préparations->Ligne produit';
                        $HistoriqueActions->description = 'Modification de la ligne produit de la préparation : '.$ligne->Preparation->numPreparation;
                        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                        $HistoriqueActions->save();

                        return redirect()->back()->withInput()->with('msgAjouter','Produit modifiée avec succès');

                            }
                        }
                        //dd('lol');
                        //dd($stock->quantite_utilisable, $quantite);
                        return redirect()->back()->withInput()->with('msgExist','Quantité n\'est pas valide');
                    }else{
                        return redirect()->back()->withInput()->with('msgExist','Quantité n\'est pas valide');
                    }
                    }else{
                        if ($importer == "1") {
                        
                            $stock->quantite_utilisable -= $quantite;
                            $stock->last_update = date("Y-m-d H:i:s");
                            $stock->update();

                            $stock2 = StockProduit::where('id_stock_produit',$ligne->idStock)->first();
                            $stock2->quantite_utilisable += $ligne->quantite_a_preparer;
                            $stock2->update();
                        }
                        
                        $ligne->idStock = $stock->id_stock_produit;
                        $ligne->quantite_a_preparer = $quantite;
                        $ligne->quantite_restante = $quantite;
                        $ligne->last_update =date("Y-m-d H:i:s");
                        $ligne->modifier = 1;
                        $ligne->update();
                        return redirect()->back()->withInput()->with('msgAjouter','Produit modifiée avec succès');
                    }
                }else{
                    return redirect()->back()->withInput()->with('msgExist','Erreur...');
                }

        }

}

}
