<?php

namespace App\Http\Controllers;

use App\ListValeur;
use App\DroitAccesBackoffice;
use App\DroitAccesMobile;
use App\Historique;
use App\Preferences;
use App\ProfilBackoffice;
use App\ProfilMobile;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Emplacement;

class PreferencesController extends Controller
{
	public function index()
	{
		/*DB::unprepared("IF (OBJECT_ID(N'[dbo].[trigger_ligne_produit_chargement_preparation]') IS NOT NULL)
						BEGIN
      						DROP TRIGGER [dbo].[trigger_ligne_produit_chargement_preparation];
						END;");

			DB::unprepared("CREATE TRIGGER [dbo].[trigger_ligne_produit_chargement_preparation]
						ON [dbo].[unite_expedition] AFTER UPDATE AS 
						BEGIN
						DECLARE
						@statut INT;
						SELECT @statut = ins.statut FROM INSERTED ins;

						IF @statut =1
    						BEGIN
						DECLARE
						@idLigneProduit INT,
						@idLigneUe INT,
						@idStock INT,
						@id_ligne_bon_reception INT,
						@num_ue_fermer VARCHAR(50),
						@num_serie VARCHAR(50),
						@ue VARCHAR(50),
						@exist_num_serie VARCHAR(50);

						
						SELECT @idLigneUe = ins.idUE FROM INSERTED ins;
						SELECT @ue= ins.SSCC FROM INSERTED ins;

						DECLARE ligne_cursor CURSOR FOR SELECT ligne.idStock, ligne.idLigneProduit, ligne_reception.id_ligne_bon_reception FROM dbo.ligne_produit AS ligne JOIN dbo.ligne_bon_reception AS ligne_reception ON ligne_reception.id_stock_produit = ligne.idStock WHERE ligne.idUE = @idLigneUe;
								OPEN ligne_cursor
								FETCH NEXT FROM ligne_cursor INTO @idStock, @idLigneProduit, @id_ligne_bon_reception;
								WHILE @@FETCH_STATUS = 0 
								BEGIN
									SET @num_ue_fermer = null;
									SET @num_serie = null;
									SET @exist_num_serie = null;

									SELECT @num_ue_fermer = (SELECT ue.num_ue FROM dbo.stock_produit AS stock JOIN dbo.ue AS ue ON stock.num_ue = ue.num_ue WHERE stock.id_stock_produit = @idStock AND ue.etat_ue = 0 )
									IF @num_ue_fermer IS NOT NULL
										BEGIN
											DECLARE ligne_cursor_2 CURSOR LOCAL FOR SELECT serie_reception.num_serie FROM dbo.num_serie AS serie_reception WHERE serie_reception.numUE = @num_ue_fermer AND serie_reception.id_ligne_reception = @id_ligne_bon_reception;
											OPEN ligne_cursor_2
											FETCH NEXT FROM ligne_cursor_2 INTO @num_serie
											WHILE @@FETCH_STATUS = 0 
											BEGIN 
												SELECT @exist_num_serie = (SELECT serie_chargement.num_serie FROM dbo.numero_serie AS serie_chargement WHERE serie_chargement.num_serie = @num_serie)
												IF @exist_num_serie IS NULL
												BEGIN
													INSERT INTO [numero_serie] ([id_ligne_produit], [num_serie], [last_update]) VALUES (@idLigneProduit,@num_serie,GETDATE());
												END
												FETCH NEXT FROM ligne_cursor_2 INTO @num_serie;
											END
											CLOSE ligne_cursor_2
											DEALLOCATE ligne_cursor_2
											FETCH NEXT FROM ligne_cursor INTO @idStock, @idLigneProduit,  @id_ligne_bon_reception

										END
								END
									
								END
								CLOSE ligne_cursor
								DEALLOCATE ligne_cursor
						END;");*/

		if(Session::get('CONFIGURATION_PREFERENCES')) {
			$emplacement_libelle_production = '';
			$emplacement_libelle_reception = '';
			$emplacement_libelle_controle = '';
			$type_num_document = 0;

			$type_entite = ListValeur::where('nom_liste','TYPE_ENTITE')->get();
			$type_emp_mobile = ListValeur::where('nom_liste','STOCK_EMPLACEMENT_MOBILE')->get();

			$profiles = Preferences::get();
			//dd($profiles);
			$count=Preferences::where('valeur_preference','!=','0')->count();
			//var_dump($count);
			//dd($count);
			$emplacements = Emplacement::all();

			if ($profiles[23]->valeur_preference != 0 ) {
				//0 packing list
				$type_num_document = $profiles[23]->valeur_preference;
			}
			if ($profiles[5]->valeur_preference != 0 ) {
				$emplacement_libelle_production = Emplacement::where('id_emplacement', $profiles[5]->valeur_preference)->first();
			}
			if ($profiles[14]->valeur_preference != 0 ) {
				$emplacement_libelle_reception = Emplacement::where('id_emplacement', $profiles[14]->valeur_preference)->first();
			}
			if ($profiles[18]->valeur_preference != 0 ) {
				$emplacement_libelle_controle = Emplacement::where('id_emplacement', $profiles[18]->valeur_preference)->first();
			}

			return view('configuration/preferences/index', compact('profiles','count','emplacements','emplacement_libelle_production','emplacement_libelle_reception','emplacement_libelle_controle','type_entite','type_emp_mobile','type_num_document'));
		}
		else{
			return view('errors/404');
		}
	}


	public function configurer(Request $request){
		//dd($request->input('21') );
		
		if ($request->input('6') != null) {
			/*$this->validate($request, [
				'8' => 'required'
			]);*/

			if ($request->input('8') == null) {
				$request->session()->flash('erreur', 'Veuillez indiquer un emplacement de production par défaut');
				return redirect('preferences/index');
			}
		}
		/*if ($request->input('24') == null) {
			$request->session()->flash('erreur', 'Veuillez indiquer un type de n° document');
			return redirect('preferences/index');
		}*/
		if ($request->input('15') == null) {
			$request->session()->flash('erreur', 'Veuillez indiquer un emplacement de réception par défaut');
			return redirect('preferences/index');
		}

		if ($request->input('19') == null) {
			$request->session()->flash('erreur', 'Veuillez indiquer un emplacement de contrôle par défaut');
			return redirect('preferences/index');
		}

		if ($request->input('19') == $request->input('15')) {
			$request->session()->flash('erreur', "Emplacement de réception ne doit pas être le même emplacement de contrôle.");
			return redirect('preferences/index');
		}
		if ($request->input('20') != null) {
			if ($request->input('21') == null) {
				$request->session()->flash('erreur', "Veuillez indiquer un type d'entité");
				return redirect('preferences/index');
			}
		}
		if ($request->input('22') != null) {
			if ($request->input('23') == null) {
				$request->session()->flash('erreur', "Veuillez indiquer un type d'emplacement mobile");
				return redirect('preferences/index');
			}
		}

		if ($request->input('27') != null) {
			if ($request->input('28') == 0) {
				$request->session()->flash('erreur', 'Veuillez indiquer un évenement déclencheur par défaut');
				return redirect('preferences/index');
			}
		}


		for ($i = 1 ; $i <= 29 ; $i++){
			switch ($i){
				case 1 : if($request->input($i) != null) {
					Preferences::where('code_preference','=',"BL")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
				}
				else {Preferences::where('code_preference','=',"BL")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);}
					break;
				case 2 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"DESTOCKAGE_BL")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);}
				else
				{
					Preferences::where('code_preference','=',"DESTOCKAGE_BL")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
				} break;
				case 3 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"N_LOT")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					}
					else {Preferences::where('code_preference','=',"N_LOT")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					}
					break;
				case 4 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"DATE_PEREMPTION")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else {
						Preferences::where('code_preference','=',"DATE_PEREMPTION")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;
				case 5 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"CHARGEMENT")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"CHARGEMENT")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 6 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"PRODUCTION")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"PRODUCTION")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 7 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"AVEC_UE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"AVEC_UE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 8 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"EMP_PROD")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"EMP_PROD")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 9 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"TRACABILITE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"TRACABILITE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 10 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"USE_UE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"USE_UE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 11 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"CONTENEUR")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"CONTENEUR")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 12 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"CONTENEUR_OBLIGATOIRE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"CONTENEUR_OBLIGATOIRE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 13 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"COMPOSE_PACK")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"COMPOSE_PACK")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 14 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"COMPOSE_MP")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"COMPOSE_MP")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 15 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"EMP_RECEPTION")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"EMP_RECEPTION ")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 16 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"AVEC_UE_RECEPTION")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"AVEC_UE_RECEPTION")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 17 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"CONTROLE_UE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"CONTROLE_UE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 18 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"CONTROLE_PRODUIT_QUANTITE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"CONTROLE_PRODUIT_QUANTITE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 19 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"EMP_CONTROLE")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"EMP_CONTROLE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 20 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"STOCK_ENTITE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"STOCK_ENTITE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 21 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"TYPE_ENTITE")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"TYPE_ENTITE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;
				case 22 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"STOCK_EMPLACEMENT_MOBILE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"STOCK_EMPLACEMENT_MOBILE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 23 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"TYPE_STOCK_EMPLACEMENT_MOBILE")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"TYPE_STOCK_EMPLACEMENT_MOBILE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;

				case 24 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"TYPE_NUMERO_DOCUMENT")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"TYPE_NUMERO_DOCUMENT")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;
				case 25 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"NUMERO_SERIE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"NUMERO_SERIE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;
				case 26 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"DESIGNATION_PRODUIT_MOBILE")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"DESIGNATION_PRODUIT_MOBILE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;
				case 27 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"AJOUT_CHARGEMENT_PREPARATION")->update(['valeur_preference' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"AJOUT_CHARGEMENT_PREPARATION")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;
				case 28 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"EVENEMENT_DECLENCHEUR_CHARGEMENT")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					$this->create_trigger_chargement_preparation($request->input($i));
					} else
					{Preferences::where('code_preference','=',"EVENEMENT_DECLENCHEUR_CHARGEMENT")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					$this->drop_trigger_chargement_preparation();
					} break;
				case 29 :
					if($request->input($i) != null) { Preferences::where('code_preference','=',"FO_SAISIE_LISTE")->update(['valeur_preference' => $request->input($i),'date_last_update'=>date("Y-m-d H:i:s")]);
					} else
					{Preferences::where('code_preference','=',"FO_SAISIE_LISTE")->update(['valeur_preference' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
					} break;
			}

		}
		
		$pref = Preferences::get();
		foreach ($pref as $permission){

			Session::put($permission->code_preference,$permission->valeur_preference);

		}
        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Modification';
        $HistoriqueActions->nom_table = 'Configuration->Préférences';
        $HistoriqueActions->description = 'Modification de préférence ';
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        $request->session()->flash('msgAddSuccess', 'Modification réussie');
		return redirect('preferences/index');
}
	public function create_trigger_chargement_preparation($evenement_declencheur){
		$this->drop_trigger_chargement_preparation();
		if ($evenement_declencheur == 1) {
			$this->ajout_preparation_chargement();
		}elseif ($evenement_declencheur == 2) {
			$this->fin_preparation_chargement();
		}
		
	}
	public function drop_trigger_chargement_preparation(){
 		DB::unprepared("IF (OBJECT_ID(N'[dbo].[trigger_chargement_preparation]') IS NOT NULL)
						BEGIN
      						DROP TRIGGER [dbo].[trigger_chargement_preparation];
						END;");
	}

	public function ajout_preparation_chargement(){
		DB::unprepared("CREATE TRIGGER [dbo].[trigger_chargement_preparation]
						ON [dbo].[preparation] AFTER UPDATE AS 
						 BEGIN
						 IF UPDATE (nombreUE) 
    						BEGIN
						DECLARE
						@idPreparation INT,
						@NumPreparation VARCHAR(50),
						@idTransporteur INT,
						@totalProduits_chargement INT,
						@totalPoids_chargement INT,
						@totalUE_chargement INT,
						@numero_ue VARCHAR(50),
						@nombre_produit INT,
						@exist_num_ue VARCHAR(50),
						@idLigneProduit INT;

						SELECT @idPreparation = ins.idPreparation FROM INSERTED ins;
						SELECT @NumPreparation = ins.numPreparation FROM INSERTED ins;
						SELECT @idTransporteur = ins.idTransporteur FROM INSERTED ins;
						SELECT @totalProduits_chargement = ins.nombreProduits FROM INSERTED ins;
						SELECT @totalPoids_chargement = ins.totalPoids FROM INSERTED ins;
						SELECT @totalUE_chargement = 0;
						SELECT @exist_num_ue =99;

						DECLARE ligne_cursor CURSOR FOR SELECT ue.num_ue, ue.nbr_produit, ligne.idLigneProduit FROM dbo.ligne_produit AS ligne JOIN dbo.stock_produit AS stock ON ligne.idStock = stock.id_stock_produit JOIN dbo.ue AS ue ON stock.num_ue = ue.num_ue WHERE ligne.idPreparation = @idPreparation AND ue.etat_ue = 0 ;

						OPEN ligne_cursor
						FETCH NEXT FROM ligne_cursor INTO @numero_ue , @nombre_produit, @idLigneProduit 
						WHILE @@FETCH_STATUS = 0 
						BEGIN 
							SELECT @exist_num_ue = (SELECT u.SSCC FROM dbo.unite_expedition AS u WHERE u.SSCC = @numero_ue)
							IF @exist_num_ue IS NULL
							BEGIN
								INSERT INTO [unite_expedition] ([SSCC], [nombreProduits], [poidsProduits], [statut]) VALUES (@numero_ue,@nombre_produit,0,0);
								SELECT @totalUE_chargement = @totalUE_chargement +1;
							END
							/*update dUE in ligne_produit*/
							UPDATE [ligne_produit] SET ligne_produit.idUE = SCOPE_IDENTITY() WHERE ligne_produit.idLigneProduit = @idLigneProduit;

							FETCH NEXT FROM ligne_cursor INTO @numero_ue , @nombre_produit, @idLigneProduit
						END
						CLOSE ligne_cursor
						DEALLOCATE ligne_cursor

						INSERT INTO [chargement] ([numChargement],[idTransporteur],[dateChargement],[statutChargement],[last_update],[totalProduits_chargement],[totalPoids_chargement],[totalUE_chargement]) VALUES ('CHA-'+@NumPreparation, @idTransporteur, GETDATE(),0,GETDATE(),@totalProduits_chargement, @totalPoids_chargement,@totalUE_chargement);
						
						INSERT INTO [ligne_preparation_chargement] ([idPreparation],[idChargement],[last_update]) VALUES (@idPreparation, SCOPE_IDENTITY(), GETDATE());
					END
						END;");

	}

	public function fin_preparation_chargement(){
		DB::unprepared("CREATE TRIGGER [dbo].[trigger_chargement_preparation]
						ON [dbo].[preparation] AFTER UPDATE AS 
						 BEGIN
						 DECLARE
						@statutPreparation INT;
						SELECT @statutPreparation = ins.statutPreparation FROM INSERTED ins;

						 IF @statutPreparation =3
    						BEGIN
						DECLARE
						@idPreparation INT,
						@NumPreparation VARCHAR(50),
						@idTransporteur INT,
						@totalProduits_chargement INT,
						@totalPoids_chargement INT,
						@totalUE_chargement INT,
						@numero_ue VARCHAR(50),
						@nombre_produit INT,
						@exist_num_ue VARCHAR(50),
						@idLigneProduit INT;

						SELECT @idPreparation = ins.idPreparation FROM INSERTED ins;
						SELECT @NumPreparation = ins.numPreparation FROM INSERTED ins;
						SELECT @idTransporteur = ins.idTransporteur FROM INSERTED ins;
						SELECT @totalProduits_chargement = ins.nombreProduits FROM INSERTED ins;
						SELECT @totalPoids_chargement = ins.totalPoids FROM INSERTED ins;
						SELECT @totalUE_chargement = 0;
						SELECT @exist_num_ue =99;

						DECLARE ligne_cursor CURSOR FOR SELECT ue.num_ue, ue.nbr_produit, ligne.idLigneProduit FROM dbo.ligne_produit AS ligne JOIN dbo.stock_produit AS stock ON ligne.idStock = stock.id_stock_produit JOIN dbo.ue AS ue ON stock.num_ue = ue.num_ue WHERE ligne.idPreparation = @idPreparation AND ue.etat_ue = 0 ;

						OPEN ligne_cursor
						FETCH NEXT FROM ligne_cursor INTO @numero_ue , @nombre_produit, @idLigneProduit 
						WHILE @@FETCH_STATUS = 0 
						BEGIN
							SELECT @exist_num_ue = (SELECT u.SSCC FROM dbo.unite_expedition AS u WHERE u.SSCC = @numero_ue)
							IF @exist_num_ue IS NULL
							BEGIN
								INSERT INTO [unite_expedition] ([SSCC], [nombreProduits], [poidsProduits], [statut]) VALUES (@numero_ue,@nombre_produit,0,0);
								SELECT @totalUE_chargement = @totalUE_chargement +1;
							END

							/*update dUE in ligne_produit*/
							UPDATE [ligne_produit] SET ligne_produit.idUE = SCOPE_IDENTITY() WHERE ligne_produit.idLigneProduit = @idLigneProduit;

							FETCH NEXT FROM ligne_cursor INTO @numero_ue , @nombre_produit, @idLigneProduit
						END
						CLOSE ligne_cursor
						DEALLOCATE ligne_cursor

						INSERT INTO [chargement] ([numChargement],[idTransporteur],[dateChargement],[statutChargement],[last_update],[totalProduits_chargement],[totalPoids_chargement],[totalUE_chargement]) VALUES ('CHA-'+@NumPreparation, @idTransporteur, GETDATE(),0,GETDATE(),@totalProduits_chargement, @totalPoids_chargement,@totalUE_chargement);
						
						INSERT INTO [ligne_preparation_chargement] ([idPreparation],[idChargement],[last_update]) VALUES (@idPreparation, SCOPE_IDENTITY(), GETDATE());
					END
						END;");
	}
}