<?php

namespace App\Http\Controllers;

use App\ConfigurationPdf;
use App\Emplacement;
use App\Historique;
use App\Inventaire;
use App\LigneInventaire;
use App\ListValeur;
use App\StockProduit;
use App\Produit;
use App\Zone;
use App\Ue;
use App\Entite;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class InventaireController extends Controller
{

    public function index()
    {
		
        $inventaires=Inventaire::join('liste_valeur','liste_valeur.code','=','inventaire.statutInventaire')
            ->where('liste_valeur.nom_liste','=','STATUT_INVENTAIRE')
			//ne pas afficher les inventaires supprimé
            ->where('inventaire.supprimer',0)
			->orderBy('idInventaire','desc')
            ->get();

        return view('inventaire.index',compact('inventaires'));
    }

    public function delete($id){

        $inventaire = inventaire::join('liste_valeur', 'liste_valeur.code', '=', 'inventaire.statutInventaire')
                ->where('liste_valeur.nom_liste', '=', 'STATUT_INVENTAIRE')
                ->find($id);
        //si l'inventaire n'a pas été supprimer deja
        if($inventaire->supprimer == 0){
            
            //enregistrer dans l'historique
            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Les inventaires';
            $HistoriqueActions->description = 'Suppression de l\'inventaire   : '.$inventaire->numInventaire;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            //update statut inventaire
            $inventaire->supprimer = 1;
            $inventaire->last_update = date("Y-m-d H:i:s");
            $inventaire->update();

            return redirect('inventaire/index')->with('msgSupprimer',"L'inventaire ".$inventaire->numInventaire." a été supprimé  avec succès.");
        }else{
            return redirect('inventaire/index')->with('msgExist',"Impossible de supprimer l'inventaire ".$inventaire->numInventaire." car il est ".$inventaire->valeur.".");
        }
    }

    public function getForm(){
            $dateToday = date("Y-m-d");

            $emplacements=Emplacement::get();
            $zones =Zone::get();
			$ues = null;
            //$ues= Ue::get();
			/*$ues= collect();
            $collet= Ue::chunk(1000, function ($rows) use ($ues) {
                    foreach ($rows as $row) {
                        $ues->push($row);
                    }
                });*/
			//dd($ues);
            $entites = Entite::get();

        $lastNum =Inventaire::orderBy('idInventaire','desc')->first();
        if ($lastNum != null) {
            $NumInventaire = substr_replace($lastNum->numInventaire, "", 0, 3);
            if ($NumInventaire == 99999){
                $NumInventaire='INV00001';
            }
            else {
                $NumInventaire = $NumInventaire + 1;
                $NumInventaire=str_pad($NumInventaire, 5, '0', STR_PAD_LEFT);


                $NumInventaire ='INV'.$NumInventaire;
            }

        }
        else
            $NumInventaire='INV00001';

        return view('inventaire.ajouter',compact('emplacements','zones','dateToday','NumInventaire','ues','entites'));
    }

    public function postForm(Request $request){

        $numExist=Inventaire::where('numInventaire','=',$request->input('numInventaire'))->count();
        $designationExist=Inventaire::where('designationInventaire','=',$request->input('designation'))->count();

        if($numExist > 0)
        {
            return redirect()->back()->withInput()->with('msgAddExist','Numéro d\'inventaire existe déjà');
        }
        elseif($designationExist > 0) {

            return redirect()->back()->withInput()->with('msgAddExist','Désignation d\'inventaire existe déjà');
        }
        else{

                $Inventaire= new Inventaire();
                $Inventaire->numInventaire=$request->input('numInventaire');
                $Inventaire->designationInventaire=$request->input('designation');
                $Inventaire->dateDebut=$request->input('dateDebut');
                $Inventaire->typeInventaire=$request->input('idSelectType');
                $Inventaire->idZone=$request->input('idSelectZone');
                $Inventaire->idEmplacement=$request->input('idSelectEmplacement');
                $Inventaire->num_entite=$request->input('numero_entite');
                $Inventaire->num_ue=$request->input('numero_ue');
                $Inventaire->statutInventaire=0;
                $Inventaire->commentaire=$request->input('commentaire');
                $Inventaire->save();

                //add ligne inventaire avec ecart = null
                //inventaire total
                if($Inventaire->typeInventaire == 0){
                    $stock = StockProduit::where('quantite', "!=", 0)->with('emplacement')->get();
                    if ($stock != null) {
                        foreach ($stock as $key => $ligne) {
                            $ligneInventaire = new LigneInventaire; 
                            $ligneInventaire->idInventaire = $Inventaire->idInventaire;
                            $ligneInventaire->idStock = $ligne->id_stock_produit;
                            $ligneInventaire->idOperateur = 0;
                            $ligneInventaire->codeEmplacement = $ligne->emplacement->code_identification;
                            $ligneInventaire->quantiteComptee = 0;
                            $ligneInventaire->quantiteEstimee = $ligne->quantite_utilisable;
                            $ligneInventaire->ecart = 0;
                            if (Session::get('STOCK_ENTITE')== "1"){
                                $ligneInventaire->num_entite = $ligne->num_entite;
                            }
                            if (Session::get('STOCK_EMPLACEMENT_MOBILE')== "1"){
                                $ligneInventaire->num_ue = $ligne->num_ue;
                            }
                            $ligneInventaire->id_produit = $ligne->id_produit;
                            $ligneInventaire->save();
                        }
                    }else{
                        //message stock vide
                    }
                }
                if ($Inventaire->typeInventaire == 1) {
                    //récupérer les emp de la zone
                    $emplacements = Emplacement::where('id_zone',$request->input('idSelectZone'))->get(['id_emplacement']);
                    $emplacements = $emplacements->toArray();
                    if ($emplacements) {
                       $stock = StockProduit::where('quantite', "!=", 0)->whereIn('id_emplacement', $emplacements)->with('emplacement')->get();
                       if ($stock) {
                           foreach ($stock as $key => $ligne) {
                            $ligneInventaire = new LigneInventaire; 
                            $ligneInventaire->idInventaire = $Inventaire->idInventaire;
                            $ligneInventaire->idStock = $ligne->id_stock_produit;
                            $ligneInventaire->idOperateur = 0;
                            $ligneInventaire->codeEmplacement = $ligne->emplacement->code_identification;
                            $ligneInventaire->quantiteComptee = 0;
                            $ligneInventaire->quantiteEstimee = $ligne->quantite_utilisable;
                            $ligneInventaire->ecart = 0;
                            if (Session::get('STOCK_ENTITE')== "1"){
                                $ligneInventaire->num_entite = $ligne->num_entite;
                            }
                            if (Session::get('STOCK_EMPLACEMENT_MOBILE')== "1"){
                                $ligneInventaire->num_ue = $ligne->num_ue;
                            }
                            $ligneInventaire->id_produit = $ligne->id_produit;
                            $ligneInventaire->save();
                        }
                       }
                    }
                }
                if ($Inventaire->typeInventaire == 2) {
                       $stock = StockProduit::where('quantite', "!=", 0)->where('id_emplacement',$request->input('idSelectEmplacement') )->with('emplacement')->get();
                       if ($stock) {
                           foreach ($stock as $key => $ligne) {
                            $ligneInventaire = new LigneInventaire; 
                            $ligneInventaire->idInventaire = $Inventaire->idInventaire;
                            $ligneInventaire->idStock = $ligne->id_stock_produit;
                            $ligneInventaire->idOperateur = 0;
                            $ligneInventaire->codeEmplacement = $ligne->emplacement->code_identification;
                            $ligneInventaire->quantiteComptee = 0;
                            $ligneInventaire->quantiteEstimee = $ligne->quantite_utilisable;
                            $ligneInventaire->ecart = 0;
                            if (Session::get('STOCK_ENTITE')== "1"){
                                $ligneInventaire->num_entite = $ligne->num_entite;
                            }
                            if (Session::get('STOCK_EMPLACEMENT_MOBILE')== "1"){
                                $ligneInventaire->num_ue = $ligne->num_ue;
                            }
                            $ligneInventaire->id_produit = $ligne->id_produit;
                            $ligneInventaire->save();
                        }
                       }  
                }

                if ($Inventaire->typeInventaire == 3) {
                       $stock = StockProduit::where('quantite', "!=", 0)->where('num_entite',$request->input('numero_entite') )->with('emplacement')->get();
                       if ($stock) {
                           foreach ($stock as $key => $ligne) {
                            $ligneInventaire = new LigneInventaire; 
                            $ligneInventaire->idInventaire = $Inventaire->idInventaire;
                            $ligneInventaire->idStock = $ligne->id_stock_produit;
                            $ligneInventaire->idOperateur = 0;
                            $ligneInventaire->codeEmplacement = $ligne->emplacement->code_identification;
                            $ligneInventaire->quantiteComptee = 0;
                            $ligneInventaire->quantiteEstimee = $ligne->quantite_utilisable;
                            $ligneInventaire->ecart = 0;
                            if (Session::get('STOCK_ENTITE')== "1"){
                                $ligneInventaire->num_entite = $ligne->num_entite;
                            }
                            if (Session::get('STOCK_EMPLACEMENT_MOBILE')== "1"){
                                $ligneInventaire->num_ue = $ligne->num_ue;
                            }
                            $ligneInventaire->id_produit = $ligne->id_produit;
                            $ligneInventaire->save();
                        }
                       }  
                }

                if ($Inventaire->typeInventaire == 4) {
                       $stock = StockProduit::where('quantite', "!=", 0)->where('num_ue',$request->input('numero_ue') )->with('emplacement')->get();
                       if ($stock) {
                           foreach ($stock as $key => $ligne) {
                            $ligneInventaire = new LigneInventaire; 
                            $ligneInventaire->idInventaire = $Inventaire->idInventaire;
                            $ligneInventaire->idStock = $ligne->id_stock_produit;
                            $ligneInventaire->idOperateur = 0;
                            $ligneInventaire->codeEmplacement = $ligne->emplacement->code_identification;
                            $ligneInventaire->quantiteComptee = 0;
                            $ligneInventaire->quantiteEstimee = $ligne->quantite_utilisable;
                            $ligneInventaire->ecart = 0;
                            if (Session::get('STOCK_ENTITE')== "1"){
                                $ligneInventaire->num_entite = $ligne->num_entite;
                            }
                            if (Session::get('STOCK_EMPLACEMENT_MOBILE')== "1"){
                                $ligneInventaire->num_ue = $ligne->num_ue;
                            }
                            $ligneInventaire->id_produit = $ligne->id_produit;
                            $ligneInventaire->save();
                        }
                       }  
                }



               

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Les inventaires';
            $HistoriqueActions->description = 'Ajout d\'inventaire   : '.$Inventaire->numInventaire;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

                return redirect('inventaire/index')->with('msgAddSuccess','Inventaire ajouté avec succès');

            }

    }

    public function show(Request $request,$id)
    {
        if (($request->input("exportPdf") == 0) || ($request->input("exportPdf") == null)) {


            $Inventaire = inventaire::join('liste_valeur', 'liste_valeur.code', '=', 'inventaire.statutInventaire')
                ->where('liste_valeur.nom_liste', '=', 'STATUT_INVENTAIRE')
                ->find($id);
				
            $zone = Zone::where('id_zone', '=', $Inventaire->idZone)
                ->value('libelle');
            $emplacement = Emplacement::where('id_emplacement', '=', $Inventaire->idEmplacement)
                ->value('libelle');

            $entite = Entite::where('num_entite', '=', $Inventaire->num_entite)
                ->first();
            $ue = Ue::where('num_ue', '=', $Inventaire->num_ue)
                ->first();
			
			$LigneInventaire= collect();
            $collect = LigneInventaire::with('User')
                ->with('Stock.Produit')
                ->with('produit')
                ->with('Emplacement')
                ->where('idInventaire', '=', $id)
                ->where('flag_delete' ,'=',0)
				->chunk(500, function ($rows) use ($LigneInventaire) {
                    foreach ($rows as $row) {
                        $LigneInventaire->push($row);
                    }
                });
            //dd($LigneInventaire);

            return view('inventaire.detail', compact('Inventaire', 'LigneInventaire', 'emplacement', 'zone','entite','ue'));
        }
        else
        {
            if ($request->input("exportPdf") == 2) {
                $Inventaire = inventaire::join('liste_valeur', 'liste_valeur.code', '=', 'inventaire.statutInventaire')
                ->where('liste_valeur.nom_liste', '=', 'STATUT_INVENTAIRE')
                ->find($id);

                $zone = Zone::where('id_zone', '=', $Inventaire->idZone)
                ->value('libelle');

                $emplacement = Emplacement::where('id_emplacement', '=', $Inventaire->idEmplacement)
                ->value('libelle');

                $entite = Entite::where('num_entite', '=', $Inventaire->num_entite)
                ->first();

                $ue = Ue::where('num_ue', '=', $Inventaire->num_ue)
                ->first();

                $configuration = ConfigurationPdf::first();

               /* $LigneInventaire = LigneInventaire::with('User')
                ->with('Stock.Produit')
                ->with('Emplacement')
                ->where('idInventaire', '=', $id)->get();*/
				
				$LigneInventaire= collect();
				$collect = LigneInventaire::with('User')
                ->with('Stock.Produit')
                ->with('Emplacement')
                ->where('idInventaire', '=', $id)
                ->where('flag_delete' ,'=',0)
				->chunk(500, function ($rows) use ($LigneInventaire) {
                    foreach ($rows as $row) {
                        $LigneInventaire->push($row);
                    }
                });

                $LigneInventaire = $LigneInventaire->groupBy(function($item, $key){   
                    return $item["id_produit"];
                });

                //dd($LigneInventaire);
                 return view('inventaire.export.exportPDFProduit', compact('Inventaire', 'LigneInventaire', 'emplacement', 'zone','configuration','entite','ue'));
                
            }
            $Inventaire = inventaire::join('liste_valeur', 'liste_valeur.code', '=', 'inventaire.statutInventaire')
                ->where('liste_valeur.nom_liste', '=', 'STATUT_INVENTAIRE')
                ->find($id);
            $zone = Zone::where('id_zone', '=', $Inventaire->idZone)
                ->value('libelle');
            $emplacement = Emplacement::where('id_emplacement', '=', $Inventaire->idEmplacement)
                ->value('libelle');
            $entite = Entite::where('num_entite', '=', $Inventaire->num_entite)
                ->first();

            $ue = Ue::where('num_ue', '=', $Inventaire->num_ue)
                ->first();
                //dd($entite, $ue);

           /* $LigneInventaire = LigneInventaire::with('User')
                ->with('Stock.Produit')
                ->with('Emplacement')
                ->where('idInventaire', '=', $id)->get();*/
				
				$LigneInventaire= collect();
				$collect = LigneInventaire::with('User')
                ->with('Stock.Produit')
                ->with('Emplacement')
                ->where('idInventaire', '=', $id)
                ->where('flag_delete' ,'=',0)
				->chunk(500, function ($rows) use ($LigneInventaire) {
                    foreach ($rows as $row) {
                        $LigneInventaire->push($row);
                    }
                });
				
            $configuration = ConfigurationPdf::first();

            return view('inventaire.export.exportPDF', compact('Inventaire', 'LigneInventaire', 'emplacement', 'zone','configuration','entite','ue'));

        }
    }

    public function getEdit($id)
    {

        $Inventaire = inventaire::join('liste_valeur','liste_valeur.code','=','inventaire.statutInventaire')
            ->where('liste_valeur.nom_liste','=','STATUT_INVENTAIRE')
            ->find($id);

         //dd($Inventaire);
         $emplacement_choix = null;
         $zoneSelected = null;
         $entiteSelected = null;
         $ueSelected = null;
        if ($Inventaire->typeInventaire == 1) {
            $emplacement_choix = Emplacement::where('id_zone',$Inventaire->idZone)->get(); 
        }
        if ($Inventaire->typeInventaire == 2) {
            $zoneSelected = Emplacement::where('id_emplacement',$Inventaire->idEmplacement)->first(); 
            $zoneSelected = $zone=Zone::where('id_zone','=',$zoneSelected->id_zone)
            ->value('libelle');
        }
        if ($Inventaire->typeInventaire == 3) {
            $entiteSelected = Entite::where('num_entite',$Inventaire->num_entite)->first();          
        }
        if ($Inventaire->typeInventaire == 4) {
            $ueSelected = Ue::where('num_ue',$Inventaire->num_ue)->first();          
        }
		$LigneInventaire = collect();
        $collect = LigneInventaire::with('User')
            ->with('Stock.Produit')
            ->with('Emplacement')
            ->where('idInventaire','=',$id)
            ->where('flag_delete' ,'=',0)
			->chunk(500, function ($rows) use ($LigneInventaire) {
                    foreach ($rows as $row) {
                        $LigneInventaire->push($row);
                    }
                });

        $statuts=ListValeur::where('liste_valeur.nom_liste','=','STATUT_INVENTAIRE')
            ->get();

        $zone=Zone::where('id_zone','=',$Inventaire->idZone)
            ->value('libelle');
        $emplacement=Emplacement::where('id_emplacement','=',$Inventaire->idEmplacement)
            ->value('libelle');
            $entite = Entite::where('num_entite', '=', $Inventaire->num_entite)
                ->first();
            $ue = Ue::where('num_ue', '=', $Inventaire->num_ue)
                ->first();

        $zones = Zone::all();
        //$stock = StockProduit::all();
        $produits = Produit::all();
        $entites = Entite::all();
        $ues = Ue::all();




        return view('inventaire.modifier',compact('Inventaire','LigneInventaire','emplacement','zone','statuts','zones','stock','entite','ue','entites','ues','produits','emplacement_choix','zoneSelected','entiteSelected','ueSelected'));


    }
    public function postEdit(Request $request,$id)
    {

        $numExist=Inventaire::where('numInventaire','=',$request->input('numInventaire'))
            ->where('idInventaire','!=',$id)
            ->count();

        $designationExist=Inventaire::where('designationInventaire','=',$request->input('designation'))
            ->where('idInventaire','!=',$id)
            ->count();


        if($numExist > 0)
        {
            return redirect('inventaire/modifier/'.$id.'')->with('msgAddExist','Numéro d\'inventaire existe déjà');
        }
        elseif($designationExist >0)
        {

            return redirect('inventaire/modifier/'.$id.'')->with('msgAddExist','Désignation d\'inventaire existe déjà');

        }
        else
        {
            $statut=$request->input('statut');
            //dd($statut);
            //dd($statut == 2);
            $inventaire=Inventaire::find($id);


                $inventaire->numInventaire=$request->input('numInventaire');
                $inventaire->designationInventaire=$request->input('designation');
                $inventaire->commentaire=$request->input('commentaire');
                $inventaire->statutInventaire=$statut;

                if($statut == 2)
                {
                    $inventaire->dateFin=date('Y/m/d');

                    $LigneInvenatie=LigneInventaire::where('idInventaire','=',$id)
                        ->get();
                    foreach($LigneInvenatie as $ligne)
                    {
                        $emplacement=Emplacement::where('code_identification','=',$ligne->codeEmplacement)->get();
                        if($emplacement->first()!=null){
                            $emplacement=$emplacement->first()->id_emplacement;
                        }
                        
                        if ($ligne->idStock != 0 ) {
               $Stock=StockProduit::find($ligne->idStock);
                $Stock->quantite=$ligne->quantiteComptee;
                $Stock->quantite_utilisable=$ligne->quantiteComptee;
                $Stock->quantite_reelle=$ligne->quantiteComptee;
                $Stock->id_emplacement=$emplacement;
                $Stock->idInventaire=$id;
                $Stock->last_update= date("Y-m-d H:i:s");
                $Stock->update();
                //if ($ligne->quantiteComptee == 0 || $ligne->flag_delete == 1) {
                if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                    $ue = Ue::where('num_ue',$ligne->num_ue)->first();
                    if ($ue != null) {
                        $ue->id_emplacement = $emplacement;
                        $ue->last_update= date("Y-m-d H:i:s");
                        if ($ligne->quantiteComptee == 0) {
                            if ($ue->nbr_produit == 1 ) {
                                $ue->etat_ue = 2;//vide
                            }
                            $ue->nbr_produit -=1;
                        }
                        $ue->update();
                    }
                }
            }else{
                $Stock = new StockProduit();
                $Stock->date_entree = date("Y-m-d");
                $Stock->id_produit = $ligne->id_produit;
                if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                    $Stock->num_ue = $ligne->num_ue;
                    //mettre a jour id_emp dans la table ue
                    $ue = Ue::where('num_ue',$ligne->num_ue)->first();
                    if ($ue != null) {
                        $ue->id_emplacement = $emplacement;
                        $ue->nbr_produit +=1;
                        $ue->last_update= date("Y-m-d H:i:s");
                        $ue->update();
                    }
                }
                if (Session::get('STOCK_ENTITE') == '1') {
                    $Stock->num_entite = $ligne->num_entite;
                }
                $Stock->validation = 1;
                $Stock->quantite=$ligne->quantiteComptee;
                $Stock->quantite_utilisable=$ligne->quantiteComptee;
                $Stock->quantite_reelle=$ligne->quantiteComptee;
                $Stock->id_emplacement=$emplacement;
                $Stock->idInventaire=$id;
                $Stock->last_update= date("Y-m-d H:i:s");
                $Stock->save();
            }

                    }

                }
                $inventaire->last_update= date("Y-m-d H:i:s");
                $inventaire->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Les inventaires';
            $HistoriqueActions->description = 'Ajout d\'inventaire   : '.$inventaire->numInventaire;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

                return redirect('inventaire/index')->with('msgAjouter','Inventaire modifié avec succès');
            }

        }

    public function getEmplacement($id){
        $result = array();
        $emplacement = Emplacement::where('id_zone',$id)->get();
        $result =  $emplacement; 

        return response()->json($result);
    }

    public function insererUneLigneProduit(Request $request){
        $id_inventaire = $request->input('id_inventaire');
        $zone = $request->input('zonee');
        $id_emplacement = $request->input('emplacement');
        $produit_stock = $request->input('produit');
        $quantite_comptee = $request->input('quantiteCompte');
        $entite = $request->input('entite');
        $ue = $request->input('ue');
        //dd($zone);


        if ($zone =='' || $id_emplacement=='' || $produit_stock=='' || $quantite_comptee=='') {
            $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
            return redirect('inventaire/modifier/'.$id_inventaire);
        }
        if (Session::get('STOCK_ENTITE')) {
            if ($entite =='') {
                $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
                return redirect('inventaire/modifier/'.$id_inventaire);
            }
        }
        if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')=='1') {
            if ($ue =='') {
                $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
                return redirect('inventaire/modifier/'.$id_inventaire);
            }
        }

        $quantite_produit = Produit::find($produit_stock);
        $emplacement = Emplacement::find($id_emplacement);
        if (Session::get('STOCK_ENTITE') =='1') {
            $ligne = LigneInventaire::where('id_produit' ,'=',$produit_stock)
                                ->where('codeEmplacement' ,'=',$emplacement->code_identification)
                                ->where('num_entite' ,'=',$entite)
                                ->where('num_ue' ,'=',$ue)
                                ->where('idInventaire','=',$id_inventaire)->first();
        }else{
            if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')=='1') {
               $ligne = LigneInventaire::where('id_produit' ,'=',$produit_stock)
                                ->where('codeEmplacement' ,'=',$emplacement->code_identification)
                                ->where('num_ue' ,'=',$ue)
                                ->where('idInventaire','=',$id_inventaire)->first();
            }else{
                $ligne = LigneInventaire::where('id_produit' ,'=',$produit_stock)
                                ->where('codeEmplacement' ,'=',$emplacement->code_identification)
                                ->where('idInventaire','=',$id_inventaire)->first();
            }
        }
        

        if ($ligne != null) {
            $ligne->quantiteComptee = $quantite_comptee;
            $ligne->ecart = $quantite_comptee - 0;
            $ligne->idOperateur = Session::get('id');
            $ligne->flag_delete = 0;
            $ligne->update();

        }else{
            $stock = StockProduit::where('num_ue',$ue)->where('id_produit',$produit_stock)->first();
            //dd($ue,$entite);
            $ligneInventaire = new LigneInventaire; 
            $ligneInventaire->idInventaire = $id_inventaire;
            if ($stock == null) {
                $ligneInventaire->idStock = 0;
            }else{
                $ligneInventaire->idStock = $stock->id_stock_produit;
            }
            
            $ligneInventaire->idOperateur = Session::get('id');
            $ligneInventaire->codeEmplacement = $emplacement->code_identification;
            $ligneInventaire->quantiteComptee = $quantite_comptee;
            $ligneInventaire->quantiteEstimee = 0;
            $ligneInventaire->ecart = $quantite_comptee - 0;
            $ligneInventaire->id_produit = $quantite_produit->id_produit;
            if (Session::get('STOCK_ENTITE') =='1') {
               $ligneInventaire->num_entite = $entite;
            }
            if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')=='1') {
                $ligneInventaire->num_ue = $ue;
            }
            
            $ligneInventaire->save();
            //dd($ligneInventaire);
        }

        $inventaire = Inventaire::find($id_inventaire);
        $inventaire->simule_fo = 1 ;
        $inventaire->last_update= date("Y-m-d H:i:s");
        $inventaire->update();

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Simuler saisie FO';
        $HistoriqueActions->nom_table = 'Les inventaires';
        $HistoriqueActions->description = "Simulation de l'inventaire: ".$inventaire->numInventaire;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('inventaire/modifier/'.$id_inventaire)->with('msgAddSuccess','Produit ajouté avec succès');
    }

    public function cloture($id_inventaire){
        $inventaire = Inventaire::find($id_inventaire);
        $inventaire->statutInventaire = 2 ;
        $inventaire->dateFin=date('Y/m/d');
        $inventaire->last_update= date("Y-m-d H:i:s");
        $inventaire->update();

        $LigneInvenatie=LigneInventaire::where('idInventaire','=',$id_inventaire)->get();
        //dd($LigneInvenatie);
        foreach($LigneInvenatie as $ligne){

            $emplacement=Emplacement::where('code_identification','=',$ligne->codeEmplacement)->get();
            if($emplacement->first()!=null){
                $emplacement=$emplacement->first()->id_emplacement;
            }
            if ($ligne->idStock != 0 ) {
                $Stock=StockProduit::find($ligne->idStock);
              
                $Stock->quantite=$ligne->quantiteComptee;
                $Stock->quantite_utilisable=$ligne->quantiteComptee;
                $Stock->quantite_reelle=$ligne->quantiteComptee;
                $Stock->id_emplacement=$emplacement;
                $Stock->idInventaire=$id_inventaire;
                $Stock->last_update= date("Y-m-d H:i:s");
                $Stock->update();
                //mise a jour des emp des ue ...

                //if ($ligne->quantiteComptee == 0 || $ligne->flag_delete == 1) {
                if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                    $ue = Ue::where('num_ue',$ligne->num_ue)->first();
                    if ($ue != null) {
                        $ue->id_emplacement = $emplacement;
                        $ue->last_update= date("Y-m-d H:i:s");
                        if ($ligne->quantiteComptee == 0) {
                            if ($ue->nbr_produit == 1 ) {
                                $ue->etat_ue = 2;//vide
                            }
                            $ue->nbr_produit -=1;
                        }
                        $ue->update();
                    }
                }
              
            }else{
                $Stock = new StockProduit();
                $Stock->date_entree = date("Y-m-d");
                $Stock->id_produit = $ligne->id_produit;
                if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                    $Stock->num_ue = $ligne->num_ue;
                    //mettre a jour id_emp+ nbr de produit dans la table ue
                    $ue = Ue::where('num_ue',$ligne->num_ue)->first();
                    if ($ue != null) {
                        $ue->id_emplacement = $emplacement;
                        $ue->nbr_produit +=1;
                        $ue->last_update= date("Y-m-d H:i:s");
                        $ue->update();
                    }
                }
                if (Session::get('STOCK_ENTITE') == '1') {
                    $Stock->num_entite = $ligne->num_entite;
                }
                $Stock->validation = 1;
                $Stock->quantite=$ligne->quantiteComptee;
                $Stock->quantite_utilisable=$ligne->quantiteComptee;
                $Stock->quantite_reelle=$ligne->quantiteComptee;
                $Stock->id_emplacement=$emplacement;
                $Stock->idInventaire=$id_inventaire;
                $Stock->last_update= date("Y-m-d H:i:s");
                $Stock->save();
                //mise a jour des emp des ue...
                //
            }
            
            
        }

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Clôture';
        $HistoriqueActions->nom_table = 'Les inventaires';
        $HistoriqueActions->description = "Clôture de l'inventaire: ".$inventaire->numInventaire;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();


        
        return redirect('inventaire/detail/'.$id_inventaire)->with('msgAddSuccess','Inventaire cloturé avec succès');
    }

    public function modifier_ligne_produit(Request $request){

        $quantite_estimee = $request->input('quantite_e');
        $quantite_comptee = $request->input('quantite_C');
        $id_inventaire = $request->input('id_inventaire');
        $ligne_produit = $request->input('ligne_produit');
        
        $ligne = LigneInventaire::find($ligne_produit);
        $ligne->quantiteComptee = $quantite_comptee;
        $ligne->ecart = $quantite_comptee - $quantite_estimee;
        $ligne->idOperateur = Session::get('id');
        $ligne->update();

        $inventaire = Inventaire::find($id_inventaire);
        $inventaire->simule_fo = 1 ;
        $inventaire->last_update= date("Y-m-d H:i:s");
        $inventaire->update();

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Modification';
        $HistoriqueActions->nom_table = 'Les inventaires';
        $HistoriqueActions->description = "Simulation de l'inventaire: ".$inventaire->numInventaire;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('inventaire/modifier/'.$id_inventaire)->with('msgAddSuccess','La quantité comptée é été modifié avec succès');
    }

    public function destroyLigneInventaire(Request $request){
        $idInventaire = $request->input('idInventaire');
        $ligne_produit = $request->input('id_ligne_produit_delete');
        $ligne = LigneInventaire::find($ligne_produit);
        //$ligne->delete();
        $ligne->flag_delete = 1 ;
        $ligne->update();

        $inventaire = Inventaire::find($idInventaire);
        $inventaire->simule_fo = 1 ;
        $inventaire->last_update= date("Y-m-d H:i:s");
        $inventaire->update();

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Suppression';
        $HistoriqueActions->nom_table = 'Les inventaires';
        $HistoriqueActions->description = "Simulation de l'inventaire: ".$inventaire->numInventaire;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('inventaire/modifier/'.$idInventaire)->with('msgAddSuccess','Supprimé avec succès');
    }
}
