<?php

namespace App\Http\Controllers;

use App\DroitAccesMobile;
use App\Historique;
use App\ProfileMobile;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;


class GestionProfilMobileController extends Controller
{
	public function index()
	{
		if(Session::get('CONFIGURATION_FRONT_OFFICE')) {
		$profiles = ProfileMobile::with('DroitAccesMobile')->get();
		return view('configuration/profilacces/mobile/index',compact('profiles'));
		}
		else{
			return view('errors/404');
		}
	}


	public function ajouter(){
		if(Session::get('CONFIGURATION_FRONT_OFFICE_AJOUTER')) {

		return view('configuration/profilacces/mobile/ajouter');
		}
		else{
			return view('errors/404');
		}
	}

	public function addNewProfil(Request $request){
		$pr=ProfileMobile::where('libelle','=', $request->input('libelle'))->get();
		if($pr->first()==null) {
			$newProfile = new ProfileMobile();
			$newProfile->libelle = $request->input('libelle');
			$newProfile->date_last_update=date("Y-m-d H:i:s");

			$newProfile->save();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Configuration->Profil d\'accés->Front office';
            $HistoriqueActions->description = 'Ajout du profil front office : '.$newProfile->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

			for ($i = 1; $i <= 11; $i++) {
				$newAccess = new DroitAccesMobile();
				$newAccess->idProfile = $newProfile->id;

				switch ($i) {
					case 1 :
						if ($request->input($i) != null) {
							$newAccess->action = "RECEPTION";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "RECEPTION";
							$newAccess->droit = 0;
						}
						break;
					case 2 :
						if ($request->input($i) != null) {
							$newAccess->action = "PREPARATION";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "PREPARATION";
							$newAccess->droit = 0;
						}
						break;
					case 3 :
						if ($request->input($i) != null) {
							$newAccess->action = "CHARGEMENT";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "CHARGEMENT";
							$newAccess->droit = 0;
						}
						break;
					case 4 :
						if ($request->input($i) != null) {
							$newAccess->action = "INVENTAIRE";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "INVENTAIRE";
							$newAccess->droit = 0;
						}
						break;
					case 5 :
						if ($request->input($i) != null) {
							$newAccess->action = "ENTREPOT";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "ENTREPOT ";
							$newAccess->droit = 0;
						}
						break;
					case 6 :
						if ($request->input($i) != null) {
							$newAccess->action = "ENTREPOT_PRODUITS";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "ENTREPOT_PRODUITS";
							$newAccess->droit = 0;
						}
						break;
					case 7 :
						if ($request->input($i) != null) {
							$newAccess->action = "ENTREPOT_EMPLACEMENTS";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "ENTREPOT_EMPLACEMENTS";
							$newAccess->droit = 0;
						}
						break;
					case 8 :
						if ($request->input($i) != null) {
							$newAccess->action = "ENTREPOT_TRANSFERT";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "ENTREPOT_TRANSFERT";
							$newAccess->droit = 0;
						}
						break;
					case 9 :
						if ($request->input($i) != null) {
							$newAccess->action = "SYNCHRONISATION";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "SYNCHRONISATION";
							$newAccess->droit = 0;
						}
						break;
						case 10 :
						if ($request->input($i) != null) {
							$newAccess->action = "ENTREPOT_PRODUITS_QNT";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "ENTREPOT_PRODUITS_QNT";
							$newAccess->droit = 0;
						}
						break;
						case 11 :
						if ($request->input($i) != null) {
							$newAccess->action = "ENTREPOT_PRODUCTION";
							$newAccess->droit = 1;
						} else {
							$newAccess->action = "ENTREPOT_PRODUCTION";
							$newAccess->droit = 0;
						}
						break;
				}
				$newAccess->date_last_update=date("Y-m-d H:i:s");
				$newAccess->save();
			}
			return redirect('profil/mobile');

		}else{
			return redirect('configuration/profilacces/mobile/ajouter' )->with('msgIdf', 'libellé existe déjà');
		}

	}

	public function supprimer($id){
		$users=User::where('idProfilDroit','=',$id)->where('profil','=',1)->get();
		if($users->first()==null) {
			$profile=ProfileMobile::find($id);

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Configuration->Profil d\'accés->Front office';
            $HistoriqueActions->description = 'Suppression du profil front office : '.$profile->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $profile->delete();

			DroitAccesMobile::where('idProfile', '=', $id)->delete();

			return redirect('profil/mobile');
		}else{
			return redirect('profil/mobile')->with('msgIdf', 'Impossible de supprimer ce profil');;
		}
	}

	public function modifier($id){

		$profile = ProfileMobile::where('id','=',$id)->with('DroitAccesMobile')->first();
		//dd($profile);
		$count = DroitAccesMobile::where('idProfile','=',$id)->where('droit','=',1)->count();
		return view('configuration/profilacces/mobile/modifier',compact('profile','count'));
	}

	public function editProfil(Request $request,$id){
		$pr=ProfileMobile::where('libelle','=', $request->input('libelle'))->where('id','!=',$id)->get();
		if($pr->first()==null) {
			$profil = ProfileMobile::find($id);
			$profil->libelle = $request->input('libelle');
			$profil->date_last_update=date("Y-m-d H:i:s");

			$profil->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Configuration->Profil d\'accés->Front office';
            $HistoriqueActions->description = 'Modification du profil front office : '.$profil->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

			for ($i = 1; $i <= 11; $i++) {
				switch ($i) {
					case 1 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "RECEPTION")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "RECEPTION")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 2 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "PREPARATION")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "PREPARATION")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 3 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "CHARGEMENT")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "CHARGEMENT")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 4 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "INVENTAIRE")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "INVENTAIRE")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 5 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT ")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 6 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_PRODUITS")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_PRODUITS")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 7 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_EMPLACEMENTS")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_EMPLACEMENTS")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 8 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_TRANSFERT")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_TRANSFERT")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
					case 9 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "SYNCHRONISATION")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "SYNCHRONISATION")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
						case 10 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_PRODUITS_QNT")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_PRODUITS_QNT")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;
						case 11 :
						if ($request->input($i) != null) {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_PRODUCTION")->update(['droit' => 1,'date_last_update'=>date("Y-m-d H:i:s")]);
						} else {
							DroitAccesMobile::where('idProfile', '=', $id)->where('action', '=', "ENTREPOT_PRODUCTION")->update(['droit' => 0,'date_last_update'=>date("Y-m-d H:i:s")]);
						}
						break;

				}
			}

			return redirect('profil/mobile');
		}else{
			return redirect('configuration/profilacces/mobile/modifier'.$id )->with('msgIdf', 'libellé existe déjà');
		}
	}
}