<?php

namespace App\Http\Controllers;

use App\DroitAccesBackoffice;
use App\Historique;
use App\ProfilBackoffice;
use App\ProfilMobile;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class GestionProfilBackofficeController extends Controller
{
	public function index()
	{
		if(Session::get('CONFIGURATION_BACK_OFFICE')) {
			$profiles = ProfilBackoffice::with('DroitAccesBackoffice')->get();
			//dd($profiles);
			return view('configuration/profilacces/backoffice/index', compact('profiles'));
		}
		else{
			return view('errors/404');
		}
	}


	public function ajouter(){

	if(Session::get('CONFIGURATION_BACK_OFFICE_AJOUTER')) {
			return view('configuration/profilacces/backoffice/ajouter');
		}
		else{
			return view('errors/404');
		}

	}

	public function addNewProfil(Request $request){

		$pr=ProfilBackoffice::where('libelle','=', $request->input('libelle'))->get();
		if($pr->first()==null) {
		$newProfile = new ProfilBackoffice();
		$newProfile->libelle = $request->input('libelle');
		$newProfile->save();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Configuration->Profil d\'accés->Back office';
            $HistoriqueActions->description = 'Ajout du profil back office : '.$newProfile->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

		for ($i = 1 ; $i <= 125 ; $i++){
			$newAccess = new DroitAccesBackoffice();
			$newAccess->idProfil = $newProfile->id;
			$newAccess->date_last_update = date("Y-m-d H:i:s");

			switch ($i){
				case 1 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION"; $newAccess->droit = 0;} break;
				case 2 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UTILISATEURS"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UTILISATEURS"; $newAccess->droit = 0;} break;
				case 3 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UTILISATEURS_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UTILISATEURS_AJOUTER"; $newAccess->droit = 0;} break;
				case 4 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UTILISATEURS_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UTILISATEURS_MODIFIER"; $newAccess->droit = 0;} break;
				case 5 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UTILISATEURS_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UTILISATEURS_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 6 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_CATEGORIES"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_CATEGORIES"; $newAccess->droit = 0;} break;
				case 7 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_CATEGORIES_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_CATEGORIES_AJOUTER"; $newAccess->droit = 0;} break;
				case 8 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_CATEGORIES_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_CATEGORIES_MODIFIER"; $newAccess->droit = 0;} break;
				case 9 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_CATEGORIES_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_CATEGORIES_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 10 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UNITES_MESURE"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UNITES_MESURE"; $newAccess->droit = 0;} break;
				case 11 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UNITES_MESURE_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UNITES_MESURE_AJOUTER"; $newAccess->droit = 0;} break;
				case 12 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UNITES_MESURE_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UNITES_MESURE_MODIFIER"; $newAccess->droit = 0;} break;
				case 13 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UNITES_MESURE_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UNITES_MESURE_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 14 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_PRODUITS"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_PRODUITS"; $newAccess->droit = 0;} break;
				case 15 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_PRODUITS_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_PRODUITS_AJOUTER"; $newAccess->droit = 0;} break;
				case 16 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_PRODUITS_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_PRODUITS_MODIFIER"; $newAccess->droit = 0;} break;
				case 17 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_PRODUITS_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_PRODUITS_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 18 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT"; $newAccess->droit = 0;} break;
				case 19 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT_AJOUTER"; $newAccess->droit = 0;} break;
				case 20 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT_MODIFIER"; $newAccess->droit = 0;} break;
				case 21 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ZONES_ENTREPOT_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 22 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_EMPLACEMENTS"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_EMPLACEMENTS"; $newAccess->droit = 0;} break;
				case 23 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_EMPLACEMENTS_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_EMPLACEMENTS_AJOUTER"; $newAccess->droit = 0;} break;
				case 24 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_EMPLACEMENTS_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_EMPLACEMENTS_MODIFIER"; $newAccess->droit = 0;} break;
				case 25 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_EMPLACEMENTS_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_EMPLACEMENTS_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 26 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK"; $newAccess->droit = 0;} break;
				case 27 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_AJOUTER"; $newAccess->droit = 0;} break;
				case 28 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_MODIFIER"; $newAccess->droit = 0;} break;
				case 29 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 30 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS"; $newAccess->droit = 0;} break;
				case 31 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_LISTE"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_LISTE"; $newAccess->droit = 0;} break;
				case 32 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_LISTE_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_LISTE_AJOUTER"; $newAccess->droit = 0;} break;
				case 33 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_LISTE_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_LISTE_MODIFIER"; $newAccess->droit = 0;} break;
				case 34 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_LISTE_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_LISTE_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 35 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_COMMANDES"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_COMMANDES	"; $newAccess->droit = 0;} break;
				case 36 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_COMMANDES_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_COMMANDES_AJOUTER"; $newAccess->droit = 0;} break;
				case 37 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_COMMANDES_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_COMMANDES_MODIFIER"; $newAccess->droit = 0;} break;
				case 38 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_COMMANDES_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_COMMANDES_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 39 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION"; $newAccess->droit = 0;} break;
				case 40 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION_AJOUTER"; $newAccess->droit = 0;} break;
				case 41 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION_MODIFIER"; $newAccess->droit = 0;} break;
				case 42 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 43 : if($request->input($i) != null) { $newAccess->action = "CLIENT"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT"; $newAccess->droit = 0;} break;
				case 44 : if($request->input($i) != null) { $newAccess->action = "CLIENT_COMMANDES"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_COMMANDES"; $newAccess->droit = 0;} break;
				case 45 : if($request->input($i) != null) { $newAccess->action = "CLIENT_COMMANDES_IMPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_COMMANDES_IMPORTER"; $newAccess->droit = 0;} break;
				case 46 : if($request->input($i) != null) { $newAccess->action = "CLIENT_COMMANDES_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_COMMANDES_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 47 : if($request->input($i) != null) { $newAccess->action = "CLIENT_TRANSPORTEURS"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_TRANSPORTEURS"; $newAccess->droit = 0;} break;
				case 48 : if($request->input($i) != null) { $newAccess->action = "CLIENT_TRANSPORTEURS_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_TRANSPORTEURS_AJOUTER"; $newAccess->droit = 0;} break;
				case 49 : if($request->input($i) != null) { $newAccess->action = "CLIENT_TRANSPORTEURS_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_TRANSPORTEURS_MODIFIER"; $newAccess->droit = 0;} break;
				case 50 : if($request->input($i) != null) { $newAccess->action = "CLIENT_TRANSPORTEURS_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_TRANSPORTEURS_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 51 : if($request->input($i) != null) { $newAccess->action = "CLIENT_PREPARATION"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_PREPARATION"; $newAccess->droit = 0;} break;
				case 52 : if($request->input($i) != null) { $newAccess->action = "CLIENT_PREPARATION_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_PREPARATION_AJOUTER"; $newAccess->droit = 0;} break;
				case 53 : if($request->input($i) != null) { $newAccess->action = "CLIENT_PREPARATION_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_PREPARATION_MODIFIER"; $newAccess->droit = 0;} break;
				case 54 : if($request->input($i) != null) { $newAccess->action = "CLIENT_PREPARATION_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_PREPARATION_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 55 : if($request->input($i) != null) { $newAccess->action = "CLIENT_CHARGEMENT"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_CHARGEMENT"; $newAccess->droit = 0;} break;
				case 56 : if($request->input($i) != null) { $newAccess->action = "CLIENT_CHARGEMENT_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_CHARGEMENT_AJOUTER"; $newAccess->droit = 0;} break;
				case 57 : if($request->input($i) != null) { $newAccess->action = "CLIENT_CHARGEMENT_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_CHARGEMENT_MODIFIER"; $newAccess->droit = 0;} break;
				case 58 : if($request->input($i) != null) { $newAccess->action = "CLIENT_CHARGEMENT_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_CHARGEMENT_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 59 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIVRAISONS"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIVRAISONS"; $newAccess->droit = 0;} break;
				case 60 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIVRAISONS_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIVRAISONS_AJOUTER"; $newAccess->droit = 0;} break;
				case 61 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIVRAISONS_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIVRAISONS_MODIFIER"; $newAccess->droit = 0;} break;
				case 62 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIVRAISONS_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIVRAISONS_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 63 : if($request->input($i) != null) { $newAccess->action = "INVENTAIRES"; $newAccess->droit = 1;} else {$newAccess->action = "INVENTAIRES"; $newAccess->droit = 0;} break;
				case 64 : if($request->input($i) != null) { $newAccess->action = "INVENTAIRES_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "INVENTAIRES_AJOUTER"; $newAccess->droit = 0;} break;
				case 65 : if($request->input($i) != null) { $newAccess->action = "INVENTAIRES_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "INVENTAIRES_MODIFIER"; $newAccess->droit = 0;} break;
				case 66 : if($request->input($i) != null) { $newAccess->action = "INVENTAIRES_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "INVENTAIRES_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 67 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION"; $newAccess->droit = 0;} break;
				case 68 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_RAPPORT_PDF"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_RAPPORT_PDF"; $newAccess->droit = 0;} break;
				case 69 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_PROFIL_ACCES"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_PROFIL_ACCES"; $newAccess->droit = 0;} break;
				case 70 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_BACK_OFFICE"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_BACK_OFFICE"; $newAccess->droit = 0;} break;
				case 71 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_BACK_OFFICE_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_BACK_OFFICE_AJOUTER"; $newAccess->droit = 0;} break;
				case 72 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_BACK_OFFICE_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_BACK_OFFICE_MODIFIER"; $newAccess->droit = 0;} break;
				case 73 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_BACK_OFFICE_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_BACK_OFFICE_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 74 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_FRONT_OFFICE"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_FRONT_OFFICE"; $newAccess->droit = 0;} break;
				case 75 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_FRONT_OFFICE_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_FRONT_OFFICE_AJOUTER"; $newAccess->droit = 0;} break;
				case 76 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_FRONT_OFFICE_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_FRONT_OFFICE_MODIFIER"; $newAccess->droit = 0;} break;
				case 77 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_FRONT_OFFICE_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_FRONT_OFFICE_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 78 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_PREFERENCES"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_PREFERENCES"; $newAccess->droit = 0;} break;
				case 79 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_PREFERENCES_CONFIGURER"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_PREFERENCES_CONFIGURER"; $newAccess->droit = 0;} break;
				case 80 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_UTILISATEURS_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_UTILISATEURS_DETAIL"; $newAccess->droit = 0;} break;
				case 81 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_LISTE_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_LISTE_DETAIL"; $newAccess->droit = 0;} break;
				case 82 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_COMMANDES_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_COMMANDES_DETAIL"; $newAccess->droit = 0;} break;
				case 83 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION_DETAIL"; $newAccess->droit = 0;} break;
				case 84 : if($request->input($i) != null) { $newAccess->action = "CLIENT_COMMANDES_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_COMMANDES_DETAIL"; $newAccess->droit = 0;} break;
				case 85 : if($request->input($i) != null) { $newAccess->action = "CLIENT_PREPARATION_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_PREPARATION_DETAIL"; $newAccess->droit = 0;} break;
				case 86 : if($request->input($i) != null) { $newAccess->action = "CLIENT_CHARGEMENT_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_CHARGEMENT_DETAIL"; $newAccess->droit = 0;} break;
				case 87 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIVRAISONS_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIVRAISONS_DETAIL"; $newAccess->droit = 0;} break;
				case 88 : if($request->input($i) != null) { $newAccess->action = "INVENTAIRES_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "INVENTAIRES_DETAIL"; $newAccess->droit = 0;} break;
				case 89 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_BACK_OFFICE_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_BACK_OFFICE_DETAIL"; $newAccess->droit = 0;} break;
				case 90 : if($request->input($i) != null) { $newAccess->action = "CONFIGURATION_FRONT_OFFICE_DETAIL"; $newAccess->droit = 1;} else {$newAccess->action = "CONFIGURATION_FRONT_OFFICE_DETAIL"; $newAccess->droit = 0;} break;
				case 91 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIST"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIST"; $newAccess->droit = 0;} break;
				case 92 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIST_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIST_AJOUTER"; $newAccess->droit = 0;} break;
				case 93 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIST_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIST_MODIFIER"; $newAccess->droit = 0;} break;
				case 94 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIST_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIST_SUPPRIMER"; $newAccess->droit = 0;} break;
				case 95 : if($request->input($i) != null) { $newAccess->action = "HISTORIQUES"; $newAccess->droit = 1;} else {$newAccess->action = "HISTORIQUES"; $newAccess->droit = 0;} break;
				case 96 : if($request->input($i) != null) { $newAccess->action = "TRACABILITE_PROFIL"; $newAccess->droit = 1;} else {$newAccess->action = "TRACABILITE_PROFIL"; $newAccess->droit = 0;} break;
				case 97 : if($request->input($i) != null) { $newAccess->action = "PRODUCTION_PROFIL"; $newAccess->droit = 1;} else {$newAccess->action = "PRODUCTION_PROFIL"; $newAccess->droit = 0;} break;
				case 98 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION_SIMULER_FO"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION_SIMULER_FO"; $newAccess->droit = 0;} break;
				case 99 : if($request->input($i) != null) { $newAccess->action = "CLIENT_PREPARATION_SIMULER_FO"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_PREPARATION_SIMULER_FO"; $newAccess->droit = 0;} break;
				case 100 : if($request->input($i) != null) { $newAccess->action = "INVENTAIRES_SIMULER_FO"; $newAccess->droit = 1;} else {$newAccess->action = "INVENTAIRES_SIMULER_FO"; $newAccess->droit = 0;} break;
				case 101 : if($request->input($i) != null) { $newAccess->action = "TRANSFERT"; $newAccess->droit = 1;} else {$newAccess->action = "TRANSFERT"; $newAccess->droit = 0;} break;
                case 102 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ENTITE"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ENTITE"; $newAccess->droit = 0;} break;
                case 103 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ENTITE_AJOUTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ENTITE_AJOUTER"; $newAccess->droit = 0;} break;
                case 104 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ENTITE_MODIFIER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ENTITE_MODIFIER"; $newAccess->droit = 0;} break;
                case 105 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_ENTITE_SUPPRIMER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_ENTITE_SUPPRIMER"; $newAccess->droit = 0;} break;
                case 106 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_PRODUITS_IMPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_PRODUITS_IMPORTER"; $newAccess->droit = 0;} break;
                case 107 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_PRODUITS_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_PRODUITS_EXPORTER"; $newAccess->droit = 0;} break;
                case 108 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_EMPLACEMENTS_IMPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_EMPLACEMENTS_IMPORTER"; $newAccess->droit = 0;} break;
                case 109 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_EMPLACEMENTS_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_EMPLACEMENTS_EXPORTER"; $newAccess->droit = 0;} break;
                case 110 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_COMMANDES_IMPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_COMMANDES_IMPORTER"; $newAccess->droit = 0;} break;
                case 111 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_COMMANDES_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_COMMANDES_EXPORTER"; $newAccess->droit = 0;} break;
                case 112 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION_IMPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION_IMPORTER"; $newAccess->droit = 0;} break;
                case 113 : if($request->input($i) != null) { $newAccess->action = "FOURNISSEURS_RECEPTION_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "FOURNISSEURS_RECEPTION_EXPORTER"; $newAccess->droit = 0;} break;
                case 114 : if($request->input($i) != null) { $newAccess->action = "CLIENT_PREPARATION_IMPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_PREPARATION_IMPORTER"; $newAccess->droit = 0;} break;
                case 115 : if($request->input($i) != null) { $newAccess->action = "CLIENT_CHARGEMENT_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_CHARGEMENT_EXPORTER"; $newAccess->droit = 0;} break;
                case 116 : if($request->input($i) != null) { $newAccess->action = "CLIENT_LIVRAISONS_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_LIVRAISONS_EXPORTER"; $newAccess->droit = 0;} break;
                case 117 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_EXPORTER"; $newAccess->droit = 0;} break;
                case 118 : if($request->input($i) != null) { $newAccess->action = "CLIENT_COMMANDES_EXPORTER"; $newAccess->droit = 1;} else {$newAccess->action = "CLIENT_COMMANDES_EXPORTER"; $newAccess->droit = 0;} break;
                case 119 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_ZONE"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_ZONE"; $newAccess->droit = 0;} break;
                case 120 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_EMPLACEMENT"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_EMPLACEMENT"; $newAccess->droit = 0;} break;
                case 121 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_ENTITE"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_ENTITE"; $newAccess->droit = 0;} break;
                case 122 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_UE"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_UE"; $newAccess->droit = 0;} break;
                case 123 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_REFERENCE"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_REFERENCE"; $newAccess->droit = 0;} break;
                case 124 : if($request->input($i) != null) { $newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_DESIGNATION"; $newAccess->droit = 1;} else {$newAccess->action = "ADMINISTRATION_STOCK_FILTRER_PAR_DESIGNATION"; $newAccess->droit = 0;} break;
			}
			$newAccess->date_last_update=date("Y-m-d H:i:s");
			$newAccess->save();

		}

		return redirect('profil/backoffice');
		}else{
			return redirect('configuration/profilacces/backoffice/ajouter' )->with('msgIdf', 'libellé existe déjà');
		}
	}

	public function supprimer($id){

		if(Session::get('CONFIGURATION_BACK_OFFICE_SUPPRIMER')) {
			$profil=ProfilBackoffice::find($id);

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Configuration->Profil d\'accés->Back office';
            $HistoriqueActions->description = 'Suppression du profil back office : '.$profil->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $profil->delete();

			DroitAccesBackoffice::where('idProfil', '=', $id)->delete();
			$profil=ProfilBackoffice::where('default_profil','=',1)->get();
			if($profil->first()!=null) {
				User::where('idProfilDroit', '=', $id)->update(['idProfilDroit' => $profil->first()->id]);
			}

			return redirect('profil/backoffice');
		}
		else{
			return view("errors/404");
		}
	}

	public function modifier($id){

		if(Session::get('CONFIGURATION_BACK_OFFICE_MODIFIER')) {
			$profile = ProfilBackoffice::where('id', '=', $id)->with('DroitAccesBackoffice')->first();
			//dd($profile->DroitAccesBackoffice[118]);
			$count = DroitAccesBackoffice::where('idProfil', '=', $id)->where('droit', '=', 1)->count();
			//dd($count);
			return view('configuration/profilacces/backoffice/modifier', compact('profile', 'count'));
		}
		else{
			return view("errors/404");
		}
	}

	public function editProfil(Request $request,$id){
		$pr=ProfilBackoffice::where('libelle','=', $request->input('libelle'))->where('id','!=',$id)->get();
		if($pr->first()==null) {

		$profil = ProfilBackoffice::find($id);
		$profil->libelle= $request->input('libelle');
		$profil->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Configuration->Profil d\'accés->Back office';
            $HistoriqueActions->description = 'Modification du profil back office : '.$profil->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

		for ($i = 1 ; $i <= 125 ; $i++){

			switch ($i){
				case 1 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION")->update(['droit' => 0]);} break;
				case 2 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS")->update(['droit' => 0]);} break;
				case 3 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_AJOUTER")->update(['droit' => 0]);} break;
				case 4 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_MODIFIER")->update(['droit' => 0]);} break;
				case 5 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_SUPPRIMER")->update(['droit' => 0]);} break;
				case 6 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES")->update(['droit' => 0]);} break;
				case 7 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES_AJOUTER")->update(['droit' => 0]);} break;
				case 8 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES_MODIFIER")->update(['droit' => 0]);} break;
				case 9 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_CATEGORIES_SUPPRIMER")->update(['droit' => 0]);} break;
				case 10 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE")->update(['droit' => 0]);} break;
				case 11 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE_AJOUTER")->update(['droit' => 0]);} break;
				case 12 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE_MODIFIER")->update(['droit' => 0]);} break;
				case 13 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UNITES_MESURE_SUPPRIMER")->update(['droit' => 0]);} break;
				case 14 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS")->update(['droit' => 0]);} break;
				case 15 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_AJOUTER")->update(['droit' => 0]);} break;
				case 16 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_MODIFIER")->update(['droit' => 0]);} break;
				case 17 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_SUPPRIMER")->update(['droit' => 0]);} break;
				case 18 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT")->update(['droit' => 0]);} break;
				case 19 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT_AJOUTER")->update(['droit' => 0]);} break;
				case 20 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT_MODIFIER")->update(['droit' => 0]);} break;
				case 21 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ZONES_ENTREPOT_SUPPRIMER")->update(['droit' => 0]);} break;
				case 22 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS")->update(['droit' => 0]);} break;
				case 23 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_AJOUTER")->update(['droit' => 0]);} break;
				case 24 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_MODIFIER")->update(['droit' => 0]);} break;
				case 25 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_SUPPRIMER")->update(['droit' => 0]);} break;
				case 26 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK")->update(['droit' => 0]);} break;
				case 27 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_AJOUTER")->update(['droit' => 0]);} break;
				case 28 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_MODIFIER")->update(['droit' => 0]);} break;
				case 29 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_SUPPRIMER")->update(['droit' => 0]);} break;
				case 30 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS")->update(['droit' => 0]);} break;
				case 31 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE")->update(['droit' => 0]);} break;
				case 32 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_AJOUTER")->update(['droit' => 0]);} break;
				case 33 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_MODIFIER")->update(['droit' => 0]);} break;
				case 34 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_SUPPRIMER")->update(['droit' => 0]);} break;
				case 35 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES	")->update(['droit' => 0]);} break;
				case 36 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_AJOUTER")->update(['droit' => 0]);} break;
				case 37 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_MODIFIER")->update(['droit' => 0]);} break;
				case 38 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_SUPPRIMER")->update(['droit' => 0]);} break;
				case 39 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION")->update(['droit' => 0]);} break;
				case 40 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_AJOUTER")->update(['droit' => 0]);} break;
				case 41 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_MODIFIER")->update(['droit' => 0]);} break;
				case 42 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_SUPPRIMER")->update(['droit' => 0]);} break;
				case 43 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT")->update(['droit' => 0]);} break;
				case 44 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES")->update(['droit' => 0]);} break;
				case 45 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_IMPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_IMPORTER")->update(['droit' => 0]);} break;
				case 46 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_SUPPRIMER")->update(['droit' => 0]);} break;
				case 47 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS")->update(['droit' => 0]);} break;
				case 48 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS_AJOUTER")->update(['droit' => 0]);} break;
				case 49 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS_MODIFIER")->update(['droit' => 0]);} break;
				case 50 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_TRANSPORTEURS_SUPPRIMER")->update(['droit' => 0]);} break;
				case 51 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION")->update(['droit' => 0]);} break;
				case 52 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_AJOUTER")->update(['droit' => 0]);} break;
				case 53 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_MODIFIER")->update(['droit' => 0]);} break;
				case 54 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_SUPPRIMER")->update(['droit' => 0]);} break;
				case 55 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT")->update(['droit' => 0]);} break;
				case 56 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_AJOUTER")->update(['droit' => 0]);} break;
				case 57 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_MODIFIER")->update(['droit' => 0]);} break;
				case 58 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_SUPPRIMER")->update(['droit' => 0]);} break;
				case 59 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS")->update(['droit' => 0]);} break;
				case 60 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_AJOUTER")->update(['droit' => 0]);} break;
				case 61 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_MODIFIER")->update(['droit' => 0]);} break;
				case 62 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_SUPPRIMER")->update(['droit' => 0]);} break;
				case 63 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES")->update(['droit' => 0]);} break;
				case 64 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_AJOUTER")->update(['droit' => 0]);} break;
				case 65 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_MODIFIER")->update(['droit' => 0]);} break;
				case 66 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_SUPPRIMER")->update(['droit' => 0]);} break;
				case 67 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION")->update(['droit' => 0]);} break;
				case 68 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_RAPPORT_PDF")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_RAPPORT_PDF")->update(['droit' => 0]);} break;
				case 69 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_PROFIL_ACCES")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_PROFIL_ACCES")->update(['droit' => 0]);} break;
				case 70 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE")->update(['droit' => 0]);} break;
				case 71 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_AJOUTER")->update(['droit' => 0]);} break;
				case 72 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_MODIFIER")->update(['droit' => 0]);} break;
				case 73 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_SUPPRIMER")->update(['droit' => 0]);} break;
				case 74 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE")->update(['droit' => 0]);} break;
				case 75 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_AJOUTER")->update(['droit' => 0]);} break;
				case 76 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_MODIFIER")->update(['droit' => 0]);} break;
				case 77 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_SUPPRIMER")->update(['droit' => 0]);} break;
				case 78 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_PREFERENCES")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_PREFERENCES")->update(['droit' => 0]);} break;
				case 79 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_PREFERENCES_CONFIGURER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_PREFERENCES_CONFIGURER")->update(['droit' => 0]);} break;
				case 80 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_UTILISATEURS_DETAIL")->update(['droit' => 0]);} break;
				case 81 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_LISTE_DETAIL")->update(['droit' => 0]);} break;
				case 82 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_DETAIL")->update(['droit' => 0]);} break;
				case 83 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_DETAIL")->update(['droit' => 0]);} break;
				case 84 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_DETAIL")->update(['droit' => 0]);} break;
				case 85 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_DETAIL")->update(['droit' => 0]);} break;
				case 86 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_DETAIL")->update(['droit' => 0]);} break;
				case 87 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_DETAIL")->update(['droit' => 0]);} break;
				case 88 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_DETAIL")->update(['droit' => 0]);} break;
				case 89 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_BACK_OFFICE_DETAIL")->update(['droit' => 0]);} break;
				case 90 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_DETAIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CONFIGURATION_FRONT_OFFICE_DETAIL")->update(['droit' => 0]);} break;
				case 91 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST")->update(['droit' => 0]);} break;
				case 92 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST_AJOUTER")->update(['droit' => 0]);} break;
				case 93 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST_MODIFIER")->update(['droit' => 0]);} break;
				case 94 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIST_SUPPRIMER")->update(['droit' => 0]);} break;
				case 95 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"HISTORIQUES")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"HISTORIQUES")->update(['droit' => 0]);} break;
				case 96 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"TRACABILITE_PROFIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"TRACABILITE_PROFIL")->update(['droit' => 0]);} break;
				case 97 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"PRODUCTION_PROFIL")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"PRODUCTION_PROFIL")->update(['droit' => 0]);} break;
				case 98 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_SIMULER_FO")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_SIMULER_FO")->update(['droit' => 0]);} break;
				case 99 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_SIMULER_FO")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_SIMULER_FO")->update(['droit' => 0]);} break;
				case 100 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_SIMULER_FO")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"INVENTAIRES_SIMULER_FO")->update(['droit' => 0]);} break;
				case 101 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"TRANSFERT")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"TRANSFERT")->update(['droit' => 0]);} break;
                case 102 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE")->update(['droit' => 0]);} break;
                case 103 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE_AJOUTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE_AJOUTER")->update(['droit' => 0]);} break;
                case 104 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE_MODIFIER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE_MODIFIER")->update(['droit' => 0]);} break;
                case 105 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE_SUPPRIMER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_ENTITE_SUPPRIMER")->update(['droit' => 0]);} break;
                case 106 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_IMPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_IMPORTER")->update(['droit' => 0]);} break;
                case 107 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_PRODUITS_EXPORTER")->update(['droit' => 0]);} break;
                case 108 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_IMPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_IMPORTER")->update(['droit' => 0]);} break;
                case 109 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_EMPLACEMENTS_EXPORTER")->update(['droit' => 0]);} break;
                case 110 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_IMPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_IMPORTER")->update(['droit' => 0]);} break;
                case 111 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_COMMANDES_EXPORTER")->update(['droit' => 0]);} break;
                case 112 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_IMPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_IMPORTER")->update(['droit' => 0]);} break;
                case 113 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"FOURNISSEURS_RECEPTION_EXPORTER")->update(['droit' => 0]);} break;
                case 114 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_IMPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_PREPARATION_IMPORTER")->update(['droit' => 0]);} break;
                case 115 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_CHARGEMENT_EXPORTER")->update(['droit' => 0]);} break;
                case 116 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_LIVRAISONS_EXPORTER")->update(['droit' => 0]);} break;
                case 117 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_EXPORTER")->update(['droit' => 0]);} break;
                case 118 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_EXPORTER")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"CLIENT_COMMANDES_EXPORTER")->update(['droit' => 0]);} break;
                case 119 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_ZONE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_ZONE")->update(['droit' => 0]);} break;
                case 120 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_EMPLACEMENT")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_EMPLACEMENT")->update(['droit' => 0]);} break;
                case 121 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_ENTITE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_ENTITE")->update(['droit' => 0]);} break;
                case 122 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_UE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_UE")->update(['droit' => 0]);} break;
                case 123 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_REFERENCE")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_REFERENCE")->update(['droit' => 0]);} break;
                case 124 : if($request->input($i) != null) { DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_DESIGNATION")->update(['droit' => 1]);} else {DroitAccesBackoffice::where('idProfil','=',$id)->where('action','=',"ADMINISTRATION_STOCK_FILTRER_PAR_DESIGNATION")->update(['droit' => 0]);} break;

            }

			}


		return redirect('profil/backoffice');
		}else{
			return redirect('configuration/profilacces/backoffice/modifier'.$id )->with('msgIdf', 'libellé existe déjà');
		}
	}
}