<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 07/06/2017
 * Time: 12:45
 */

namespace App\Http\Controllers;


use App\CommandeFournisseur;
use App\Commune;
use App\Fournisseur;
use App\Historique;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Wilaya;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

use App\LigneCommandeFournisseur;
use App\BonReception;
use App\LigneBonReception;
use App\StockProduit;

class FournisseurController extends Controller
{



    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                $stockProduit->update();*/

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }




    public function index()
    {

        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        $fournisseurs = Fournisseur::all();
        return view('fournisseur.index',compact('fournisseurs'));
    }


    public function getForm()
    {
        $wilayas = Wilaya::all();
        $communes = Commune::all();
        return view('fournisseur.ajouter', compact('wilayas', 'communes'));
    }


    public function delete($id)
    {

        $exist = CommandeFournisseur::where('id_fournisseur', '=', $id)->count();
        if($exist == 0)
        {
            $fournisseur=Fournisseur::find($id);


            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Fournisseurs->Liste des fournisseurs';
            $HistoriqueActions->description = 'Suppression du fournisseur : '.$fournisseur->societe ;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $fournisseur->delete();

            return redirect('fournisseur/index')->with('msgDeleteOk',"Le fournisseur a été supprimé avec succès");
        }
        else
        {
            return redirect('fournisseur/index')->with('msgDeleteNotOk',"Impossible de supprimer le fournisseur car des commandes fournisseurs lui sont attribués");
        }




    }


    public function postForm(Request $request)
    {
        //dd($request->input());
        $exist = Fournisseur::where('societe', '=', $request->input('societe'))->where('contact', '=', $request->input('contact'))->count();
        if($exist == 0)
        {
            $commune = Commune::find($request->input('commune'));
            //dd($commune->id_wilaya);
            $wilaya = Wilaya::find($commune->id_wilaya);

            $fournisseur = new Fournisseur();
            $fournisseur->societe = $request->input('societe');
            $fournisseur->contact = $request->input('contact');
            $fournisseur->fonction = $request->input('fonction');
            $fournisseur->adresse_complet = $request->input('adresse'). " ". $commune->nom_commune. " ". $wilaya->nom_wilaya;
            $fournisseur->adresse = $request->input('adresse');
            $fournisseur->telephone = $request->input('telephone');
            $fournisseur->fax = $request->input('fax');
            $fournisseur->email = $request->input('email');
            $fournisseur->page_accueil = $request->input('page_accueil');
            $fournisseur->id_commune = $request->input('commune');
            $fournisseur->save();


            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Fournisseurs->Liste des fournisseurs';
            $HistoriqueActions->description = 'Ajout du fournisseur : '.$fournisseur->societe ;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();
            return redirect('fournisseur/index')->with('msgAddSuccess',"Le fournisseur a été ajouté avec succès");



        }
        else
        {
            return redirect('fournisseur/ajouter')->with('msgAddExist',"Ce fournisseur existe déjà");

        }


    }



    public function getFormEdit($id)
    {

        $fournisseur = Fournisseur::find($id);

        $id_wilaya = Wilaya::join('commune','commune.id_wilaya','=','wilaya.id_wilaya')
            ->where('commune.id_commune','=',$fournisseur->id_commune)
            ->first()->id_wilaya;

        $communes = Commune::all();
        $wilayas = Wilaya::all();


        return view('fournisseur/modifier', compact('fournisseur', 'communes', 'wilayas','id_wilaya'));


    }


    public function getCommune()
    {
        $ref = Input::get('ID');
        $rest=DB::table('commune')
            ->where('id_wilaya','=',$ref)
            ->orderBy('nom_commune')
            ->get();
        return response()->json($rest);
    }


    public function postFormEdit(Request $request, $id)
    {

        //dd($request->input());

        $fournisseur = Fournisseur::find($id);
        //dd($fournisseur);
        $exist = Fournisseur::where('societe', '=', $request->input('societe'))
            ->where('contact', '=', $request->input('contact'))
            ->where('fonction', '=', $request->input('fonction'))
            ->where('telephone', '=', $request->input('telephone'))
            ->where('fax', '=', $request->input('fax'))
            ->where('email', '=', $request->input('email'))
            ->where('page_accueil', '=', $request->input('page_accueil'))
            ->where('id_commune', '=', $request->input('commune'))
            ->where('adresse', '=', $request->input('adresse'))
            ->count();
        if($exist == 0)
        {
            $commune = Commune::find($request->input('commune'));
            $wilaya = Wilaya::find($commune->id_wilaya);

            $fournisseur->societe = $request->input('societe');
            $fournisseur->contact = $request->input('contact');
            $fournisseur->fonction = $request->input('fonction');
            $fournisseur->adresse_complet = $request->input('adresse'). " ". $commune->nom_commune. " ". $wilaya->nom_wilaya;
            $fournisseur->adresse = $request->input('adresse');
            $fournisseur->telephone = $request->input('telephone');
            $fournisseur->fax = $request->input('fax');
            $fournisseur->email = $request->input('email');
            $fournisseur->page_accueil = $request->input('page_accueil');
            $fournisseur->id_commune = $request->input('commune');
            $fournisseur->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Fournisseurs->Liste des fournisseurs';
            $HistoriqueActions->description = 'Modification du fournisseur : '.$fournisseur->societe ;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('fournisseur/index')->with('msgAddSuccess',"Le fournisseur a été modifié avec succès");

        }
        else
        {
            return redirect('fournisseur/modifier/'.$id)->with('msgUpdateExist','Ce fournisseur existe déjà');

        }


    }


}