<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 30/05/2017
 * Time: 16:32
 */

namespace App\Http\Controllers;


use App\Emplacement;
use App\Historique;
use App\StockProduit;
use App\Produit;
use App\Zone;
use App\Ue;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use App\BonReception;
use App\LigneBonReception;
use Illuminate\Support\Facades\Session;
use Excel;
use \Response;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Redirect;
use Config;
use PHPExcel_IOFactory;
use PHPExcel_Style_NumberFormat;

use PHPExcel;

use PHPExcel_Cell;
use PHPExcel_Cell_DataType;
use PHPExcel_Cell_IValueBinder;
use PHPExcel_Cell_DefaultValueBinder;

class EmplacementController extends Controller
{





    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->last_update= date("Y-m-d H:i:s");
                $stockProduit->update();*/

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }






    public function index()
    {

        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        $emplacements = Emplacement::with("zone")->get();
        //dd($emplacements);
        //dd($emplacements[0]->zone->libelle);
        return view('emplacement.index',compact('emplacements'));
    }


    public function getForm()
    {
        $zones = Zone::all();
        return view('emplacement.ajouter', compact('zones'));
    }



    public function postForm(Request $request)
    {
        $emplacement = Emplacement::where('libelle','=',$request->input('libelle'))->first();
        $existCode = Emplacement::where('code_identification','=',$request->input('code'))->first();
       // dd($existCode);
        if($emplacement == null)
        {
            if($existCode == null) {

                $emplacement = new Emplacement();
                $emplacement->libelle = $request->input('libelle');
                $emplacement->code_identification = $request->input('code');
                $emplacement->description = $request->input('description');
                $emplacement->id_zone = $request->input('zone');
                $emplacement->volumeMax = $request->input('volumeMax');
                $emplacement->etat = "DISPONIBLE";
                if(Session::get('CHARGEMENT')=='1') {
                    $emplacement->emplacement_mobile = $request->input('vehicule');
                }else{
                    $emplacement->emplacement_mobile = "NON";

                }

                $emplacement->save();

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Ajout';
                $HistoriqueActions->nom_table = 'Administration->Les emplacements';
                $HistoriqueActions->description = 'Ajout d\'emplacement : '.$emplacement->libelle;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                return redirect('emplacement/index')->with('msgAdd', "Le nouvel emplacement de stockage a été ajouté avec succès");
            }
            else {

                return redirect()->back()->withInput()->with('msgLib','Le code à barres  existe déjà');
            }
        }
        else
        {
            return redirect()->back()->withInput()->with('msgLib','Le libellé existe déjà');
        }

    }


    public function delete($id)
    {


        $stockProduit = StockProduit::where('id_emplacement', '=', $id)->first();
        //dd($stockProduit);
        if ($stockProduit == null)
        {

            $emplacement=Emplacement::find($id);

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Administration->Les emplacements';
            $HistoriqueActions->description = 'Suppression d\'emplacement : '.$emplacement->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $emplacement->delete();
            return redirect('emplacement/index')->with('msgDeleteOk',"L'emplacement de stockage a été supprimé avec succès");
        }

        else if($stockProduit->quantite > 0 )
        {

            return redirect('emplacement/index')->with('msgDeleteNotOk',"Impossible de supprimer cet emplacement de stockage, car il y a des produits qui sont stockés");
        }
        else
        {

            Emplacement::find($id)->delete();
            return redirect('emplacement/index')->with('msgDeleteOk',"L'emplacement de stockage a été supprimé avec succès");
        }


    }


    public function getFormEdit($id)
    {
        $emplacement = Emplacement::find($id);
        $zones = Zone::all();
        return view('emplacement/modifier', compact('emplacement', 'zones'));
    }

    public function postFormEdit(Request $request, $id)
    {
        $emplacement = Emplacement::find($id);


        $exist = Emplacement::where('libelle','=',$request->input('libelle'))
            ->where('id_emplacement','=',$id)
            ->where('libelle', '!=', $emplacement->libelle)
            ->count();


        $exist_libelle = Emplacement::where('libelle', '=', $request->input('libelle'))
            ->where('libelle', '!=', $emplacement->libelle)
            ->count();

        if($emplacement->code_identification != null) {
            $exist_Code = Emplacement::where('code_identification', '=', $request->input('code'))
                ->where('code_identification', '!=', $emplacement->code_identification)
                ->count();
        }
        else
        {
            $exist_Code= 0;
        }


        if($exist == 0 && $exist_libelle == 0) {

            if ($exist_Code == 0) {

                $emplacement->libelle = $request->input('libelle');
                $emplacement->code_identification = $request->input('code');
                $emplacement->description = $request->input('description');
                $emplacement->id_zone = $request->input('zone');
                $emplacement->volumeMax = $request->input('volumeMax');
                if(Session::get('CHARGEMENT')=='1') {
                    $emplacement->emplacement_mobile = $request->input('vehicule');
                }else{
                    $emplacement->emplacement_mobile = "NON";

                }                $emplacement->last_update= date("Y-m-d H:i:s");
                $emplacement->update();

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Modification';
                $HistoriqueActions->nom_table = 'Administration->Les emplacements';
                $HistoriqueActions->description = 'Modification d\'emplacement : '.$emplacement->libelle;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();

                return redirect('emplacement/index')->with('msgAdd', "L'emplacement de stockage a été modifié avec succès");
            }
            else{
                return redirect('emplacement/modifier/' . $id)->with('msgLib','Le code à barres  existe déjà');
            }
        }
        else
        {
            return redirect('emplacement/modifier/'.$id)->with('msgLib','Le libellé existe déjà');

        }

    }

    public function getProduitStock($id){
        $result = array();
        //$produitStock = StockProduit::where('id_emplacement',$id)->get();
        $produitStock = StockProduit::all();
        $collection = collect();
        foreach ($produitStock as $ps) {
            $produit = Produit::find($ps->id_produit);
            $collection->put($ps->id_stock_produit,$produit->reference."-".$produit->designation);
        }
        $result = $collection; 
        return [$collection];
    }

    
    public function detail_ue($id_emplacement){
        $ue = UE::where('nbr_produit','!=',0)->where('id_emplacement',$id_emplacement)->get();
        return $ue;
    }

    public function downloadModele(Request $request){
        $file=public_path()."/Modele_Emplacement.xlsx";
        $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
        return Response::download($file, 'Modele_Emplacement.xlsx',$headers);
        
    }
    public function import(Request $request){
        ini_set('max_execution_time', 1000);
        $bytes = $request->file('file')->getClientSize();
        $ext = Input::file('file')->getClientOriginalExtension();
        if ( $ext == "xlsx" || $ext == 'xls'){
            if ($bytes < 25165824) {
                $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));

                $sheet = $objPHPExcel->getSheet(0);
                //dd($sheet);
                $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                
                //dd($highestRow);
                $erreur = collect();
                if ($highestRow > 1) {
                    $y=1;
                    foreach ($sheet->getRowIterator() as $key=> $row) {
                        //Version 2
                        $libelle = null;
                        $code = null;
                        $zone = null;
                        $volume = null;
                        $vehicule = null;
                        $remarque = null;
                        if ($row->getRowIndex() >= 2){
                            // On boucle sur les cellule de la ligne
                            $libelle= $sheet->getCell('A'.$y)->getValue(); 
                            $code = $sheet->getCell('B'.$y)->getValue();                  
                            $zone= $sheet->getCell('C'.$y)->getValue();
                            $volume= $sheet->getCell('D'.$y)->getValue();
                            $vehicule= $sheet->getCell('E'.$y)->getValue();
                            $remarque = $sheet->getCell('F'.$y)->getValue();

                            //dd($y,$libelle,$code,$zone,$volume,$vehicule,$remarque);
                        
                        $emplacement = Emplacement::where('libelle',$libelle)->first();
                        if ($emplacement == null) {
                                $zonee = Zone::where('libelle',$zone)->first();
                                if ($zonee != null) {
                                    //dd('l');
                                    $emplacement = new Emplacement();
                                    $emplacement->libelle = $libelle;
                                    $emplacement->code_identification = $code;
                                    if ($remarque == null) $remarque ="";
                                    $emplacement->description = $remarque;
                                    $emplacement->id_zone = $zonee->id_zone;
                                    $emplacement->volumeMax = $volume;
                                    $emplacement->etat = "DISPONIBLE";
                                    if(Session::get('CHARGEMENT')=='1') {
                                        $emplacement->emplacement_mobile = $vehicule;
                                    }else{
                                        $emplacement->emplacement_mobile = "NON";
                                    }
                                    $emplacement->save();
                                }else{
                                    $erreur->put($key, "La zone ".$zone." n'existe pas");
                                }
                        
                        }else{
                             $zonee = Zone::where('libelle',$zone)->first();
                            if ($zonee != null) {
                                    $emplacement->libelle = $libelle;
                                    $emplacement->code_identification = $code;
                                    if ($remarque == null) $remarque ="";
                                    $emplacement->description = $remarque;
                                    $emplacement->id_zone = $zonee->id_zone;
                                    $emplacement->volumeMax = $volume;
                                    $emplacement->etat = "DISPONIBLE";
                                    if(Session::get('CHARGEMENT')=='1') {
                                        $emplacement->emplacement_mobile = $vehicule;
                                    }else{
                                        $emplacement->emplacement_mobile = "NON";
                                    }
                                    $emplacement->update();
                                }else{
                                    $erreur->put($key, "La zone ".$zone." n'existe pas");
                                }
                        }
                    }
                    $y++;
                }
                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Importation';
                $HistoriqueActions->nom_table = 'Administration->Les emplacements';
                $HistoriqueActions->description = 'Importation des emplacements depuis un fichier';
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();
                
                if ($sheet->getHighestRow() - 1 == $erreur->count()) {
                    return redirect('emplacement/index')->with('msgAjouterAnnuler',
                        $erreur);
                }
                if ($erreur->count() == 0) {
                    return redirect('emplacement/index')->with('msgAjouter', 'Fichier importé avec succès');
                }else{
                    return redirect('emplacement/index')->with('msgAjouterErreur',$erreur);
                }
            }
            else
                return Redirect::back()->withErrors(['Fichier vide ']);
        } else return Redirect::back()->withErrors(['Fichier volumineux ']);

    } else return Redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);
}

public function exportEmp(){
    $emplacements = Emplacement::with("zone")->get();
    Excel::create('Les emplacements_'.date('y-m-d'),function($excel) use ($emplacements){
        $excel->sheet('Feuil1', function($sheet) use ($emplacements){
            $sheet->setColumnFormat(array(
               'B' => '@',
            ));
            $sheet->loadView('emplacement.export.exportEmpl')->with('emplacements',$emplacements);
        });
    })->download('xlsx');
}
    
}