<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 08/06/2017
 * Time: 14:51
 */

namespace App\Http\Controllers;


use App\CommandeFournisseur;
use App\Fournisseur;
use App\Historique;
use App\LigneCommandeFournisseur;
use App\ListValeur;
use App\Produit;
use Carbon\Carbon;
use Illuminate\Database\SeedServiceProvider;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

use App\BonReception;
use App\LigneBonReception;
use App\StockProduit;
use Config;

class CommandeFournisseurController extends Controller
{






    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);
            if ($lignescommande) {
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur ON');
                }
                foreach($lignescommande as $ligne){
                    $lignecommande = new LigneCommandeFournisseur();

                    $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                    $lignecommande->id_produit = $ligne->id_produit;
                    $lignecommande->id_commande = $id;
                    $lignecommande->quantite_commander = $ligne->quantite_commander;
                    $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                    $lignecommande->tva = $ligne->tva;
                    $lignecommande->prix_ht = $ligne->prix_ht;
                    $lignecommande->prix_ttc = $ligne->prix_ttc;
                    $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                    $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                    $lignecommande->save();
                }
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur OFF');
                }
            }

            

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');
            if ($lignesBonReception) {
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception ON');
                }
                foreach($lignesBonReception as $ligne)
                {
                    $ligneBonReception = new LigneBonReception();

                    $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                    $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                    $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                    $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                    $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                    $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                    $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;
                    /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                    $stockProduit->quantite = $ligne->stockProduit->quantite;
                    $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                    $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                    $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                    $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                    $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                    $stockProduit->update();*/
                    $ligneBonReception->save();
                }
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception OFF');
                }
            }

            

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }














    public function index()
    {

        Session::put('idFournisseur', null);
        Session::put('contactFounisseur', null);
        Session::put('adresseFournisseur', null);
        Session::put('etatCommande', null);
        Session::put('dateCreation', null);
        Session::put('ligne_commande_fournisseur', null);
        Session::put('commandes_fournisseurs', null);
        Session::put('ligne_commande_fournisseur',null);

        LigneCommandeFournisseur::where('id_commande','=',0)->delete();
        CommandeFournisseur::where('date_creation', '=', null)->delete();

        $commandes_fournisseurs = CommandeFournisseur::where('etat', '!=', 'ANNULEE')->where('supprimer', '=', '0')->get();
        //dd($commandes_fournisseurs);

        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        return view('commande_fournisseur.index',compact('commandes_fournisseurs'));
    }


    public function getForm()
    {

        /*
        $count = DB::table('commande_fournisseur')->max('id_commande_fournisseur');
        $num_commande_fournisseur = $count + 1;
        */

    /*    $commandeFoirnisseurExiste = CommandeFournisseur::where('id_fournisseur', '=', 0)->count();
        if ($commandeFoirnisseurExiste == 0){
            $commande = new CommandeFournisseur();
            //dd($commande);
            $commande->id_fournisseur = 0;
            $commande->date_creation = null;
            $commande->total_prix_ht = 0;
            $commande->total_prix_ttc = 0;
            $commande->etat = null;
            //dd($commande);
            $commande->save();
            //dd($commande->id_commande_fournisseur);
            $num_commande_fournisseur = $commande->id_commande_fournisseur;
        }else{
            $commande = CommandeFournisseur::where('id_fournisseur', '=', 0)->first();
            $num_commande_fournisseur = $commande->id_commande_fournisseur;

        }*/

        //dd($num_commande_fournisseur);

        $fournisseurs = Fournisseur::all();
        $statuts = ListValeur::where('nom_liste', '=', 'STATUT_COMMANDE')->get();
        $produits = Produit::all();
        $lignescommande = LigneCommandeFournisseur::where('id_commande', '=', 0)->with('produit')->get();
        //dd($lignescommande);

        $lastNum =CommandeFournisseur::orderBy('num_commande_fournisseur','desc')->first();
       // dd($lastNum);
        if ($lastNum != null) {
            $NumCmdFo = substr_replace($lastNum->num_commande_fournisseur, "", 0, 5);
            if ($NumCmdFo == 99999){
                $NumCmdFo='CMDFO00001';
            }
            else {
                $NumCmdFo = $NumCmdFo + 1;
                $NumCmdFo=str_pad($NumCmdFo, 5, '0', STR_PAD_LEFT);


                $NumCmdFo ='CMDFO'.$NumCmdFo;
            }

        }
        else
            $NumCmdFo='CMDFO00001';

        return view('commande_fournisseur.ajouter', compact('fournisseurs', 'statuts', 'produits', 'lignescommande','NumCmdFo'));
    }

    public function postForm(Request $request)
    {
       // dd(number_format($request->input('total_ht'), 2));
        //$commande = new CommandeFournisseur();
        $commande =  new CommandeFournisseur();
        //dd($commande);
        $commande->num_commande_fournisseur = $request->input('num_commande_fournisseur');
        $commande->id_fournisseur = $request->input('fournisseur');
        $commande->date_creation = $request->input('date_creation');
        $commande->total_prix_ht = $request->input('total_ht');
        $commande->total_prix_ttc = $request->input('total_ttc');
        $commande->etat = $request->input('statut');
        $commande->supprimer = 0;

        $commande->save();

        LigneCommandeFournisseur::where('id_commande','=',0)->update(['id_commande' =>  $commande->id_commande_fournisseur]);

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Ajout';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les commandes des fournisseurs';
        $HistoriqueActions->description = 'Ajout de la commande fournisseur: '.$commande->num_commande_fournisseur ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();


        return redirect('commande_fournisseur/index')->with('msgAjouter','Commande ajoutée avec succès');

    }


    public function getFournisseur()
    {
        $ref = Input::get('ID');
        $rest=DB::table('fournisseur')
            ->where('id_fournisseur','=',$ref)
            ->get();
        return response()->json($rest);
    }


    public function postAddLigneCommande(Request $request)
    {   

        $produit = $request->input('produit');
        if (!$produit) {
            
            $request->session()->flash('erreur', 'Veuillez sélectionner un produit');
            return redirect('commande_fournisseur/ajouter');
        }


        Session::put('idFournisseur', $request->input('idFournisseur'));
        Session::put('contactFounisseur', $request->input('contactFounisseur'));
        Session::put('adresseFournisseur', $request->input('adresseFournisseur'));
        Session::put('etatCommande', $request->input('etatCommande'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));


        //dd( Session::get('etatCommande'));

        $exist = LigneCommandeFournisseur::where('id_commande', '=', 0)->where('id_produit', '=', $request->input('produit'))->count();
        if($exist == 0)
        {
            $lignecommande = new LigneCommandeFournisseur();

            $lignecommande->id_produit = $request->input('produit');
            $lignecommande->id_commande = 0;
            $lignecommande->quantite_commander = $request->input('quantite');
            $lignecommande->quantite_receptionner = 0;
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prix_ht = $request->input('prix_unitaire_ht');
            $lignecommande->prix_ttc = $request->input('prix_unitaire_ttc');
            $lignecommande->total_prix_ht = $request->input('totale_ht');
            $lignecommande->total_prix_ttc = $request->input('totale_ttc');

            $lignecommande->save();

            return redirect('commande_fournisseur/ajouter');
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à la commande');
        }

    }

    public function postEditeLigneCommande(Request $request, $id)
    {
        Session::put('idFournisseur', $request->input('idFournisseur'));
        Session::put('contactFounisseur', $request->input('contactFounisseur'));
        Session::put('adresseFournisseur', $request->input('adresseFournisseur'));
        Session::put('etatCommande', $request->input('etatCommande'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

        //dd($id);
        $exist = LigneCommandeFournisseur::where('id_commande', '=', 0)->where('id_produit', '=', $request->input('produit'))->where('id_ligne_commande_fournisseur','!=',$id)->count();

        if($exist == 0)
        {
            $lignecommande = LigneCommandeFournisseur::find($id);

            $lignecommande->id_produit = $request->input('produit');
            $lignecommande->id_commande = 0;
            $lignecommande->quantite_commander = $request->input('quantite');
            $lignecommande->quantite_receptionner = 0;
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prix_ht = $request->input('prix_unitaire_ht');
            $lignecommande->prix_ttc = $request->input('prix_unitaire_ttc');
            $lignecommande->total_prix_ht = $request->input('totale_ht');
            $lignecommande->total_prix_ttc = $request->input('totale_ttc');

            $lignecommande->update();

            return redirect('commande_fournisseur/ajouter');
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à la commande');
        }
    }

    public function deleteLigneCommandeFournisseur(Request $request, $id)
    {

        Session::put('idFournisseur', $request->input('idFournisseur'));
        Session::put('contactFounisseur', $request->input('contactFounisseur'));
        Session::put('adresseFournisseur', $request->input('adresseFournisseur'));
        Session::put('etatCommande', $request->input('etatCommande'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

        LigneCommandeFournisseur::find($id)->delete();
        return redirect('commande_fournisseur/ajouter');
    }



    public function getFormEdit($id)
    {


        $commande_fournisseur = CommandeFournisseur::find($id);
        $lignescommande = LigneCommandeFournisseur::where('id_commande', '=', $id)->with('produit')->get();

        $fournisseurs = Fournisseur::all();
        $fournisseur_commande = Fournisseur::find($commande_fournisseur->id_fournisseur);


        $statuts = ListValeur::where('nom_liste', '=', 'STATUT_COMMANDE')->get();
        $produits = Produit::all();

        if(!Session::has('commandes_fournisseurs')){

            Session::put('idFournisseur', $fournisseur_commande->id_fournisseur);
            Session::put('contactFounisseur', $fournisseur_commande->contact);
            Session::put('adresseFournisseur', $fournisseur_commande->adresse_complet);
            Session::put('etatCommande', $commande_fournisseur->etat);
            Session::put('dateCreation', $commande_fournisseur->date_creation);

            Session::put('commandes_fournisseurs', $commande_fournisseur);
            Session::put('ligne_commande_fournisseur',$lignescommande);
        }


        return view('commande_fournisseur.modifier', compact('fournisseurs', 'fournisseur_commande', 'statuts', 'produits', 'lignescommande', 'commande_fournisseur'));


    }


    public function postAddLigneCommandeEdit(Request $request, $id)
    {

        $produit = $request->input('produit');
        if (!$produit) {
            
            $request->session()->flash('erreur', 'Veuillez sélectionner un produit');
            return redirect('commande_fournisseur/modifier/'.$id);
        }
        
        Session::put('idFournisseur', $request->input('idFournisseur'));
        Session::put('contactFounisseur', $request->input('contactFounisseur'));
        Session::put('adresseFournisseur', $request->input('adresseFournisseur'));
        Session::put('etatCommande', $request->input('etatCommande'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

        //dd(Session::get('etatCommande'));

        $exist = LigneCommandeFournisseur::where('id_commande', '=', $id)->where('id_produit', '=', $request->input('produit'))->count();
        if($exist == 0)
        {
            $lignecommande = new LigneCommandeFournisseur();

            $lignecommande->id_produit = $request->input('produit');
            $lignecommande->id_commande = $id;
            $lignecommande->quantite_commander = $request->input('quantite');
            $lignecommande->quantite_receptionner = 0;
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prix_ht = $request->input('prix_unitaire_ht');
            $lignecommande->prix_ttc = $request->input('prix_unitaire_ttc');
            $lignecommande->total_prix_ht = $request->input('totale_ht');
            $lignecommande->total_prix_ttc = $request->input('totale_ttc');

            $lignecommande->save();

            return redirect('commande_fournisseur/modifier/'.$id);
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à la commande');
        }


    }


    public function deleteLigneCommandeFournisseurEdit(Request $request,$id,$idCommande)
    {
        Session::put('idFournisseur', $request->input('idFournisseur'));
        Session::put('contactFounisseur', $request->input('contactFounisseur'));
        Session::put('adresseFournisseur', $request->input('adresseFournisseur'));
        Session::put('etatCommande', $request->input('etatCommande'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

        LigneCommandeFournisseur::find($id)->delete();
        return redirect('commande_fournisseur/modifier/'.$idCommande);
    }


    public function postEditeLigneCommandeEdit(Request $request,$id,$idCommande)
    {

        Session::put('idFournisseur', $request->input('idFournisseur'));
        Session::put('contactFounisseur', $request->input('contactFounisseur'));
        Session::put('adresseFournisseur', $request->input('adresseFournisseur'));
        Session::put('etatCommande', $request->input('etatCommande'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

        $exist = LigneCommandeFournisseur::where('id_commande', '=', $idCommande)->where('id_produit', '=', $request->input('produit'))->where('id_ligne_commande_fournisseur','!=',$id)->count();

        if($exist == 0)
        {
            $lignecommande = LigneCommandeFournisseur::find($id);

            $lignecommande->id_produit = $request->input('produit');
            $lignecommande->id_commande = $idCommande;
            $lignecommande->quantite_commander = $request->input('quantite');
            $lignecommande->quantite_receptionner = 0;
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prix_ht = $request->input('prix_unitaire_ht');
            $lignecommande->prix_ttc = $request->input('prix_unitaire_ttc');
            $lignecommande->total_prix_ht = $request->input('totale_ht');
            $lignecommande->total_prix_ttc = $request->input('totale_ttc');

            $lignecommande->update();

            return redirect('commande_fournisseur/modifier/'.$idCommande);
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à la commande');
        }

    }

    public function postFormEdit(Request $request,$id)
    {
        // dd(number_format($request->input('total_ht'), 2));
        $commande =  CommandeFournisseur::find($id);

        $commande->id_fournisseur = $request->input('fournisseur');
        $commande->date_creation = $request->input('date_creation');
        $commande->total_prix_ht = $request->input('total_ht');
        $commande->total_prix_ttc = $request->input('total_ttc');
        $commande->etat = $request->input('statut');
        $commande->supprimer = 0;

        $commande->update();

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Modification';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les commandes des fournisseurs';
        $HistoriqueActions->description = 'Modification de la commande fournisseur: '.$commande->num_commande_fournisseur ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        Session::put('commandes_fournisseurs', null);
        Session::put('ligne_commande_fournisseur',null);

        return redirect('commande_fournisseur/index')->with('msgAjouter','Commande modifiée avec succès');
    }

    public function cancelModification($id)
    {
    //dd('lol');

        $test = LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();
        //dd($test);
        if ($test != 0 ) {
            $lignescommande = Session::get('ligne_commande_fournisseur');

        //dd($lignescommande);

            if ($lignescommande) {
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur ON');
                }
                foreach($lignescommande as $ligne){
                    $lignecommande = new LigneCommandeFournisseur();
                    $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                    $lignecommande->id_produit = $ligne->id_produit;
                    $lignecommande->id_commande = $id;
                    $lignecommande->quantite_commander = $ligne->quantite_commander;
                    $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                    $lignecommande->tva = $ligne->tva;
                    $lignecommande->prix_ht = $ligne->prix_ht;
                    $lignecommande->prix_ttc = $ligne->prix_ttc;
                    $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                    $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;
                    $lignecommande->save();
                }
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur OFF');
                }
            }  
        }

        return redirect('commande_fournisseur/index');
    }



    public function showDetailCommandeFournisseur($id)
    {

        //dd($id);
        //$commande_fournisseur = CommandeFournisseur::find($id);
        $commande_fournisseur = CommandeFournisseur::where('id_commande_fournisseur', '=', $id)->with('fournisseur')->first();
        //dd($commande_fournisseur);
        $lignescommande = LigneCommandeFournisseur::where('id_commande', '=', $id)->with('produit')->get();
       /* LigneCommandeFournisseur::where('id_commande','=',$id)->where('id_produit','=',46)->update(['id_produit' =>66]);
        LigneCommandeFournisseur::where('id_commande','=',$id)->where('id_produit','=',47)->update(['id_produit' => 67]);
        LigneCommandeFournisseur::where('id_commande','=',$id)->where('id_produit','=',48)->update(['id_produit' => 68]);*/
       // dd($lignescommande);
        $fournisseurs = Fournisseur::all();
        $fournisseur_commande = Fournisseur::find($commande_fournisseur->id_fournisseur);


        $statuts = ListValeur::where('nom_liste', '=', 'STATUT_COMMANDE')->get();
        $produits = Produit::all();



        return view('commande_fournisseur.detail', compact('fournisseurs', 'fournisseur_commande', 'statuts', 'produits', 'lignescommande', 'commande_fournisseur'));


    }


    public function delete($id)
    {

        $commandeFournisseur = CommandeFournisseur::find($id);
        $commandeFournisseur->supprimer = 1;
        $commandeFournisseur->update();

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Suppression';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les commandes des fournisseurs';
        $HistoriqueActions->description = 'Suppression de la commande fournisseur: '.$commandeFournisseur->num_commande_fournisseur ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('commande_fournisseur/index')->with('msgSupprimer','La commande fournisseur a été supprimée avec succès');

    }




}