<?php

namespace App\Http\Controllers;


use App\Client;
use App\CommandeClient;
use App\Historique;
use App\LigneCommandeProduit;
use App\Preparation;
use App\Produit;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use \Response;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use PHPExcel_IOFactory;
use Illuminate\Support\Facades\Redirect;
use Excel;
use Config;






class CommandeClientController extends Controller
{

    public function index()
    {

        $commandes_client= CommandeClient::get();
       //

        LigneCommandeProduit::where('idCommande', '=', 0)->delete();

        Session::put('idClient', null);
        Session::put('contactClient', null);
        Session::put('adresseClient', null);
        Session::put('dateCreation', null);
       // Session::put('commandes_clients', null);

       // dd(Session::get('commandes_clients'),Session::get('ligne_commande_client'));
        if(Session::get('commandes_clients') != null)
        {
            $id = Session::get('commandes_clients')->idCommande;

            LigneCommandeProduit::where('idCommande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_client');
            if ($lignescommande) {
                if(Config::get('database')['default'] == "sqlsrv"){
                        DB::unprepared('SET IDENTITY_INSERT ligne_commande_produit ON');
                }

                foreach($lignescommande as $ligne){
                    $lignecommande = new LigneCommandeProduit();
                    $lignecommande->idLigneCommandeProduit = $ligne->idLigneCommandeProduit;
                    $lignecommande->idProduit = $ligne->idProduit;
                    $lignecommande->idCommande = $id;
                    $lignecommande->quantiteCommande = $ligne->quantiteCommande;
                    $lignecommande->tva = $ligne->tva;
                    $lignecommande->prixHT = $ligne->prixHT;
                    $lignecommande->prixTTC = $ligne->prixTTC;
                    $lignecommande->totalPrixHT =$ligne->totalPrixHT;
                    $lignecommande->totalPrixTTC = $ligne->totalPrixTTC;
                    $lignecommande->save();
                }
                if(Config::get('database')['default'] == "sqlsrv"){
                        DB::unprepared('SET IDENTITY_INSERT ligne_commande_produit OFF');
                }
            }
            Session::put('commandes_clients', null);
            Session::put('ligne_commande_client', null);

        }

        return view('commande_client.index',compact('commandes_client'));
    }

    public function delete($id)
    {
        $Preparation= Preparation::select('idCommande')
            ->get();

        $exist = Preparation::where('idCommande','=',$id)
            ->whereIn('idCommande',$Preparation)
            ->count();

       // dd($exist);
        if($exist == 0 )
        {
            $commandeClient = CommandeClient::find($id);


            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Clients->Les commandes des clients';
            $HistoriqueActions->description = 'Suppression du commande client  : '.$commandeClient->numCommande ;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $commandeClient->delete();

            return redirect('commande_client/index')->with('msgSupprimer','La commande client a été supprimée  avec succès');
        }
        else
        {
            return redirect('commande_client/index')->with('msgExist',"Suppression impossible car une préparation est affectée à cette commande");
        }



    }

    public function show($id)
    {
        $commande_client = CommandeClient::find($id);
        $hasPreparations=Preparation::where('idCommande','=',$id)->get();
        $lignescommande = LigneCommandeProduit::with('produit')->where('idCommande','=',$id)->get();
       /* LigneCommandeProduit::where('idCommande','=',$id)->where('idProduit','=',56)->update(['idProduit' =>76]);
        LigneCommandeProduit::where('idCommande','=',$id)->where('idProduit','=',57)->update(['idProduit' =>77]);
        LigneCommandeProduit::where('idCommande','=',$id)->where('idProduit','=',58)->update(['idProduit' =>78]);
        LigneCommandeProduit::where('idCommande','=',$id)->where('idProduit','=',59)->update(['idProduit' =>79]);*/
      //  dd($lignescommande);

        return view('commande_client.detail',compact('commande_client','lignescommande','hasPreparations'));

    }

    public function upload(Request $request)
    {



            $bytes = $request->file('file')->getClientSize();
            $ext = Input::file('file')->getClientOriginalExtension();

            if ($ext == "csv" || $ext == "xlsx" || $ext == 'xls')
            {
                if ($bytes < 25165824) {
                    $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));
                    $sheet = $objPHPExcel->getSheet(0);
                    $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();


                    $numCommande = null;
                    $raisonSociale = null;
                    $adresseClient = null;
                    $emailClient = null;
                    $nomContact = null;
                    $prenomContact = null;
                    $date = null;


                    //Tester si le fichier n'est pas vide
                    if ($highestRow > 1) {
                        //dd($sheet->getRowIndex());
                        foreach ($sheet->getRowIterator() as $row) {
                            //Version 2


                            if ($row->getRowIndex() == 2) {
                                // On boucle sur les cellule de la ligne
                                foreach ($row->getCellIterator() as $cell) {

                                  if ($raisonSociale == null) {
                                        $raisonSociale = $cell->getValue();
                                    } elseif ($adresseClient == null) {
                                        $adresseClient = $cell->getValue();

                                    } elseif ($emailClient == null) {
                                        $emailClient = $cell->getValue();
                                    } elseif ($nomContact == null) {
                                        $nomContact = $cell->getValue();
                                    } elseif ($prenomContact == null) {
                                        $prenomContact = $cell->getValue();

                                    } elseif ($date == null) {
                                        $date = $cell->getValue();
                                     // dd(strtotime($date));
                                        $date = date('Y-m-d', strtotime($date));
                                       // dd($date);
                                    }

                                }

                            //    $exist=CommandeClient::where('numCommande','=',$numCommande)->count();
                         //       if($exist == 0) {
                                    $client=Client::where('raisonSociale','=',$raisonSociale)->count();

                                    $lastNum =CommandeClient::orderBy('idCommande','desc')->first();
                                    if ($lastNum != null) {
                                        $NumCommande = substr_replace($lastNum->numCommande, "", 0, 5);
                                        if ($NumCommande == 99999){
                                            $NumCommande='CMDCL00001';
                                        }
                                        else {
                                            $NumCommande = $NumCommande + 1;
                                            $NumCommande=str_pad($NumCommande, 5, '0', STR_PAD_LEFT);


                                            $NumCommande ='CMDCL'.$NumCommande;
                                        }

                                    }
                                    else
                                        $NumCommande='CMDCL00001';

                                    if($client == 0 )
                                    {
                                        $newClient = new Client() ;
                                        $newClient->raisonSociale = $raisonSociale;
                                        $newClient->nomClient = $nomContact;
                                        $newClient->prenomClient = $prenomContact;
                                        $newClient->emailClient = $emailClient;
                                        $newClient->adresseClient = $adresseClient;
                                        $newClient->save();

                                        $idClient = Client::max('idClient');



                                        $commandeClient =new CommandeClient();
                                        $commandeClient->numCommande = $NumCommande;
                                        $commandeClient->dateCommande = $date;
                                        $commandeClient->idClient = $idClient ;
                                        $commandeClient->statutCommande	 = "En cours" ;
                                        $commandeClient->save() ;

                                    }

                                    else
                                    {

                                        $client = Client::where('raisonSociale','=',$raisonSociale)->first();

                                        $commandeClient =new CommandeClient();
                                        $commandeClient->numCommande = $NumCommande;
                                        $commandeClient->dateCommande = $date;
                                        $commandeClient->idClient = $client->idClient ;
                                        $commandeClient->statutCommande	 = "En cours" ;

                                        $commandeClient->save() ;

                                    }

                           //     }
                          //      else
                          //      {
                          //          return redirect::back()->withInput()->withErrors(['N° commande existe déjà ']);
                          //      }





                            } else if ($row->getRowIndex() > 3) {
                                

                                // try {
                                $reference = null;
                                $designation = null;
                                $quantite = null;
                                $tva = null;
                                $prixUnitaireHT = null;
                                $prixUnitaireTTC = null;
                                $totalPrixHT = null;
                                $totalPrixTTC = null;
                              //  dd($row->getCellIterator());
                                $i=0;
                                foreach ($row->getCellIterator() as $cell) {
                                    $i++;
                                    if($i==1){
                                        $reference = $cell->getValue();
                                    }
                                    if($i==2){
                                        $designation = $cell->getValue();
                                    } if($i==3){
                                        $quantite = $cell->getValue();
                                    }if($i==4){
                                        $tva = $cell->getValue();
                                    }if($i==5){
                                        $prixUnitaireHT = $cell->getValue();
                                    }if($i==6){
                                        $prixUnitaireTTC = $cell->getValue();
                                    }if($i==7){
                                        $totalPrixHT = $cell->getValue();
                                    }if($i==8){
                                        $totalPrixTTC = $cell->getValue();
                                    }
                                   /* if ($reference == null && $designation == null && $quantite == null && $tva == null && $prixUnitaireHT == null && $prixUnitaireTTC == null && $totalPrixHT == null && $totalPrixTTC == null) {
                                        $reference = $cell->getValue();

                                    } elseif ($reference != null && $designation == null && $quantite == null && $tva == null && $prixUnitaireHT == null && $prixUnitaireTTC == null && $totalPrixHT == null && $totalPrixTTC == null) {
                                        $designation = $cell->getValue();

                                    } elseif ($reference != null && $designation != null && $quantite == null && $tva == null && $prixUnitaireHT == null && $prixUnitaireTTC == null && $totalPrixHT == null && $totalPrixTTC == null) {
                                        $quantite = $cell->getValue();

                                    } elseif ($reference != null && $designation != null && $quantite != null && $tva == null && $prixUnitaireHT == null && $prixUnitaireTTC == null && $totalPrixHT == null && $totalPrixTTC == null) {
                                        $tva = $cell->getValue();
                                        //dd($tva);
                                    } elseif ($reference != null && $designation != null && $quantite != null && $tva != null && $prixUnitaireHT == null && $prixUnitaireTTC == null && $totalPrixHT == null && $totalPrixTTC == null) {
                                        $prixUnitaireHT = $cell->getValue();
                                     //   dd($prixUnitaireHT);

                                    } elseif ($reference != null && $designation != null && $quantite != null && $tva != null && $prixUnitaireHT != null && $prixUnitaireTTC == null && $totalPrixHT == null && $totalPrixTTC == null) {
                                        $prixUnitaireTTC = $cell->getValue();
//dd("UTTC".$prixUnitaireTTC);
                                    } elseif ($reference != null && $designation != null && $quantite != null && $tva != null && $prixUnitaireHT != null && $prixUnitaireTTC != null && $totalPrixHT == null && $totalPrixTTC == null) {
                                        $totalPrixHT = $cell->getValue();
                                       // dd($totalPrixHT);
                                    } elseif ($reference != null && $designation != null && $quantite != null && $tva != null && $prixUnitaireHT != null && $prixUnitaireTTC != null && $totalPrixHT != null && $totalPrixTTC == null) {
                                        $totalPrixTTC = $cell->getValue();
                                        //dd($totalPrixTTC);
                                    }*/

                                }
                                $i=0;
                                if ($reference =='') {
                                    break;
                                }
                                //dd($prixUnitaireHT);
                              //  dd($prixUnitaireTTC);
                                $idCommande = CommandeClient::max('idCommande');
                                $idProduit = Produit::where('reference','=',$reference)->first();

                                if($idProduit){
                                    $ligneProduit = new LigneCommandeProduit();
                                    $ligneProduit->idCommande = $idCommande;
                                    $ligneProduit->idProduit = $idProduit->id_produit;
                                    $ligneProduit->quantiteCommande = $quantite;
                                    $ligneProduit->tva = $tva;
                                    $ligneProduit->prixHT = $prixUnitaireHT;
                                    $ligneProduit->prixTTC = $prixUnitaireTTC;
                                    $ligneProduit->totalPrixHT = $totalPrixHT;
                                    $ligneProduit->totalPrixTTC = $totalPrixTTC;
                                    $ligneProduit->save();
                                }
                                else{
                                    $idCommande=CommandeClient::max('idCommande');
                                    $annulerCommande=CommandeClient::find($idCommande);
                                    $annulerCommande->delete();
                                    return redirect::back()->withInput()->withErrors(['Veuillez vérifier que les produits commandés existent dans la liste des produits ']);
                                }



                              //  dd($reference, $designation,$quantite,$tva ,$prixUnitaireHT, $prixUnitaireTTC ,$totalPrixHT, $totalPrixTTC );
                                /****/
                            }


                        }

                        //fin else
                    }

                    $HistoriqueActions = new Historique();
                    $HistoriqueActions->type_action = 'Importation';
                    $HistoriqueActions->nom_table = 'Clients->Les commandes des clients';
                    $HistoriqueActions->description = 'Importation du commande client depuis un fichier ' ;
                    $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                    $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                    $HistoriqueActions->save();

                    return redirect('commande_client/index')->with('msgAjouter', 'Fichier importé avec succès');


                } else return redirect::back()->withInput()->withErrors(['Fichier volumineux ']);
            } else
                return redirect::back()->withInput()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx" ']);

    }


    public function redirectPreparation($id)
    {
      //dd($id);
        $commande =CommandeClient::find($id);
        Session::put('numP',1234);
        Session::put('numCommande', $commande->numCommande);
        Session::put('commande', 'checked');
        Session::put('raisonSociale', $commande->client->raisonSociale);
        Session::put('adresseClient', $commande->client->adresseClient);
        Session::put('pageSource', 'commande');
        Session::put('idPr', $id);
        return redirect('preparation/ajouter');
    }

    public function downloadModele(Request $request){


        $file=public_path()."/Modele_Commande_client.xlsx";
        $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
        return Response::download($file, 'Modele_Commande_client.xlsx',$headers);
        //return \Illuminate\Support\Facades\Response::download($file);

    }

    public function getForm()
    {

        $clients = Client::all();
        $produits = Produit::all();
        $lignescommande = LigneCommandeProduit::where('idCommande', '=', 0)->with('produit')->get();
        //dd($lignescommande);

        $lastNum =CommandeClient::orderBy('numCommande','desc')->first();
        // dd($lastNum);
        if ($lastNum != null) {
            $NumCmdCL = substr_replace($lastNum->numCommande, "", 0, 5);
            if ($NumCmdCL == 99999){
                $NumCmdCL='CMDCL00001';
            }
            else {
                $NumCmdCL = $NumCmdCL + 1;
                $NumCmdCL=str_pad($NumCmdCL, 5, '0', STR_PAD_LEFT);


                $NumCmdCL ='CMDCL'.$NumCmdCL;
            }

        }
        else
            $NumCmdCL='CMDCL00001';

        return view('commande_client.ajouter', compact( 'clients', 'produits', 'lignescommande','NumCmdCL'));
    }

    public function getClient()
    {
        $ref = Input::get('ID');
        $rest=DB::table('client')
            ->where('idClient','=',$ref)
            ->get();

        return response()->json($rest);
    }


    public function postAddLigneCommande(Request $request)
    {
        /*$this->validate($request, [
                'produit' => 'required'
        ]);*/
        $produit = $request->input('produit');
        if (!$produit) {
            
            $request->session()->flash('erreur', 'Veuillez sélectionner un produit');
            return redirect('commande_client/ajouter');
        }

        Session::put('idClient', $request->input('idClient'));
        Session::put('contactClient', $request->input('contactClient'));
        Session::put('adresseClient', $request->input('adresseClient'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));


        //dd( Session::get('etatCommande'));

        $exist = LigneCommandeProduit::where('idCommande', '=', 0)->where('idProduit', '=', $request->input('produit'))->count();
        if($exist == 0)
        {
            $lignecommande = new LigneCommandeProduit();

            $lignecommande->idProduit = $request->input('produit');
            $lignecommande->idCommande = 0;
            $lignecommande->quantiteCommande = $request->input('quantite');
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prixHT = $request->input('prix_unitaire_ht');
            $lignecommande->prixTTC = $request->input('prix_unitaire_ttc');
            $lignecommande->totalPrixHT = $request->input('totale_ht');
            $lignecommande->totalPrixTTC = $request->input('totale_ttc');

            $lignecommande->save();

            return redirect('commande_client/ajouter');
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à la commande');
        }

    }


    public  function postForm(Request $request)
    {
       // dd($request->input('dateCreationCommande'));
        $commande =  new CommandeClient();

        $commande->numCommande = $request->input('num_commande_client');
        $commande->idClient = $request->input('client');
        $commande->dateCommande = $request->input('dateCreationCommande');
        $commande->statutCommande = $request->input('statut');

        $commande->save();

        LigneCommandeProduit::where('idCommande','=',0)->update(['idCommande' =>  $commande->idCommande]);

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Ajout';
        $HistoriqueActions->nom_table = 'Clients->Les commandes des clients';
        $HistoriqueActions->description = 'Ajout du commande client : '.$commande->numCommande ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();


        return redirect('commande_client/index')->with('msgAjouter','Commande ajoutée avec succès');
    }

    public function postEditeLigneCommande(Request $request, $id)
    {

        Session::put('idClient', $request->input('idClient'));
        Session::put('contactClient', $request->input('contactClient'));
        Session::put('adresseClient', $request->input('adresseClient'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));


        $exist = LigneCommandeProduit::where('idCommande', '=', 0)->where('idProduit', '=', $request->input('produit'))->where('idLigneCommandeProduit','!=',$id)->count();

        if($exist == 0)
        {
            $lignecommande = LigneCommandeProduit::find($id);

            $lignecommande->idProduit = $request->input('produit');
            $lignecommande->idCommande = 0;
            $lignecommande->quantiteCommande = $request->input('quantite');
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prixHT = $request->input('prix_unitaire_ht');
            $lignecommande->prixTTC = $request->input('prix_unitaire_ttc');
            $lignecommande->totalPrixHT = $request->input('totale_ht');
            $lignecommande->totalPrixTTc = $request->input('totale_ttc');

            $lignecommande->update();

            return redirect('commande_client/ajouter');
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à la commande');
        }
    }

    public function deleteLigneCommande(Request $request, $id)
    {

        Session::put('idClient', $request->input('idClient'));
        Session::put('contactClient', $request->input('contactClient'));
        Session::put('adresseClient', $request->input('adresseClient'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

        LigneCommandeProduit::find($id)->delete();
        return redirect('commande_client/ajouter');
    }

    public  function getFormEdit($id)
    {

        $commande_client  = CommandeClient::find($id);
        $lignescommande = LigneCommandeProduit::where('idCommande', '=', $id)->with('produit')->get();

        $clients = Client::all();
        $client_commande = Client::find($commande_client->idClient);


        $produits = Produit::all();

        if(!Session::has('commandes_clients')) {

            Session::put('idClient', $client_commande->idClient);
            Session::put('contactClient', $client_commande->nomClient . " " . $client_commande->prenomClient);
            Session::put('adresseClient', $client_commande->adresseClient);
            Session::put('dateCreation', $commande_client->dateCommande);

            Session::put('commandes_clients', $commande_client);
            Session::put('ligne_commande_client', $lignescommande);
        }



        return view('commande_client.modifier', compact('clients', 'client_commande', 'produits', 'lignescommande', 'commande_client'));


    }

    public function postAddLigneCommandeEdit(Request $request, $id)
    {
        $produit = $request->input('produit');
        if (!$produit) {
            
            $request->session()->flash('erreur', 'Veuillez sélectionner un produit');
            return redirect('commande_client/modifier/' . $id);
        }

        Session::put('idClient', $request->input('idClient'));
        Session::put('contactClient', $request->input('contactClient'));
        Session::put('adresseClient', $request->input('adresseClient'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

       // dd($request->input());

        $exist = LigneCommandeProduit::where('idCommande', '=', $id)
            ->where('idProduit', '=', $request->input('produit'))
            ->count();
        if ($exist == 0) {
            $lignecommande = new LigneCommandeProduit();

            $lignecommande->idProduit = $request->input('produit');
            $lignecommande->idCommande = $id;
            $lignecommande->quantiteCommande = $request->input('quantite');
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prixHT = $request->input('prix_unitaire_ht');
            $lignecommande->prixTTC = $request->input('prix_unitaire_ttc');
            $lignecommande->totalPrixHT = $request->input('totale_ht');
            $lignecommande->totalPrixTTC = $request->input('totale_ttc');

            $lignecommande->save();

            return redirect('commande_client/modifier/' . $id);
        } else {
            return redirect()->back()->withInput()->with('msgExist', 'Ce produit est déjà ajouté à la commande');
        }

    }


    public function postEditeLigneCommandeEdit(Request $request,$id,$idCommande)
    {
        Session::put('idClient', $request->input('idClient'));
        Session::put('contactClient', $request->input('contactClient'));
        Session::put('adresseClient', $request->input('adresseClient'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

       // dd(Session::get('idClient'));

        $exist = LigneCommandeProduit::where('idCommande', '=', $idCommande)->where('idProduit', '=', $request->input('produit'))->where('idLigneCommandeProduit','!=',$id)->count();

        if($exist == 0)
        {
            $lignecommande = LigneCommandeProduit::find($id);

            $lignecommande->idProduit = $request->input('produit');
            $lignecommande->idCommande = $idCommande;
            $lignecommande->quantiteCommande = $request->input('quantite');
            $lignecommande->tva = $request->input('tva');
            $lignecommande->prixHT = $request->input('prix_unitaire_ht');
            $lignecommande->prixTTC = $request->input('prix_unitaire_ttc');
            $lignecommande->totalPrixHT = $request->input('totale_ht');
            $lignecommande->totalPrixTTC = $request->input('totale_ttc');

            $lignecommande->update();

            return redirect('commande_client/modifier/'.$idCommande);
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à la commande');
        }

    }

    public function deleteLigneCommandeClientEdit(Request $request,$id,$idCommande)
    {

        Session::put('idClient', $request->input('idClient'));
        Session::put('contactClient', $request->input('contactClient'));
        Session::put('adresseClient', $request->input('adresseClient'));
        Session::put('dateCreation', $request->input('dateCreationCommande'));

        //dd( Session::get('dateCreation'));

        LigneCommandeProduit::find($id)->delete();

        return redirect('commande_client/modifier/'.$idCommande);
    }


    public function postFormEdit(Request $request,$id)
    {
        // dd(number_format($request->input('total_ht'), 2));
        $commande =  CommandeClient::find($id);

        $commande->idClient = $request->input('client');
        $commande->dateCommande = $request->input('date_creation');
        $commande->update();

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Modification';
        $HistoriqueActions->nom_table = 'Clients->Les commandes des clients';
        $HistoriqueActions->description = 'Modification du commande client : '.$commande->numCommande ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        Session::put('commandes_clients', null);
        Session::put('ligne_commande_client',null);

        return redirect('commande_client/index')->with('msgAjouter','Commande modifiée avec succès');
    }


    public function cancelModification($id)
    {
        //DB::unprepared('SET IDENTITY_INSERT ligne_commande_produit ON');
        //dd(Config::get('database')['default']);
        //$test = 1;
        $test = LigneCommandeProduit::where('idCommande', '=', $id)->delete();
        if ($test != 0) {
            $lignescommande = Session::get('ligne_commande_client');
            //dd($lignescommande);
            if ($lignescommande) {
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_produit ON');
                }
                foreach($lignescommande as $ligne){
				
                    $lignecommande = new LigneCommandeProduit();
                    $lignecommande->idLigneCommandeProduit = $ligne->idLigneCommandeProduit;
                    $lignecommande->idProduit = $ligne->idProduit;
                    $lignecommande->idCommande = $id;
                    $lignecommande->quantiteCommande = $ligne->quantiteCommande;
                    $lignecommande->tva = $ligne->tva;
                    $lignecommande->prixHT = $ligne->prixHT;
                    $lignecommande->prixTTC = $ligne->prixTTC;
                    $lignecommande->totalPrixHT =$ligne->totalPrixHT;
                    $lignecommande->totalPrixTTC = $ligne->totalPrixTTC;
                    $lignecommande->save(); 
                }
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_produit OFF');
                }
            }

        return redirect('commande_client/index');
    }
    }
}