<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 07/06/2017
 * Time: 12:45
 */

namespace App\Http\Controllers;


use App\Client;
use App\CommandeClient;
use App\Commune;
use App\Historique;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Wilaya;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;


class ClientController extends Controller
{





    public function index()
    {


        $clients = Client::paginate(100);
        return view('client.index',compact('clients'));
    }
	public function recherche(Request $request){
        $mot_a_rechercher = $request->get('recherche');

        $clients = Client::select('client.*')->
        Where('raisonSociale','like','%'.$mot_a_rechercher.'%')->
        orWhere('nomClient','like','%'.$mot_a_rechercher.'%')->
        orWhere('prenomClient','like','%'.$mot_a_rechercher.'%')->
        orWhere('telephoneClient','like','%'.$mot_a_rechercher.'%')->
        orWhere('emailClient','like','%'.$mot_a_rechercher.'%')->
        orWhere('adresseClient','like','%'.$mot_a_rechercher.'%')->
        orWhere('region','like','%'.$mot_a_rechercher.'%')->
        paginate(100)->appends('recherche' , $mot_a_rechercher);
                //dd($produits);
        return view('client.index',compact('clients','mot_a_rechercher'));

    }


    public function getForm()
    {
        $wilayas = Wilaya::all();
        return view('client.ajouter',compact('wilayas'));
    }


    public function delete($id)
    {

        $exist = CommandeClient::where('idClient', '=', $id)->count();
        if($exist == 0)
        {
            $client=Client::find($id);


            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Clients->Liste des clients';
            $HistoriqueActions->description = 'Suppression du client : '.$client->raisonSociale ;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $client->delete();

            return redirect('client/index')->with('msgDeleteOk',"Le client a été supprimé avec succès");
        }
        else
        {
            return redirect('client/index')->with('msgDeleteNotOk',"Impossible de supprimer le client car des commandes clients lui sont attribués");
        }




    }


    public function postForm(Request $request)
    {
      //  dd($request->input());
        $exist = Client::where('raisonSociale', '=', $request->input('societe'))->count();
        if($exist == 0)
        {
            
            $client = new Client();
            $client->raisonSociale = $request->input('societe');
            $client->nomClient = $request->input('nom');
            $client->prenomClient = $request->input('prenom');
            $client->adresseClient = $request->input('adresse');
            $client->telephoneClient = $request->input('telephone');
            $client->emailClient = $request->input('email');
            if ($request->input('region') != '' || $request->input('region') != null) {
                $client->region = $request->input('region');
            }
            
            $client->save();


            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Clients->Liste des client';
            $HistoriqueActions->description = 'Ajout du client : '.$client->raisonSociale ;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('client/index')->with('msgAddSuccess',"Le client a été ajouté avec succès");



        }
        else
        {
            return redirect('client/ajouter')->with('msgAddExist',"Ce client existe déjà");

        }


    }



    public function getFormEdit($id)
    {

        $client = client::find($id);
        $wilayas = Wilaya::all();
        $id_wilaya = $client->region;

        return view('client/modifier', compact('client','wilayas','id_wilaya'));


    }




    public function postFormEdit(Request $request, $id)
    {



        $client = client::find($id);

        $exist = client::where('raisonSociale', '=', $request->input('societe'))
            ->where('idClient','!=',$id)
            ->count();
        if($exist == 0)
        {

            $client->raisonSociale = $request->input('societe');
            $client->nomClient = $request->input('nom');
            $client->prenomClient = $request->input('prenom');
            $client->adresseClient = $request->input('adresse');
            $client->telephoneClient = $request->input('telephone');
            $client->emailClient = $request->input('email');
            $client->region = $request->input('region');
            $client->update();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'clients->Liste des clients';
            $HistoriqueActions->description = 'Modification du client : '.$client->raisonSociale ;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('client/index')->with('msgAddSuccess',"Le client a été modifié avec succès");

        }
        else
        {
            return redirect('client/modifier/'.$id)->with('msgUpdateExist','Ce client existe déjà');

        }


    }


}