<?php

namespace App\Http\Controllers;


use App\Chargement;
use App\ConfigurationPdf;
use App\Emplacement;
use App\Historique;
use App\LignePreparationChargement;
use App\ListValeur;
use App\Preparation;
use App\Transporteur;
use App\NumeroSerie;
use App\LigneProduit;
use App\StockProduit;
use App\UniteExpedition;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;
use App\CompteurModule;
use Excel;
use PHPExcel;
//use App\LignePreparationChargement;

class ChargementController extends Controller
{
    public function index(){

        $chargements = DB::table('chargement')
                        ->join('liste_valeur', 'liste_valeur.code', '=', 'chargement.statutChargement')
                        ->leftJoin('transporteur', 'chargement.idTransporteur', '=', 'transporteur.idTransporteur')
                        ->leftJoin('emplacement', 'chargement.idEmplacement', '=', 'emplacement.id_emplacement')
                        ->leftJoin('preparation', function ($join) {
                            $join->on('chargement.numChargement', '=', DB::raw("CONCAT('CHA-', preparation.numPreparation)"));
                        })
                        ->leftJoin('bon_livraison', 'preparation.idPreparation', '=', 'bon_livraison.id_preparation')
                        //les chargement qui ne sont pas livrée
                        ->where('bon_livraison.num_bl', '=', null)
                        ->where('liste_valeur.nom_liste', '=', 'STATUT_CHARGEMENT')
                        ->select(['chargement.idChargement','chargement.numChargement','transporteur.numTransporteur','transporteur.nomTransporteur','transporteur.prenomTransporteur','emplacement.libelle','chargement.dateChargement','chargement.totalUE_chargement','chargement.totalProduits_chargement','chargement.totalPoids_chargement','bon_livraison.num_bl','bon_livraison.id_bon_livraison','liste_valeur.valeur'])
                        ->paginate(100);

        $statut_chargement = ListValeur::where('nom_liste','STATUT_CHARGEMENT')->get();
        //dd($statut_chargement);
        
        return view('chargement.index',compact('chargements','statut_chargement'));
    }

    public function recherche(Request $request){

        $mot_a_rechercher = Input::get('recherche');
        $mode_affichage = Input::get('mode_affichage');
        $statut = Input::get('statut');
        
        //dd($statut , $mot_a_rechercher, $mode_affichage);

        $chargements = DB::table('chargement')
                        ->join('liste_valeur', 'liste_valeur.code', '=', 'chargement.statutChargement')
                        ->leftJoin('transporteur', 'chargement.idTransporteur', '=', 'transporteur.idTransporteur')
                        ->leftJoin('emplacement', 'chargement.idEmplacement', '=', 'emplacement.id_emplacement')
                        ->leftJoin('preparation', function ($join) {
                            $join->on('chargement.numChargement', '=', DB::raw("CONCAT('CHA-', preparation.numPreparation)"));
                        })
                        ->leftJoin('bon_livraison', 'preparation.idPreparation', '=', 'bon_livraison.id_preparation')

                        ->where('liste_valeur.nom_liste', '=', 'STATUT_CHARGEMENT')
                        ->where(function ($query1) use ($mot_a_rechercher) {
                            $query1->where('chargement.numChargement', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('chargement.dateChargement', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('chargement.totalUE_chargement', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('chargement.totalProduits_chargement', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('chargement.totalPoids_chargement', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('liste_valeur.valeur', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('transporteur.numTransporteur', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('transporteur.nomTransporteur', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('transporteur.prenomTransporteur', 'like', '%' . $mot_a_rechercher . '%')
                            ->orWhere('emplacement.libelle', 'like', '%' . $mot_a_rechercher . '%');
                        })
                        ->where(function($query) use ($mode_affichage){
                                if ($mode_affichage == 1 || $mode_affichage == '') $query->where('bon_livraison.num_bl', '=', null);
                                if ($mode_affichage == 2) $query->where('bon_livraison.num_bl', '!=', null);
                        })
                        ->where(function($query2) use ($statut){
                                if ($statut != '10') $query2->where('chargement.statutChargement', '=', $statut);
                        })
                        ->select(['chargement.idChargement','chargement.numChargement','transporteur.numTransporteur','transporteur.nomTransporteur','transporteur.prenomTransporteur','emplacement.libelle','chargement.dateChargement','chargement.totalUE_chargement','chargement.totalProduits_chargement','chargement.totalPoids_chargement','bon_livraison.num_bl','bon_livraison.id_bon_livraison','liste_valeur.valeur'])
                        ->paginate(100)
                        ->appends(['recherche'=> $mot_a_rechercher, 'mode_affichage' => $mode_affichage, 'statut' => $statut]);

                        //dd($mot_a_rechercher, $mode_affichage, $chargements);
        $statut_chargement = ListValeur::where('nom_liste','STATUT_CHARGEMENT')->get();

        return view('chargement.index',compact('chargements','mot_a_rechercher','mode_affichage','statut_chargement','statut'));  
    }

    public function filtre(Request $request){
        $mode_affichage = Input::get('mode_affichage');
        $statut = Input::get('statut');
        
        $chargements = DB::table('chargement')
                        ->join('liste_valeur', 'liste_valeur.code', '=', 'chargement.statutChargement')
                        ->leftJoin('transporteur', 'chargement.idTransporteur', '=', 'transporteur.idTransporteur')
                        ->leftJoin('emplacement', 'chargement.idEmplacement', '=', 'emplacement.id_emplacement')
                        ->leftJoin('preparation', function ($join) {
                            $join->on('chargement.numChargement', '=', DB::raw("CONCAT('CHA-', preparation.numPreparation)"));
                        })
                        ->leftJoin('bon_livraison', 'preparation.idPreparation', '=', 'bon_livraison.id_preparation')
                        ->where(function($query) use ($mode_affichage){
                                if ($mode_affichage == 1) $query->where('bon_livraison.num_bl', '=', null);
                                if ($mode_affichage == 2) $query->where('bon_livraison.num_bl', '!=', null);
                        })
                        ->where(function($query2) use ($statut){
                                if ($statut != 10) $query2->where('chargement.statutChargement', '=', $statut);
                        })
                        ->where('liste_valeur.nom_liste', '=', 'STATUT_CHARGEMENT')
                        ->select(['chargement.idChargement','chargement.numChargement','transporteur.numTransporteur','transporteur.nomTransporteur','transporteur.prenomTransporteur','emplacement.libelle','chargement.dateChargement','chargement.totalUE_chargement','chargement.totalProduits_chargement','chargement.totalPoids_chargement','bon_livraison.num_bl','bon_livraison.id_bon_livraison','liste_valeur.valeur'])
                        ->paginate(100)
                        ->appends(['mode_affichage' => $mode_affichage, 'statut' => $statut]);

        $statut_chargement = ListValeur::where('nom_liste','STATUT_CHARGEMENT')->get();

        return view('chargement.index',compact('chargements','mode_affichage','statut','statut_chargement'));
    }

    public function getForm(){
        $transporteurs=Transporteur::get();
        $emplacements=Emplacement::where('emplacement_mobile','=','OUI')->get();
        $idtransporteur=null;
        $lignes= [];

        /*$lastNum = Chargement::orderBy('idChargement', 'desc')->first();

        if ($lastNum != null) {
            $NumChargement = substr_replace($lastNum->numChargement, "", 0, 5);
           // dd($NumChargement);

            if ($NumChargement == 99999) {
                $NumChargement = 'CHARG00001';
            } else {
                $NumChargement = $NumChargement + 1;
                $NumChargement = str_pad($NumChargement, 5, '0', STR_PAD_LEFT);


                $NumChargement = 'CHARG' . $NumChargement;
            }

        } else
            $NumChargement = 'CHARG00001';*/
            $NumChargement = null;
            if ( Session::get('AJOUT_CHARGEMENT_PREPARATION') == 0) {
                
            
            if ( Session::get('numChargement') == null) {
        $monfichier = fopen('NumeroChargement.txt', 'r');

        $ligne1 = fgets($monfichier);
        $prefixe = explode("=", $ligne1);
        $prefixe = str_replace("\r\n","",$prefixe[1]);

        $ligne2 = fgets($monfichier);
        $date = explode("=", $ligne2);
        $date = str_replace("\r\n","",$date[1]);
        $date = date("Y-m-d");
        if ($date == "AAMMJJ") {
            $date = date("y-m-d");
        }
        if($date == "JJMMAA"){
            $date = date("d-m-y");
        }
        if ($date == "AAAA") {
            $date = date("Y");
        }
        if ($date == "AA") {
            $date = date("y");
        }

        $date = str_replace("-","",$date);

        $prep = CompteurModule::where('MODULE',"CHARGEMENT")->first();
        $day = 0;
        $mounth = 0;
        $year = 0;

        if ($prep != null) {
            $timestamp = strtotime($prep->last_update);
            
            if (date("Y", $timestamp) == date('Y')) $year = $prep->COMPTEUR_PAR_AN + 1;
            else $year = 1;

            if (date("m", $timestamp) == date('m')) $mounth = $prep->COMPTEUR_PAR_MOIS + 1;
            else $mounth = 1;

            if (date("d", $timestamp) == date('d')) $day= $prep->COMPTEUR_PAR_JOUR + 1;
            else $day = 1;

            //$prep->last_update = date("Y-m-d");
            //$prep->update();
        }else{
            /*$prep = new CompteurModule();
            $prep->MODULE = "PREPARATION";
            $prep->COMPTEUR_PAR_JOUR = 1;
            $prep->COMPTEUR_PAR_MOIS = 1;
            $prep->COMPTEUR_PAR_AN = 1;
            $prep->last_update = date("Y-m-d");
            $prep->save();*/
            $day = 1;
            $mounth = 1;
            $year = 1;
        }
        $ligne3 = fgets($monfichier);
        $taille_compteur = explode("=", $ligne3);
        $taille_compteur = (int)str_replace("\r\n","",$taille_compteur[1]);

        $ligne4 = fgets($monfichier);
        $format_sequence = explode("=", $ligne4);
        $format_sequence = str_replace("\r\n","",$format_sequence[1]);
        $format_sequence = str_replace("+","",$format_sequence);

        $jour = str_pad($day, $taille_compteur, '0', STR_PAD_LEFT);
        $mois = str_pad($mounth, $taille_compteur, '0', STR_PAD_LEFT);
        $an = str_pad($year, $taille_compteur, '0', STR_PAD_LEFT);

        $format_sequence = str_replace("DATE",$date,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_JOUR",$jour,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_MOIS",$mois,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_AN",$an,$format_sequence);
        $NumChargement = $prefixe.$format_sequence;

        Session::put('numChargement',$NumChargement);
        }else
        $NumChargement = Session::get('numChargement');
    }

        return view('chargement.ajouter',compact('transporteurs','emplacements','lignes','idtransporteur','NumChargement'));
    }


    public function getFormid($id)
    {
        /*$lastNum = Chargement::orderBy('idChargement', 'desc')->first();
        if ($lastNum != null) {
            $NumChargement = substr_replace($lastNum->numChargement, "", 0, 5);
            if ($NumChargement == 99999) {
                $NumChargement = 'CHARG00001';
            } else {
                $NumChargement = $NumChargement + 1;
                $NumChargement = str_pad($NumChargement, 5, '0', STR_PAD_LEFT);


                $NumChargement = 'CHARG' . $NumChargement;
            }

        } else
            $NumChargement = 'CHARG00001';*/
        $NumChargement = Session::get('numChargement');

        $transporteurs=Transporteur::get();
        $emplacements=Emplacement::where('emplacement_mobile','=','OUI')->get();
        $idtransporteur=Transporteur::find($id);
        $LignePreparationChargement=LignePreparationChargement::select('idPreparation')->get();
      // dd($LignePreparationChargement);
        $lignes=Preparation::with('CommandeClient.Client')
            ->where('idTransporteur','=',$id)
            ->where('statutPreparation','!=',4)
            ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
            ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
            ->whereNotIn('idPreparation',$LignePreparationChargement)
            ->get();
        //dd($lignes);

        return view('chargement.ajouter',compact('transporteurs','emplacements','lignes','idtransporteur','NumChargement'));
    }

     public function postForm(Request $request,$id)
     {
        $chargementExist=Chargement::where('numChargement','=',$request->input('numChargement'))
            ->count();
         //dd($chargementExist);

         if($chargementExist == 0 )
        {
            $chargement= new Chargement();
            $NumChargement = -2;
            if ( Session::get('AJOUT_CHARGEMENT_PREPARATION') == 0) {
            
            $monfichier = fopen('NumeroChargement.txt', 'r');

        $ligne1 = fgets($monfichier);
        $prefixe = explode("=", $ligne1);
        $prefixe = str_replace("\r\n","",$prefixe[1]);

        $ligne2 = fgets($monfichier);
        $date = explode("=", $ligne2);
        $date = str_replace("\r\n","",$date[1]);
        $date = date("Y-m-d");
        if ($date == "AAMMJJ") {
            $date = date("y-m-d");
        }
        if($date == "JJMMAA"){
            $date = date("d-m-y");
        }
        if ($date == "AAAA") {
            $date = date("Y");
        }
        if ($date == "AA") {
            $date = date("y");
        }

        $date = str_replace("-","",$date);

        $prep = CompteurModule::where('MODULE',"CHARGEMENT")->first();
        
        if ($prep != null) {
            $timestamp = strtotime($prep->last_update);
            
            if (date("Y", $timestamp) == date('Y')) $prep->COMPTEUR_PAR_AN += 1;
            else $prep->COMPTEUR_PAR_AN = 1;

            if (date("m", $timestamp) == date('m')) $prep->COMPTEUR_PAR_MOIS += 1;
            else $prep->COMPTEUR_PAR_MOIS = 1;

            if (date("d", $timestamp) == date('d')) $prep->COMPTEUR_PAR_JOUR += 1;
            else $prep->COMPTEUR_PAR_JOUR = 1;

            $prep->last_update = date("Y-m-d");
            $prep->update();
        }else{
            $prep = new CompteurModule();
            $prep->MODULE = "CHARGEMENT";
            $prep->COMPTEUR_PAR_JOUR = 1;
            $prep->COMPTEUR_PAR_MOIS = 1;
            $prep->COMPTEUR_PAR_AN = 1;
            $prep->last_update = date("Y-m-d");
            $prep->save();
        }

        $ligne3 = fgets($monfichier);
        $taille_compteur = explode("=", $ligne3);
        $taille_compteur = (int)str_replace("\r\n","",$taille_compteur[1]);

        $ligne4 = fgets($monfichier);
        $format_sequence = explode("=", $ligne4);
        $format_sequence = str_replace("\r\n","",$format_sequence[1]);
        $format_sequence = str_replace("+","",$format_sequence);

        $jour = str_pad($prep->COMPTEUR_PAR_JOUR, $taille_compteur, '0', STR_PAD_LEFT);
        $mois = str_pad($prep->COMPTEUR_PAR_MOIS, $taille_compteur, '0', STR_PAD_LEFT);
        $an = str_pad($prep->COMPTEUR_PAR_AN, $taille_compteur, '0', STR_PAD_LEFT);

        $format_sequence = str_replace("DATE",$date,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_JOUR",$jour,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_MOIS",$mois,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_N_PREP_AN",$an,$format_sequence);
        $NumChargement = $prefixe.$format_sequence;
    }

        $chargement->numChargement = $NumChargement;
            //$chargement->numChargement = $request->input('numChargement');
            $chargement->dateChargement = $request->input('dateChargement');
            $chargement->idTransporteur = $id;
            $chargement->idEmplacement = $request->input('idEmplacement');
            if (Session::get('STOCK_ENTITE') != "1" && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1") {
            $chargement->totalUE_chargement = $request->input('totalUE');
        }
            $chargement->totalProduits_chargement = $request->input('totalProduits');
            $chargement->totalPoids_chargement = $request->input('totalPoids');
            $chargement->statutChargement = 0;
            $chargement->save();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Clients->Les chargements';
            $HistoriqueActions->description = 'Ajout du chargement  : '.$chargement->numChargement;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $idChargement=Chargement::max('idChargement');

            $lignes=Preparation::with('CommandeClient.Client')
                ->where('idTransporteur','=',$id)
                ->get();
            // dd($lignes);
            foreach ($lignes as $ligne) {
                if($request->input('select'.$ligne->idPreparation.'')=='selected')
                {
                    $ligne_preparation = new LignePreparationChargement();
                    $ligne_preparation->idPreparation = $ligne->idPreparation;
                    $ligne_preparation->idChargement = $idChargement  ;
                    $ligne_preparation->save();

                    //get all ligne_produit
                    $lignesProduits = LigneProduit::where('idPreparation',$ligne->idPreparation)->get();
                    if ($lignesProduits) {
                        foreach ($lignesProduits as $key => $element) {
                            $stock = StockProduit::where('id_stock_produit',$element->idStock)->with('ue')->with('produit')->first();
                            //dd($stock);
                            if ($stock->ue->etat_ue == 0) {
                                $UniteE = 0;
                                $existeUE = UniteExpedition::where('SSCC',$stock->num_ue)->first();
                                if ($existeUE != null) {
                                       $UniteE= $existeUE;
                                }else{
                                    $UniteE = new UniteExpedition();
                                    $UniteE->SSCC = $stock->num_ue;
                                    $UniteE->nombreProduits = $stock->ue->nbr_produit;
                                    $UniteE->poidsProduits = 0;
                                    $UniteE->save();

                                    //totalUE_chargement
                                    $chargement->totalUE_chargement += 1;
                                    $chargement->update();
                                }
                                //edit ligne_produit
                                $element->idUE = $UniteE->idUE; 
                                $element->update();
                                
                            }
                        }
                    }
                    
                    
                }

            }

            return redirect('chargement/index')->with('msgAdd','Chargement ajouté avec succès');

        }
         else
         {
             return redirect('chargement/ajouter/'.$id.'')->with('msgExist','Numéro de chargement existe déja ');
         }


     }
    public function delete($id)
    {

    	
        $delete=Chargement::find($id);

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Suppression';
        $HistoriqueActions->nom_table = 'Clients->Les chargements';
        $HistoriqueActions->description = 'Suppression du chargement  : '.$delete->numChargement;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        //supp les box fermer trouver dans la table unite expedition
        if ($delete->totalUE_chargement != 0) {
           $lignes_chargement = LignePreparationChargement::where('idChargement','=',$id)->with('preparations.LigneProduit.stockProduit.ue')->get();
           if ($lignes_chargement != null) {
            foreach ($lignes_chargement as $key => $ligne) {
                foreach ($ligne->preparations->LigneProduit as $key => $value) {
                    $delete_unite_expedition = UniteExpedition::where('SSCC',$value->stockProduit->ue->num_ue)->delete();
                }
            } //dd($lignes_chargement);
           }
        }

        $delete->delete();


        $deleteLigne =LignePreparationChargement::where('idChargement','=',$id)->delete();

        return redirect()->back()->withInput()->with('msgSupprimer','Le chargement a été supprimé avec succès');

    }

    public function getEdit($id)
    {
        $transporteurs=Transporteur::get();
        $emplacements=Emplacement::where('emplacement_mobile','=','OUI')->get();
        $idtransporteur=null;
        $lignePreparation= LignePreparationChargement::select('idPreparation')
                    ->where('idChargement','=',$id)
                    ->get();

      //dd($lignePreparation);

        $chargement = Chargement::find($id);

        $listeStatut= ListValeur::where('nom_liste','=','STATUT_CHARGEMENT')
            ->get();


        /*$lignes=Preparation::with('CommandeClient.Client')
            ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
            ->whereIn('idPreparation',$lignePreparation)
            ->orwhere('idTransporteur','=',$chargement->idTransporteur)
            ->where('statutPreparation','!=',4)
            ->get();*/

            $lignes=Preparation::with('CommandeClient.Client')
            ->where('idTransporteur','=',$chargement->idTransporteur)
            ->where('statutPreparation','!=',4)
            ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
            ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
            ->whereIn('idPreparation',$lignePreparation)
            ->get();
       // dd($lignes);


        return view('chargement.modifier',compact('transporteurs','emplacements','lignes','idtransporteur','id','chargement','listeStatut'));
    }

    public function postEdit(Request $request,$id)
    {

        $chargementExist=Chargement::where('idChargement','!=',$id)
            ->where('numChargement','=',$request->input('numChargement'))
            ->count();

        if($chargementExist == 0 ){

            $chargement=Chargement::find($id);
            $chargement->numChargement = $request->input('numChargement');
            $chargement->dateChargement = $request->input('dateChargement');
            $chargement->idEmplacement = $request->input('idEmplacement');
            if (Session::get('STOCK_ENTITE') != "1" && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') != "1") {
                $chargement->totalUE_chargement = $request->input('totalUE');
            }
            $chargement->totalProduits_chargement = $request->input('totalProduits');
            $chargement->totalPoids_chargement = $request->input('totalPoids');
            $chargement->statutChargement = $request->input('Statut');
            $chargement->last_update= date("Y-m-d H:i:s");
            $chargement->update();

            //dd($chargement);


            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Clients->Les chargements';
            $HistoriqueActions->description = 'Modification du chargement  : '.$chargement->numChargement;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            $lignePreparation= LignePreparationChargement::select('idPreparation')
                ->where('idChargement','=',$id)
                ->get();

            $lignes=Preparation::with('CommandeClient.Client')
                ->whereIn('idPreparation',$lignePreparation)
                ->orwhere('idTransporteur','=',$chargement->idTransporteur)
                ->get();
            // dd($lignes);
            foreach ($lignes as $ligne) {
                $condition=LignePreparationChargement::select('idPreparation')
                    ->where('idPreparation','=',$ligne->idPreparation)->where('idChargement','=',$id)->count();

                if($request->input('select'.$ligne->idPreparation.'')=='selected')
                {
                    if($condition == 0 ){

                        $ligne_preparation = new LignePreparationChargement();
                        $ligne_preparation->idPreparation = $ligne->idPreparation  ;
                        $ligne_preparation->idChargement = $id  ;
                        $ligne_preparation->save();
                    }
                }
                else
                {
                    if($condition != 0)
                    {
                        $ligne_preparation = LignePreparationChargement::where('idPreparation','=',$ligne->idPreparation)
                            ->where('idChargement','=',$id)->first();
                        $ligne_preparation->delete();
                    }
                }

            }
            //dd($chargement);
            return redirect('chargement/index')->with('msgAdd','Chargement modifié avec succès');

        }
        else
        {
            return redirect('chargement/Modifier/'.$id.'')->with('msgExist','Numéro de chargement existe déja ');
        }

    }

    public function sessionChargement(){
        $num = Input::get('ID');

        Session::put('numChargement',$num);

        return response()->json();

    }

    public function sessionDate(){
        $num = Input::get('ID');

        Session::put('dateChargement',$num);

        return response()->json();

    }

    public function show(Request $request,$id)
    {
        if (($request->input("exportPdf") == 0) || ($request->input("exportPdf") == null)) {

            $chargement=Chargement::with('Transporteur')
                ->with('Emplacement')
                ->join('liste_valeur','liste_valeur.code','=','chargement.statutChargement')
                ->where('liste_valeur.nom_liste','=','STATUT_CHARGEMENT')
                ->find($id);

            $lignePreparation= LignePreparationChargement::select('idPreparation')
                ->where('idChargement','=',$id)
                ->get();
                //dd($lignePreparation);

            $lignesP=Preparation::select('idPreparation')
                ->whereIn('idPreparation',$lignePreparation)
                ->get();

            $lignes=Preparation::with('CommandeClient.Client')
                ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
                ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
                ->whereIn('idPreparation',$lignePreparation)
                ->get();
            // dd($lignes);
            $LigneProduits = LigneProduit::whereIn('idPreparation',$lignePreparation)
                ->with('StockProduit.Emplacement')
                ->with('UniteExpedition')
                ->with('Produit')
                ->with('User')
                //->leftJoin('numero_serie','numero_serie.id_ligne_produit','=','ligne_produit.idLigneProduit')
                ->get();

            //dd($LigneProduits);

            return view('chargement.detail',compact('lignes','id','chargement','Preparations','LigneProduits'));


        }
        else{

            $chargement=Chargement::with('Transporteur')
                ->with('Emplacement')
                ->join('liste_valeur','liste_valeur.code','=','chargement.statutChargement')
                ->where('liste_valeur.nom_liste','=','STATUT_CHARGEMENT')
                ->find($id);

            $lignePreparation= LignePreparationChargement::select('idPreparation')
                ->where('idChargement','=',$id)
                ->get();

            $lignesP=Preparation::select('idPreparation')
                ->whereIn('idPreparation',$lignePreparation)
                ->get();

            $lignes=Preparation::with('CommandeClient.Client')
                ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
                ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
                ->whereIn('idPreparation',$lignePreparation)
                ->get();
            // dd($lignes);
            $LigneProduits ='';
            if (Session::get('NUMERO_SERIE') == '1') {
               $LigneProduits = LigneProduit::whereIn('idPreparation',$lignePreparation)
                ->with('StockProduit.Emplacement')
                ->with('UniteExpedition')
                ->with('Produit')
                ->with('User')
                ->leftJoin('numero_serie','numero_serie.id_ligne_produit','=','ligne_produit.idLigneProduit')
                ->get();
            }else{
                $LigneProduits = LigneProduit::whereIn('idPreparation',$lignePreparation)
                ->with('StockProduit.Emplacement')
                ->with('UniteExpedition')
                ->with('Produit')
                ->with('User')
                ->get();
            }
            

            //dd($LigneProduits);

            $configuration = ConfigurationPdf::first();

            return view('chargement.export.exportPDF',compact('lignes','id','chargement','Preparations','LigneProduits','configuration'));
        }
    }

    public function charge($id_chargement){
        $chargement = Chargement::find($id_chargement);
        if ($chargement != null) {
            $chargement->statutChargement = 4;
            $chargement->update();
            //changer le status des préparations lié au chargement a préparer
            $preparations = LignePreparationChargement::where('idChargement', $chargement->idChargement)->get();
            if ($preparations != null) {
                foreach ($preparations as $preparation) {
                    $preparation = Preparation::find($preparation->idPreparation);
                    if ($preparation != null) {
                       
                        $preparation->statutPreparation = 3; //préparée
                        $preparation->last_update = date("Y-m-d H:i:s");
                        $preparation->update();
                        $ligne_preparation = LigneProduit::where('idPreparation',$preparation->idPreparation)->get();
                        if ($ligne_preparation != null) {
                            foreach ($ligne_preparation as $ligne) {
                                $ligne->quantite_preparer += $ligne->quantite_restante ; 
                                $ligne->quantite_restante = 0;
                                //$ligne->idUser = Session::get('id');
                                $ligne->last_update = date("Y-m-d H:i:s");
                                $ligne->update();
                            }
                        }
                    }
                }
            }
        }

        return redirect('chargement/index')->with('msgAdd','Chargement valider avec succès');

    }
public function get_numero_serie($id){
    $num_serie = NumeroSerie::where('id_ligne_produit',$id)->get();
    return $num_serie;
}

public function export(Request $request){

        $debut = $request->input("date_debut");
        $fin = $request->input("date_fin");

        $chargements = Chargement::join('ligne_preparation_chargement','ligne_preparation_chargement.idChargement','=','chargement.idChargement')              
                ->join('preparation','preparation.idPreparation','=','ligne_preparation_chargement.idPreparation')
                ->join('client','client.idClient','=','preparation.adresse_livraison')
                ->leftJoin('wilaya','wilaya.id_wilaya','=','client.region')
                ->leftJoin('commande_client','commande_client.idCommande','=','preparation.idCommande')
                ->join('liste_valeur','liste_valeur.code','=','preparation.statutPreparation')
                ->where('liste_valeur.nom_liste','=','STATUT_PREPARATION')
                ->whereBetween('chargement.dateChargement',[$debut, $fin])
                ->with('Transporteur')->with('LignePreparationsChargement.preparations.LigneProduit')->get();
        //dd($chargements);

        Excel::create('Rapport des chargements '.date('y-m-d'),function($excel) use ($chargements){
        $excel->sheet('Feuil1', function($sheet) use ($chargements){
            $sheet->setColumnFormat(array(
                'A' =>  '@',
                'B' =>  '@',
                'C' =>  '@',
                'D' =>  '@',
                'E' =>  '@',
                'F' =>  '@',
                'G' =>  '@',
                'H' =>  '@',
                'I' =>  '@',
                'J' =>  '@',
                'K' =>  '@',
                'L' =>  '@',
                'M' =>  '@',
            ));
            $sheet->setStyle(array(
                'font' => array(
                    'name' =>  'Calibri',
                    'size' =>  10,
                )
            ));
            /*$sheet->setWidth(array(
                'A' =>  30,
                'B' =>  50,
                'C' =>  30,
                'D' =>  30,
                'E' =>  15,
                'F' =>  20,
                'G' =>  70,
                'H' =>  15,
                'I' =>  15,
                'J' =>  15,
                'K' =>  25,
            ));*/
            $sheet->loadView('chargement.export.exportExcel')->with(['chargements'=>$chargements]);
        });
    })->download('xlsx');
    }


}