<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 25/05/2017
 * Time: 11:55
 */

namespace App\Http\Controllers;

use App\Historique;
use App\Produit;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Categorie;

use App\CommandeFournisseur;
use App\LigneCommandeFournisseur;
use App\BonReception;
use App\LigneBonReception;
use App\StockProduit;
use Illuminate\Support\Facades\Session;

class CategorieController extends Controller
{



    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                /*$stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                $stockProduit->update();*/

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }













    public function index()
    {

        CommandeFournisseur::where('date_creation', '=', null)->delete();
        BonReception::where('date_creation', '=', null)->delete();
        StockProduit::where('validation', '=', 0)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        $categories = Categorie::all();
        return view('categorie.index',compact('categories'));
    }


    public function getForm()
    {
        return view('categorie.ajouter');
    }



    public function postForm(Request $request)
    {

        $categorie = Categorie::where('libelle','=',$request->input('libelle'))->first();
        if($categorie == null)
        {
            $categorie = new Categorie();
            $categorie->libelle = $request->input('libelle');
            $categorie->description = $request->input('description');

            $categorie->save();
            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Administration->Catégories';
            $HistoriqueActions->description = 'Ajout du catégorie : '.$categorie->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date = Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('categorie/index')->with('msgAdd',"la catégorie a été ajouté avec succès");

        }
        else
        {
            return redirect()->back()->withInput()->with('msgLib','Le libellé existe déjà');
        }

    }


    public function delete($id)
    {

        $exist = Produit::where('id_categorie', '=', $id)->count();
        if($exist == 0)
        {
            $categorie=Categorie::find($id);
            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Suppression';
            $HistoriqueActions->nom_table = 'Administration->Catégories';
            $HistoriqueActions->description = 'Supprission du catégorie : '.$categorie->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date = Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();
            $categorie->delete();

            return redirect('categorie/index')->with('msgDelete',"La catégorie a été supprimé avec succès");
        }
        else
        {
            return redirect('categorie/index')->with('msgDelete',"Suppression impossible car des produits sont affectés à cette catégorie");
        }




    }

    public function getFormEdit($id)
    {
        $categorie = Categorie::find($id);
        return view('categorie/modifier', compact('categorie'));
    }

    public function postFormEdit(Request $request, $id)
    {
        $categorie = Categorie::find($id);
        $exist = Categorie::where('libelle','=',$request->input('libelle'))->where('id_categorie','!=',$id)->count();

       // $exist_libelle = Categorie::where('libelle', '=', $request->input('libelle'))->count();

        if($exist == 0 )
        {
            $categorie->libelle = $request->input('libelle');
            $categorie->description = $request->input('description');

            $categorie->update();

            $categorie=Categorie::find($id);
            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Modification';
            $HistoriqueActions->nom_table = 'Administration->Catégories';
            $HistoriqueActions->description = 'Modification du catégorie : '.$categorie->libelle;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date = Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            return redirect('categorie/index')->with('msgAdd',"La catégorie a été modifiée avec succès");
        }
        else
        {
            return redirect('categorie/modifier/'.$id)->with('msgLib','Le libellé existe déjà');

        }

    }


}