<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 24/09/2017
 * Time: 16:45
 */

namespace App\Http\Controllers;

use App\BonReception;
use App\StockProduit;
use App\Zone;
use App\Emplacement;
use App\CommandeFournisseur;
use App\LigneBonReception;
use App\LigneCommandeFournisseur;
use App\ListValeur;
use App\Produit;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;




class BonReceptionProductionControlleur extends Controller
{



    public function restorData(){

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');

            //dd($lignescommande);

            foreach($lignescommande as $ligne)
            {

                $lignecommande = new LigneCommandeFournisseur();

                $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $lignecommande->id_produit = $ligne->id_produit;
                $lignecommande->id_commande = $id;
                $lignecommande->quantite_commander = $ligne->quantite_commander;
                $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                $lignecommande->tva = $ligne->tva;
                $lignecommande->prix_ht = $ligne->prix_ht;
                $lignecommande->prix_ttc = $ligne->prix_ttc;
                $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                $lignecommande->save();


            }

        }


        if(Session::get('bonReception') != null)
        {

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');

            foreach($lignesBonReception as $ligne)
            {
                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;

                $stockProduit = StockProduit::find($ligne->id_stock_produit);
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                $stockProduit->update();

                $ligneBonReception->save();


            }

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }

    }







    public function index()
    {
        Session::put('dateCreation', null);
        Session::put('bonReceptionProduction', null);
        Session::put('lignesBonReceptionProduction', null);

        LigneBonReception::where('id_bon_reception','=',0)->delete();
        StockProduit::where('validation', '=', 0)->delete();
        BonReception::where('date_creation', '=', null)->delete();

        $bons_receptions = BonReception::where('supprimer', '=', 0)->where('id_commande', '=', 0)->get();

        CommandeFournisseur::where('date_creation', '=', null)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);

        return view('bon_reception_production.index',compact('bons_receptions'));
    }


    public function getForm()
    {

        $bonReceptionExiste = BonReception::where('date_creation', '=', null)->count();
        if ($bonReceptionExiste == 0){
            $bonReception = new BonReception();
            $bonReception->date_creation = null;
            $bonReception->id_commande = 0;
            $bonReception->supprimer = 0;
            $bonReception->save();
            $num_bon_reception = $bonReception->id_bon_reception;
        }else{
            $bonReception = BonReception::where('date_creation', '=', null)->first();
            $num_bon_reception = $bonReception->id_bon_reception;
        }

        $produits = Produit::all();
        $lignes = LigneBonReception::where('id_bon_reception','=',0)->with('stockProduit.produit')->get();
        //dd($lignes);

        $zones = Zone::all();
        $emplacements = Emplacement::all();

        return view('bon_reception_production.ajouter', compact('num_bon_reception', 'produits', 'zones', 'emplacements', 'lignes'));

    }



    public function postForm (Request $request)
    {
        //dd($request->input());

        $bonReception =  BonReception::find($request->input('num_bon_reception'));
        $bonReception->supprimer = 0;
        $bonReception->date_creation = $request->input("date_creation");
        $bonReception->id_commande = 0;
        $bonReception->update();



        LigneBonReception::where('id_bon_reception', '=', 0)->update(['id_bon_reception' =>  $request->input('num_bon_reception')]);
        StockProduit::where('validation', '=', 0)->update(['validation' => 1]);

        return redirect('receptions/reception_production/index')->with('msgAjouter','Bon de réception ajouté avec succès');


    }


    public function postAddLigneBonReceptionProduction(Request $request)
    {
        //dd($request->input());

        Session::put('dateCreation', $request->input('dateCreationBonReception'));

        $exist = LigneBonReception::where('id_bon_reception', '=', 0)->where('id_produit', '=', $request->input('produit'))->count();
        if($exist == 0)
        {
            $stockProduit = new StockProduit();
            $stockProduit->quantite = $request->input("quantiteReceptionnee");
            $stockProduit->date_fabrication = $request->input("dateFabrication");
            $stockProduit->date_peremption = $request->input("datePeremption");
            $stockProduit->numero_lot = $request->input("numeroLot");
            $stockProduit->date_entree = $request->input("dateEntree");
            $stockProduit->validation = 0;
            $stockProduit->id_produit = $request->input("produit");
            $stockProduit->id_emplacement = $request->input("emplacement");
            $stockProduit->save();
            $idStockProduit = $stockProduit->id_stock_produit;

            $ligneBonReception = new LigneBonReception();
            $ligneBonReception->id_bon_reception = 0;
            $ligneBonReception->id_ligne_commande_fournisseur = 0;
            $ligneBonReception->quantite_commander = $request->input("quantiteReceptionnee");
            $ligneBonReception->quantite_receptionner = $request->input("quantiteReceptionnee");
            $ligneBonReception->quantite_reste_receptionnee = 0;
            $ligneBonReception->id_stock_produit = $idStockProduit;
            $ligneBonReception->id_produit = $request->input("produit");
            $ligneBonReception->save();

            return redirect('receptions/reception_production/ajouter');

        }else{

            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté au bon de réception');

        }


    }


    public function postEditeLigneBonReceptionProduction(Request $request, $id)
    {
        //dd($id);
        //dd($request->input());
        Session::put('dateCreation', $request->input('dateCreationBonReception'));

        //dd($id);
        $exist = LigneBonReception::where('id_bon_reception', '=', 0)->where('id_produit', '=', $request->input('produit'))->where('id_ligne_bon_reception','!=',$id)->count();

        if($exist == 0)
        {
            $ligneBonReception = LigneBonReception::find($id);
            $idStockProduit = $ligneBonReception->id_stock_produit;
            $stockProduit = StockProduit::find($idStockProduit);

            $stockProduit->quantite = $request->input("quantiteReceptionnee");
            $stockProduit->date_fabrication = $request->input("dateFabrication");
            $stockProduit->date_peremption = $request->input("datePeremption");
            $stockProduit->numero_lot = $request->input("numeroLot");
            $stockProduit->date_entree = $request->input("dateEntree");
            $stockProduit->validation = 0;
            $stockProduit->id_produit = $request->input("produit");
            $stockProduit->id_emplacement = $request->input("emplacement");
            $stockProduit->update();

            $ligneBonReception->quantite_commander = $request->input("quantiteReceptionnee");
            $ligneBonReception->quantite_receptionner = $request->input("quantiteReceptionnee");
            $ligneBonReception->update();

            return redirect('receptions/reception_production/ajouter');
        }
        else
        {
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à ce bon réception');
        }

    }

    public function postAddLigneBonReceptionProductionEdit(Request $request, $id)
    {
        //dd($request->input());
        //dd($request->input());
        Session::put('dateCreation', $request->input('dateCreationBonReception'));
        $exist = LigneBonReception::where('id_bon_reception', '=', $id)->where('id_produit', '=', $request->input('produit'))->count();
        if($exist == 0)
        {
            $stockProduit = new StockProduit();
            $stockProduit->quantite = $request->input("quantiteReceptionnee");
            $stockProduit->date_fabrication = $request->input("dateFabrication");
            $stockProduit->date_peremption = $request->input("datePeremption");
            $stockProduit->numero_lot = $request->input("numeroLot");
            $stockProduit->date_entree = $request->input("dateEntree");
            $stockProduit->validation = 0;
            $stockProduit->id_produit = $request->input("produit");
            $stockProduit->id_emplacement = $request->input("emplacement");
            $stockProduit->save();
            $idStockProduit = $stockProduit->id_stock_produit;

            $ligneBonReception = new LigneBonReception();
            $ligneBonReception->id_bon_reception = $id;
            $ligneBonReception->id_ligne_commande_fournisseur = 0;
            $ligneBonReception->quantite_commander = $request->input("quantiteReceptionnee");
            $ligneBonReception->quantite_receptionner = $request->input("quantiteReceptionnee");
            $ligneBonReception->quantite_reste_receptionnee = 0;
            $ligneBonReception->id_stock_produit = $idStockProduit;
            $ligneBonReception->id_produit = $request->input("produit");
            $ligneBonReception->save();

            return redirect('receptions/reception_production/modifier/'.$id);

        }else{
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté au bon de réception');
        }

    }

    public function postEditeLigneBonReceptionProductionEdit(Request $request, $id, $idBonReception)
    {
        Session::put('dateCreation', $request->input('dateCreationBonReception'));

        $exist = LigneBonReception::where('id_bon_reception', '=', $idBonReception)->where('id_produit', '=', $request->input('produit'))->where('id_ligne_bon_reception', '!=', $id)->count();
        if ($exist == 0)
        {
            $ligneBonReception = LigneBonReception::find($id);
            $idStockProduit = $ligneBonReception->id_stock_produit;
            $stockProduit = StockProduit::find($idStockProduit);

            $stockProduit->quantite = $request->input("quantiteReceptionnee");
            $stockProduit->date_fabrication = $request->input("dateFabrication");
            $stockProduit->date_peremption = $request->input("datePeremption");
            $stockProduit->numero_lot = $request->input("numeroLot");
            $stockProduit->date_entree = $request->input("dateEntree");
            $stockProduit->validation = 0;
            $stockProduit->id_produit = $request->input("produit");
            $stockProduit->id_emplacement = $request->input("emplacement");
            $stockProduit->update();

            $ligneBonReception->quantite_commander = $request->input("quantiteReceptionnee");
            $ligneBonReception->quantite_receptionner = $request->input("quantiteReceptionnee");
            $ligneBonReception->update();

            return redirect('receptions/reception_production/modifier/'.$idBonReception);
        }else{
            return redirect()->back()->withInput()->with('msgExist','Ce produit est déjà ajouté à ce bon de réception');

        }



    }


    public function deleteLigneBonReceptionProduction(Request $request, $id)
    {
        //dd($id);
        Session::put('dateCreation', $request->input('dateCreationBonReception'));

        $ligneBonReception = LigneBonReception::find($id);
        $idStockProduit = $ligneBonReception->id_stock_produit;

        LigneBonReception::find($id)->delete();
        StockProduit::find($idStockProduit)->delete();

        return redirect('receptions/reception_production/ajouter');
    }


    public function showDetailBonReceptionProduction($id)
    {
        //dd($id);
        $bonReception = BonReception::where('id_bon_reception', '=', $id)->first();
        //dd($bonReception);
        $lignes = LigneBonReception::where('id_bon_reception', '=', $id)->with('stockProduit.produit')->get();
        //dd($lignes);

        $stockProduits = StockProduit::all();
        $produits = Produit::all();
        $zones = Zone::all();
        $emplacements = Emplacement::all();

        return view('bon_reception_production.detail', compact('bonReception', 'lignes', 'stockProduits', 'produits', 'zones', 'emplacements'));



    }


    public function getFormEdit($id)
    {
        //dd($id);
        $bonReception = BonReception::find($id);
        //dd($bonReception);
        $lignes = LigneBonReception::where('id_bon_reception', '=', $id)->with('stockProduit.produit')->get();
        //dd($lignes);

        if(!Session::has('bonReceptionProduction'))
        {
            Session::put('dateCreation', $bonReception->date_creation);
            Session::put('bonReceptionProduction', $bonReception);
            Session::put('lignesBonReceptionProduction', $lignes);
        }
        $stockProduits = StockProduit::all();
        $produits = Produit::all();
        $zones = Zone::all();
        $emplacements = Emplacement::all();
        //dd(Session::get('dateCreation'));

        return view('bon_reception_production.modifier', compact('bonReception', 'lignes', 'stockProduits', 'produits', 'zones', 'emplacements'));


    }

    public function postFormEdit(Request $request, $id)
    {

        $bonReception = BonReception::find($id);
        $bonReception->date_creation = $request->input('date_creation');
        $bonReception->update();
        StockProduit::where('validation', '=', 0)->update(['validation' => 1]);

        Session::put('dateCreation', null);
        Session::put('bonReceptionProduction', null);
        Session::put('lignesBonReceptionProduction', null);

        return redirect('receptions/reception_production/index')->with('msgAjouter','Bon réception modifié avec succès');
    }


    public function cancelModificationBonReceptionProduction($id)
    {

        LigneBonReception::where('id_bon_reception', '=', $id)->delete();
        StockProduit::where('validation', '=', 0)->delete();
        $lignesBonRception = Session::get('lignesBonReceptionProduction');
        foreach ($lignesBonRception as $ligne)
        {
            $stockProduit = new StockProduit();
            $stockProduit->quantite = $ligne->stockProduit->quantite;
            $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
            $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
            $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
            $stockProduit->date_entree = $ligne->stockProduit->date_entree;
            $stockProduit->validation = $ligne->stockProduit->validation;
            $stockProduit->id_produit = $ligne->stockProduit->id_produit;
            $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
            $stockProduit->save();
            $idStockProduit = $stockProduit->id_stock_produit;

            $ligneBonRception = new LigneBonReception();
            $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
            $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
            $ligneBonRception->quantite_commander = $ligne->quantite_commander;
            $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
            $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
            $ligneBonRception->id_stock_produit = $idStockProduit;
            $ligneBonRception->id_produit = $ligne->id_produit;
            $ligneBonRception->save();

        }
        return redirect('receptions/reception_production/index');

    }

    public function deleteLigneBonReceptionEdit(Request $request, $idLigneBonReception, $idBonReception)
    {

        //dd($request->input());
        //dd($idLigneBonReception);
        //Session::put('dateCreation', $request->input('dateCreationBonReception'));
        Session::put('dateCreation', $request->input('dateCreationBonReception'));

        $ligne = LigneBonReception::find($idLigneBonReception);
        $idStockProduit = $ligne->id_stock_produit;

        StockProduit::find($idStockProduit)->delete();
        LigneBonReception::find($idLigneBonReception)->delete();

        return redirect('receptions/reception_production/modifier/'.$idBonReception);



    }


    public function delete($id)
    {
        //dd($id);
        $lignes = LigneBonReception::where('id_bon_reception', '=', $id)->get();
        foreach ($lignes as $ligne)
        {
            $idStpckProduit = $ligne->id_stock_produit;
            StockProduit::find($idStpckProduit)->delete();
            LigneBonReception::find($ligne->id_ligne_bon_reception)->delete();

        }

        BonReception::find($id)->delete();

        return redirect('receptions/reception_production/index')->with('msgSupprimer','Le bon réception production a été supprimer avec succès');

    }


}