<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 18/06/2017
 * Time: 14:19
 */

namespace App\Http\Controllers;

use App\LigneBonReceptionUe;
use App\BonReception;
use App\CommandeClient;
use App\Historique;
use App\LigneBonLivraison;
use App\StockProduit;
use App\Zone;
use App\Emplacement;
use App\CommandeFournisseur;
use App\LigneBonReception;
use App\LigneCommandeFournisseur;
use App\ListValeur;
use App\Produit;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use PDF;
use App\ConfigurationPdf;
use Config;
use PHPExcel_IOFactory;
use PHPExcel_Style_NumberFormat;
use Excel;
use \Response;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Redirect;
use App\Preferences;
use App\Entite;
use App\Ue;
use App\Fournisseur;
use App\NumSerie;


class BonReceptionFournisseurControlleur extends Controller
{


    public function restorData(){

        Session::put('avec_ueee',0);

        if(Session::get('commandes_fournisseurs') != null)
        {

            $id = Session::get('commandes_fournisseurs')->id_commande_fournisseur;

            LigneCommandeFournisseur::where('id_commande', '=', $id)->delete();

            $lignescommande = Session::get('ligne_commande_fournisseur');
            if ($lignescommande) {
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur ON');
                }
                foreach($lignescommande as $ligne)
                {
                    $lignecommande = new LigneCommandeFournisseur();
                    $lignecommande->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                    $lignecommande->id_produit = $ligne->id_produit;
                    $lignecommande->id_commande = $id;
                    $lignecommande->quantite_commander = $ligne->quantite_commander;
                    $lignecommande->quantite_receptionner = $ligne->quantite_receptionner;
                    $lignecommande->tva = $ligne->tva;
                    $lignecommande->prix_ht = $ligne->prix_ht;
                    $lignecommande->prix_ttc = $ligne->prix_ttc;
                    $lignecommande->total_prix_ht =$ligne->total_prix_ht;
                    $lignecommande->total_prix_ttc = $ligne->total_prix_ttc;

                    $lignecommande->save();
                }
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_commande_fournisseur OFF');
                }

            }


        }


        if(Session::get('bonReception') != null)
        {
                //dd(Session::get('bonReception'));

            $id = Session::get('bonReception')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();

            $lignesBonReception = Session::get('lignesBonReception');
            if ($lignesBonReception) {
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception ON');
                }
                foreach($lignesBonReception as $ligne)
                {
                    $ligneBonReception = new LigneBonReception();

                    $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                    $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                    $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                    $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                    $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                    $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                    $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;
                    $ligneBonReception->id_produit = $ligne->id_produit;
                   /* $stockProduit = StockProduit::find($ligne->id_stock_produit);
                    $stockProduit->quantite = $ligne->stockProduit->quantite;
                    $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                    $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                    $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                    $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                    $stockProduit->date_entree = $ligne->stockProduit->date_entree;

                    $stockProduit->update();*/
                    $ligneBonReception->save();
                }
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception OFF');
                }
            }

            

        }


        if(Session::get('bonReceptionProduction') != null)
        {
            $id = Session::get('bonReceptionProduction')->id_bon_reception;
            LigneBonReception::where('id_bon_reception', '=', $id)->delete();
            StockProduit::where('validation', '=', 0)->delete();
            $lignesBonRception = Session::get('lignesBonReceptionProduction');
            foreach ($lignesBonRception as $ligne)
            {
                $stockProduit = new StockProduit();
                $stockProduit->quantite = $ligne->stockProduit->quantite;
                $stockProduit->date_fabrication = $ligne->stockProduit->date_fabrication;
                $stockProduit->date_peremption = $ligne->stockProduit->date_peremption;
                $stockProduit->numero_lot = $ligne->stockProduit->numero_lot;
                $stockProduit->date_entree = $ligne->stockProduit->date_entree;
                $stockProduit->validation = $ligne->stockProduit->validation;
                $stockProduit->id_produit = $ligne->stockProduit->id_produit;
                $stockProduit->id_emplacement = $ligne->stockProduit->id_emplacement;
                $stockProduit->save();
                $idStockProduit = $stockProduit->id_stock_produit;

                $ligneBonRception = new LigneBonReception();
                $ligneBonRception->id_bon_reception = $ligne->id_bon_reception;
                $ligneBonRception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonRception->quantite_commander = $ligne->quantite_commander;
                $ligneBonRception->quantite_receptionner = $ligne->quantite_receptionner;
                $ligneBonRception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                $ligneBonRception->id_stock_produit = $idStockProduit;
                $ligneBonRception->id_produit = $ligne->id_produit;
                $ligneBonRception->save();

            }

        }
        if(Session::get('emplacement') != null)
        {
         //   $idEmplacement=Session::get('emplacement')->id_emplacement;
            $emplacements=Session::get('emplacement');
          //  dd($emplacements);
            foreach($emplacements as $emplacement)
            {
                $emplacementUpdate=Emplacement::find($emplacement->id_emplacement);
                $taux=$emplacement->tauxOccupation;
                $emplacementUpdate->tauxOccupation=$taux;
                $emplacementUpdate->update();
            }

        }

    }

    public function index()
    {
        Session::put('lignes',null);
        Session::put('societe',null);
        Session::put('contact',null);
        Session::put('date',null);

        Session::put('idBonReception', null);
        Session::put('dateCreationBonReception', null);
        Session::put('commandeFournisseur', null);
        Session::put('fournisseur', null);
        Session::put('contactFounisseur', null);
        Session::put('dateCreationCommandeFournisseur', null);

        Session::put('bonReception', null);
        Session::put('commandeFournisseur', null);
        Session::put('lignesBonReception', null);

        LigneBonReception::where('id_bon_reception','=',0)->delete();
        StockProduit::where('validation', '=', 0)->delete();
        BonReception::where('date_creation', '=', null)->delete();

        //$bons_receptions = BonReception::with('commandeFounisseur.fournisseur')->where('supprimer', '=', 0)->where('id_commande', '!=', 0)->get();
        $bons_receptions = BonReception::with('commandeFounisseur.fournisseur')->where('supprimer', '=', 0)
                            ->orderBy('date_creation','DESC')->paginate(100);
        //dd($bons_receptions);
        CommandeFournisseur::where('date_creation', '=', null)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);
        Session::put('emplacement', null);
        //$lignes=DB::table('ligne_bon_reception')->select('id_bon_reception')->get();
       /* $result = DB::table('bon_reception')->whereNotIn('id_bon_reception', function($q){
            $q->select('id_bon_reception')->from('ligne_bon_reception');
        })->get();
       // $recept=BonReception::whereNotIn('id_bon_reception',$lignes)->get();
        dd($result);*/
        //dd($bons_receptions);
        return view('bon_reception_fournisseur.index',compact('bons_receptions'));
    }

    public function recherche_list(Request $request){
        $mot_a_rechercher = $request->get('recherche');
        $bons_receptions = BonReception::with('commandeFounisseur.fournisseur')
                                        ->where('supprimer', '=', 0)
                                        ->orderBy('date_creation','DESC')
                                        ->where(function ($query) use ($mot_a_rechercher) {
                                            $query->where('num_bon_reception', 'like', '%' . $mot_a_rechercher . '%')
                                                ->orWhere('contrat', 'like', '%' . $mot_a_rechercher . '%')
                                                ->orWhere('facture', 'like', '%' . $mot_a_rechercher . '%')
                                                ->orWhere('num_document', 'like', '%' . $mot_a_rechercher . '%')
                                                ->orWhere('num_entite', 'like', '%' . $mot_a_rechercher . '%')
                                                ->orWhere('date_creation', 'like', '%' . $mot_a_rechercher . '%')
                                                ->orWhere('date_creation', 'like', '%' . $mot_a_rechercher . '%')
                                                ->orwhere(function($query3) use ($mot_a_rechercher){
                                                    if ( $mot_a_rechercher == "En attente réception") 
                                                        $query3->where('statut',0);
                                                    if ( $mot_a_rechercher == "En attente validation") 
                                                        $query3->where('statut',1)->orWhere('statut',2);
                                                    if ( $mot_a_rechercher == "Validé") 
                                                        $query3->where('statut',3);
                                                    if ( $mot_a_rechercher == "En attente") 
                                                        $query3->where('statut',0)->orWhere('statut',1)->orWhere('statut',2);
                                                })
                                                ->orWhereHas('commandeFounisseur', function ($query1) use ($mot_a_rechercher) {
                                                    $query1->where('num_commande_fournisseur', 'like', '%' . $mot_a_rechercher . '%');
                                                })
                                                ->orWhereHas('commandeFounisseur.fournisseur', function ($query2) use ($mot_a_rechercher) {
                                                    $query2->where('societe', 'like', '%' . $mot_a_rechercher . '%');
                                                });
                                        })
                                        ->paginate(100)
                                        ->appends('recherche', $mot_a_rechercher);
        //dd($mot_a_rechercher);

        return view('bon_reception_fournisseur.index',compact('bons_receptions','mot_a_rechercher'));
    }

    /*public function index_ue()
    {
        Session::put('lignes',null);
        Session::put('societe',null);
        Session::put('contact',null);
        Session::put('date',null);

        Session::put('idBonReception', null);
        Session::put('dateCreationBonReception', null);
        Session::put('commandeFournisseur', null);
        Session::put('fournisseur', null);
        Session::put('contactFounisseur', null);
        Session::put('dateCreationCommandeFournisseur', null);

        Session::put('bonReception', null);
        Session::put('commandeFournisseur', null);
        Session::put('lignesBonReception', null);

        LigneBonReception::where('id_bon_reception','=',0)->delete();
        StockProduit::where('validation', '=', 0)->delete();
        BonReception::where('date_creation', '=', null)->delete();

        $bons_receptions = BonReception::with('commandeFounisseur.fournisseur')->where('supprimer', '=', 0)->where('id_commande', '=', -1)->get();
        //dd($bons_receptions);
        CommandeFournisseur::where('date_creation', '=', null)->delete();

        $this->restorData();
        Session::put('commandes_fournisseurs', null);
        Session::put('bonReception', null);
        Session::put('emplacement', null);
        //$lignes=DB::table('ligne_bon_reception')->select('id_bon_reception')->get();
       /* $result = DB::table('bon_reception')->whereNotIn('id_bon_reception', function($q){
            $q->select('id_bon_reception')->from('ligne_bon_reception');
        })->get();
       // $recept=BonReception::whereNotIn('id_bon_reception',$lignes)->get();
        //dd($result);
        //dd($bons_receptions);
        return view('bon_reception_fournisseur_ue.index',compact('bons_receptions'));
    }
    */


    public function getForm()
    {

        Session::put('lignes',null);
        Session::put('societe',null);
        Session::put('contact', null);
        Session::put('date',null);

        $emplacement=Emplacement::select('id_emplacement','tauxOccupation')->get();
        Session::put('emplacement',$emplacement);


        LigneBonReception::where('id_bon_reception','=',0)->delete();

        $commande = new CommandeFournisseur();
        /*
        $count = DB::table('bon_reception')->max('id_bon_reception');
        $num_bon_receptionr = $count + 1;
        */

    /*  $bonReceptionExiste = BonReception::where('date_creation', '=', null)->count();
        if ($bonReceptionExiste == 0){
            $bonReception = new BonReception();
            $bonReception->date_creation = null;
            $bonReception->id_commande = 0;
            $bonReception->supprimer = 0;
            $bonReception->save();
            $num_bon_receptionr = $bonReception->id_bon_reception;
        }else{
            $bonReception = BonReception::where('date_creation', '=', null)->first();
            $num_bon_receptionr = $bonReception->id_bon_reception;
        }*/

        $commandes = CommandeFournisseur::where('etat', '!=', 'Réceptionnée')
        ->where('supprimer','=',0)
        ->with('fournisseur')->get();
        //dd($commandes);
        $lignes = LigneBonReception::where('id_bon_reception','=',0)->with('ligneCommandeFournisseur.produit')->get();

        $zones = Zone::all();
        $emplacements = Emplacement::all();
        $produits = Produit::all();

        $ajouterProduitNonCommande = false;

        $lastNum =BonReception::orderBy('id_bon_reception','desc')->first();
        if ($lastNum != null) {
            $NumBonReception = substr_replace($lastNum->num_bon_reception, "", 0, 5);
            if ($NumBonReception == 99999){
                $NumBonReception='BNREC00001';
            }
            else {
                $NumBonReception = $NumBonReception + 1;
                $NumBonReception=str_pad($NumBonReception, 5, '0', STR_PAD_LEFT);


                $NumBonReception ='BNREC'.$NumBonReception;
            }

        }
        else
            $NumBonReception='BNREC00001';

        return view('bon_reception_fournisseur.ajouter', compact('NumBonReception','commandes', 'lignes','commande', 'zones', 'emplacements','produits','ajouterProduitNonCommande'));

    }

    public function getForm_ue()
    {

        Session::put('lignes',null);
        Session::put('societe',null);
        Session::put('contact', null);
        Session::put('date',null);

        $emplacement=Emplacement::select('id_emplacement','tauxOccupation')->get();
        Session::put('emplacement',$emplacement);


        LigneBonReception::where('id_bon_reception','=',0)->delete();

        $commande = new CommandeFournisseur();
        /*
        $count = DB::table('bon_reception')->max('id_bon_reception');
        $num_bon_receptionr = $count + 1;
        */

    /*  $bonReceptionExiste = BonReception::where('date_creation', '=', null)->count();
        if ($bonReceptionExiste == 0){
            $bonReception = new BonReception();
            $bonReception->date_creation = null;
            $bonReception->id_commande = 0;
            $bonReception->supprimer = 0;
            $bonReception->save();
            $num_bon_receptionr = $bonReception->id_bon_reception;
        }else{
            $bonReception = BonReception::where('date_creation', '=', null)->first();
            $num_bon_receptionr = $bonReception->id_bon_reception;
        }*/

        $commandes = CommandeFournisseur::where('etat', '!=', 'Réceptionnée')
        ->where('supprimer','=',0)
        ->with('fournisseur')->get();
        //dd($commandes);
        $lignes = LigneBonReception::where('id_bon_reception','=',0)->with('ligneCommandeFournisseur.produit')->get();

        $zones = Zone::all();
        $emplacements = Emplacement::all();
        $produits = Produit::all();

        $ajouterProduitNonCommande = false;

        $lastNum =BonReception::orderBy('id_bon_reception','desc')->first();
        if ($lastNum != null) {
            $NumBonReception = substr_replace($lastNum->num_bon_reception, "", 0, 5);
            if ($NumBonReception == 99999){
                $NumBonReception='BNREC00001';
            }
            else {
                $NumBonReception = $NumBonReception + 1;
                $NumBonReception=str_pad($NumBonReception, 5, '0', STR_PAD_LEFT);


                $NumBonReception ='BNREC'.$NumBonReception;
            }

        }
        else
            $NumBonReception='BNREC00001';

        return view('bon_reception_fournisseur.ajouter', compact('NumBonReception','commandes', 'lignes','commande', 'zones', 'emplacements','produits','ajouterProduitNonCommande'));

    }

    public function getFormWithIdCommande($idCommande)
    {
        $ajouterProduitNonCommande = true;

        $test = BonReception::where('id_commande','=',$idCommande)->get();
        foreach ($test as $t) {
            if ($t->statut != 3 && $t->supprimer == 0) {
                return redirect('receptions/reception_fournisseur/ajouter')->with('msgErreurCommandeNonValide',"Veuillez valider le bon de réception avant de faire cette opération");
            }
        }

        $exist = LigneBonReception::join('ligne_commande_fournisseur','ligne_commande_fournisseur.id_ligne_commande_fournisseur','=','ligne_bon_reception.id_ligne_commande_fournisseur')
        ->join('commande_fournisseur','commande_fournisseur.id_commande_fournisseur','=','ligne_commande_fournisseur.id_commande')
        ->where('commande_fournisseur.id_commande_fournisseur','=',$idCommande)
        ->where('id_bon_reception','=',0)->count();

        $commande = CommandeFournisseur::where('id_commande_fournisseur','=',$idCommande)
        ->with('fournisseur')->first();

        if($exist == 0){

            LigneBonReception::where('id_bon_reception','=',0)->delete();


            $lignesCommande = LigneCommandeFournisseur::where('id_commande','=',$idCommande)->whereRaw('quantite_receptionner < quantite_commander')->with('produit')->get();

            Session::put('lignes',$lignesCommande);
            Session::put('societe',$commande->fournisseur->societe);
            Session::put('contact',$commande->fournisseur->contact);
            Session::put('date',$commande->date_creation);

            foreach($lignesCommande as $ligne){

                $ligneBonReception = new LigneBonReception();

                $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                $ligneBonReception->id_bon_reception = 0;
                $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                $ligneBonReception->quantite_receptionner = 0;

                $quantiteDejaReceptionnee = LigneBonReception::where('id_ligne_commande_fournisseur', '=', $ligne->id_ligne_commande_fournisseur)
                ->where('id_bon_reception', '!=', 0)->sum('quantite_receptionner');

                $quantiteRestAReceptionnee = $ligne->quantite_commander - $quantiteDejaReceptionnee;
                $ligneBonReception->quantite_reste_receptionnee = $quantiteRestAReceptionnee;
                $ligneBonReception->id_produit = $ligne->id_produit;
                $ligneBonReception->save();
            }
        }

        $lignes = LigneBonReception::where('id_bon_reception','=',0)->with('ligneCommandeFournisseur.produit')->get();

        $lastNum =BonReception::orderBy('id_bon_reception','desc')->first();
        if ($lastNum != null) {
            $NumBonReception = substr_replace($lastNum->num_bon_reception, "", 0, 5);
            if ($NumBonReception == 99999){
                $NumBonReception='BNREC00001';
            }
            else {
                $NumBonReception = $NumBonReception + 1;
                $NumBonReception=str_pad($NumBonReception, 5, '0', STR_PAD_LEFT);
                $NumBonReception ='BNREC'.$NumBonReception;
            }
        }
        else
            $NumBonReception='BNREC00001';

        $commandes = CommandeFournisseur::where('etat', '!=', 'Réceptionnée')
        ->where('supprimer','=',0)
        ->with('fournisseur')->get();

        $zones = Zone::all();
        $emplacements = Emplacement::all();
        $produits = Produit::all();

        return view('bon_reception_fournisseur.ajouter', compact('NumBonReception', 'commandes', 'lignes', 'commande', 'zones', 'emplacements','produits','ajouterProduitNonCommande'));

    }


    public function postForm(Request $request)
    {
        $lignes = LigneBonReception::where('id_bon_reception', '=', 0)
        ->where('id_ligne_commande_fournisseur', '!=', 0)
        ->where('quantite_receptionner', '>', 0)
        ->get();

        $ligness = LigneBonReception::where('id_bon_reception', '=', 0)
        ->where('id_ligne_commande_fournisseur', '!=', 0)
        ->get();
        //dd($lignes->count());
        $qntReceptionnerLigne=LigneBonReception::where('quantite_receptionner', '>', 0)
        ->where('id_bon_reception', '=', 0)
        ->where('id_ligne_commande_fournisseur', '!=', 0)
        ->get();

        if(count($qntReceptionnerLigne)!=0) {
            if ($lignes->first() != null) {
                if (Session::get('STOCK_ENTITE') == 0 && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')== 0) {
                 //metttre a jour le stock quantité réelle
                foreach ($qntReceptionnerLigne as $ligne) {
                    $stockProduit = StockProduit::where('id_produit','=',$ligne->id_produit)
                                                ->where('id_emplacement' ,'=',$ligne->idEmplacement)
                                                ->where('numero_lot','=',$ligne->numLot)
                                                ->first();
                    if ($stockProduit != null) {
                        $stockProduit->quantite_reelle = $stockProduit->quantite_reelle + $ligne->quantite_receptionner;
                        $stockProduit->last_update = date("Y-m-d H:i:s");
                        $stockProduit->update();
                    }
                }
            }
                $bonReception = new BonReception();
                $bonReception->num_bon_reception = $request->input('num_bon_reception');
                $bonReception->date_creation = $request->input('date_creation');
                $bonReception->id_commande = $request->input('idCommandeFournisseur');
                $bonReception->produit_rec = count($lignes);
                $unite_expedition = $request->input('ue');
                if ($unite_expedition) {
                    $bonReception->unite_expedition = 1;
                }
                else
                    $bonReception->unite_expedition = 0;
                $bonReception->supprimer = 0;

                $bonReception->save();

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Ajout';
                $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions par produit';
                $HistoriqueActions->description = 'Ajout de la réception: '.$bonReception->num_bon_reception ;
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();


                
                


                LigneBonReception::where('id_bon_reception', '=', 0)->update(['id_bon_reception' => $bonReception->id_bon_reception]);
                //  dd($totalCmd.$totalRecep);


                LigneBonReception::where('quantite_receptionner', '=', 0)->delete();

              //  StockProduit::where('validation', '=', 0)->update(['validation' => 1]);
                return redirect('receptions/reception_fournisseur/index')->with('msgAjouter', 'Bon de réception créé avec succès');

            } else {
                return redirect('receptions/reception_fournisseur/index')->with('msgErreurReception', 'Erreur d\'enregitrement du bon de réception ');

            }
        }else

        return redirect('receptions/reception_fournisseur/ajouter/'.$request->input('idCommandeFournisseur'))->with('msgErreurReception', 'Veuillez réceptionner au moins un produit pour valider le bon de réception.');
    }


    public function deleteLigneBonReception(Request $request, $id)
    {

        //dd($request->input());

        $ligneBonReception = LigneBonReception::find($id);
       // dd($ligneBonReception);
       // $idStockProduit = $ligneBonReception->id_stock_produit;
       // $getStock=StockProduit::find($idStockProduit);
        //dd($getStock->quantite,$ligneBonReception->quantite_receptionner);
      /*  if($idStockProduit != 0 && $getStock->quantite == $ligneBonReception->quantite_receptionner){
            StockProduit::find($idStockProduit)->delete();
        }
        if($idStockProduit != 0 && $getStock->quantite != $ligneBonReception->quantite_receptionner){
            $getStock->quantite = $getStock->quantite-$ligneBonReception->quantite_receptionner;
            $getStock->update();
        }*/
        LigneBonReception::find($id)->delete();
        //return redirect('bon_reception/ajouter/'.$request->input('idBonReception'));
        return redirect('receptions/reception_fournisseur/modifier/'.$request->input('idCommande'));

    }


    public function postAddQuantiteReceptionnee(Request $request, $id)
    {
        $emplacement = Emplacement::find($request->input('emplacement'));

        $lignes = LigneBonReception::where('id_ligne_bon_reception','=',$id)->with('ligneCommandeFournisseur.produit')->first();

        $commande_id = $request->input('commande_id');
        $idProduit = 0;
        if ($commande_id) {
            $idProduit =$lignes->ligneCommandeFournisseur->id_produit;  
        }else
        {
            $idProduit =$lignes->id_produit; 
        }
        $produit = Produit::find($idProduit);
        $volumeProduit = ($produit->volume) * ($request->input('quantiteReceptionnee'));
        $volumeMax = $emplacement->volumeMax;
        $tauxOccupation = 0;
        if ($volumeMax !=0) {
            $tauxOccupation = ($emplacement->tauxOccupation) + ($volumeProduit / $volumeMax) * 100;
        }
        $tauxOccupation = number_format($tauxOccupation, 2);


        if ($tauxOccupation > 100) {

            return redirect('receptions/reception_fournisseur/ajouter/' . $request->input('idCommande'))->withInput()->with('msgExist', "L'emplacement sélectionné ne peut pas contenir toute cette quantité");

        } else {

            $ligne = LigneBonReception::where('id_ligne_bon_reception', '=', $id)->with('ligneCommandeFournisseur.produit')->first();

            $ligne->quantite_receptionner = $request->input('quantiteReceptionnee');
            if ($ligne->id_ligne_commande_fournisseur == 0) {
                $ligne->qteReceptionnerFO = $request->input('quantiteReceptionnee');
            }
            if ($commande_id) {
                $ligne->quantite_reste_receptionnee = $request->input('quantiteReceptionnee');
            }

            $ligne->idEmplacement = $request->input('emplacement');
            if (Session::get('N_LOT') == '1') {
                $ligne->numLot = $request->input('numeroLot');
            } else {
                $ligne->numLot = "";
            }
            if (Session::get('DATE_PEREMPTION') == '1') {

                $ligne->date_fabrication = $request->input('dateFabrication');
                $ligne->date_peremption = $request->input('datePeremption');
            }

            $ligne->update();


            $emplacement->tauxOccupation = $tauxOccupation;
            if ($tauxOccupation == 100) {
                $emplacement->etat = 'NON DISPONIBLE';
            }

            $emplacement->update();


            return redirect('receptions/reception_fournisseur/ajouter/' . $request->input('idCommande'));

        }
    }

    public function showDetailBonReception($id_bon_reception)
    {

        $lignes = LigneBonReception::where('id_bon_reception',$id_bon_reception)
        ->where('id_ligne_commande_fournisseur','!=',0)
        ->with('produit')->get();
        $resultat = collect();
        $resultat_avec_conteneur_null = collect();
        $Nconteneur = collect();
        //$numeroConteneur = collect();

        if(Session::get('CONTENEUR')=='0') {
            foreach ($lignes as $key => $ligne) {
                $sscc = $this->get_ue_from_poduit($ligne->id_ligne_bon_reception);
                if ($sscc) {
                    $resultat->put($ligne->produit->code_identification, $sscc);
                }
            }
        }else{
            foreach ($lignes as $key => $ligne) {
                $LigneBonReceptionUe = LigneBonReceptionUe::where('id_ligne_bon_reception',$ligne->id_ligne_bon_reception)->with('ligneBonReception.produit')->get();

                foreach ($LigneBonReceptionUe as $key1 => $lignee) {
                    $lol = LigneBonReceptionUe::where('n_conteneur',$lignee->n_conteneur)->with('ligneBonReception.produit')->get();

                    if ($lol && $lignee->n_conteneur != null ) {
                        $Nconteneur->put($lignee->n_conteneur, $lol);
                    }
                    if ($lignee->n_conteneur == null) {
                        $resultat_avec_conteneur_null->put($lignee->sscc, $lignee);
                    }
                }
            }
        }
        //dd($Nconteneur, $resultat_avec_conteneur_null );

        $configuration = ConfigurationPdf::first();

        $bonReception = BonReception::with('commandeFounisseur')->find($id_bon_reception);
        $commandeFournisseur = CommandeFournisseur::with('fournisseur')->find($bonReception->id_commande);
        $lignesBonReception = LigneBonReception::where('id_bon_reception', '=', $id_bon_reception)
        ->with('ligneCommandeFournisseur.produit')
        ->with('Operateur')
        ->get();

        return view('bon_reception_fournisseur.detail', compact('bonReception', 'commandeFournisseur', 'lignesBonReception','configuration','resultat','resultat_avec_conteneur_null','Nconteneur'));
    }

    public function showDetailBonReceptionUE($id_bon_reception){
        $collection = "";
        if(Session::get('AVEC_UE_RECEPTION')=='1') {
            if(Session::get('CONTROLE_UE')=='1') {
                $collection = LigneBonReception::where('id_bon_reception',$id_bon_reception)
                ->join('ligne_bon_reception_ue','ligne_bon_reception_ue.id_ligne_bon_reception','=','ligne_bon_reception.id_ligne_bon_reception')
                ->with('produit')->with('Emplacement')
                ->get();
            }
        }else{
            $collection = LigneBonReception::where('id_bon_reception',$id_bon_reception)
            ->with('produit')->with('Emplacement')
            ->get();
        }
        
        $configuration = ConfigurationPdf::first();

        if (Session::get('STOCK_ENTITE')=='1') {
            $bonReception = BonReception::where('id_bon_reception',$id_bon_reception)
                ->where('id_commande','>',0)
                ->with('entite')
                ->with('commandeFounisseur.Fournisseur')
                ->first();

            if ($bonReception == null){
                $bonReception = BonReception::where('id_bon_reception',$id_bon_reception)->with('entite')->first();
            }

        }else{
            $bonReception = BonReception::find($id_bon_reception);
        }

        
        return view('bon_reception_fournisseur_ue.detail', compact('configuration','collection','bonReception'));
    }

    public function getFormEdit($id){

        $bonReception = BonReception::find($id);
        //dd($bonReception);

        $commandeFournisseur = CommandeFournisseur::with('fournisseur')->find($bonReception->id_commande);
        //dd($commandeFournisseur);
        $lignesBonReception = LigneBonReception::where('id_bon_reception', '=', $id)->with('Emplacement')->with('ligneCommandeFournisseur.produit')->get();
        //dd($lignesBonReception);

        //$lignesBonReception = LigneBonReception::where('id_bon_reception', '=', $id)->stockProduit->with('ligneCommandeFournisseur.produit')->get();
        //dd($lignesBonReception);
        if(!Session::has('bonReception')){
            Session::put('idBonReception', $bonReception->id_bon_reception);
            Session::put('dateCreationBonReception', $bonReception->date_creation);
            Session::put('commandeFournisseur', $commandeFournisseur->id_commande_fournisseur);
            Session::put('fournisseur', $commandeFournisseur->fournisseur->fournisseur);
            Session::put('contactFounisseur', $commandeFournisseur->fournisseur->contact);
            Session::put('dateCreationCommandeFournisseur', $commandeFournisseur->date_creation);
            Session::put('bonReception', $bonReception);
            //id_stock_produit
            Session::put('lignesBonReception', $lignesBonReception);
            Session::put('commandeFournisseur', $commandeFournisseur);
        }
            $zones = Zone::all();
            $emplacements = Emplacement::all();
            $produits = Produit::all(); 

        //dd($lignesBonReception);

            return view('bon_reception_fournisseur.modifier', compact('bonReception', 'commandeFournisseur', 'lignesBonReception', 'zones', 'emplacements','produits'));
        }

    public function postEditeLigneBonReceptionEdit(Request $request ,$id, $idBonReception){

            Session::put('idBonReception', $request->input('idBonReception'));
            Session::put('dateCreationBonReception', $request->input('dateCreationBonReception'));
            Session::put('fournisseur', $request->input('fournisseur'));
            Session::put('contactFounisseur', $request->input('contactFounisseur'));
            $idCommande=BonReception::where('id_bon_reception','=',$idBonReception)->get();
                if($idCommande->first()!=null){
                    $idCommande=$idCommande->first()->id_commande;
                }

            $emplacement = Emplacement::find($request->input('emplacement'));
        // $bonReception=LigneBonReception::find($id);
            $lignes = LigneBonReception::where('id_ligne_bon_reception','=',$id)->with('ligneCommandeFournisseur.produit')->first();
            $idProduit = 0;
            if ($lignes->id_ligne_commande_fournisseur != 0) {
                $idProduit = $lignes->ligneCommandeFournisseur->id_produit;
            }else{
                $idProduit = $lignes->id_produit;
            }

            $produit = Produit::find($idProduit);
            $volumeProduit = ($produit->volume) * ($request->input('quantiteReceptionnee'));
            $volumeMax = $emplacement->volumeMax;
            $ligneBonReception=LigneBonReception::find($id);
            $stockQnt=$ligneBonReception->quantite_receptionner;
            $volumeProduitStock= ($produit->volume) * $stockQnt;
            $encienTaux=($volumeProduitStock/$volumeMax)*100 ;

            $tauxOccupation = number_format(($emplacement->tauxOccupation) + (($volumeProduit / $volumeMax) * 100)-($encienTaux));
            $tauxOccupation = number_format($tauxOccupation, 2);

            if ($tauxOccupation > 100) {
                return redirect('receptions/reception_fournisseur/modifier/'.$idBonReception)->withInput()->with('msgExist', "L'emplacement sélectionné ne peut pas contenir toute cette quantité");
            } else {
                $bnRec=BonReception::find($idBonReception);
                $ligneBonReception = LigneBonReception::find($id);
                if (Session::get('STOCK_ENTITE') == 0 && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')== 0) {
                //mettre a jour la qnt reelle dans le stock
                $stockProduit = StockProduit::where('id_produit','=',$ligneBonReception->id_produit)
                                        ->where('id_emplacement' ,'=',$ligneBonReception->idEmplacement)
                                        ->where('numero_lot','=',$ligneBonReception->numLot)
                                        ->first();
                if ($stockProduit != null) {
                    $stockProduit->quantite_reelle -= $ligneBonReception->quantite_receptionner;
                    $stockProduit->quantite_reelle += $request->input('quantiteReceptionnee');
                    $stockProduit->last_update = date("Y-m-d H:i:s");
                    $stockProduit->update();
                }
            }
                if ($ligneBonReception->id_ligne_commande_fournisseur != 0) {
                    $ligneBonReception->quantite_receptionner = $request->input('quantiteReceptionnee');
                    $ligneBonReception->qteReceptionnerFO = 0;
                    $ligneBonReception->operateur = 0;
                }else{
                    $ligneBonReception->qteReceptionnerFO = $request->input('quantiteReceptionnee');
                    $ligneBonReception->operateur = Session::get('id');
                    $ligneBonReception->quantite_receptionner = $request->input('quantiteReceptionnee');
                }

            /*$received=true;
            $totalCmd=0;
            $totalRecep=0;*/

          //  foreach ($lignes as $ligne) {
            /*if ($lignes->id_ligne_commande_fournisseur != 0) {
                $ligneCommande = LigneCommandeFournisseur::find($lignes->id_ligne_commande_fournisseur);
                $ligneCommande->quantite_receptionner += $lignes->quantite_receptionner;
                $totalCmd += $ligneCommande->quantite_commander;
                $totalRecep += $ligneCommande->quantite_receptionner;
                $ligneCommande->update();
              //  }
             //   dd($totalCmd.$totalRecep);
                if($totalRecep==0){
                    CommandeFournisseur::where('id_commande_fournisseur', '=', $bnRec->id_commande)->update(['etat' => "En cours"]);

                }elseif($totalCmd>$totalRecep){
                    CommandeFournisseur::where('id_commande_fournisseur', '=', $bnRec->id_commande)->update(['etat' => "Réceptionnée partiellement"]);

                }elseif($totalCmd==$totalRecep){
                    CommandeFournisseur::where('id_commande_fournisseur', '=', $bnRec->id_commande)->update(['etat' => "Réceptionnée"]);

                }
            }*/
          //  $idStockProduit = $ligneBonReception->id_stock_produit;
         //   $stockProduit = StockProduit::find($idStockProduit);

         //   $stockProduit->quantite = $request->input('quantiteReceptionnee');
            if(Session::get('DATE_PEREMPTION')=='1') {
                $ligneBonReception->date_fabrication = $request->input('dateFabrication');
                $ligneBonReception->date_peremption = $request->input('datePeremption');
            }
            if(Session::get('N_LOT')=='1') {
                $ligneBonReception->numLot = $request->input('numeroLot');
            }else{
                $ligneBonReception->numLot ="";
            }

            $ligneBonReception->idEmplacement = $request->input('emplacement');

           // $stockProduit->update();
            $ligneBonReception->modifier = 1;
            $ligneBonReception->update();

            
            //dd($ligneBonReception);

            //$ligneCommandeFournisseur = LigneBonReception::where('id_bon_reception', '=', $id)->with('ligneCommandeFournisseur')->first();

            $emplacement->tauxOccupation = $tauxOccupation;
            if($tauxOccupation == 100)
            {
                $emplacement->etat = 'NON DISPONIBLE';
            }

            $emplacement->update();


            return redirect('receptions/reception_fournisseur/modifier/' . $idBonReception);

            //dd($request->input());
        }

    }




    public function cancelModification($id)
    {
        $test = '';
        $memory_ligne = collect();
        if (Session::get('STOCK_ENTITE') == 0 && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')== 0) {
            $test = LigneBonReception::where('id_bon_reception', '=', $id)->where('modifier',1)->get();
            foreach ($test as $key => $value) {
                $stockProduit = StockProduit::where('id_produit','=',$value->id_produit)
                                        ->where('id_emplacement' ,'=',$value->idEmplacement)
                                        ->where('numero_lot','=',$value->numLot)
                                        ->first();
                if ($stockProduit != null) {
                    $stockProduit->quantite_reelle -= $value->quantite_receptionner;
                    $stockProduit->last_update = date("Y-m-d H:i:s");
                    $stockProduit->update();
                    $memory_ligne->put($key,$value->id_ligne_bon_reception);
                }
            }
            $test = LigneBonReception::where('id_bon_reception', '=', $id)->delete();
        }else{
            $test = LigneBonReception::where('id_bon_reception', '=', $id)->delete();
        }
        
        $bnRec=BonReception::find($id);
        if ($test != 0) {
            $lignesBonReception = Session::get('lignesBonReception');
            if ($lignesBonReception) {
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception ON');
                }

                foreach($lignesBonReception as $ligne){
                    if (Session::get('STOCK_ENTITE') == 0 && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')== 0) {
                    if ($memory_ligne->contains($ligne->id_ligne_bon_reception)) {
                //mettre a jour le stock
                $stock = StockProduit::where('id_produit','=',$ligne->id_produit)
                                        ->where('id_emplacement' ,'=',$ligne->idEmplacement)
                                        ->where('numero_lot','=',$ligne->numLot)
                                        ->first();
                $stockProduit->quantite_reelle += $ligne->quantite_receptionner;
                $stockProduit->last_update = date("Y-m-d H:i:s");
                $stockProduit->update();
                
            }
        }

                    $ligneBonReception = new LigneBonReception();
                    $ligneBonReception->id_ligne_bon_reception = $ligne->id_ligne_bon_reception;
                    $ligneBonReception->id_bon_reception = $ligne->id_bon_reception;
                    $ligneBonReception->id_ligne_commande_fournisseur = $ligne->id_ligne_commande_fournisseur;
                    $ligneBonReception->quantite_commander = $ligne->quantite_commander;
                    $ligneBonReception->quantite_receptionner = $ligne->quantite_receptionner;
                    $ligneBonReception->quantite_reste_receptionnee = $ligne->quantite_reste_receptionnee;
                    $ligneBonReception->id_stock_produit = $ligne->id_stock_produit;
                    //$totalCmd+=$ligne->quantite_commander;
                    //$totalRecep+=$ligne->quantite_reste_receptionnee;
                    $ligneBonReception->date_fabrication = $ligne->date_fabrication;
                    $ligneBonReception->date_peremption = $ligne->date_peremption;
                    $ligneBonReception->numLot = $ligne->numLot;
                    $ligneBonReception->idEmplacement = $ligne->idEmplacement;
                    $ligneBonReception->id_produit = $ligne->id_produit; 
                    $ligneBonReception->qteReceptionnerFO = $ligne->qteReceptionnerFO;
                    $ligneBonReception->operateur = $ligne->operateur;
                    $ligneBonReception->save();
                    if (Session::get('STOCK_ENTITE') == 0 && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')== 0) {



                    }

                }
                if (Config::get('database')['default'] == "sqlsrv") {
                    DB::unprepared('SET IDENTITY_INSERT ligne_bon_reception OFF');
                }
            }
        }
        
        //$totalCmd=0;
        //$totalRecep=0;
        
        /*if($totalRecep==0){
            CommandeFournisseur::where('id_commande_fournisseur', '=', $bnRec->id_commande)->update(['etat' => "En cours"]);

        }elseif($totalCmd>$totalRecep){
            CommandeFournisseur::where('id_commande_fournisseur', '=', $bnRec->id_commande)->update(['etat' => "Réceptionnée partiellement"]);

        }elseif($totalCmd==$totalRecep){
            CommandeFournisseur::where('id_commande_fournisseur', '=', $bnRec->id_commande)->update(['etat' => "Réceptionnée"]);

        }*/

        return redirect('/receptions/reception_fournisseur/index');
    }


    public function postFormEdit(Request $request,$id)
    {
        //dd($request->input());
        $bonReception =  BonReception::find($id);
        //dd($bonReception);
        if (Session::get('STOCK_ENTITE') == 0 && Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE')== 0) {
            LigneBonReception::where('id_bon_reception',$bonReception->id_bon_reception)
            ->update(['modifier' => 0]);
        }
        
        
        Session::put('bonReception', null);
        Session::put('lignesBonReception', null);

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Modification';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions par produit';
        $HistoriqueActions->description = 'Modification de la réception: '.$bonReception->num_bon_reception ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('/receptions/reception_fournisseur/index')->with('msgAjouter','Le bon de réception a été modifiée avec succès');
    }


    public function deleteLigneBonReceptionEdit(Request $request,$id,$idBonReception)
    {

        //$ligneBonReception = LigneBonReception::find($id);

        //dd("je suis dans deleteLigneBonReceptionEdit");

        $ligneBonReception = LigneBonReception::find($id);
        //dd($ligneBonReception);
        $idStockProduit = $ligneBonReception->id_stock_produit;
        if($idStockProduit != 0){
            StockProduit::find($idStockProduit)->delete();
        }

        LigneBonReception::find($id)->delete();


        //return redirect('bon_reception/modifier/'.$idBonReception);

        //StockProduit::where('id_ligne_bon_reception', '=', $id)->delete();

        return redirect('receptions/reception_fournisseur/ajouter/'.$request->input('idCommande'));
    }
    public function delete($id){
        //$lignesBonReception = LigneBonReception::where('id_bon_reception', '=', $id)->get();
        //dd($lignesBonReception);

        /*$lignesBonReception = LigneBonReception::where('id_bon_reception', '=', $id)->get();
        foreach ($lignesBonReception as $ligneBonReception){
            $idStockProduit = $ligneBonReception->id_stock_produit;
            StockProduit::find($idStockProduit)->delete();
            //idStockProduit peut etre = 0 =>erreur
        }*/
        $bonReception = BonReception::find($id);
        //dd($bonReception);
        if ($bonReception != null) {
            $bonReception->supprimer = 1;
            $bonReception->statut = 3;
            $bonReception->last_update = date("Y-m-d H:i:s");
            $bonReception->update();
            //changer status ligne_bon_reception_ue
            $lignes = LigneBonReception::where('id_bon_reception',$bonReception->id_bon_reception)->get();
            if ($lignes != null) {
                foreach ($lignes as $key => $ligne) {
                     //mettre a jour la quantité réelle
                        $stockProduit = StockProduit::where('id_produit','=',$ligne->id_produit)
                                                ->where('id_emplacement' ,'=',$ligne->idEmplacement)
                                                //->where('numero_lot','=',$ligne->numLot)
                                                ->first();
                        if ($stockProduit != null) {
                            $stockProduit->quantite_reelle -= $ligne->quantite_receptionner;
                            $stockProduit->last_update = date("Y-m-d H:i:s");
                            $stockProduit->update();
                        }
                    $ligne_ue = LigneBonReceptionUe::where('id_ligne_bon_reception',$ligne->id_ligne_bon_reception)->first();
                    if ($ligne_ue != null) {
                        $ligne_ue->statut = 2;
                        $ligne_ue->update();
                    }
                    //supprimer les numero de série
                    if (Session::get('NUMERO_SERIE')) {
                        NumSerie::where('id_ligne_reception',$ligne->id_ligne_bon_reception)->delete();
                    }
                      
                }
            }
        }

        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Suppression';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions';
        $HistoriqueActions->description = 'Suppression de la réception: '.$bonReception->num_bon_reception ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('receptions/reception_fournisseur/index')->with('msgSupprimer','Le bon de réception a été supprimer avec succès');

    }

    public function delete_ue($id)
    {
        $bonReception = BonReception::find($id);
        $bonReception->supprimer = 1;
        $bonReception->last_update = date("Y-m-d H:i:s");
        $bonReception->update();
        
        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Suppression';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions';
        $HistoriqueActions->description = 'Suppression de la réception: '.$bonReception->num_bon_reception ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('receptions/reception_fournisseur_ue/index')->with('msgSupprimer','Le bon de réception a été supprimer avec succès');

    }

    public function valider($id){
        $avec_ue = BonReception::find($id);

        $lignes = LigneBonReception::where('id_bon_reception', '=', $id)->with('ligneCommandeFournisseur.produit')->get();
        //dd($lignes);

        $idStockProduitUe = 0;
        $totalCmd = 0;
        $totalRecep = 0;
        foreach($lignes as $key =>$ligne) {
            $existeStock = 0;
            if ($ligne->id_ligne_commande_fournisseur != 0) {
                $existeStock = StockProduit::where('id_produit', '=', $ligne->ligneCommandeFournisseur->produit->id_produit)
                ->where('id_emplacement', '=', $ligne->idEmplacement)
                ->where('numero_lot', '=', $ligne->numLot)
                ->first();
            }else{
                $existeStock = StockProduit::where('id_produit', '=', $ligne->id_produit)
                ->where('id_emplacement', $ligne->idEmplacement)
                ->where('numero_lot', $ligne->numLot)
                ->first();
            }
            if ($existeStock != null) {
             $stockProduit = StockProduit::find($existeStock->id_stock_produit);
             $stockProduit->quantite_reelle -= $ligne->quantite_receptionner;
             $stockProduit->quantite_reelle += $ligne->qteReceptionnerFO;
             $stockProduit->quantite += $ligne->qteReceptionnerFO;
             $stockProduit->quantite_utilisable += $ligne->qteReceptionnerFO;
             $stockProduit->last_update = date("Y-m-d H:i:s");
             $stockProduit->update();

             $idStockProduit = $stockProduit->id_stock_produit;
             $idStockProduitUe = $idStockProduit;

             $ligne->id_stock_produit = $idStockProduit;
             $ligne->last_update = date("Y-m-d H:i:s");
             $ligne->update();
         } else {

             $stockProduit = new StockProduit();
             $stockProduit->quantite = $ligne->qteReceptionnerFO;
             $stockProduit->quantite_utilisable = $ligne->qteReceptionnerFO;
            $stockProduit->quantite_reelle = $ligne->qteReceptionnerFO;
             if (Session::get('DATE_PEREMPTION') == '1') {

                 $stockProduit->date_fabrication = $ligne->date_fabrication;
                 $stockProduit->date_peremption = $ligne->date_peremption;
             }
             if (Session::get('N_LOT') == '1') {
                 $stockProduit->numero_lot = $ligne->numLot;
             } else {
                 $stockProduit->numero_lot = "";
             }
             $stockProduit->id_emplacement = $ligne->idEmplacement;
             $stockProduit->date_entree = date("Y-m-d H:i:s");
             if ($ligne->id_ligne_commande_fournisseur != 0) {
                $stockProduit->id_produit = $ligne->ligneCommandeFournisseur->produit->id_produit;
            }else{
                $stockProduit->id_produit = $ligne->id_produit;
            }

            $stockProduit->validation = 1;
            $stockProduit->save();

            $idStockProduit = $stockProduit->id_stock_produit;
            $idStockProduitUe = $idStockProduit;
            $ligne->id_stock_produit = $idStockProduit;
            $ligne->update();
        }
        if ($avec_ue->unite_expedition) {
            $ue = LigneBonReceptionUe::where('id_ligne_bon_reception',$ligne->id_ligne_bon_reception)->update(['id_stock_produit' => $idStockProduitUe ,'last_update' => date("Y-m-d H:i:s")]); 
        }
        if ($ligne->id_ligne_commande_fournisseur != 0) {
         $ligneCommandeFournisseur = LigneCommandeFournisseur::find($ligne->id_ligne_commande_fournisseur);
                 //dd($ligneCommandeFournisseur);
         $ligneCommandeFournisseur->quantite_receptionner =  $ligneCommandeFournisseur->quantite_receptionner + $ligne->qteReceptionnerFO;
         $ligneCommandeFournisseur->update();
                //$totalCmd += $ligneCommandeFournisseur->quantite_commander;
                //$totalRecep += $ligneCommandeFournisseur->quantite_receptionner;
     }
 }
         //dd($totalCmd, $totalRecep);
         //récupérer le nombre de ligne de la commande
 $nbrLigne = LigneCommandeFournisseur::where('id_commande',$avec_ue->id_commande)
 ->get();
        //$nbr = 0;
 $en_cours= 1 ;
 $receptionne= 0;
 $p_receptionne = 0;
 foreach ($nbrLigne as $key => $value) {
    if ($value->quantite_receptionner != 0) {
        $en_cours = 0;
    }
    if ($value->quantite_commander <= $value->quantite_receptionner) {    
        $receptionne = 1;
    }elseif ($value->quantite_commander > $value->quantite_receptionner) {
        $p_receptionne = 1;
        $receptionne = 0;
        break;
    }
}

if (! $en_cours) {
    if ($p_receptionne) {
        CommandeFournisseur::where('id_commande_fournisseur', '=', $avec_ue->id_commande)->update(['etat' => "Réceptionnée partiellement"]);
    }
    if ($receptionne) {
        CommandeFournisseur::where('id_commande_fournisseur', '=', $avec_ue->id_commande)->update(['etat' => "Réceptionnée"]);
    }
}else{
    CommandeFournisseur::where('id_commande_fournisseur', '=', $avec_ue->id_commande)->update(['etat' => "En cours"]);
}
         //dd($nbr , $lignes->count());

         //if ($ligne->id_ligne_commande_fournisseur != 0) {
            //if ($nbr != 0) {
               // CommandeFournisseur::where('id_commande_fournisseur', '=', $avec_ue->id_commande)->update(['etat' => "Réceptionnée partiellement"]);
            //}else{
            //dd($totalCmd, $totalRecep);
           /*if ($totalRecep == 0) {
                    CommandeFournisseur::where('id_commande_fournisseur', '=', $avec_ue->id_commande)->update(['etat' => "En cours"]);

                } elseif ($totalCmd > $totalRecep) {
                    CommandeFournisseur::where('id_commande_fournisseur', '=', $avec_ue->id_commande)->update(['etat' => "Réceptionnée partiellement"]);

                } elseif ($totalCmd == $totalRecep) {
                    CommandeFournisseur::where('id_commande_fournisseur', '=', $avec_ue->id_commande)->update(['etat' => "Réceptionnée"]);
                }*/
    //}
            //}


    /*   foreach ($ligne as $l)
        {
            if ($l->statut == 0){
              $stock=StockProduit::find($l->id_stock_produit);

                $qntStock=$stock->quantite;
                $qntReceptionner=$l->quantite_receptionner;
                $qntFo=$l->qteReceptionnerFO;
              $stock->quantite=$qntStock-$qntReceptionner+$qntFo;

              $stock->last_update=date("Y-m-d H:i:s");
              $stock->update();
              $l->statut=1;
              $l->last_update=date("Y-m-d H:i:s");
              $l->update();
            }
        }*/

        $bon_reception=BonReception::find($id);
        $bon_reception->last_update=date("Y-m-d H:i:s");
        $bon_reception->statut = 3;
        $bon_reception->update();


        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Validation';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions par produit';
        $HistoriqueActions->description = 'Validation de la réception: '.$bon_reception->num_bon_reception ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();


        return redirect('receptions/reception_fournisseur/detail/'.$id)->with('msgAdd','Le stock a été mis à jour avec succès');
    }

    public function valider_ue($id){
        $bonReception = BonReception::find($id);
        if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
            $lignes = LigneBonReception::where('id_bon_reception', '=', $id)
            ->join('ligne_bon_reception_ue','ligne_bon_reception_ue.id_ligne_bon_reception','=','ligne_bon_reception.id_ligne_bon_reception')
            ->with('produit')->get();
        }else{       
            $lignes = LigneBonReception::where('id_bon_reception', '=', $id)->with('produit')->get();
        }

        //dd($lignes);
        
        $idStockProduitUe = 0;
        foreach($lignes as $key =>$ligne) {
            if ($ligne->qteReceptionnerFO != 0) {

                $existeStock = 0;
                if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                    $existeStock = StockProduit::where('id_produit', '=', $ligne->id_produit)
                    ->where('id_emplacement', $ligne->idEmplacement)
                    ->where('num_ue', $ligne->sscc)
                    //->where('numero_lot', $ligne->numLot)
                    ->first();
                }else{
                    $existeStock = StockProduit::where('id_produit', '=', $ligne->id_produit)
                    ->where('id_emplacement', $ligne->idEmplacement)
                    //->where('numero_lot', $ligne->numLot)
                    ->first();

                    //dd($existeStock);
                }
                
                
                if ($existeStock != null) {
                    $stockProduit = StockProduit::find($existeStock->id_stock_produit);
                    $stockProduit->quantite += $ligne->qteReceptionnerFO;
                    $stockProduit->quantite_utilisable += $ligne->qteReceptionnerFO;
                    $stockProduit->quantite_reelle -= $ligne->quantite_receptionner;
                    $stockProduit->quantite_reelle += $ligne->qteReceptionnerFO;
                    $stockProduit->last_update = date("Y-m-d H:i:s");
                    if (Session::get('STOCK_ENTITE') == '1') {
                       $stockProduit->num_entite = $bonReception->num_entite;
                    }
                    $stockProduit->update();

                    $idStockProduit = $stockProduit->id_stock_produit;
                    $idStockProduitUe = $idStockProduit;

                    $ligne->id_stock_produit = $idStockProduit;
                    $ligne->last_update = date("Y-m-d H:i:s");
                    $ligne->update();
                } else {
                     //ajouter UE
                           if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') { 
                                $ue = UE::where('num_ue',$ligne->sscc)->first();
                                if ($ue == null) {
                                    $ue = new UE();
                                    $ue->num_ue = $ligne->sscc;
                                    $ue->nbr_produit = 1;
                                    $ue->etat_ue = 0;//fermer
                                    $ue->id_emplacement = $ligne->Emplacement->id_emplacement;
                                    $ue->last_update = date("Y-m-d H:i:s");
                                    $ue->save();
                                }else{
                                    $ue->nbr_produit += 1;
                                    $ue->etat_ue = 0;//fermer
                                    $ue->last_update = date("Y-m-d H:i:s");
                                    $ue->update();
                                }
                                $ue = $ue->id_ue;
                            }
                            
                    

                    $stockProduit = new StockProduit();
                    $stockProduit->quantite = $ligne->qteReceptionnerFO;
                    $stockProduit->quantite_utilisable = $ligne->qteReceptionnerFO;
                    $stockProduit->quantite_reelle = $ligne->qteReceptionnerFO;
                    if (Session::get('DATE_PEREMPTION') == '1') {

                     $stockProduit->date_fabrication = $ligne->date_fabrication;
                     $stockProduit->date_peremption = $ligne->date_peremption;
                 }
                 if (Session::get('N_LOT') == '1') {
                     $stockProduit->numero_lot = $ligne->numLot;
                 } else {
                     $stockProduit->numero_lot = "";
                 }
                 if (Session::get('STOCK_ENTITE') == '1') {
                     $stockProduit->num_entite = $bonReception->num_entite;
                 }
                 if (Session::get('TYPE_STOCK_EMPLACEMENT_MOBILE') == '1') {
                     $stockProduit->num_ue = $ligne->sscc;
                 }
                 $stockProduit->id_emplacement = $ligne->idEmplacement;
                 $stockProduit->date_entree = date("Y-m-d H:i:s");

                 $stockProduit->id_produit = $ligne->id_produit;

                 $stockProduit->validation = 1;
                 $stockProduit->save();

                 $idStockProduit = $stockProduit->id_stock_produit;
                 $idStockProduitUe = $idStockProduit;
                 $ligne->id_stock_produit = $idStockProduit;
                 $ligne->update();
             }
            if ($bonReception->unite_expedition) {
                $ue = LigneBonReceptionUe::where('id_ligne_bon_reception',$ligne->id_ligne_bon_reception)->update(['id_stock_produit' => $idStockProduitUe ,'last_update' => date("Y-m-d H:i:s"),'statut' => 1]);
            }
        }else{
            LigneBonReceptionUe::where('id_ligne_bon_reception',$ligne->id_ligne_bon_reception)->delete();
            $ligne->delete();
        }
    }

    //$bon_reception=BonReception::find($id);
    $bonReception->last_update=date("Y-m-d H:i:s");
    $bonReception->statut = 3;
    $bonReception->update();


    $HistoriqueActions = new Historique();
    $HistoriqueActions->type_action = 'Validation';
    $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions';
    $HistoriqueActions->description = 'Validation de la réception: '.$bonReception->num_bon_reception ;
    $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
    $HistoriqueActions->date =Carbon::now('Africa/Algiers');
    $HistoriqueActions->save();

    return redirect('receptions/reception_fournisseur_ue/detail/'.$id)->with('msgAdd','Le stock a été mis à jour avec succès');
}
    /**
     * [get_ue_from_poduit: récupérer la liste des ue pour un produit]
     * @param  [int] $id_produit [identifiant de produit]
     * @return [collection] $sscc [collection contenant tt les sscc qui le produit lui appartient]
     */
    public function get_ue_from_poduit($idLigne_bon_reception){

        $ligne = LigneBonReceptionUe::where('id_ligne_bon_reception',$idLigne_bon_reception)->get();
        //déclarer une collection 'sscc' vide
        /*$sscc = collect();
        //récupérer tt les lignes_bon_reception qui ont le meme id_produit 
        $lignes = LigneBonReception::where('id_produit',$id_produit)->get();
        //vérifier si : pour chaque id ligne_bon_reception ask il existe ds la table LigneBonReceptionUe! 
        //si oui : on prend le sscc de la table ligne_bon_reception_ue.
        foreach ($lignes as $ligne) {
            $existe = LigneBonReceptionUe::where('id_ligne_bon_reception',$ligne->id_ligne_bon_reception)->get();

            if (! $existe->isEmpty()) {
                foreach ($existe as $e) {
                    $sscc->put($e->id_ligne_bon_reception.$e,$e->sscc);
                }
            }
        }*/
        //retourner la collecion pour l'afficher.
        return $ligne;
    }

    public function downloadPDF($ligne){
        $sscc = $this->get_ue_from_poduit($ligne);
        $ligneBonReception = LigneBonReception::find($ligne);
        $emplacement = $ligneBonReception->emplacement->libelle;
        $produit = Produit::find($ligneBonReception->ligneCommandeFournisseur->produit->id_produit);
        $configuration = ConfigurationPdf::first(); 

        //return view('bon_reception_fournisseur.export.exportPDF',compact('configuration'));

        $pdf = PDF::loadView('bon_reception_fournisseur.export.exportPDF',compact('sscc','emplacement','produit','configuration'));
        return $pdf->download('Liste des unités d expédition.pdf');
    }

    public function simule_saisie_fo(Request $request){
        $quantite_RR = $request->input('quantite_RR');
        $bon_reception = $request->input('bon_reception');
        $ligne_bon_reception = $request->input('ligne_bon_reception');

        $ligneBonReception = LigneBonReception::find($ligne_bon_reception);

        if($ligneBonReception->quantite_reste_receptionnee  == $quantite_RR)
            $ligneBonReception->statut = 1;
        else
            $ligneBonReception->statut = 0;

        $ligneBonReception->qteReceptionnerFO = $quantite_RR ;
        $ligneBonReception->quantite_reste_receptionnee = $ligneBonReception->quantite_receptionner - $quantite_RR ;

        $ligneBonReception->qteReceptionnerFO = $quantite_RR ;
        $ligneBonReception->operateur = Session::get('id');
        $ligneBonReception->simule_fo = 1;
        $ligneBonReception->last_update= date("Y-m-d H:i:s");
        $ligneBonReception->update();

        $bonReception = BonReception::find($bon_reception);
        $bonReception->last_update = date("Y-m-d H:i:s");
        $bonReception->statut = 1;
        $bonReception->update();
        //penser a gérer le cas ou il modifier la quantité_RR a 0 
        //ask on change statut de bon_reception a 0 ? 
        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Simuler saisie FO';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions par produit';
        $HistoriqueActions->description = 'Simulation de la réception: '.$bonReception->num_bon_reception;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();
        
        return redirect('receptions/reception_fournisseur/detail/'.$bon_reception)->with('msgAdd','La quantité réceptionnée (réelle) a été modifiée avec succès');
    }

    public function simule_saisie_fo_ue(Request $request){
        $quantite_RR = (float) $request->input('quantite_RR');
        $bon_reception = $request->input('bon_reception');
        $ligne_bon_reception = $request->input('ligne_bon_reception');

        $ligneBonReception = LigneBonReception::find($ligne_bon_reception);

        if($ligneBonReception->quantite_reste_receptionnee  == $quantite_RR)
            $ligneBonReception->statut = 1;
        else
            $ligneBonReception->statut = 0;

        $ligneBonReception->qteReceptionnerFO = $quantite_RR ;
        $ligneBonReception->quantite_reste_receptionnee = number_format($ligneBonReception->quantite_receptionner - $quantite_RR,1) ;

        $ligneBonReception->qteReceptionnerFO = $quantite_RR ;
        $ligneBonReception->operateur = Session::get('id');
        $ligneBonReception->simule_fo = 1;
        $ligneBonReception->last_update= date("Y-m-d H:i:s");
        $ligneBonReception->update();

        $bonReception = BonReception::find($bon_reception);
        $bonReception->last_update = date("Y-m-d H:i:s");
        $bonReception->statut = 1;
        $bonReception->update();
        //penser a gérer le cas ou il modifier la quantité_RR a 0 
        //ask on change statut de bon_reception a 0 ? 
        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Simuler saisie FO';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions par UE';
        $HistoriqueActions->description = 'Simulation de la réception: '.$bonReception->num_bon_reception;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();
        
        return redirect('receptions/reception_fournisseur_ue/detail/'.$bon_reception)->with('msgAdd','La quantité réceptionnée (réelle) a été modifiée avec succès');
    }

    public function get_ue_checked($id){
        if ($id) {
            Session::put('avec_ueee',1);
        }else
        Session::put('avec_ueee',0);
    }

    public function produitNonCommandeModifier(Request $request){

        $bonReception = $request->input('bonReception');
        $produit = $request->input('produit');
        $quantite = $request->input('quantitee');
        $emplacement = $request->input('emplacement');
        if (Session::get('N_LOT') == '1') {
            $lot = $request->input('lot');
        }
        if(Session::get('DATE_PEREMPTION')=='1'){
            $dateF = $request->input('dateFabrication');
            $dateP = $request->input('datePeremption');
        }

        if(Session::get('DATE_PEREMPTION')=='1' && Session::get('N_LOT') == '1'){
            if (!$lot && !$dateF && !$dateP) {
                $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
                return redirect('receptions/reception_fournisseur/modifier/'.$bonReception);
            }
        }

        if ($produit  && $quantite  && $emplacement ) {
            //testé si le produit existe
            $test = LigneBonReception::where('id_bon_reception',$bonReception)->with('ligneCommandeFournisseur.produit')->get();
            //dd($test);
            if ($test != null) {
                foreach ($test as $key => $t) {
                    if ($t->ligneCommandeFournisseur != null) {
                        if ($t->id_produit == $produit || $t->ligneCommandeFournisseur->produit->id_produit == $produit){
                            $request->session()->flash('erreur', 'Le produit existe déjà dans la liste');
                            return redirect('receptions/reception_fournisseur/modifier/'.$bonReception);
                        }
                    }else{
                        if ($t->id_produit == $produit){
                            $request->session()->flash('erreur', 'Le produit existe déjà dans la liste');
                            return redirect('receptions/reception_fournisseur/modifier/'.$bonReception);
                        }
                    }
                    
                }
            }

            $ligne = new LigneBonReception();
            $ligne->id_bon_reception = $bonReception;
            $ligne->id_ligne_commande_fournisseur = 0;
            $ligne->quantite_commander = 0;
            $ligne->quantite_receptionner = $quantite;
            $ligne->quantite_reste_receptionnee = 0;
            $ligne->id_stock_produit = 0;
            $ligne->idEmplacement = $emplacement;
            if (Session::get('N_LOT') == '1') {
                $ligne->numLot = $lot;
            }else{
                $ligne->numLot ='';
            }
            if(Session::get('DATE_PEREMPTION')=='1'){
                $ligne->date_fabrication = $dateF;
                $ligne->date_peremption = $dateP;
            }
            $ligne->qteReceptionnerFO = $quantite;
            $ligne->statut = 0;
            $ligne->operateur = Session::get('id');
            $ligne->simule_fo = 1;
            $ligne->id_produit = $produit;
            $ligne->modifier = 1;
            $ligne->save();

            $request->session()->flash('ajouter', 'Le produit a été ajouté avec succès');
            return redirect('receptions/reception_fournisseur/modifier/'.$bonReception);

        }
        else{
            $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
            return redirect('receptions/reception_fournisseur/modifier/'.$bonReception);
        }
    }

    public function produitNonCommande(Request $request){

        $id_commande = $request->input('id_commande');
        if (! $id_commande) {
            $request->session()->flash('erreur', 'Veuillez sélectionner une commande');
            return redirect('receptions/reception_fournisseur/ajouter');
        }
        $produit = $request->input('produit');
        $quantite = $request->input('quantitee');
        $emplacement = $request->input('emplacement');
        if (Session::get('N_LOT') == '1') {
            $lot = $request->input('lot');
        }
        if(Session::get('DATE_PEREMPTION')=='1'){
            $dateF = $request->input('dateFabrication');
            $dateP = $request->input('datePeremption');
        }

        if(Session::get('DATE_PEREMPTION')=='1' && Session::get('N_LOT') == '1'){
            if (!$lot && !$dateF && !$dateP) {
                if ($id_commande) {
                    $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
                    return redirect('receptions/reception_fournisseur/ajouter/'.$id_commande);
                }else{
                    $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
                    return redirect('receptions/reception_fournisseur/ajouter');
                }
            }
        }
        if ($produit  && $quantite  && $emplacement ) {
            //testé si le produit existe
            $test = LigneBonReception::where('id_bon_reception',0)->with('ligneCommandeFournisseur.produit')->get();
            if ($test != null) {
                foreach ($test as $key => $t) {
                    if ($t->ligneCommandeFournisseur != null) {
                        if ($t->id_produit == $produit || $t->ligneCommandeFournisseur->produit->id_produit == $produit){
                            $request->session()->flash('erreur', 'Le produit existe déjà dans la liste');
                            return redirect('receptions/reception_fournisseur/ajouter/'.$id_commande);
                        }
                    }else{
                        if ($t->id_produit == $produit){
                            $request->session()->flash('erreur', 'Le produit existe déjà dans la liste');
                            return redirect('receptions/reception_fournisseur/ajouter/'.$id_commande);
                        }
                    }
                }
            }
            $ligne = new LigneBonReception();
            $ligne->id_bon_reception = 0;
            $ligne->id_ligne_commande_fournisseur = 0;
            $ligne->quantite_commander = 0;
            $ligne->quantite_receptionner = $quantite;
            $ligne->quantite_reste_receptionnee = 0;
            $ligne->id_stock_produit = 0;
            $ligne->idEmplacement = $emplacement;
            if (Session::get('N_LOT') == '1') {
                $ligne->numLot = $lot;
            }else{
                $ligne->numLot ='';
            }
            if(Session::get('DATE_PEREMPTION')=='1'){
                $ligne->date_fabrication = $dateF;
                $ligne->date_peremption = $dateP;
            }
            $ligne->qteReceptionnerFO = $quantite;
            $ligne->statut = 0;
            $ligne->operateur = Session::get('id');
            $ligne->simule_fo = 1;
            $ligne->id_produit = $produit;
            $ligne->save();

            $request->session()->flash('ajouter', 'Le produit a été ajouté avec succès');
            return redirect('receptions/reception_fournisseur/ajouter/'.$id_commande);
        }
        else{
            if ($id_commande) {
                $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
                return redirect('receptions/reception_fournisseur/ajouter/'.$id_commande);
            }else{
                $request->session()->flash('erreur', 'Veuillez remplir tous les champs');
                return redirect('receptions/reception_fournisseur/ajouter');
            }
        }
    }

    public function downloadModele(Request $request){
        if(Session::get('AVEC_UE_RECEPTION')){
            if(Session::get('CONTROLE_UE')){
                if(Session::get('STOCK_ENTITE')){
                    $file=public_path()."/Modele_Reception_UE_Entite.xlsx";
                    $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
                    return Response::download($file, 'Modele_Reception_UE_Entite.xlsx',$headers); 
                }else{
                    $file=public_path()."/Modele_Reception_UE.xlsx";
                    $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
                    return Response::download($file, 'Modele_Reception_UE.xlsx',$headers); 
                }
            }  
        }else{
            $file=public_path()."/Modele_Reception.xlsx";
            $headers = array('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',);
            return Response::download($file, 'Modele_Reception.xlsx',$headers);
        }
    }

    public function import_ue(Request $request){
        //avec ue
        //sans entite
        if (Session::get('TYPE_NUMERO_DOCUMENT') != "1") {
           return Redirect::back()->withErrors(["Veuillez définir d'abord un type de n° document dans préférences."]);
        }
        //tester si on'a un emplacement par défaut dans préférence.
        $emp_reception = Preferences::where('code_preference','=',"EMP_RECEPTION")->first();
        //dd($emp_reception);
        if ($emp_reception->valeur_preference == 0 || $emp_reception == null) {
            return Redirect::back()->withErrors(["Veuillez définir d'abord un emplacement de réception par défaut dans préférences."]);
        }
        $bon_reception = null;
        ini_set('max_execution_time', 1000);

        $bytes = $request->file('file')->getClientSize();

        $ext = Input::file('file')->getClientOriginalExtension();
        if ( $ext == "xlsx" || $ext == 'xls'){
            if ($bytes < 25165824) {
                $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));
                $sheet = $objPHPExcel->getSheet(0);
                $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                //dd($highestRow);
                $erreur = collect();
                $warning = collect();
                $numeroDocument = null;
                $date_creation = null;
                if ($highestRow > 1) {
                    $y=1;
                    DB::beginTransaction();
                    //$getAllUe = LigneBonReceptionUE::all();
                    $ue_memory = collect();
                    foreach ($sheet->getRowIterator() as $key=> $row) {
                        //Version 2
                        $numero_document = null;
                        $date = null;
                        $numero_ue = null;
                        $code_barre_produit = null;
                        $reference_produit = null;
                        $designation_produit = null;
                        $quantite = null;
                        if ($row->getRowIndex() >= 2){
                            // On boucle sur les cellule de la ligne
                            $numero_document= trim($sheet->getCell('A'.$y)->getValue()); 
                            $date = $sheet->getCell('B'.$y)->getValue();
                            //dd(strtotime($date));
                            //$date = PHPExcel_Style_NumberFormat::toFormattedString($date,PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2);
                            $date = strtotime(str_replace('/', '-',$date));
                            $date = date('Y-m-d',$date);
                            //dd($date);
                            //dd(date('Y-m-d',$date));
                            $numero_ue = trim($sheet->getCell('C'.$y)->getValue());
                            $code_barre_produit= $sheet->getCell('D'.$y)->getValue();
                            $reference_produit= $sheet->getCell('E'.$y)->getValue();
                            $designation_produit= $sheet->getCell('F'.$y)->getValue();
                            $quantite = $sheet->getCell('G'.$y)->getValue();

                            //Ajouter un bon de réception avec id commande = -1.
                            if ($row->getRowIndex() == 2) {
                             //vérifier si les champs nécessaire pour créer un bon réception fournisseur son rempli
                             if ($numero_document != null && $date != null) {
                                $numeroDocument = $numero_document ;
                                $date_creation = $date;

                                $BonReception = new BonReception();
                                $NumBonReception = null;
                                $lastNum = BonReception::orderBy('id_bon_reception','desc')->first();
                                if ($lastNum != null) {
                                    $NumBonReception = substr_replace($lastNum->num_bon_reception, "", 0, 5);
                                    if ($NumBonReception == 99999){
                                        $NumBonReception='BNREC00001';
                                    }
                                    else{
                                        $NumBonReception = $NumBonReception + 1;
                                        $NumBonReception=str_pad($NumBonReception, 5, '0', STR_PAD_LEFT);
                                        $NumBonReception ='BNREC'.$NumBonReception;
                                    }
                                }
                                else{
                                    $NumBonReception='BNREC00001';
                                }
                                $BonReception->num_bon_reception = $NumBonReception;
                                $BonReception->date_creation = $date;
                                $BonReception->id_commande = -1; //fichier import sans commande
                                $BonReception->produit_rec = $sheet->getHighestRow() - 1;
                                $BonReception->last_update = date("Y-m-d H:i:s");
                                //$ue = Preferences::where('code_preference','=',"AVEC_UE_RECEPTION")->first();
                                $BonReception->unite_expedition = 1 ; 
                                $BonReception->supprimer = 0;
                                $BonReception->statut = 0;
                                $BonReception->num_document = $numero_document;
                                $BonReception->save();
                                $bon_reception = $BonReception;
                            }else return Redirect::back()->withErrors(['Le champ N°document est obligatoire']);
                        }
                        //vérifier si la date ou numéro ducument on été changé
                        if ($numeroDocument != $numero_document) {
                            $warning->put($key, 'Le numéro de document a été modifié');
                            break;
                        }
                        if ($date_creation != $date) {
                            $warning->put($key, 'La date de création a été modifiée');
                            break;
                        }
                        //
                        $getAllUe = LigneBonReceptionUe::where('sscc',$numero_ue)->get();
                        if ($getAllUe != null) {
                            foreach ($getAllUe as $value) {
                                
                                   if ($value->statut == 1) {
                                       //erreur
                                       $erreur->put($key, "Le numéro de l'UE doit être unique par un bon de réception");
                                       break;
                                   }
                                   if ($value->statut == 0) {
                                        $testLigne = LigneBonReception::where('id_ligne_bon_reception',$value->id_ligne_bon_reception)->with('bonReception')->first();
                                        //DB::rollback();
                                        //dd($testLigne);

                                        if ($testLigne != null){
                                            if ($testLigne->id_bon_reception != $bon_reception->id_bon_reception && $testLigne->bonReception->supprimer == 0){
                                               $erreur->put($key, "Le numéro de l'UE doit être unique par un bon de réception");
                                                break;
                                            }
                                            }else{
                                               $erreur->put($key, "Le numéro de l'UE doit être unique par un bon de réception");
                                                break; 
                                            }
                                        }
                            }       
                        }
                        //ajouter les ligne bon réception
                        //tester si le produit existe bien
                        $produit = Produit::where('reference',$reference_produit)->first();
                        if ($produit != null) {
                            //cas ou 2 produit ou plus son dans le meme box alors en somme les quantités
                            $test = LigneBonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->where('id_produit',$produit->id_produit)->get();
                            $update = 0;
                            if ($test) {
                                foreach ($test as $t) {
                                     $testUe = LigneBonReceptionUe::where('id_ligne_bon_reception',$t->id_ligne_bon_reception)->get();

                                     if ($testUe) {
                                        foreach ($testUe as $ue) {
                                            if ($ue->sscc == $numero_ue) {
                                                $update = 1;
                                                //update ligne
                                                $t->quantite_commander += $quantite;
                                                $t->quantite_receptionner += $quantite ;
                                                $t->quantite_reste_receptionnee += $quantite ;
                                                $t->update();

                                                

                                                $BonReceptionn = BonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->first();
                                                $BonReceptionn->produit_rec -= 1;
                                                $BonReceptionn->update();
                                                //$warning->put($key, 'La date de création a été modifiée');
                                                break;
                                            }
                                        }
                                     }
                                }
                            }
                            if($update == 0){
                                if ($numero_ue != null && $quantite != null) {
                                    $LigneBonReception = new LigneBonReception();
                                    $LigneBonReception->id_bon_reception = $bon_reception->id_bon_reception;
                                    $LigneBonReception->id_ligne_commande_fournisseur = -1; //fichier import sans commande
                                    $LigneBonReception->quantite_commander = $quantite;
                                    $LigneBonReception->quantite_receptionner = $quantite;
                                    $LigneBonReception->quantite_reste_receptionnee = $quantite;
                                    $LigneBonReception->id_produit = $produit->id_produit;
                                    $LigneBonReception->idEmplacement = $emp_reception->valeur_preference;
                                    $LigneBonReception->qteReceptionnerFO = 0;
                                    $LigneBonReception->statut = 0;
                                    $LigneBonReception->operateur = 0;
                                    $LigneBonReception->simule_fo = 0;
                                    $LigneBonReception->last_update = date("Y-m-d H:i:s");
                                    $LigneBonReception->save();
                                    //ajouter dans la table ligne bon réception ue
                                    $ligneBonRceptionUE = new LigneBonReceptionUe();
                                    $ligneBonRceptionUE->id_stock_produit = 0;
                                    $ligneBonRceptionUE->sscc = $numero_ue;
                                    $ligneBonRceptionUE->id_ligne_bon_reception = $LigneBonReception->id_ligne_bon_reception;
                                    $ligneBonRceptionUE->last_update = date("Y-m-d H:i:s");
                                    $ligneBonRceptionUE->save();

                                    
                                    if (! $ue_memory->contains($numero_ue)) {
                                        //inserer dans la collection le ue;
                                        $ue_memory->put($key, $numero_ue);
                                    }
                                    
                                }else{
                                    if ($numero_ue == null) {
                                        $erreur->put($key, "Le champ N°UE est obligatoire");
                                        break;
                                    }
                                    if ($quantite == null) {
                                       $erreur->put($key, "Le champ Quantité est obligatoire");
                                       break;
                                    }
                                }    
                           }
                        }else{
                            $erreur->put($key, "Le produit ".$reference_produit." n'existe pas");
                            break;
                        }
                    }
                    $y++;
                }
                $BonReceptionn = BonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->first();
                $BonReceptionn->nbr_ue_reste = $ue_memory->count();
                $BonReceptionn->update();

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Importation';
                $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions';
                $HistoriqueActions->description = 'Importation des réceptions depuis un fichier';
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();
                //dd($sheet->getHighestRow() - 1, $erreur->count());
                if ($sheet->getHighestRow() - 1 == $erreur->count()) {
                    DB::rollback();
                    //delete bon_reception
                    //BonReception::where('id_bon_reception', $bon_reception->id_bon_reception)->delete();
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouterAnnuler',
                        [$erreur]);
                }
                if ($erreur->count() == 0 && $warning->count() == 0) {
                    DB::commit();
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouter', 'Fichier importé avec succès');
                }else{
                    DB::rollback();
                    /*//delete bon reception
                    BonReception::where('id_bon_reception', $bon_reception->id_bon_reception)->delete();
                    //delete ligne_bon reception
                    $ligne = LigneBonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->get();
                    LigneBonReceptionUe::where('id_ligne_bon_reception',)->delete();
                    $ligne->delete();*/
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouterErreur',[$warning , $erreur]);
                }
            }
            else
                return Redirect::back()->withErrors(['Fichier vide ']);
        } else return Redirect::back()->withErrors(['Fichier volumineux ']);

    } else return Redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);
}

    public function import(Request $request){
        //sans ue
        //sans entite
        //tester si on'a un emplacement par défaut dans préférence.
        $emp_reception = Preferences::where('code_preference','=',"EMP_RECEPTION")->first();
        //dd($emp_reception);
        if ($emp_reception->valeur_preference == 0 || $emp_reception == null) {
            return Redirect::back()->withErrors(["Veuillez définir d'abord un emplacement de réception par défaut dans préférences."]);
        }
        $bon_reception = null;
        ini_set('max_execution_time', 1000);

        $bytes = $request->file('file')->getClientSize();

        $ext = Input::file('file')->getClientOriginalExtension();
        if ( $ext == "xlsx" || $ext == 'xls'){
            if ($bytes < 25165824) {
                $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));
                $sheet = $objPHPExcel->getSheet(0);
                $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                //dd($highestRow);
                $erreur = collect();
                $warning = collect();
                $numeroDocument = null;
                $date_creation = null;
                if ($highestRow > 1) {
                    $y=1;
                    DB::beginTransaction();
                    //$getAllUe = LigneBonReceptionUE::all();
                    foreach ($sheet->getRowIterator() as $key=> $row) {
                        //Version 2
                        $numero_document = null;
                        $date = null;
                        $numero_ue = null;
                        $code_barre_produit = null;
                        $reference_produit = null;
                        $designation_produit = null;
                        $quantite = null;
                        if ($row->getRowIndex() >= 2){
                            // On boucle sur les cellule de la ligne
                            $numero_document= trim($sheet->getCell('A'.$y)->getValue()); 
                            $date = $sheet->getCell('B'.$y)->getValue();
                            //dd(strtotime($date));
                            //$date = PHPExcel_Style_NumberFormat::toFormattedString($date,PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2);
                            $date = strtotime(str_replace('/', '-',$date));
                            $date = date('Y-m-d',$date);
                            //dd($date);
                            //dd(date('Y-m-d',$date));
                            //$numero_ue = trim($sheet->getCell('C'.$y)->getValue());
                            $code_barre_produit= $sheet->getCell('C'.$y)->getValue();
                            $reference_produit= $sheet->getCell('D'.$y)->getValue();
                            $designation_produit= $sheet->getCell('E'.$y)->getValue();
                            $quantite = $sheet->getCell('F'.$y)->getValue();

                            //Ajouter un bon de réception avec id commande = -1.
                            if ($row->getRowIndex() == 2) {
                             //vérifier si les champs nécessaire pour créer un bon réception fournisseur son rempli
                             if ($numero_document != null && $date != null) {
                                $numeroDocument = $numero_document ;
                                $date_creation = $date;

                                $BonReception = new BonReception();
                                $NumBonReception = null;
                                $lastNum = BonReception::orderBy('id_bon_reception','desc')->first();
                                if ($lastNum != null) {
                                    $NumBonReception = substr_replace($lastNum->num_bon_reception, "", 0, 5);
                                    if ($NumBonReception == 99999){
                                        $NumBonReception='BNREC00001';
                                    }
                                    else{
                                        $NumBonReception = $NumBonReception + 1;
                                        $NumBonReception=str_pad($NumBonReception, 5, '0', STR_PAD_LEFT);
                                        $NumBonReception ='BNREC'.$NumBonReception;
                                    }
                                }
                                else{
                                    $NumBonReception='BNREC00001';
                                }
                                $BonReception->num_bon_reception = $NumBonReception;
                                $BonReception->date_creation = $date;
                                $BonReception->id_commande = -1; //fichier import sans commande
                                $BonReception->produit_rec = $sheet->getHighestRow() - 1;
                                $BonReception->last_update = date("Y-m-d H:i:s");
                                //$ue = Preferences::where('code_preference','=',"AVEC_UE_RECEPTION")->first();
                                $BonReception->unite_expedition = 0 ; 
                                $BonReception->supprimer = 0;
                                $BonReception->statut = 0;
                                $BonReception->num_document = $numero_document;
                                $BonReception->save();
                                $bon_reception = $BonReception;
                            }else return Redirect::back()->withErrors(['Le champ N°document est obligatoire']);
                        }
                        //vérifier si la date ou numéro ducument on été changé
                        if ($numeroDocument != $numero_document) {
                            $warning->put($key, 'Le numéro de document a été modifié');
                            break;
                        }
                        if ($date_creation != $date) {
                            $warning->put($key, 'La date de création a été modifiée');
                            break;
                        }
                        
                        
                        //ajouter les ligne bon réception
                        //tester si le produit existe bien
                        $produit = Produit::where('reference',$reference_produit)->first();
                        if ($produit != null) {
                            //cas ou 2 meme produit => alors en somme les quantités
                            $test = LigneBonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->where('id_produit',$produit->id_produit)->first();
                            $update = 0;
                            if ($test) {
                                $update = 1;

                                $test->quantite_commander += $quantite;
                                $test->quantite_receptionner += $quantite ;
                                $test->quantite_reste_receptionnee += $quantite ;
                                $test->update();

                                //mettre a jour la quantité réelle du stock
                                                $stock = StockProduit::where('id_emplacement',$emp_reception->valeur_preference)->where('id_produit',$produit->id_produit)
                                                    //->where('num_ue',$numero_ue)
                                                    ->first();
                                                    if ($stock != null) {
                                                        //dd('lol');
                                                        $stock->quantite_reelle += $quantite;
                                                        $stock->update();
                                                    }

                                $BonReceptionn = BonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->first();
                                $BonReceptionn->produit_rec -= 1;
                                $BonReceptionn->update();
                            }
                            if($update == 0){
                                if ($quantite != null) {

                                    $LigneBonReception = new LigneBonReception();
                                    $LigneBonReception->id_bon_reception = $bon_reception->id_bon_reception;
                                    $LigneBonReception->id_ligne_commande_fournisseur = -1; //fichier import sans commande
                                    $LigneBonReception->quantite_commander = $quantite;
                                    $LigneBonReception->quantite_receptionner = $quantite;
                                    $LigneBonReception->quantite_reste_receptionnee = $quantite;
                                    $LigneBonReception->id_produit = $produit->id_produit;
                                    $LigneBonReception->idEmplacement = $emp_reception->valeur_preference;
                                    $LigneBonReception->qteReceptionnerFO = 0;
                                    $LigneBonReception->statut = 0;
                                    $LigneBonReception->operateur = 0;
                                    $LigneBonReception->simule_fo = 0;
                                    $LigneBonReception->last_update = date("Y-m-d H:i:s");
                                    $LigneBonReception->save();

                                    //mettre a jour la quantité réelle du stock
                                                $stock = StockProduit::where('id_emplacement',$emp_reception->valeur_preference)->where('id_produit',$produit->id_produit)
                                                    //->where('num_ue',$numero_ue)
                                                    ->first();
                                                    //dd($emp_reception->valeur_preference, $produit->id_produit,$stock);
                                                    if ($stock) {
                                                       $stock->quantite_reelle += $quantite;
                                                        $stock->update();
                                                    }
                                    
                                }else{
                                    $erreur->put($key, "Le champ Quantité est obligatoire");
                                    break;  
                                }    
                           }
                        }else{
                            $erreur->put($key, "Le produit ".$reference_produit." n'existe pas");
                            break;
                        }
                    }
                    $y++;
                }
                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Importation';
                $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions';
                $HistoriqueActions->description = 'Importation des réceptions depuis un fichier';
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();
                //dd($sheet->getHighestRow() - 1, $erreur->count());
                if ($sheet->getHighestRow() - 1 == $erreur->count()) {
                    DB::rollback();
                    //delete bon_reception
                    //BonReception::where('id_bon_reception', $bon_reception->id_bon_reception)->delete();
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouterAnnuler',
                        [$erreur]);
                }
                if ($erreur->count() == 0 && $warning->count() == 0) {
                    DB::commit();
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouter', 'Fichier importé avec succès');
                }else{
                    DB::rollback();
                    /*//delete bon reception
                    BonReception::where('id_bon_reception', $bon_reception->id_bon_reception)->delete();
                    //delete ligne_bon reception
                    $ligne = LigneBonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->get();
                    LigneBonReceptionUe::where('id_ligne_bon_reception',)->delete();
                    $ligne->delete();*/
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouterErreur',[$warning , $erreur]);
                }
            }
            else
                return Redirect::back()->withErrors(['Fichier vide ']);
        } else return Redirect::back()->withErrors(['Fichier volumineux ']);

    } else return Redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);
}

    public function import_entite(Request $request){
        //avec ue
        //avec entite
        //dd(Session::get('TYPE_NUMERO_DOCUMENT'));
        if (Session::get('TYPE_NUMERO_DOCUMENT') != "1") {
           return Redirect::back()->withErrors(["Veuillez définir d'abord un type de n° document dans préférences."]);
        }

        //tester si on'a un emplacement par défaut dans préférence.
        $emp_reception = Preferences::where('code_preference','=',"EMP_RECEPTION")->first();
        //dd($emp_reception);
        if ($emp_reception->valeur_preference == 0 || $emp_reception == null) {
            return Redirect::back()->withErrors(["Veuillez définir d'abord un emplacement de réception par défaut dans préférences."]);
        }
        $bon_reception = null;
        ini_set('max_execution_time', 1000);

        $bytes = $request->file('file')->getClientSize();

        $ext = Input::file('file')->getClientOriginalExtension();
        if ( $ext == "xlsx" || $ext == 'xls'){
            if ($bytes < 25165824) {
                $objPHPExcel = PHPExcel_IOFactory::load(Input::file('file'));
                $sheet = $objPHPExcel->getSheet(0);
                $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
                //dd($highestRow);
                $erreur = collect();
                $warning = collect();
                //key: id_bon_reception ; value: N° Document.
                $data = collect();
                $numeroDocument = null;
                $date_creation = null;
                if ($highestRow > 1) {
                    $y=1;
                    DB::beginTransaction();
                    //$getAllUe = LigneBonReceptionUE::all();
                    //déclare une collection
                    $ue_memory = collect();
                    $ueee = collect();
                    $bon_reception = 0;
                    foreach ($sheet->getRowIterator() as $key=> $row) {

                        //Version 2
                        $numero_entite = null;
                        $libelle_entite = null;
                        $numero_document = null;
                        $date = null;
                        $numero_ue = null;
                        $code_barre_produit = null;
                        $reference_produit = null;
                        $designation_produit = null;
                        $quantite = null;
                        if ($row->getRowIndex() >= 2){
                            // On boucle sur les cellule de la ligne
                            $numero_entite = trim($sheet->getCell('A'.$y)->getValue()); 
                            $libelle_entite = $sheet->getCell('B'.$y)->getValue();

                            $numero_document = trim($sheet->getCell('C'.$y)->getValue()); 
                            $date = $sheet->getCell('D'.$y)->getValue();
                            //dd($date);
                            //dd(strtotime($date));
                            //$date = PHPExcel_Style_NumberFormat::toFormattedString($date,PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD2);
                            $date = strtotime(str_replace('/', '-',$date));
                            //dd($date);
                            $date = date('Y-m-d',$date);
                            //dd($date);
                            if ($date=="1970-01-01") {
                                //dd('test');
                                $date = date('Y-m-d');
                            }
                            //dd($date);
                            //dd(date('Y-m-d',$date));
                            $numero_ue = trim($sheet->getCell('E'.$y)->getValue());
                            $code_barre_produit= $sheet->getCell('F'.$y)->getValue();
                            $reference_produit= $sheet->getCell('G'.$y)->getValue();
                            $designation_produit= $sheet->getCell('H'.$y)->getValue();
                            $quantite = $sheet->getCell('I'.$y)->getValue();


                            $numSerie=$sheet->getCell('J'.$y)->getValue();
                            $numBC=$sheet->getCell('K'.$y)->getValue();
                            $contrat=$sheet->getCell('L'.$y)->getValue();
                            $facture=$sheet->getCell('M'.$y)->getValue();
                            $fourniseur=$sheet->getCell('N'.$y)->getValue();
                            //dd($quantite);

                            //Ajouter un bon de réception avec id commande = -1.
                           
                            
                             //vérifier si les champs nécessaire pour créer un bon réception fournisseur son rempli
                             if ($numero_document != null && $date != null && $numero_entite != null) {
                                $numeroDocument = $numero_document ;
                                $date_creation = $date;
                                $numeroEntite = $numero_entite;

                            if ($data->has($numero_document.$numBC.$contrat.$facture) == true) {
                                $bon_reception = $data->get($numero_document.$numBC.$contrat.$facture);
                            }else{
                                $BonReception = new BonReception();
                                $NumBonReception = null;
                                $lastNum = BonReception::orderBy('id_bon_reception','desc')->first();
                                if ($lastNum != null) {
                                    $NumBonReception = substr_replace($lastNum->num_bon_reception, "", 0, 5);
                                    if ($NumBonReception == 99999){
                                        $NumBonReception='BNREC00001';
                                    }
                                    else{
                                        $NumBonReception = $NumBonReception + 1;
                                        $NumBonReception=str_pad($NumBonReception, 5, '0', STR_PAD_LEFT);
                                        $NumBonReception ='BNREC'.$NumBonReception;
                                    }
                                }
                                else{
                                    $NumBonReception='BNREC00001';
                                }

                                if ($numBC != null) {
                                    if($fourniseur != null)
                                    {
                                        $getFournisseur=Fournisseur::where('societe','=',$fourniseur)->first();
                                        if ($getFournisseur == null){
                                            $newFournisseur = new Fournisseur();
                                            $newFournisseur->societe=$fourniseur;
                                            $newFournisseur->save();
                                            $idFournisseur=$newFournisseur->id_fournisseur;
                                          //  dd($idFournisseur);
                                        }else{
                                            $idFournisseur=$getFournisseur->id_fournisseur;
                                        }

                                    }else
                                    {
                                        $idFournisseur =0;
                                    }

                                    $BonCommande= new CommandeFournisseur();
                                    $BonCommande->num_commande_fournisseur=$numBC;
                                    $BonCommande->date_creation=$date;
                                    $BonCommande->etat=0;
                                    $BonCommande->id_fournisseur=$idFournisseur;
                                    $BonCommande->supprimer=0;
                                    $BonCommande->total_prix_ht=0;
                                    $BonCommande->total_prix_ttc=0;
                                    $BonCommande->save();
                                    $idBonCommande=$BonCommande->id_commande_fournisseur;
                                }else
                                {
                                    $idBonCommande=-1;
                                }


                                $BonReception->num_bon_reception = $NumBonReception;
                                $BonReception->date_creation = $date;
                                $BonReception->id_commande = -1; //fichier import sans commande
                                //a voir
                                //$BonReception->produit_rec = $sheet->getHighestRow() - 1;
                                $BonReception->last_update = date("Y-m-d H:i:s");
                                //$ue = Preferences::where('code_preference','=',"AVEC_UE_RECEPTION")->first();
                                $BonReception->unite_expedition = 1 ; 
                                $BonReception->supprimer = 0;
                                $BonReception->statut = 0;
                                $BonReception->num_document = $numero_document;
                                $BonReception->num_entite = $numero_entite;
                                $BonReception->id_commande = $idBonCommande;
                                $BonReception->contrat = $contrat;
                                $BonReception->facture = $facture;
                                $BonReception->save();
                                $bon_reception = $BonReception->id_bon_reception;

                                $data->put($numero_document.$numBC.$contrat.$facture,$BonReception->id_bon_reception);
                                //DB::rollback();
                                //dd($data->get($numero_document));
                            }
                                
                                
                               //ajoute entité
                                $entite = Entite::where('num_entite',$numero_entite)->first();
                                if ($entite == null) {
                                    //get type entité
                                        $liste_valeur = ListValeur::join('preferences','preferences.valeur_preference',"=","liste_valeur.code")
                                                    ->where('nom_liste', "TYPE_ENTITE")->first();
                                        if ($liste_valeur) {
                                            $new_entite = new Entite();
                                            $new_entite->num_entite = $numero_entite;
                                            $new_entite->type_entite = $liste_valeur->valeur;
                                            $new_entite->libelle_entite = $libelle_entite;
                                            $new_entite->save();
                                        }
                                    
                                }else{
                                    //modifier libellé ?
                                }
                            
                            }else {
                                if ($numero_document == null) {
                                    return Redirect::back()->withErrors(['Le champ N°document est obligatoire']);
                                }
                                if ($date == null) {
                                    return Redirect::back()->withErrors(['Le champ Date e création est obligatoire']);
                                }
                                if ($numero_entite == null) {
                                    return Redirect::back()->withErrors(['Le champ N° Entité est obligatoire']);
                                }      
                            }
                        
                        //vérifier si la date ou numéro ducument on été changé
                        /*if ($numeroDocument != $numero_document) {
                            $warning->put($key, 'Le numéro de document a été modifié');
                            break;
                        }*/
                        if ($date_creation != $date) {
                            $warning->put($key, 'La date de création a été modifiée');
                            break;
                        }
                        /*if ($numeroEntite != $numero_entite) {
                            $warning->put($key, "Le numéro d'entité' a été modifié");
                            break;
                        }*/
                        //
                        $getAllUe = LigneBonReceptionUe::where('sscc',$numero_ue)->with('ligneBonReception')->get();
                        if ($getAllUe != null) {
                            foreach ($getAllUe as $value) {

                                   if ($value->statut == 1 && $value->ligneBonReception->id_bon_reception !=  $bon_reception){
                                           $erreur->put($key, "Le numéro de l'UE doit être unique par un bon de réception1");
                                           break;
                                    }
                                   if ($value->statut == 0){
                                        $testLigne = LigneBonReception::where('id_ligne_bon_reception',$value->id_ligne_bon_reception)->with('bonReception')->first();
                                      

                                        if ($testLigne != null) {
                                            if ($testLigne->id_bon_reception != $bon_reception && $testLigne->bonReception->supprimer == 0) {
                                               $erreur->put($key, "Le numéro de l'UE doit être unique par un bon de réceptio2n");

                                            
                                                break;
                                            }
                                        }else{
                                            $erreur->put($key, "Le numéro de l'UE doit être unique par un bon de réception3");
                                            break; 
                                        }
                                    }    
                            }
                        }
                        //ajouter les ligne bon réception
                        //tester si le produit existe bien
                        $produit = Produit::where('reference',$reference_produit)->first();
                        if ($produit != null) {
                            //cas ou 2 produit ou plus son dans le meme box alors en somme les quantités
                            $test = LigneBonReception::where('id_bon_reception',$bon_reception)->where('id_produit',$produit->id_produit)->get();

                            $update = 0;

                            if ($test != null && $test->isEmpty() == false) {
                        
                                foreach ($test as $t) {
                                     $testUe = LigneBonReceptionUe::where('id_ligne_bon_reception',$t->id_ligne_bon_reception)->get();

                                     if ($testUe) {
                                        foreach ($testUe as $ue) {
                                            if ($ue->sscc == $numero_ue) {
                                                $update = 1;
                                                //update ligne
                                                $t->quantite_commander += $quantite;
                                                $t->quantite_receptionner += $quantite ;
                                                $t->quantite_reste_receptionnee += $quantite ;
                                                $t->update();

                                                //num_serie ??
                                                if ($numSerie != null){

                                                    $list=explode( ';', $numSerie );

                                                    foreach ($list as $num) {
                                                        if ($num != '' || $num != null) {
                                                            $existNumSerie = NumSerie::where('num_serie', '=', $num)->count();

                                                            if ($existNumSerie == 0) {

                                                                $newNumSerie = new NumSerie();
                                                                $newNumSerie->num_serie = $num;
                                                                $newNumSerie->id_ligne_reception = $t->id_ligne_bon_reception;
                                                                $newNumSerie->numUE = $numero_ue;
                                                                $newNumSerie->last_update = date("Y-m-d H:i:s");
                                                                $newNumSerie->save();
                                                            } else {
                                                                $erreur->put($key, "Le N° série ' " . $num . " ' existe déjà");
                                                                break;
                                                            }


                                                        }
                                                    }
                                                }

                                                /*$BonReceptionn = BonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->first();
                                                //avoir
                                                $BonReceptionn->produit_rec -= 1;
                                                $BonReceptionn->update();*/
                                                //$warning->put($key, 'La date de création a été modifiée');
                                                break;
                                            }
                                        }
                                     }
                                }
                            }
                            
                            if($update == 0){
                                
                                if ($numero_ue != null && $quantite != null) {
                                    $LigneBonReception = new LigneBonReception();
                                    $LigneBonReception->id_bon_reception = $bon_reception;

                                    $LigneBonReception->id_ligne_commande_fournisseur = -1; //fichier import sans commande
                                    $LigneBonReception->quantite_commander = $quantite;
                                    $LigneBonReception->quantite_receptionner = $quantite;
                                    $LigneBonReception->quantite_reste_receptionnee = $quantite;
                                    $LigneBonReception->id_produit = $produit->id_produit;
                                    $LigneBonReception->idEmplacement = $emp_reception->valeur_preference;
                                    $LigneBonReception->qteReceptionnerFO = 0;
                                    $LigneBonReception->statut = 0;
                                    $LigneBonReception->operateur = 0;
                                    $LigneBonReception->simule_fo = 0;
                                    $LigneBonReception->last_update = date("Y-m-d H:i:s");
                                    $LigneBonReception->save();

                                    //ajouter dans la table ligne bon réception ue
                                    $ligneBonRceptionUE = new LigneBonReceptionUe();
                                    $ligneBonRceptionUE->id_stock_produit = 0;
                                    $ligneBonRceptionUE->sscc = $numero_ue;
                                    $ligneBonRceptionUE->id_ligne_bon_reception = $LigneBonReception->id_ligne_bon_reception;
                                    $ligneBonRceptionUE->last_update = date("Y-m-d H:i:s");
                                    $ligneBonRceptionUE->save();

                                    $BonReceptionn = BonReception::where('id_bon_reception',$bon_reception)->first();
                                    //$BonReceptionn->nbr_ue_reste = $ue_memory->count();
                                    $BonReceptionn->produit_rec += 1;
                                    if ($ueee->contains($numero_ue) == false) {
                                        $BonReceptionn->nbr_ue_reste += 1;
                                        $ueee->put($key,$numero_ue);
                                    }


                                    
                                    $BonReceptionn->update();

                                    if ($numSerie != null)
                                    {

                                        $list=explode( ';', $numSerie );

                                        foreach ($list as $num) {
                                            if ($num != '' || $num != null) {
                                                $existNumSerie = NumSerie::where('num_serie', '=', $num)->count();

                                                if ($existNumSerie == 0) {

                                                    $newNumSerie = new NumSerie();
                                                    $newNumSerie->num_serie = $num;
                                                    $newNumSerie->id_ligne_reception = $LigneBonReception->id_ligne_bon_reception;
                                                    $newNumSerie->numUE = $numero_ue;
                                                    $newNumSerie->last_update = date("Y-m-d H:i:s");
                                                    $newNumSerie->save();
                                                } else {
                                                    $erreur->put($key, "Le N° série ' " . $num . " ' existe déjà");
                                                    break;
                                                }


                                            }
                                        }
                                    }

                                    /*if (! $ue_memory->contains($numero_ue)) {
                                        //inserer dans la collection le ue;
                                        $ue_memory->put($key, $numero_ue);
                                    }*/
                                    
                                }else{
                                    if ($numero_ue == null) {
                                        $erreur->put($key, "Le champ N°UE est obligatoire");
                                        break;
                                    }
                                    if ($quantite == null) {
                                       $erreur->put($key, "Le champ Quantité est obligatoire");
                                       break;
                                    }
                                }    
                           }

                        }else{
                            $erreur->put($key, "Le produit ".$reference_produit." n'existe pas");
                            break;
                        }
                    }
                    $y++;
                }
                
                    

                $HistoriqueActions = new Historique();
                $HistoriqueActions->type_action = 'Importation';
                $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions';
                $HistoriqueActions->description = 'Importation des réceptions depuis un fichier';
                $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
                $HistoriqueActions->date =Carbon::now('Africa/Algiers');
                $HistoriqueActions->save();
                //dd($sheet->getHighestRow() - 1, $erreur->count());
                if ($sheet->getHighestRow() - 1 == $erreur->count()) {
                    DB::rollback();
                    //delete bon_reception
                    //BonReception::where('id_bon_reception', $bon_reception->id_bon_reception)->delete();
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouterAnnuler',
                        [$erreur]);
                }
                if ($erreur->count() == 0 && $warning->count() == 0) {
                    DB::commit();
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouter', 'Fichier importé avec succès');
                }else{
                    DB::rollback();
                    /*//delete bon reception
                    BonReception::where('id_bon_reception', $bon_reception->id_bon_reception)->delete();
                    //delete ligne_bon reception
                    $ligne = LigneBonReception::where('id_bon_reception',$bon_reception->id_bon_reception)->get();
                    LigneBonReceptionUe::where('id_ligne_bon_reception',)->delete();
                    $ligne->delete();*/
                    return redirect('receptions/reception_fournisseur/index')->with('msgAjouterErreur',[$warning , $erreur]);
                }
            }
            else
                return Redirect::back()->withErrors(['Fichier vide ']);
        } else return Redirect::back()->withErrors(['Fichier volumineux ']);

    } else return Redirect::back()->withErrors(['Veuillez importer un fichier de type "csv" ou "xls" ou "xslx"']);


}

    public function get_num_serie($id){
        $num_serie = NumSerie::where('id_ligne_reception',$id)->get();
        return $num_serie;
    }


    

    public function recherche(Request $request)
    {

        $numSerie = $request->input('numSerie');
        if ($numSerie != null) {
        $existNumSerie = NumSerie::where('num_serie', '=', $numSerie)->first();
        //dd($existNumSerie);

        if ($existNumSerie == null) {

            return Redirect::back()->withErrors(['N° série : " ' . $numSerie . ' "  n\'existe pas']);

        } else {

            $getLigne = LigneBonReception::where('id_ligne_bon_reception', '=', $existNumSerie->id_ligne_reception)->first();
            // dd($getLigne);
            $bons_receptions = BonReception::with('commandeFounisseur.fournisseur')
                ->where('supprimer', '=', 0)
                ->where('id_bon_reception', '=', $getLigne->id_bon_reception)
                ->orderBy('date_creation','DESC')->paginate(100);


            return view('bon_reception_fournisseur.index', compact('bons_receptions'));
        }
    }else{
            return Redirect::back();
        }

        
       

    }

    public function getFormEditUE($id_bon_reception)
    {

        $collection = "";
        if(Session::get('AVEC_UE_RECEPTION')=='1') {
            if(Session::get('CONTROLE_UE')=='1') {
                $collection = LigneBonReception::where('id_bon_reception',$id_bon_reception)
                    ->join('ligne_bon_reception_ue','ligne_bon_reception_ue.id_ligne_bon_reception','=','ligne_bon_reception.id_ligne_bon_reception')
                    ->with('produit')->with('Emplacement')
                    ->get();
            }
        }else{
            $collection = LigneBonReception::where('id_bon_reception',$id_bon_reception)
                ->with('produit')->with('Emplacement')
                ->get();
        }

        $configuration = ConfigurationPdf::first();

        if (Session::get('STOCK_ENTITE')=='1') {
            $bonReception = BonReception::where('id_bon_reception',$id_bon_reception)
                ->where('id_commande','>',0)
                ->with('entite')
                ->with('commandeFounisseur.Fournisseur')
                ->first();

            if ($bonReception == null){
                $bonReception = BonReception::where('id_bon_reception',$id_bon_reception)->with('entite')->first();
            }

        }else{
            $bonReception = BonReception::find($id_bon_reception);
        }

        $fournisseurs=Fournisseur::get();
       if($bonReception->id_commande > 0)
       {
           $commande=CommandeFournisseur::where('id_commande_fournisseur','=',$bonReception->id_commande)->first();
       }else{
           $commande=null;
       }

   // dd($commande);

        return view('bon_reception_fournisseur_ue.modifier', compact('configuration','collection','bonReception','fournisseurs','commande'));
    }



    public function postFormEditUE(Request $request,$id)
    {

        $bonReception =  BonReception::with('commandeFounisseur')->find($id);



        $num_commande=$request->input('num_commande');
        $fournisseur=$request->input('fournisseur');
        $contrat=$request->input('contrat');
        $facture=$request->input('facture');
        $idBonCommande = $bonReception->id_commande;

        if ($num_commande != null) {

            //   if ($num_commande != $bonReception->commandeFounisseur->num_commande_fournisseur) {

            $existNumCommande = CommandeFournisseur::where('num_commande_fournisseur', '=', $num_commande)->first();
            if ($existNumCommande == null) {

                $newCommande = new CommandeFournisseur;
                $newCommande->num_commande_fournisseur = $num_commande;
                $newCommande->date_creation = $bonReception->date_creation;
                $newCommande->etat = 0;
                if ($fournisseur != null) {
                    $newCommande->id_fournisseur = $fournisseur;
                }
                else{
                    $newCommande->id_fournisseur = 0;
                }
                $newCommande->supprimer = 0;
                $newCommande->total_prix_ht = 0;
                $newCommande->total_prix_ttc = 0;
                $newCommande->save();
                $idBonCommande = $newCommande->id_commande_fournisseur;
            } else {
                $idBonCommande = $existNumCommande->id_commande_fournisseur;
            }

            //   }

            //      if ($fournisseur != $bonReception->commandeFounisseur->id_fournisseur) {

            $commande = CommandeFournisseur::where('id_commande_fournisseur', '=', $idBonCommande)->first();
            if ($fournisseur != null) {
                $commande->id_fournisseur = $fournisseur;
            }else{
                $commande->id_fournisseur = 0;
            }
            $commande->update();
      //      }
        }else
        {
            $idBonCommande = -1 ;
        }

        $bonReception->id_commande=$idBonCommande;
        $bonReception->contrat=$contrat;
        $bonReception->facture=$facture;
        $bonReception->update();


        $HistoriqueActions = new Historique();
        $HistoriqueActions->type_action = 'Modification';
        $HistoriqueActions->nom_table = 'Fournisseurs->Les réceptions';
        $HistoriqueActions->description = 'Modification de la réception: '.$bonReception->num_bon_reception ;
        $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
        $HistoriqueActions->date =Carbon::now('Africa/Algiers');
        $HistoriqueActions->save();

        return redirect('/receptions/reception_fournisseur/index')->with('msgAjouter','Le bon de réception a été modifiée avec succès');
    }
    public function postFormEditSN(Request $request,$id){
        $id_num_serie = $request->input('id_num_serie');
        $id_ligne_reception = $request->input('id_ligne_reception');
        $num_serie = $request->input('num_serie');
       
        for ($i=0; $i < count($id_num_serie); $i++) { 
            $num_serie_ = NumSerie::find($id_num_serie[$i]);
            //dd($num_serie_);
            $existeNS = NumSerie::where('num_serie',$num_serie[$i])->first();
            //dd(count($id_num_serie),$num_serie[$i],$existeNS);
            if ($existeNS != null && $num_serie_->num_serie != $num_serie[$i]) {
                return redirect('/receptions/reception_fournisseur_ue/modifier/'.$id)->with('msgExist','Le N° série '.$num_serie[$i].' existe déjà');
            }else{
                //$num_serie_ = NumSerie::find($id_num_serie[$i]);
                $num_serie_->id_ligne_reception = $id_ligne_reception[$i];
                $num_serie_->num_serie = $num_serie[$i];
                $num_serie_->last_update = date("Y-m-d H:i:s");
                $num_serie_->update();
            }   
        }
        return redirect('/receptions/reception_fournisseur_ue/modifier/'.$id)->with('msgAjouter','Le numéro de série a été modifiée avec succès');
    }

    public function export(Request $request){

        $debut = $request->input("date_debut");
        $fin = $request->input("date_fin");

        $receptions = collect();
         $receptions =  BonReception::join('ligne_bon_reception','ligne_bon_reception.id_bon_reception','=','bon_reception.id_bon_reception')
                ->join('produit','produit.id_produit','=','ligne_bon_reception.id_produit')
                ->join('unite_mesure','unite_mesure.id_unite_mesure','=','produit.code_mesure')
                ->join('ligne_bon_reception_ue','ligne_bon_reception_ue.id_ligne_bon_reception','=','ligne_bon_reception.id_ligne_bon_reception')
                //->leftJoin('num_serie','num_serie.id_ligne_reception','=','ligne_bon_reception.id_ligne_bon_reception')
                //->where('id_commande','>',0)
                ->with('entite')
                ->with('commandeFounisseur.Fournisseur')
                //->with('ligneBonReception.numeroSerie')
                ->whereBetween('date_creation',[$debut, $fin])
                ->where('supprimer', "!=", 1)

                ->select('bon_reception.statut as statut_bon_reception','*')->get();
                //->select(['bon_reception.num_bon_reception'])
                
                //->select('bon_reception.statut as statut_bon_reception','ligne_bon_reception.id_bon_reception as mmm','*')
                //->get();
                
        //dd($receptions);

        Excel::create('Rapport des réceptions '.date('y-m-d'),function($excel) use ($receptions){
        $excel->sheet('Feuil1', function($sheet) use ($receptions){
            $sheet->setColumnFormat(array(
                'A' =>  '@',
                'B' =>  '@',
                'C' =>  '@',
                'D' =>  '@',
                'E' =>  '@',
                'F' =>  '@',
                'G' =>  '@',
                'H' =>  '@',
                'I' =>  '@',
                'J' =>  '@',
                'K' =>  '@',
                'L' =>  '@',
                'M' =>  '@',
            ));
            $sheet->setStyle(array(
                'font' => array(
                    'name' =>  'Calibri',
                    'size' =>  10,
                )
            ));
            $sheet->setWidth(array(
                'A' =>  30,
                'B' =>  30,
                'C' =>  30,
                'D' =>  30,
                'E' =>  15,
                'F' =>  50,
                'G' =>  30,
                'H' =>  20,
                'I' =>  80,
                'J' =>  10,
                'K' =>  10,
                'L' =>  70,
                'M' =>  30,
            ));
            $sheet->getStyle('I')->getAlignment()->setWrapText(true);
            $sheet->getStyle('L')->getAlignment()->setWrapText(true);
            $sheet->loadView('bon_reception_fournisseur.export.exportExcel')->with(['receptions'=>$receptions]);
        });
    })->download('xlsx');
    }

}