<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 18/06/2017
 * Time: 14:19
 */

namespace App\Http\Controllers;


use App\BonLivraison;
use App\UniteExpedition;
use App\LigneBonReceptionUe;
use App\ConfigurationPdf;
use App\Historique;
use App\Produit;
use App\ProduitCompose;
use App\CommandeClient;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\LigneBonLivraison;
use App\LigneProduit;
use App\Preparation;
use App\StockProduit;
use Illuminate\Support\Facades\Session;
use App\Ue;
use App\CompteurModule;
use Excel;
use App\LigneBonReception;
use Illuminate\Support\Facades\DB;
use PHPExcel_Worksheet_Drawing;


use PHPExcel;
use DNS1D;


class BonLivraisonController extends Controller
{
    public function index(){
        Session::put('pageSource',null);
        Session::put('idBL',null);
		$bons_livraison = collect();
        $collect=BonLivraison::join('liste_valeur','liste_valeur.code','=','bon_livraison.statut')
            ->where('liste_valeur.nom_liste','=','STATUT_BL')
            ->with('preparation.Client')
            ->with('commandeClient')
            ->chunk(500, function ($rows) use ($bons_livraison) {
                    foreach ($rows as $row) {
                        $bons_livraison->push($row);
                    }
                });
            //dd($bons_livraison);

             return view('bon_livraison.index',compact('bons_livraison'));
    }

    public function add($id)
    {
        Session::put('pageSource','preparation');
        Session::put('idBL',$id);
        $existBl=BonLivraison::where('id_preparation','=',$id)->count();

        if ($existBl == 0) {


            //$lastNum = BonLivraison::orderBy('id_bon_livraison', 'desc')->first();
            //$Year=substr_replace(date('Y'), "", 0, 2);

            /*if ($lastNum != null) {
                $NumBonLivraison = substr_replace($lastNum->num_bl, "", 0, 5);
                $OldYear=substr_replace($lastNum->num_bl, "", 0, 2);
                $OldYear=substr_replace($OldYear, "", 2, 6);

                if ($OldYear == $Year) {
                    if ($NumBonLivraison == 99999) {
                        $NumBonLivraison = 'BL' . $Year . '/00001';
                    } else {
                        $NumBonLivraison = $NumBonLivraison + 1;
                        $NumBonLivraison = str_pad($NumBonLivraison, 5, '0', STR_PAD_LEFT);
                        $NumBonLivraison = 'BL' . $Year . '/' . $NumBonLivraison;
                    }
                }else {
                    $NumBonLivraison = 'BL' . $Year . '/00001';
                }
            } else
                $NumBonLivraison = 'BL'.$Year.'/00001';*/

            $monfichier = fopen('NumeroBL.txt', 'r');

        $ligne1 = fgets($monfichier);
        $prefixe = explode("=", $ligne1);
        $prefixe = str_replace("\r\n","",$prefixe[1]);

        $ligne2 = fgets($monfichier);
        $date = explode("=", $ligne2);
        $date = str_replace("\r\n","",$date[1]);
        $date = date("Y-m-d");
        if ($date == "AAMMJJ") {
            $date = date("y-m-d");
        }
        if($date == "JJMMAA"){
            $date = date("d-m-y");
        }
        if ($date == "AAAA") {
            $date = date("Y");
        }
        if ($date == "AA") {
            $date = date("y");
        }

        $date = str_replace("-","",$date);

        //récupéré nombre de bon livraison par jour , par mois par an
        $bon_livraison = CompteurModule::where('MODULE',"BON_LIVRAISON")->first();
        if ($bon_livraison != null) {
            $timestamp = strtotime($bon_livraison->last_update);
            
            if (date("Y", $timestamp) == date('Y')) $bon_livraison->COMPTEUR_PAR_AN += 1;
            else $bon_livraison->COMPTEUR_PAR_AN = 1;

            if (date("m", $timestamp) == date('m')) $bon_livraison->COMPTEUR_PAR_MOIS += 1;
            else $bon_livraison->COMPTEUR_PAR_MOIS = 1;

            if (date("d", $timestamp) == date('d')) $bon_livraison->COMPTEUR_PAR_JOUR += 1;
            else $bon_livraison->COMPTEUR_PAR_JOUR = 1;

            $bon_livraison->last_update = date("Y-m-d");
            $bon_livraison->update();
        }else{
            $bon_livraison = new CompteurModule();
            $bon_livraison->MODULE = "BON_LIVRAISON";
            $bon_livraison->COMPTEUR_PAR_JOUR = 1;
            $bon_livraison->COMPTEUR_PAR_MOIS = 1;
            $bon_livraison->COMPTEUR_PAR_AN = 1;
            $bon_livraison->last_update = date("Y-m-d");
            $bon_livraison->save();
        }

        $ligne3 = fgets($monfichier);
        $taille_compteur = explode("=", $ligne3);
        $taille_compteur = (int)str_replace("\r\n","",$taille_compteur[1]);

        $ligne4 = fgets($monfichier);
        $format_sequence = explode("=", $ligne4);
        $format_sequence = str_replace("\r\n","",$format_sequence[1]);
        $format_sequence = str_replace("+","",$format_sequence);

        $jour = str_pad($bon_livraison->COMPTEUR_PAR_JOUR, $taille_compteur, '0', STR_PAD_LEFT);
        $mois = str_pad($bon_livraison->COMPTEUR_PAR_MOIS, $taille_compteur, '0', STR_PAD_LEFT);
        $an = str_pad($bon_livraison->COMPTEUR_PAR_AN, $taille_compteur, '0', STR_PAD_LEFT);

        $format_sequence = str_replace("DATE",$date,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_NB_LIV_JOUR",$jour,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_NB_LIV_MOIS",$mois,$format_sequence);
        $format_sequence = str_replace("COMPTEUR_NB_LIV_AN",$an,$format_sequence);
        $NumBonLivraison = $prefixe.$format_sequence;

            $preparation = Preparation::find($id);
            /*$preparation->date_fin = date("Y-m-d H:i:s");
            $preparation->update();*/

            $bon_livraison = new BonLivraison();
            $bon_livraison->num_bl = $NumBonLivraison;
            $bon_livraison->id_preparation = $id;
            $bon_livraison->statut = 1;
            $bon_livraison->id_commande = $preparation->idCommande;
            $bon_livraison->nbr_produit = $preparation->nombreProduits;
            $bon_livraison->date_creation = date("Y-m-d H:i:s");
            $bon_livraison->save();

            $HistoriqueActions = new Historique();
            $HistoriqueActions->type_action = 'Ajout';
            $HistoriqueActions->nom_table = 'Clients->Les livraisons';
            $HistoriqueActions->description = 'Ajout du bon de livraison  : '.$bon_livraison->num_bl;
            $HistoriqueActions->nom_user = Session::get('nom').' '.Session::get('prenom');
            $HistoriqueActions->date =Carbon::now('Africa/Algiers');
            $HistoriqueActions->save();

            if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "0" || Session::get('STOCK_ENTITE') == "0"){
                $cmd=CommandeClient::find($preparation->idCommande);
                $cmd->statutCommande="Livrée";
                $cmd->update();
            }
            


            $ligne_produit_pre = LigneProduit::where('idPreparation', '=', $id)->get();

            foreach ($ligne_produit_pre as $ligne) {
                $ligne_bl_produit = new LigneBonLivraison;
                $ligne_bl_produit->id_bon_livraison = $bon_livraison->id_bon_livraison;
                $ligne_bl_produit->id_produit = $ligne->idProduit;
                $ligne_bl_produit->qnt = $ligne->quantite_a_preparer;
                $ligne_bl_produit->id_ligne_produit = $ligne->idLigneProduit;
                $ligne_bl_produit->save();
                if(Session::get('DESTOCKAGE_BL')=='1') {
                    $stock ='';
                    if (Session::get('STOCK_EMPLACEMENT_MOBILE') == "1" || Session::get('STOCK_ENTITE') == "1"){
                    $stock = StockProduit::join('ue','ue.num_ue',"=","stock_produit.num_ue")->where('id_stock_produit',$ligne->idStock)->first();
                    /*if ($stock->etat_ue == 0) {
                        $ue = Ue::where('num_ue',$stock->num_ue)->first();
                        $ue->etat_ue = 1; //ouvert
                        $ue->last_update = date("Y-m-d H:i:s");
                        $ue->update();
                    }*/
                    if ($stock->quantite - $ligne->quantite_a_preparer == 0) {
                        $ue = Ue::where('num_ue',$stock->num_ue)->first();
                        if ($ue->nbr_produit == 1 ) {
                            $ue->etat_ue = 2;//vide
                        }
                        $ue->nbr_produit -= 1; 
                        $ue->last_update = date("Y-m-d H:i:s");
                        $ue->update();
                    }
                }else{
                    $stock = StockProduit::find($ligne->idStock);
                }

                    $stock->quantite -= $ligne->quantite_a_preparer;
                    $stock->quantite_reelle -= $ligne->quantite_a_preparer;
                    $stock->last_update = date("Y-m-d H:i:s");
                    $stock->update();

                    //mettre a jour le statut = 2, de la table ligne_bon_reception_ue
                    $Ue = UniteExpedition::where('idUE',$ligne->idUE)->first();
                    if ($Ue !=null) {
                        $ligneBonReceptionUe = LigneBonReceptionUe::where('sscc',$Ue->SSCC)
                        ->where('id_stock_produit',$ligne->idStock)->first();
                        if($ligneBonReceptionUe !=null){
                            $ligneBonReceptionUe->statut = 2;
                            $ligneBonReceptionUe->last_update = date("Y-m-d H:i:s");
                            $ligneBonReceptionUe->update();
                        }
                    }
                }
            }
            return redirect('livraison/detail/' . $bon_livraison->id_bon_livraison);
        }else
        {
            $idBl=BonLivraison::where('id_preparation','=',$id)->first();
            return redirect('livraison/detail/' . $idBl->id_bon_livraison);
    }
    }

    public function show($id,Request $request){
        if (($request->input("exportPdf") == 0) || ($request->input("exportPdf") == null)) {

            $bonLivraison = BonLivraison::with('preparation.Client.willaya')
                ->with('preparation.entite')
                ->with('commandeClient')
                ->find($id);
                //dd($bonLivraison);
            $ligneBonLivraison = LigneBonLivraison::where('id_bon_livraison', '=', $id)
                ->with('produit')
                ->with('ligneProduit.StockProduit.ligneBonReceptionUe.ligneBonReception.bonReception')
                ->get();
            //dd($ligneBonLivraison);
            $total_qnt = 0 ;
            $total_qnt_cmp = 0;

            foreach ($ligneBonLivraison as $key => $ligne) {
                $total_qnt +=  $ligne->qnt;
            
                if($ligne->produit->compose_pack == 'OUI'){
                    $produitCompose = ProduitCompose::where('id_produit_parent',$ligne->produit->id_produit)->get();
                    foreach ($produitCompose as $key => $pro) {
                       $total_qnt_cmp += $pro->quantite * $ligne->qnt;
                    }
                }else{
                    
                    $total_qnt_cmp +=$ligne->qnt;
                    
                    
                }
            }

            
            //dd($total_qnt_cmp);
            $produits=Produit::get();
            //dd($ligneBonLivraison);


            return view('bon_livraison.detail', compact('bonLivraison', 'ligneBonLivraison','produits','total_qnt','total_qnt_cmp'));

        }else{
            if ($request->input("exportPdf") == -1) {
                $bonLivraison = BonLivraison::with('preparation.Transporteur')
                ->with('preparation.Client.willaya')
                ->with('commandeClient')
                ->find($id);
                //dd($bonLivraison);
            $ligneBonLivraison = LigneBonLivraison::with('produit.uniteMesure')
                ->where('id_bon_livraison', '=', $id)
                ->with('ligneProduit.StockProduit.ligneBonReceptionUe.ligneBonReception.bonReception')
                ->with('ligneProduit.NumeroSerie')         
                ->get();

                //dd($ligneBonLivraison);

            $configuration = ConfigurationPdf::first();
            //get prefixe
            $monfichier = fopen('NumeroBL.txt', 'r');
            $ligne1 = fgets($monfichier);
            $prefixe = explode("=", $ligne1);
            $prefixe = str_replace("\r\n","",$prefixe[1]); 

            $produits=Produit::get();

            $total_qnt = 0 ;
            $total_qnt_cmp = 0;
            $produitComposeCollect = collect();

            foreach ($ligneBonLivraison as $key => $ligne) {

                
                    if ($ligne->ligneProduit->NumeroSerie->isEmpty() == false) {

                        $total_qnt+= $ligne->ligneProduit->NumeroSerie->count();
                    }else{
                        $total_qnt +=  $ligne->qnt;
                    } 
                    
                
                if($ligne->produit->compose_pack == 'OUI'){

                    $produitCompose = ProduitCompose::where('id_produit_parent',$ligne->produit->id_produit)
                    ->with('produitParent')->with('produitEnfant')->get();
                    $produitComposeCollect->put($ligne->id_bl_produit, $produitCompose);
                    foreach ($produitCompose as $key => $pro) {
                        $total_qnt_cmp += $pro->quantite * $ligne->qnt;
                    }
                }else{
                    $total_qnt_cmp +=$ligne->qnt;
                }
                
                
            }
            Excel::create($bonLivraison->num_bl,function($excel) use ($ligneBonLivraison,$bonLivraison,$total_qnt,$prefixe,$configuration,$id){
        $excel->sheet('Feuil1', function($sheet) use ($ligneBonLivraison,$bonLivraison,$total_qnt,$prefixe,$configuration,$id){


            $sheet->setStyle(array(
                'font' => array(
                    'name' =>  'Calibri',
                    'size' =>  30,
                )
            ));
            //dd($configuration);
            if ($configuration->image != "") {
               $objDrawing = new PHPExcel_Worksheet_Drawing;
            $objDrawing->setPath(public_path('/dist\img'.'/'.$configuration->image)); //your image path
            $objDrawing->setCoordinates('A1');
            $objDrawing->setHeight(350);
            $objDrawing->setWorksheet($sheet);
        }if ($configuration->image2 != "") {
            $objDrawing2 = new PHPExcel_Worksheet_Drawing;
            $objDrawing2->setPath(public_path('/dist\img'.'/'.$configuration->image2)); //your image path
            $objDrawing2->setCoordinates('G1');
            $objDrawing2->setHeight(350);
            $objDrawing2->setWorksheet($sheet);
            }

               $path=DNS1D::getBarcodePNGPath($bonLivraison->num_bl, 'C39',6,200,array(1,1,1), true);
            $objDrawing3 = new PHPExcel_Worksheet_Drawing;
            $objDrawing3->setPath(public_path($path)); //your image path
            $objDrawing3->setCoordinates('D5');
            $objDrawing3->setHeight(120);
            $objDrawing3->setWorksheet($sheet);
            
            
            $sheet->cell('A3', function($cell) {
                $cell->setFontSize(80);
                $cell->setFontWeight('bold');
            });
           

              $sheet->cell('A6', function($cell) {
                $cell->setFontSize(100);
            });
            
            //$sheet->setCellValue('A5', ''.DNS1D::getBarcodeHTML($bonLivraison->num_bl, 'C39').'' );
            $sheet->setColumnFormat(array(
               'A' => '@',
               'B' => '@',
               'C' => '@',
               'E' => '@',
               'H' => '@',
               'I' => '@',
            ));

            $sheet->getStyle('D')->getAlignment()->setWrapText(true);
            //$sheet->getColumnDimension('A')->setWidth(500);

             //$sheet->getRowDimension('12')->setRowHeight(-1);
                //$sheet->getColumnDimension('A')->setWidth(100);
                $sheet->setWidth(array(
                'A' =>  30,
                'B' =>  20,
                'C' =>  15,
                'D' =>  40,
                'E' =>  25,
                'F' =>  15,
                'G' =>  10,
                'H' =>  10,
                'I' =>  20,
            ));


                
                $sheet->setHeight(3, 80);
                $sheet->setHeight(5, 100);

                //$sheet->getRowDimension()->setRowHeight(80);
                

                $ligne = LigneBonLivraison::leftJoin('numero_serie','numero_serie.id_ligne_produit','=','ligne_bl_produit.id_ligne_produit')
                ->where('id_bon_livraison', '=', $id)        
                ->count();

                //29 + nbr ligne
                if ($bonLivraison->id_commande != 0) {  
                    $sheet->cell('A8', function($cell) {
                $cell->setFontSize(45);
            });
                    $sheet->cell('A10', function($cell) {
                $cell->setFontSize(38);
            });
                    $sheet->cell('A11', function($cell) {
                $cell->setFontSize(38);
            });

                    $i = 27 ;
                    $j = $ligne;
                    while ($j) {
                        $sheet->setHeight($i, 120);
                        $i++;
                        $j--;  
                    }        
                    $ligne += 31;

                    $sheet->setHeight(array(
                    8       =>  80,
                    10       =>  80,
                    11       =>  80,
                    13       =>  80,
                    14       =>  80,
                    15       =>  80,
                    16       =>  80,
                    18       =>  80,
                    19       =>  80,
                    20       =>  80,
                    21       =>  80,
                    22       =>  80,
                    23       =>  80,
                    25       =>  80,
                    26       =>  80,
                ));

                }else {
                    $sheet->cell('A8', function($cell) {
                $cell->setFontSize(38);
            });
                    $sheet->cell('A9', function($cell) {
                $cell->setFontSize(38);
            });
                    $i = 25 ;
                    $j = $ligne;
                    while ($j) {
                        $sheet->setHeight($i, 120);
                        $i++;
                        $j--;  
                    } 
                    $ligne += 29;

                    $sheet->setHeight(array(
                    8       =>  80,
                    9       =>  80,
                    11       =>  80,
                    12       =>  80,
                    13       =>  80,
                    14       =>  80,
                    16       =>  80,
                    17       =>  80,
                    18       =>  80,
                    19       =>  80,
                    20       =>  80,
                    21       =>  80,
                    23       =>  80,
                    24       =>  80,
                ));
                }

                
                
                $sheet->setHeight(array(
                    $ligne       =>  80,
                    $ligne+1       =>  80,
                    $ligne+2       =>  80,
                    $ligne+3     =>  80,
                    $ligne+4       =>  80,
                    $ligne+5       =>  80,
                    $ligne+6       =>  80,
                    $ligne+8       =>  80,
                    $ligne+9       =>  80,

                ));


            
            $sheet->loadView('bon_livraison.export.exportExcel2')
            ->with(['ligneBonLivraison'=>$ligneBonLivraison,'bonLivraison'=>$bonLivraison,'total_qnt'=>$total_qnt, 'prefixe'=> $prefixe,'configuration'=>$configuration]);
        });
    })->download('xlsx');

            return view('bon_livraison.export.exportExcel2', compact('bonLivraison', 'ligneBonLivraison','configuration','produits','total_qnt','total_qnt_cmp','produitComposeCollect','prefixe'));
               
            }else{
                $bonLivraison = BonLivraison::with('preparation.Transporteur')
                ->with('preparation.Client.willaya')
                ->with('commandeClient')
                ->find($id);
            $ligneBonLivraison = LigneBonLivraison::with('produit')
                ->where('id_bon_livraison', '=', $id)
                ->with('ligneProduit.StockProduit.ligneBonReceptionUe.ligneBonReception.bonReception')
                ->with('ligneProduit.NumeroSerie')
                ->get();
                //dd($ligneBonLivraison);

            $configuration = ConfigurationPdf::first();

            $produits=Produit::get();

            $total_qnt = 0 ;
            $total_qnt_cmp = 0;
            $produitComposeCollect = collect();

            foreach ($ligneBonLivraison as $key => $ligne) {
                
                    if ($ligne->ligneProduit->NumeroSerie->isEmpty() == false) {

                        $total_qnt+= $ligne->ligneProduit->NumeroSerie->count();
                    }else{
                        $total_qnt +=  $ligne->qnt;
                    }                  
                
                if($ligne->produit->compose_pack == 'OUI'){
                    $produitCompose = ProduitCompose::where('id_produit_parent',$ligne->produit->id_produit)
                    ->with('produitParent')->with('produitEnfant')->get();
                    $produitComposeCollect->put($ligne->id_bl_produit, $produitCompose);
                    foreach ($produitCompose as $key => $pro) {
                        $total_qnt_cmp += $pro->quantite * $ligne->qnt;
                    }
                }else{
                    $total_qnt_cmp +=$ligne->qnt;
                } 
            }
            //dd($total_qnt);

            return view('bon_livraison.export.exportPDF', compact('bonLivraison', 'ligneBonLivraison','configuration','produits','total_qnt','total_qnt_cmp','produitComposeCollect'));
            }
            
        }
    }

    public function get_produits_compose($id_produit){
        $produits = ProduitCompose::where('id_produit_parent',$id_produit)
                                    ->with('produitEnfant')->get();

        return $produits;
    }

    public function annuler($id_bon_livraison){
        //update BL statut =0 = annulé
        $bon_livraison = BonLivraison::find($id_bon_livraison);
        $bon_livraison->statut = 0;
        $bon_livraison->update();
        //get ligne BL
        $lignes = LigneBonLivraison::where('id_bon_livraison',$id_bon_livraison)->with('ligneProduit')->get();
        foreach ($lignes as $key => $ligne) {
           $stock = StockProduit::find($ligne->ligneProduit->idStock);
           if ($stock->quantite == 0) {
                $ue = Ue::where('num_ue',$stock->num_ue)->first();
                if ($ue->nbr_produit == 0 ) {
                    $ue->etat_ue = 1;//ouvert
                }
                $ue->nbr_produit += 1; 
                $ue->last_update = date("Y-m-d H:i:s");
                $ue->update();
           }
           $stock->quantite += $ligne->qnt;
           $stock->quantite_utilisable += $ligne->qnt;
           $stock->quantite_reelle += $ligne->qnt;
           $stock->update();
           //dd($stock);
        }
        $bons_livraison=BonLivraison::join('liste_valeur','liste_valeur.code','=','bon_livraison.statut')
            ->where('liste_valeur.nom_liste','=','STATUT_BL')
            ->with('preparation.Client')
            ->with('commandeClient')
            ->get();
            //dd($bons_livraison);

             //return view('bon_livraison.index',compact('bons_livraison'))->with('msgAjouter','La quantité préparée a été modifiée avec succès');

             return redirect('livraison/index')->with('msgAjouter',"Le bon de livraison a été annulé avec succès");

        
        //
        //entité , produit, emp, qte, ue




    }
    public function export(Request $request){

        $debut = $request->input("date_debut");
        $fin = $request->input("date_fin");

        $bl = BonLivraison::join('ligne_bl_produit','ligne_bl_produit.id_bon_livraison','=','bon_livraison.id_bon_livraison')
               
                ->join('produit','produit.id_produit','=','ligne_bl_produit.id_produit')
                ->join('categorie','categorie.id_categorie','=','produit.id_categorie')
                ->join('unite_mesure','unite_mesure.id_unite_mesure','=','produit.code_mesure')

                ->join('ligne_produit','ligne_produit.idLigneProduit','=','ligne_bl_produit.id_ligne_produit')

                ->join('stock_produit','stock_produit.id_stock_produit','=','ligne_produit.idStock')

                ->leftJoin('ligne_bon_reception_ue','ligne_bon_reception_ue.id_stock_produit','=','stock_produit.id_stock_produit')

                ->leftJoin('ligne_bon_reception','ligne_bon_reception.id_ligne_bon_reception','=','ligne_bon_reception_ue.id_ligne_bon_reception')

                ->leftJoin('bon_reception','bon_reception.id_bon_reception','=','ligne_bon_reception.id_bon_reception')


                ->leftJoin('numero_serie','numero_serie.id_ligne_produit','=','ligne_bl_produit.id_ligne_produit')

                ->join('liste_valeur','liste_valeur.code','=','bon_livraison.statut')
                ->where('liste_valeur.nom_liste','=','STATUT_BL')
                 

                ->whereBetween('bon_livraison.date_creation',[$debut, $fin])

                ->with('preparation.Client.willaya')
                ->with('preparation.CommandeClient')
                ->with('preparation.Transporteur')

                //->with('ligneBonReceptionUe.ligneBonReception.bonReception')
                ->select('bon_livraison.date_creation as date_livraison','categorie.libelle as libelle_categorie','*')->orderBy('num_bl', 'asc')->get();

        //dd($bl);


        Excel::create('Rapport des livraisons '.date('y-m-d'),function($excel) use ($bl){
        $excel->sheet('Feuil1', function($sheet) use ($bl){
            $sheet->setColumnFormat(array(
                'A' =>  '@',
                'B' =>  '@',
                'C' =>  '@',
                'D' =>  '@',
                'E' =>  '@',
                'F' =>  '@',
                'G' =>  '@',
                'H' =>  '@',
                'I' =>  '@',
                'J' =>  '@',
                'K' =>  '@',
                'L' =>  '@',
                'M' =>  '@',
                'N' =>  '@',
                'O' =>  '@',
                'P' =>  '@',
                'Q' =>  '@',
                'R' =>  '@',
                'S' =>  '@',
                'T' =>  '@',
            ));
            $sheet->setStyle(array(
                'font' => array(
                    'name' =>  'Calibri',
                    'size' =>  10,
                )
            ));
            /*$sheet->setWidth(array(
                'A' =>  30,
                'B' =>  50,
                'C' =>  30,
                'D' =>  30,
                'E' =>  15,
                'F' =>  20,
                'G' =>  70,
                'H' =>  15,
                'I' =>  15,
                'J' =>  15,
                'K' =>  25,
            ));*/
            $sheet->getStyle('T')->getAlignment()->setWrapText(true);
            $sheet->loadView('bon_livraison.export.exportExcelListeBL')->with(['bl'=>$bl]);
        });
    })->download('xlsx');
    }
}