<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Entite extends Model
{

    protected $table='entite';
    protected $primaryKey='num_entite';

    protected $casts = ['num_entite' => 'string'];
    protected $keyType = 'string';
    public $incrementing = false;

    public $timestamps = false;
    protected $fillable=['type_entite','libelle_entite'];
    

    public function getPrimaryKey(){
        return $this->primaryKey;
    }

    public function stockProduit(){
        return $this->hasMany('App\StockProduit','num_entite','num_entite');
    }

    public function bonReception(){
        return $this->hasMany('App\BonReception','num_entite','num_entite');
    }

    public function preparation(){
        return $this->hasMany('App\Preparation','num_entite','num_entite');
    }

}