<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 30/05/2017
 * Time: 16:00
 */

namespace App;


use Illuminate\Database\Eloquent\Model;

class Emplacement extends Model
{

    protected $table='emplacement';
    protected $primaryKey='id_emplacement';
    protected $fillable=['libelle', 'description', 'etat', 'id_zone','emplacement_mobile','code_identification'];
    public $timestamps = false;
    public function  getPrimaryKey()
    {
        return $this->primaryKey;
    }


    public function zone(){
        return $this->belongsTo('App\Zone','id_zone', 'id_zone');
    }

    public function stockProduit()
    {
        return $this->hasMany('App\StockProduit');
    }

    public function transporteur()
    {
        return $this->hasMany('App\Transporteur');
    }

    public function chargement()
    {
        return $this->hasMany('App\Chargement');
    }

    public function LigneInventaire()
    {
        return $this->hasMany('App\LigneInventaire','code_identification','codeEmplacement');
    }

    public function productions(){
        return $this->hasMany('App\Production','id_emplacement');
    }

    public function tracabilites(){
        return $this->hasMany('App\Tracabilite','id_emplacement');
    }
}