<?php
/**
 * Created by PhpStorm.
 * User: Salim
 * Date: 08/06/2017
 * Time: 14:50
 */

namespace App;


use Illuminate\Database\Eloquent\Model;

class CommandeFournisseur extends Model
{

    protected $table='commande_fournisseur';
    protected $primaryKey='id_commande_fournisseur';
    protected $fillable=['date_creation','total_prix_ht','total_prix_ttc', 'etat', 'id_fournisseur'];
    public $timestamps = false;
    public function  getPrimaryKey(){
        return $this->primaryKey;
    }



    public function fournisseur(){
        return $this->belongsTo('App\Fournisseur','id_fournisseur');
    }


    public function lignesCommandeFournisseur(){
        return $this->hasMany('App\LigneCommandeFournisseur','id_commande_fournisseur','id_commande');
    }

    public function bonReception()
    {
        return $this->hasMany('App\BonReception', 'id_commande_fournisseur', 'id_commande');
    }






}