<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class CommandeClient extends Model
{

    protected $table = 'commande_client';
    protected $primaryKey = 'idCommande';
    protected $fillable = ['dateCommande', 'numCommande', 'statutCommande', 'idClient'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }

    public function Client()
    {
        return $this->belongsTo('App\Client', 'idClient');
    }

    public function ligneCommandeProduit(){
        return $this->hasMany('App\LigneCommandeProduit','idCommande','idCommande');
    }

    public function preparation()
    {
    return $this->hasOne('App\Preparation','idCommande','idCommande');
    }

}










