<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class Client extends Model
{

    protected $table = 'client';
    protected $primaryKey = 'idClient';
    protected $fillable = ['raisonSociale', 'nomClient', 'prenomClient', 'telephoneClient','emailClient','adresseClient'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }

    public function CommandeClient()
    {
        return $this->hasMany('App\CommandeClient', 'idClient', 'idClient');
    }

    public function willaya(){
        return $this->belongsTo('App\Wilaya', 'region','id_wilaya');
    }

}