<?php


namespace App;


use Illuminate\Database\Eloquent\Model;

class Chargement extends Model
{

    protected $table = 'chargement';
    protected $primaryKey = 'idChargement';
    protected $fillable = ['numChargement', 'dateChargement','idTransporteur','idEmplacement','totalUE_chargement','totalProduits_chargement','totalPoids_chargement','statutChargement'];
    public $timestamps = false;

    public function getPrimaryKey()
    {
        return $this->primaryKey;
    }
    public function LignePreparationChargement()
    {
        return $this->hasMany('App\LignePreparation','idChargement','idChargement');
    }

    public function LignePreparationsChargement()
    {
        return $this->hasMany('App\LignePreparationChargement','idChargement','idChargement');
    }

    public function  Transporteur()
    {
        return $this->belongsTo('App\Transporteur','idTransporteur');
    }

    public function  Emplacement()
    {
        return $this->belongsTo('App\Emplacement','idEmplacement');
    }







}